<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: GSS_CorrelativoMast.xml */
/* Generado: 2020-08-18 04:21:26 */

/* Mantenimiento de los registros de la tabla GSS_CorrelativoMast */
abstract class BaseGSS_CorrelativoMastDP extends GSS_CorrelativoMastBV
{
    /* Constructor ( Establece los valores desde un objeto GSS_CorrelativoMastBN ) */
    public function __construct( GSS_CorrelativoMastBN $o_GSS_CorrelativoMastBN = null )
    {
        parent::__construct();
        if ( !is_null( $o_GSS_CorrelativoMastBN ) )
        {
            $this->setByBN( $o_GSS_CorrelativoMastBN );
        }
    }

    public $b_Debug = false;

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Establece los valores desde un objeto GSS_CorrelativoMastBN */
    public function setByBN( GSS_CorrelativoMastBN $o_GSS_CorrelativoMastBN )
    {
        if ( !is_null( $o_GSS_CorrelativoMastBN->getIdCompania() ) )
        {
            $this->setIdCompania( $o_GSS_CorrelativoMastBN->getIdCompania() );
        }
        if ( !is_null( $o_GSS_CorrelativoMastBN->getIdTipocomprobante() ) )
        {
            $this->setIdTipocomprobante( $o_GSS_CorrelativoMastBN->getIdTipocomprobante() );
        }
        if ( !is_null( $o_GSS_CorrelativoMastBN->getIdSerie() ) )
        {
            $this->setIdSerie( $o_GSS_CorrelativoMastBN->getIdSerie() );
        }
        if ( !is_null( $o_GSS_CorrelativoMastBN->getDescripcion() ) )
        {
            $this->setDescripcion( $o_GSS_CorrelativoMastBN->getDescripcion() );
        }
        if ( !is_null( $o_GSS_CorrelativoMastBN->getCorrelativoNumero() ) )
        {
            $this->setCorrelativoNumero( $o_GSS_CorrelativoMastBN->getCorrelativoNumero() );
        }
        if ( !is_null( $o_GSS_CorrelativoMastBN->getCorrelativoDesde() ) )
        {
            $this->setCorrelativoDesde( $o_GSS_CorrelativoMastBN->getCorrelativoDesde() );
        }
        if ( !is_null( $o_GSS_CorrelativoMastBN->getCorrelativoHasta() ) )
        {
            $this->setCorrelativoHasta( $o_GSS_CorrelativoMastBN->getCorrelativoHasta() );
        }
        if ( !is_null( $o_GSS_CorrelativoMastBN->getAlmacenCodigo() ) )
        {
            $this->setAlmacenCodigo( $o_GSS_CorrelativoMastBN->getAlmacenCodigo() );
        }
        if ( !is_null( $o_GSS_CorrelativoMastBN->getEstado() ) )
        {
            $this->setEstado( $o_GSS_CorrelativoMastBN->getEstado() );
        }
        if ( !is_null( $o_GSS_CorrelativoMastBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_GSS_CorrelativoMastBN->getUsuarioModificacion() );
        }
        if ( !is_null( $o_GSS_CorrelativoMastBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_GSS_CorrelativoMastBN->getFechaModificacion() );
        }
        if ( !is_null( $o_GSS_CorrelativoMastBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_GSS_CorrelativoMastBN->getFechaCreacion() );
        }
        if ( !is_null( $o_GSS_CorrelativoMastBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_GSS_CorrelativoMastBN->getUsuarioCreacion() );
        }
    }

    /* Graba un nuevo registro */
    public function save()
    {
        $this->validateRecord();
        $o_GSS_CorrelativoMastFN = new GSS_CorrelativoMastFN();
        $o_GSS_CorrelativoMastBN = $o_GSS_CorrelativoMastFN->selectByPk( $this->getIdCompania(), $this->getIdTipocomprobante(), $this->getIdSerie() );
        if ( is_null( $o_GSS_CorrelativoMastBN ) )
        {
            $s_SQLQuery1 = "INSERT INTO GSS_CorrelativoMast ( ";
            $s_SQLQuery2 = "VALUES ( ";
            $s_Separator = "";
            if ( !is_null( $this->getIdCompania() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdCompania";
                $s_SQLQuery2 .= $s_Separator."".$this->getIdCompania()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdTipocomprobante() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdTipocomprobante";
                $s_SQLQuery2 .= $s_Separator."'".$this->getIdTipocomprobante()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdSerie() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdSerie";
                $s_SQLQuery2 .= $s_Separator."'".$this->getIdSerie()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getDescripcion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Descripcion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getDescripcion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getCorrelativoNumero() ) )
            {
                $s_SQLQuery1 .= $s_Separator."CorrelativoNumero";
                $s_SQLQuery2 .= $s_Separator."".$this->getCorrelativoNumero()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getCorrelativoDesde() ) )
            {
                $s_SQLQuery1 .= $s_Separator."CorrelativoDesde";
                $s_SQLQuery2 .= $s_Separator."".$this->getCorrelativoDesde()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getCorrelativoHasta() ) )
            {
                $s_SQLQuery1 .= $s_Separator."CorrelativoHasta";
                $s_SQLQuery2 .= $s_Separator."".$this->getCorrelativoHasta()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getAlmacenCodigo() ) )
            {
                $s_SQLQuery1 .= $s_Separator."AlmacenCodigo";
                $s_SQLQuery2 .= $s_Separator."'".$this->getAlmacenCodigo()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEstado() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Estado";
                $s_SQLQuery2 .= $s_Separator."'".$this->getEstado()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioModificacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UsuarioModificacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUsuarioModificacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaModificacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaModificacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaModificacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaCreacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaCreacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioCreacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UsuarioCreacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUsuarioCreacion()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery = $s_SQLQuery1." ) ".$s_SQLQuery2." );";
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        }
        else
        {
            throw new Exception( "El id ya esta registrado." );
        }
        return true;
    }

    /* Actualiza los datos del registro */
    public function update()
    {
        $this->validateRecord();
        if ( true )
        {
            $s_SQLQuery = "UPDATE GSS_CorrelativoMast SET ";
            $s_Separator = "";
            if ( !is_null( $this->getDescripcion() ) )
            {
                $s_SQLQuery .= $s_Separator."Descripcion = '".$this->getDescripcion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getCorrelativoNumero() ) )
            {
                $s_SQLQuery .= $s_Separator."CorrelativoNumero = ".$this->getCorrelativoNumero()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getCorrelativoDesde() ) )
            {
                $s_SQLQuery .= $s_Separator."CorrelativoDesde = ".$this->getCorrelativoDesde()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getCorrelativoHasta() ) )
            {
                $s_SQLQuery .= $s_Separator."CorrelativoHasta = ".$this->getCorrelativoHasta()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getAlmacenCodigo() ) )
            {
                $s_SQLQuery .= $s_Separator."AlmacenCodigo = '".$this->getAlmacenCodigo()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEstado() ) )
            {
                $s_SQLQuery .= $s_Separator."Estado = '".$this->getEstado()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioModificacion() ) )
            {
                $s_SQLQuery .= $s_Separator."UsuarioModificacion = '".$this->getUsuarioModificacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaModificacion() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaModificacion = '".$this->getFechaModificacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaCreacion() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaCreacion = '".$this->getFechaCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioCreacion() ) )
            {
                $s_SQLQuery .= $s_Separator."UsuarioCreacion = '".$this->getUsuarioCreacion()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery .= " WHERE  IdCompania = ".$this->getIdCompania()." AND  IdTipocomprobante = '".$this->getIdTipocomprobante()."' AND  IdSerie = '".$this->getIdSerie()."';";
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        }
        else
        {
            throw new Exception( "El id no esta registrado." );
        }
        return true;
    }

    /* Elimina el registro */
    public function delete()
    {
        $s_SQLQuery = "DELETE FROM GSS_CorrelativoMast WHERE  IdCompania = ".$this->getIdCompania()." AND  IdTipocomprobante = '".$this->getIdTipocomprobante()."' AND  IdSerie = '".$this->getIdSerie()."';";
        $o_Resource = Conexion::getConexion();
        $o_Statement = $o_Resource->createStatement();
        $o_Statement->executeQuery( $s_SQLQuery );
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        return true;
    }

}
?>