<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: GSS_Compania.xml */
/* Generado: 2024-09-24 03:40:16 */

/* Mantenimiento de los registros de la tabla GSS_Compania */
abstract class BaseGSS_CompaniaDP extends GSS_CompaniaBV
{
    /* Constructor ( Establece los valores desde un objeto GSS_CompaniaBN ) */
    public function __construct( GSS_CompaniaBN $o_GSS_CompaniaBN = null )
    {
        parent::__construct();
        if ( !is_null( $o_GSS_CompaniaBN ) )
        {
            $this->setByBN( $o_GSS_CompaniaBN );
        }
    }

    public $b_Debug = false;

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Establece los valores desde un objeto GSS_CompaniaBN */
    public function setByBN( GSS_CompaniaBN $o_GSS_CompaniaBN )
    {
        if ( !is_null( $o_GSS_CompaniaBN->getIdCompania() ) )
        {
            $this->setIdCompania( $o_GSS_CompaniaBN->getIdCompania() );
        }
        if ( !is_null( $o_GSS_CompaniaBN->getCodigo() ) )
        {
            $this->setCodigo( $o_GSS_CompaniaBN->getCodigo() );
        }
        if ( !is_null( $o_GSS_CompaniaBN->getDescripcionCorta() ) )
        {
            $this->setDescripcionCorta( $o_GSS_CompaniaBN->getDescripcionCorta() );
        }
        if ( !is_null( $o_GSS_CompaniaBN->getDescripcionLarga() ) )
        {
            $this->setDescripcionLarga( $o_GSS_CompaniaBN->getDescripcionLarga() );
        }
        if ( !is_null( $o_GSS_CompaniaBN->getPaisId() ) )
        {
            $this->setPaisId( $o_GSS_CompaniaBN->getPaisId() );
        }
        if ( !is_null( $o_GSS_CompaniaBN->getDepartamento() ) )
        {
            $this->setDepartamento( $o_GSS_CompaniaBN->getDepartamento() );
        }
        if ( !is_null( $o_GSS_CompaniaBN->getProvincia() ) )
        {
            $this->setProvincia( $o_GSS_CompaniaBN->getProvincia() );
        }
        if ( !is_null( $o_GSS_CompaniaBN->getDistrito() ) )
        {
            $this->setDistrito( $o_GSS_CompaniaBN->getDistrito() );
        }
        if ( !is_null( $o_GSS_CompaniaBN->getDireccionComun() ) )
        {
            $this->setDireccionComun( $o_GSS_CompaniaBN->getDireccionComun() );
        }
        if ( !is_null( $o_GSS_CompaniaBN->getDireccionAdicional() ) )
        {
            $this->setDireccionAdicional( $o_GSS_CompaniaBN->getDireccionAdicional() );
        }
        if ( !is_null( $o_GSS_CompaniaBN->getNotasdeVenta() ) )
        {
            $this->setNotasdeVenta( $o_GSS_CompaniaBN->getNotasdeVenta() );
        }
        if ( !is_null( $o_GSS_CompaniaBN->getNotasdeAlquiler() ) )
        {
            $this->setNotasdeAlquiler( $o_GSS_CompaniaBN->getNotasdeAlquiler() );
        }
        if ( !is_null( $o_GSS_CompaniaBN->getTelefono1() ) )
        {
            $this->setTelefono1( $o_GSS_CompaniaBN->getTelefono1() );
        }
        if ( !is_null( $o_GSS_CompaniaBN->getTelefono2() ) )
        {
            $this->setTelefono2( $o_GSS_CompaniaBN->getTelefono2() );
        }
        if ( !is_null( $o_GSS_CompaniaBN->getRuc() ) )
        {
            $this->setRuc( $o_GSS_CompaniaBN->getRuc() );
        }
        if ( !is_null( $o_GSS_CompaniaBN->getEstado() ) )
        {
            $this->setEstado( $o_GSS_CompaniaBN->getEstado() );
        }
        if ( !is_null( $o_GSS_CompaniaBN->getTelefono3() ) )
        {
            $this->setTelefono3( $o_GSS_CompaniaBN->getTelefono3() );
        }
        if ( !is_null( $o_GSS_CompaniaBN->getFax1() ) )
        {
            $this->setFax1( $o_GSS_CompaniaBN->getFax1() );
        }
        if ( !is_null( $o_GSS_CompaniaBN->getFax2() ) )
        {
            $this->setFax2( $o_GSS_CompaniaBN->getFax2() );
        }
        if ( !is_null( $o_GSS_CompaniaBN->getAfectoIGVFlag() ) )
        {
            $this->setAfectoIGVFlag( $o_GSS_CompaniaBN->getAfectoIGVFlag() );
        }
        if ( !is_null( $o_GSS_CompaniaBN->getLogoFileDir() ) )
        {
            $this->setLogoFileDir( $o_GSS_CompaniaBN->getLogoFileDir() );
        }
        if ( !is_null( $o_GSS_CompaniaBN->getLogoFile() ) )
        {
            $this->setLogoFile( $o_GSS_CompaniaBN->getLogoFile() );
        }
        if ( !is_null( $o_GSS_CompaniaBN->getLogoFileAncho() ) )
        {
            $this->setLogoFileAncho( $o_GSS_CompaniaBN->getLogoFileAncho() );
        }
        if ( !is_null( $o_GSS_CompaniaBN->getLogoFileAlto() ) )
        {
            $this->setLogoFileAlto( $o_GSS_CompaniaBN->getLogoFileAlto() );
        }
        if ( !is_null( $o_GSS_CompaniaBN->getLogoBackFileDir() ) )
        {
            $this->setLogoBackFileDir( $o_GSS_CompaniaBN->getLogoBackFileDir() );
        }
        if ( !is_null( $o_GSS_CompaniaBN->getLogoBackFileWeb() ) )
        {
            $this->setLogoBackFileWeb( $o_GSS_CompaniaBN->getLogoBackFileWeb() );
        }
        if ( !is_null( $o_GSS_CompaniaBN->getLogoBackFileAncho() ) )
        {
            $this->setLogoBackFileAncho( $o_GSS_CompaniaBN->getLogoBackFileAncho() );
        }
        if ( !is_null( $o_GSS_CompaniaBN->getLogoBackFileAlto() ) )
        {
            $this->setLogoBackFileAlto( $o_GSS_CompaniaBN->getLogoBackFileAlto() );
        }
        if ( !is_null( $o_GSS_CompaniaBN->getRepresentanteLegal() ) )
        {
            $this->setRepresentanteLegal( $o_GSS_CompaniaBN->getRepresentanteLegal() );
        }
        if ( !is_null( $o_GSS_CompaniaBN->getPaginaWeb() ) )
        {
            $this->setPaginaWeb( $o_GSS_CompaniaBN->getPaginaWeb() );
        }
        if ( !is_null( $o_GSS_CompaniaBN->getFacturaNotasFormatoPDF() ) )
        {
            $this->setFacturaNotasFormatoPDF( $o_GSS_CompaniaBN->getFacturaNotasFormatoPDF() );
        }
        if ( !is_null( $o_GSS_CompaniaBN->getBoletaNotasFormatoPDF() ) )
        {
            $this->setBoletaNotasFormatoPDF( $o_GSS_CompaniaBN->getBoletaNotasFormatoPDF() );
        }
        if ( !is_null( $o_GSS_CompaniaBN->getEmailEmpresa() ) )
        {
            $this->setEmailEmpresa( $o_GSS_CompaniaBN->getEmailEmpresa() );
        }
        if ( !is_null( $o_GSS_CompaniaBN->getDirParaBuscarComprobante() ) )
        {
            $this->setDirParaBuscarComprobante( $o_GSS_CompaniaBN->getDirParaBuscarComprobante() );
        }
        if ( !is_null( $o_GSS_CompaniaBN->getPorTipoCambio() ) )
        {
            $this->setPorTipoCambio( $o_GSS_CompaniaBN->getPorTipoCambio() );
        }
        if ( !is_null( $o_GSS_CompaniaBN->getDeshabilitarTipoCambio() ) )
        {
            $this->setDeshabilitarTipoCambio( $o_GSS_CompaniaBN->getDeshabilitarTipoCambio() );
        }
        if ( !is_null( $o_GSS_CompaniaBN->getEnviarProveedorAutoFlag() ) )
        {
            $this->setEnviarProveedorAutoFlag( $o_GSS_CompaniaBN->getEnviarProveedorAutoFlag() );
        }
        if ( !is_null( $o_GSS_CompaniaBN->getEnviarCompDirectoSunatFlag() ) )
        {
            $this->setEnviarCompDirectoSunatFlag( $o_GSS_CompaniaBN->getEnviarCompDirectoSunatFlag() );
        }
        if ( !is_null( $o_GSS_CompaniaBN->getAfectoRetencionIGVFlag() ) )
        {
            $this->setAfectoRetencionIGVFlag( $o_GSS_CompaniaBN->getAfectoRetencionIGVFlag() );
        }
        if ( !is_null( $o_GSS_CompaniaBN->getAfectoPercepcionIGVFlag() ) )
        {
            $this->setAfectoPercepcionIGVFlag( $o_GSS_CompaniaBN->getAfectoPercepcionIGVFlag() );
        }
        if ( !is_null( $o_GSS_CompaniaBN->getMostrarMargenVenta() ) )
        {
            $this->setMostrarMargenVenta( $o_GSS_CompaniaBN->getMostrarMargenVenta() );
        }
        if ( !is_null( $o_GSS_CompaniaBN->getCarteraClienteFlag() ) )
        {
            $this->setCarteraClienteFlag( $o_GSS_CompaniaBN->getCarteraClienteFlag() );
        }
        if ( !is_null( $o_GSS_CompaniaBN->getAprobacionParaImpGuias() ) )
        {
            $this->setAprobacionParaImpGuias( $o_GSS_CompaniaBN->getAprobacionParaImpGuias() );
        }
        if ( !is_null( $o_GSS_CompaniaBN->getMostrarNumeroLote() ) )
        {
            $this->setMostrarNumeroLote( $o_GSS_CompaniaBN->getMostrarNumeroLote() );
        }
        if ( !is_null( $o_GSS_CompaniaBN->getTrabajarModoAlquiler() ) )
        {
            $this->setTrabajarModoAlquiler( $o_GSS_CompaniaBN->getTrabajarModoAlquiler() );
        }
        if ( !is_null( $o_GSS_CompaniaBN->getOpeCierreCaja() ) )
        {
            $this->setOpeCierreCaja( $o_GSS_CompaniaBN->getOpeCierreCaja() );
        }
        if ( !is_null( $o_GSS_CompaniaBN->getIdClientePorDef() ) )
        {
            $this->setIdClientePorDef( $o_GSS_CompaniaBN->getIdClientePorDef() );
        }
        if ( !is_null( $o_GSS_CompaniaBN->getIdUsuarioAdmin() ) )
        {
            $this->setIdUsuarioAdmin( $o_GSS_CompaniaBN->getIdUsuarioAdmin() );
        }
        if ( !is_null( $o_GSS_CompaniaBN->getOpeDsctoStockEnGuiaR() ) )
        {
            $this->setOpeDsctoStockEnGuiaR( $o_GSS_CompaniaBN->getOpeDsctoStockEnGuiaR() );
        }
        if ( !is_null( $o_GSS_CompaniaBN->getUsarCreditoConCuotas() ) )
        {
            $this->setUsarCreditoConCuotas( $o_GSS_CompaniaBN->getUsarCreditoConCuotas() );
        }
        if ( !is_null( $o_GSS_CompaniaBN->getUsarProdReferenciaFlag() ) )
        {
            $this->setUsarProdReferenciaFlag( $o_GSS_CompaniaBN->getUsarProdReferenciaFlag() );
        }
        if ( !is_null( $o_GSS_CompaniaBN->getLogoBackgroundColor() ) )
        {
            $this->setLogoBackgroundColor( $o_GSS_CompaniaBN->getLogoBackgroundColor() );
        }
        if ( !is_null( $o_GSS_CompaniaBN->getNavbarBackgroundColor() ) )
        {
            $this->setNavbarBackgroundColor( $o_GSS_CompaniaBN->getNavbarBackgroundColor() );
        }
        if ( !is_null( $o_GSS_CompaniaBN->getSidebarBackgroundColor() ) )
        {
            $this->setSidebarBackgroundColor( $o_GSS_CompaniaBN->getSidebarBackgroundColor() );
        }
        if ( !is_null( $o_GSS_CompaniaBN->getUsuSecundarioPruebaUser() ) )
        {
            $this->setUsuSecundarioPruebaUser( $o_GSS_CompaniaBN->getUsuSecundarioPruebaUser() );
        }
        if ( !is_null( $o_GSS_CompaniaBN->getUsuSecundarioPruebaPass() ) )
        {
            $this->setUsuSecundarioPruebaPass( $o_GSS_CompaniaBN->getUsuSecundarioPruebaPass() );
        }
        if ( !is_null( $o_GSS_CompaniaBN->getUsuSecundarioProdUser() ) )
        {
            $this->setUsuSecundarioProdUser( $o_GSS_CompaniaBN->getUsuSecundarioProdUser() );
        }
        if ( !is_null( $o_GSS_CompaniaBN->getUsuSecundarioProdPass() ) )
        {
            $this->setUsuSecundarioProdPass( $o_GSS_CompaniaBN->getUsuSecundarioProdPass() );
        }
        if ( !is_null( $o_GSS_CompaniaBN->getModoEntorno() ) )
        {
            $this->setModoEntorno( $o_GSS_CompaniaBN->getModoEntorno() );
        }
        if ( !is_null( $o_GSS_CompaniaBN->getEliminado() ) )
        {
            $this->setEliminado( $o_GSS_CompaniaBN->getEliminado() );
        }
        if ( !is_null( $o_GSS_CompaniaBN->getFechaEliminado() ) )
        {
            $this->setFechaEliminado( $o_GSS_CompaniaBN->getFechaEliminado() );
        }
        if ( !is_null( $o_GSS_CompaniaBN->getUsuarioEliminado() ) )
        {
            $this->setUsuarioEliminado( $o_GSS_CompaniaBN->getUsuarioEliminado() );
        }
        if ( !is_null( $o_GSS_CompaniaBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_GSS_CompaniaBN->getFechaCreacion() );
        }
        if ( !is_null( $o_GSS_CompaniaBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_GSS_CompaniaBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_GSS_CompaniaBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_GSS_CompaniaBN->getFechaModificacion() );
        }
        if ( !is_null( $o_GSS_CompaniaBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_GSS_CompaniaBN->getUsuarioModificacion() );
        }
    }

    /* Graba un nuevo registro */
    public function save()
    {
        $this->validateRecord();
        $o_GSS_CompaniaFN = new GSS_CompaniaFN();
        $o_GSS_CompaniaBN = $o_GSS_CompaniaFN->selectByPk( $this->getIdCompania() );
        if ( is_null( $o_GSS_CompaniaBN ) )
        {
            $s_SQLQuery1 = "INSERT INTO GSS_Compania ( ";
            $s_SQLQuery2 = "VALUES ( ";
            $s_Separator = "";
            if ( !is_null( $this->getIdCompania() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdCompania";
                $s_SQLQuery2 .= $s_Separator."".$this->getIdCompania()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getCodigo() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Codigo";
                $s_SQLQuery2 .= $s_Separator."'".$this->getCodigo()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getDescripcionCorta() ) )
            {
                $s_SQLQuery1 .= $s_Separator."DescripcionCorta";
                $s_SQLQuery2 .= $s_Separator."'".$this->getDescripcionCorta()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getDescripcionLarga() ) )
            {
                $s_SQLQuery1 .= $s_Separator."DescripcionLarga";
                $s_SQLQuery2 .= $s_Separator."'".$this->getDescripcionLarga()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getPaisId() ) )
            {
                $s_SQLQuery1 .= $s_Separator."PaisId";
                $s_SQLQuery2 .= $s_Separator."'".$this->getPaisId()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getDepartamento() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Departamento";
                $s_SQLQuery2 .= $s_Separator."'".$this->getDepartamento()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getProvincia() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Provincia";
                $s_SQLQuery2 .= $s_Separator."'".$this->getProvincia()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getDistrito() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Distrito";
                $s_SQLQuery2 .= $s_Separator."'".$this->getDistrito()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getDireccionComun() ) )
            {
                $s_SQLQuery1 .= $s_Separator."DireccionComun";
                $s_SQLQuery2 .= $s_Separator."'".$this->getDireccionComun()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getDireccionAdicional() ) )
            {
                $s_SQLQuery1 .= $s_Separator."DireccionAdicional";
                $s_SQLQuery2 .= $s_Separator."'".$this->getDireccionAdicional()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getNotasdeVenta() ) )
            {
                $s_SQLQuery1 .= $s_Separator."NotasdeVenta";
                $s_SQLQuery2 .= $s_Separator."'".$this->getNotasdeVenta()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getNotasdeAlquiler() ) )
            {
                $s_SQLQuery1 .= $s_Separator."NotasdeAlquiler";
                $s_SQLQuery2 .= $s_Separator."'".$this->getNotasdeAlquiler()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getTelefono1() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Telefono1";
                $s_SQLQuery2 .= $s_Separator."'".$this->getTelefono1()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getTelefono2() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Telefono2";
                $s_SQLQuery2 .= $s_Separator."'".$this->getTelefono2()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getRuc() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Ruc";
                $s_SQLQuery2 .= $s_Separator."'".$this->getRuc()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEstado() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Estado";
                $s_SQLQuery2 .= $s_Separator."'".$this->getEstado()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getTelefono3() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Telefono3";
                $s_SQLQuery2 .= $s_Separator."'".$this->getTelefono3()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFax1() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Fax1";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFax1()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFax2() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Fax2";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFax2()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getAfectoIGVFlag() ) )
            {
                $s_SQLQuery1 .= $s_Separator."AfectoIGVFlag";
                $s_SQLQuery2 .= $s_Separator."'".$this->getAfectoIGVFlag()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getLogoFileDir() ) )
            {
                $s_SQLQuery1 .= $s_Separator."LogoFileDir";
                $s_SQLQuery2 .= $s_Separator."'".$this->getLogoFileDir()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getLogoFile() ) )
            {
                $s_SQLQuery1 .= $s_Separator."LogoFile";
                $s_SQLQuery2 .= $s_Separator."'".$this->getLogoFile()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getLogoFileAncho() ) )
            {
                $s_SQLQuery1 .= $s_Separator."LogoFileAncho";
                $s_SQLQuery2 .= $s_Separator."'".$this->getLogoFileAncho()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getLogoFileAlto() ) )
            {
                $s_SQLQuery1 .= $s_Separator."LogoFileAlto";
                $s_SQLQuery2 .= $s_Separator."'".$this->getLogoFileAlto()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getLogoBackFileDir() ) )
            {
                $s_SQLQuery1 .= $s_Separator."LogoBackFileDir";
                $s_SQLQuery2 .= $s_Separator."'".$this->getLogoBackFileDir()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getLogoBackFileWeb() ) )
            {
                $s_SQLQuery1 .= $s_Separator."LogoBackFileWeb";
                $s_SQLQuery2 .= $s_Separator."'".$this->getLogoBackFileWeb()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getLogoBackFileAncho() ) )
            {
                $s_SQLQuery1 .= $s_Separator."LogoBackFileAncho";
                $s_SQLQuery2 .= $s_Separator."'".$this->getLogoBackFileAncho()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getLogoBackFileAlto() ) )
            {
                $s_SQLQuery1 .= $s_Separator."LogoBackFileAlto";
                $s_SQLQuery2 .= $s_Separator."'".$this->getLogoBackFileAlto()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getRepresentanteLegal() ) )
            {
                $s_SQLQuery1 .= $s_Separator."RepresentanteLegal";
                $s_SQLQuery2 .= $s_Separator."'".$this->getRepresentanteLegal()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getPaginaWeb() ) )
            {
                $s_SQLQuery1 .= $s_Separator."PaginaWeb";
                $s_SQLQuery2 .= $s_Separator."'".$this->getPaginaWeb()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFacturaNotasFormatoPDF() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FacturaNotasFormatoPDF";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFacturaNotasFormatoPDF()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getBoletaNotasFormatoPDF() ) )
            {
                $s_SQLQuery1 .= $s_Separator."BoletaNotasFormatoPDF";
                $s_SQLQuery2 .= $s_Separator."'".$this->getBoletaNotasFormatoPDF()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEmailEmpresa() ) )
            {
                $s_SQLQuery1 .= $s_Separator."EmailEmpresa";
                $s_SQLQuery2 .= $s_Separator."'".$this->getEmailEmpresa()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getDirParaBuscarComprobante() ) )
            {
                $s_SQLQuery1 .= $s_Separator."DirParaBuscarComprobante";
                $s_SQLQuery2 .= $s_Separator."'".$this->getDirParaBuscarComprobante()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getPorTipoCambio() ) )
            {
                $s_SQLQuery1 .= $s_Separator."PorTipoCambio";
                $s_SQLQuery2 .= $s_Separator."".$this->getPorTipoCambio()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getDeshabilitarTipoCambio() ) )
            {
                $s_SQLQuery1 .= $s_Separator."DeshabilitarTipoCambio";
                $s_SQLQuery2 .= $s_Separator."".$this->getDeshabilitarTipoCambio()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEnviarProveedorAutoFlag() ) )
            {
                $s_SQLQuery1 .= $s_Separator."EnviarProveedorAutoFlag";
                $s_SQLQuery2 .= $s_Separator."'".$this->getEnviarProveedorAutoFlag()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEnviarCompDirectoSunatFlag() ) )
            {
                $s_SQLQuery1 .= $s_Separator."EnviarCompDirectoSunatFlag";
                $s_SQLQuery2 .= $s_Separator."".$this->getEnviarCompDirectoSunatFlag()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getAfectoRetencionIGVFlag() ) )
            {
                $s_SQLQuery1 .= $s_Separator."AfectoRetencionIGVFlag";
                $s_SQLQuery2 .= $s_Separator."'".$this->getAfectoRetencionIGVFlag()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getAfectoPercepcionIGVFlag() ) )
            {
                $s_SQLQuery1 .= $s_Separator."AfectoPercepcionIGVFlag";
                $s_SQLQuery2 .= $s_Separator."'".$this->getAfectoPercepcionIGVFlag()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getMostrarMargenVenta() ) )
            {
                $s_SQLQuery1 .= $s_Separator."MostrarMargenVenta";
                $s_SQLQuery2 .= $s_Separator."".$this->getMostrarMargenVenta()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getCarteraClienteFlag() ) )
            {
                $s_SQLQuery1 .= $s_Separator."CarteraClienteFlag";
                $s_SQLQuery2 .= $s_Separator."".$this->getCarteraClienteFlag()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getAprobacionParaImpGuias() ) )
            {
                $s_SQLQuery1 .= $s_Separator."AprobacionParaImpGuias";
                $s_SQLQuery2 .= $s_Separator."".$this->getAprobacionParaImpGuias()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getMostrarNumeroLote() ) )
            {
                $s_SQLQuery1 .= $s_Separator."MostrarNumeroLote";
                $s_SQLQuery2 .= $s_Separator."".$this->getMostrarNumeroLote()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getTrabajarModoAlquiler() ) )
            {
                $s_SQLQuery1 .= $s_Separator."TrabajarModoAlquiler";
                $s_SQLQuery2 .= $s_Separator."".$this->getTrabajarModoAlquiler()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getOpeCierreCaja() ) )
            {
                $s_SQLQuery1 .= $s_Separator."OpeCierreCaja";
                $s_SQLQuery2 .= $s_Separator."".$this->getOpeCierreCaja()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdClientePorDef() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdClientePorDef";
                $s_SQLQuery2 .= $s_Separator."".$this->getIdClientePorDef()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdUsuarioAdmin() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdUsuarioAdmin";
                $s_SQLQuery2 .= $s_Separator."".$this->getIdUsuarioAdmin()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getOpeDsctoStockEnGuiaR() ) )
            {
                $s_SQLQuery1 .= $s_Separator."OpeDsctoStockEnGuiaR";
                $s_SQLQuery2 .= $s_Separator."".$this->getOpeDsctoStockEnGuiaR()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsarCreditoConCuotas() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UsarCreditoConCuotas";
                $s_SQLQuery2 .= $s_Separator."".$this->getUsarCreditoConCuotas()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsarProdReferenciaFlag() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UsarProdReferenciaFlag";
                $s_SQLQuery2 .= $s_Separator."".$this->getUsarProdReferenciaFlag()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getLogoBackgroundColor() ) )
            {
                $s_SQLQuery1 .= $s_Separator."LogoBackgroundColor";
                $s_SQLQuery2 .= $s_Separator."'".$this->getLogoBackgroundColor()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getNavbarBackgroundColor() ) )
            {
                $s_SQLQuery1 .= $s_Separator."NavbarBackgroundColor";
                $s_SQLQuery2 .= $s_Separator."'".$this->getNavbarBackgroundColor()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getSidebarBackgroundColor() ) )
            {
                $s_SQLQuery1 .= $s_Separator."SidebarBackgroundColor";
                $s_SQLQuery2 .= $s_Separator."'".$this->getSidebarBackgroundColor()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuSecundarioPruebaUser() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UsuSecundarioPruebaUser";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUsuSecundarioPruebaUser()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuSecundarioPruebaPass() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UsuSecundarioPruebaPass";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUsuSecundarioPruebaPass()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuSecundarioProdUser() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UsuSecundarioProdUser";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUsuSecundarioProdUser()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuSecundarioProdPass() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UsuSecundarioProdPass";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUsuSecundarioProdPass()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getModoEntorno() ) )
            {
                $s_SQLQuery1 .= $s_Separator."ModoEntorno";
                $s_SQLQuery2 .= $s_Separator."".$this->getModoEntorno()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEliminado() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Eliminado";
                $s_SQLQuery2 .= $s_Separator."".$this->getEliminado()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaEliminado() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaEliminado";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaEliminado()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioEliminado() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UsuarioEliminado";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUsuarioEliminado()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaCreacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaCreacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioCreacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UsuarioCreacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUsuarioCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaModificacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaModificacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaModificacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioModificacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UsuarioModificacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUsuarioModificacion()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery = $s_SQLQuery1." ) ".$s_SQLQuery2." );";
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
        }
        else
        {
            throw new Exception( "El id ya esta registrado." );
        }
        return true;
    }

    /* Actualiza los datos del registro */
    public function update()
    {
        $this->validateRecord();
        if ( true )
        {
            $s_SQLQuery = "UPDATE GSS_Compania SET ";
            $s_Separator = "";
            if ( !is_null( $this->getCodigo() ) )
            {
                $s_SQLQuery .= $s_Separator."Codigo = '".$this->getCodigo()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getDescripcionCorta() ) )
            {
                $s_SQLQuery .= $s_Separator."DescripcionCorta = '".$this->getDescripcionCorta()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getDescripcionLarga() ) )
            {
                $s_SQLQuery .= $s_Separator."DescripcionLarga = '".$this->getDescripcionLarga()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getPaisId() ) )
            {
                $s_SQLQuery .= $s_Separator."PaisId = '".$this->getPaisId()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getDepartamento() ) )
            {
                $s_SQLQuery .= $s_Separator."Departamento = '".$this->getDepartamento()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getProvincia() ) )
            {
                $s_SQLQuery .= $s_Separator."Provincia = '".$this->getProvincia()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getDistrito() ) )
            {
                $s_SQLQuery .= $s_Separator."Distrito = '".$this->getDistrito()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getDireccionComun() ) )
            {
                $s_SQLQuery .= $s_Separator."DireccionComun = '".$this->getDireccionComun()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getDireccionAdicional() ) )
            {
                $s_SQLQuery .= $s_Separator."DireccionAdicional = '".$this->getDireccionAdicional()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getNotasdeVenta() ) )
            {
                $s_SQLQuery .= $s_Separator."NotasdeVenta = '".$this->getNotasdeVenta()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getNotasdeAlquiler() ) )
            {
                $s_SQLQuery .= $s_Separator."NotasdeAlquiler = '".$this->getNotasdeAlquiler()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getTelefono1() ) )
            {
                $s_SQLQuery .= $s_Separator."Telefono1 = '".$this->getTelefono1()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getTelefono2() ) )
            {
                $s_SQLQuery .= $s_Separator."Telefono2 = '".$this->getTelefono2()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getRuc() ) )
            {
                $s_SQLQuery .= $s_Separator."Ruc = '".$this->getRuc()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEstado() ) )
            {
                $s_SQLQuery .= $s_Separator."Estado = '".$this->getEstado()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getTelefono3() ) )
            {
                $s_SQLQuery .= $s_Separator."Telefono3 = '".$this->getTelefono3()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFax1() ) )
            {
                $s_SQLQuery .= $s_Separator."Fax1 = '".$this->getFax1()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFax2() ) )
            {
                $s_SQLQuery .= $s_Separator."Fax2 = '".$this->getFax2()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getAfectoIGVFlag() ) )
            {
                $s_SQLQuery .= $s_Separator."AfectoIGVFlag = '".$this->getAfectoIGVFlag()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getLogoFileDir() ) )
            {
                $s_SQLQuery .= $s_Separator."LogoFileDir = '".$this->getLogoFileDir()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getLogoFile() ) )
            {
                $s_SQLQuery .= $s_Separator."LogoFile = '".$this->getLogoFile()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getLogoFileAncho() ) )
            {
                $s_SQLQuery .= $s_Separator."LogoFileAncho = '".$this->getLogoFileAncho()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getLogoFileAlto() ) )
            {
                $s_SQLQuery .= $s_Separator."LogoFileAlto = '".$this->getLogoFileAlto()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getLogoBackFileDir() ) )
            {
                $s_SQLQuery .= $s_Separator."LogoBackFileDir = '".$this->getLogoBackFileDir()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getLogoBackFileWeb() ) )
            {
                $s_SQLQuery .= $s_Separator."LogoBackFileWeb = '".$this->getLogoBackFileWeb()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getLogoBackFileAncho() ) )
            {
                $s_SQLQuery .= $s_Separator."LogoBackFileAncho = '".$this->getLogoBackFileAncho()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getLogoBackFileAlto() ) )
            {
                $s_SQLQuery .= $s_Separator."LogoBackFileAlto = '".$this->getLogoBackFileAlto()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getRepresentanteLegal() ) )
            {
                $s_SQLQuery .= $s_Separator."RepresentanteLegal = '".$this->getRepresentanteLegal()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getPaginaWeb() ) )
            {
                $s_SQLQuery .= $s_Separator."PaginaWeb = '".$this->getPaginaWeb()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFacturaNotasFormatoPDF() ) )
            {
                $s_SQLQuery .= $s_Separator."FacturaNotasFormatoPDF = '".$this->getFacturaNotasFormatoPDF()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getBoletaNotasFormatoPDF() ) )
            {
                $s_SQLQuery .= $s_Separator."BoletaNotasFormatoPDF = '".$this->getBoletaNotasFormatoPDF()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEmailEmpresa() ) )
            {
                $s_SQLQuery .= $s_Separator."EmailEmpresa = '".$this->getEmailEmpresa()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getDirParaBuscarComprobante() ) )
            {
                $s_SQLQuery .= $s_Separator."DirParaBuscarComprobante = '".$this->getDirParaBuscarComprobante()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getPorTipoCambio() ) )
            {
                $s_SQLQuery .= $s_Separator."PorTipoCambio = ".$this->getPorTipoCambio()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getDeshabilitarTipoCambio() ) )
            {
                $s_SQLQuery .= $s_Separator."DeshabilitarTipoCambio = ".$this->getDeshabilitarTipoCambio()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEnviarProveedorAutoFlag() ) )
            {
                $s_SQLQuery .= $s_Separator."EnviarProveedorAutoFlag = '".$this->getEnviarProveedorAutoFlag()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEnviarCompDirectoSunatFlag() ) )
            {
                $s_SQLQuery .= $s_Separator."EnviarCompDirectoSunatFlag = ".$this->getEnviarCompDirectoSunatFlag()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getAfectoRetencionIGVFlag() ) )
            {
                $s_SQLQuery .= $s_Separator."AfectoRetencionIGVFlag = '".$this->getAfectoRetencionIGVFlag()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getAfectoPercepcionIGVFlag() ) )
            {
                $s_SQLQuery .= $s_Separator."AfectoPercepcionIGVFlag = '".$this->getAfectoPercepcionIGVFlag()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getMostrarMargenVenta() ) )
            {
                $s_SQLQuery .= $s_Separator."MostrarMargenVenta = ".$this->getMostrarMargenVenta()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getCarteraClienteFlag() ) )
            {
                $s_SQLQuery .= $s_Separator."CarteraClienteFlag = ".$this->getCarteraClienteFlag()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getAprobacionParaImpGuias() ) )
            {
                $s_SQLQuery .= $s_Separator."AprobacionParaImpGuias = ".$this->getAprobacionParaImpGuias()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getMostrarNumeroLote() ) )
            {
                $s_SQLQuery .= $s_Separator."MostrarNumeroLote = ".$this->getMostrarNumeroLote()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getTrabajarModoAlquiler() ) )
            {
                $s_SQLQuery .= $s_Separator."TrabajarModoAlquiler = ".$this->getTrabajarModoAlquiler()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getOpeCierreCaja() ) )
            {
                $s_SQLQuery .= $s_Separator."OpeCierreCaja = ".$this->getOpeCierreCaja()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdClientePorDef() ) )
            {
                $s_SQLQuery .= $s_Separator."IdClientePorDef = ".$this->getIdClientePorDef()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdUsuarioAdmin() ) )
            {
                $s_SQLQuery .= $s_Separator."IdUsuarioAdmin = ".$this->getIdUsuarioAdmin()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getOpeDsctoStockEnGuiaR() ) )
            {
                $s_SQLQuery .= $s_Separator."OpeDsctoStockEnGuiaR = ".$this->getOpeDsctoStockEnGuiaR()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsarCreditoConCuotas() ) )
            {
                $s_SQLQuery .= $s_Separator."UsarCreditoConCuotas = ".$this->getUsarCreditoConCuotas()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsarProdReferenciaFlag() ) )
            {
                $s_SQLQuery .= $s_Separator."UsarProdReferenciaFlag = ".$this->getUsarProdReferenciaFlag()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getLogoBackgroundColor() ) )
            {
                $s_SQLQuery .= $s_Separator."LogoBackgroundColor = '".$this->getLogoBackgroundColor()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getNavbarBackgroundColor() ) )
            {
                $s_SQLQuery .= $s_Separator."NavbarBackgroundColor = '".$this->getNavbarBackgroundColor()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getSidebarBackgroundColor() ) )
            {
                $s_SQLQuery .= $s_Separator."SidebarBackgroundColor = '".$this->getSidebarBackgroundColor()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuSecundarioPruebaUser() ) )
            {
                $s_SQLQuery .= $s_Separator."UsuSecundarioPruebaUser = '".$this->getUsuSecundarioPruebaUser()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuSecundarioPruebaPass() ) )
            {
                $s_SQLQuery .= $s_Separator."UsuSecundarioPruebaPass = '".$this->getUsuSecundarioPruebaPass()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuSecundarioProdUser() ) )
            {
                $s_SQLQuery .= $s_Separator."UsuSecundarioProdUser = '".$this->getUsuSecundarioProdUser()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuSecundarioProdPass() ) )
            {
                $s_SQLQuery .= $s_Separator."UsuSecundarioProdPass = '".$this->getUsuSecundarioProdPass()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getModoEntorno() ) )
            {
                $s_SQLQuery .= $s_Separator."ModoEntorno = ".$this->getModoEntorno()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEliminado() ) )
            {
                $s_SQLQuery .= $s_Separator."Eliminado = ".$this->getEliminado()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaEliminado() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaEliminado = '".$this->getFechaEliminado()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioEliminado() ) )
            {
                $s_SQLQuery .= $s_Separator."UsuarioEliminado = '".$this->getUsuarioEliminado()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaCreacion() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaCreacion = '".$this->getFechaCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioCreacion() ) )
            {
                $s_SQLQuery .= $s_Separator."UsuarioCreacion = '".$this->getUsuarioCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaModificacion() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaModificacion = '".$this->getFechaModificacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioModificacion() ) )
            {
                $s_SQLQuery .= $s_Separator."UsuarioModificacion = '".$this->getUsuarioModificacion()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery .= " WHERE  IdCompania = ".$this->getIdCompania().";";
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }

            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
        }
        else
        {
            throw new Exception( "El id no esta registrado." );
        }
        return true;
    }

    /* Elimina el registro */
    public function delete()
    {
        $s_SQLQuery = "DELETE FROM GSS_Compania WHERE  IdCompania = ".$this->getIdCompania().";";
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = Conexion::getConexion();
        $o_Statement = $o_Resource->createStatement();
        $o_Statement->executeQuery( $s_SQLQuery );
        return true;
    }

}
?>