<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: FCO_CajaUsuario.xml */
/* Generado: 2021-10-20 01:20:13 */

/* Mantenimiento de los registros de la tabla FCO_CajaUsuario */
abstract class BaseFCO_CajaUsuarioDP extends FCO_CajaUsuarioBV
{
    /* Constructor ( Establece los valores desde un objeto FCO_CajaUsuarioBN ) */
    public function __construct( FCO_CajaUsuarioBN $o_FCO_CajaUsuarioBN = null )
    {
        parent::__construct();
        if ( !is_null( $o_FCO_CajaUsuarioBN ) )
        {
            $this->setByBN( $o_FCO_CajaUsuarioBN );
        }
    }

    public $b_Debug = false;

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Establece los valores desde un objeto FCO_CajaUsuarioBN */
    public function setByBN( FCO_CajaUsuarioBN $o_FCO_CajaUsuarioBN )
    {
        if ( !is_null( $o_FCO_CajaUsuarioBN->getIdCaja() ) )
        {
            $this->setIdCaja( $o_FCO_CajaUsuarioBN->getIdCaja() );
        }
        if ( !is_null( $o_FCO_CajaUsuarioBN->getIdUsuario() ) )
        {
            $this->setIdUsuario( $o_FCO_CajaUsuarioBN->getIdUsuario() );
        }
        if ( !is_null( $o_FCO_CajaUsuarioBN->getIdCompania() ) )
        {
            $this->setIdCompania( $o_FCO_CajaUsuarioBN->getIdCompania() );
        }
        if ( !is_null( $o_FCO_CajaUsuarioBN->getIdSucursal() ) )
        {
            $this->setIdSucursal( $o_FCO_CajaUsuarioBN->getIdSucursal() );
        }
        if ( !is_null( $o_FCO_CajaUsuarioBN->getEnUsoFlag() ) )
        {
            $this->setEnUsoFlag( $o_FCO_CajaUsuarioBN->getEnUsoFlag() );
        }
        if ( !is_null( $o_FCO_CajaUsuarioBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_FCO_CajaUsuarioBN->getFechaCreacion() );
        }
        if ( !is_null( $o_FCO_CajaUsuarioBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_FCO_CajaUsuarioBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_FCO_CajaUsuarioBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_FCO_CajaUsuarioBN->getFechaModificacion() );
        }
        if ( !is_null( $o_FCO_CajaUsuarioBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_FCO_CajaUsuarioBN->getUsuarioModificacion() );
        }
    }

    /* Graba un nuevo registro */
    public function save()
    {
        $this->validateRecord();
        $o_FCO_CajaUsuarioFN = new FCO_CajaUsuarioFN();
        $o_FCO_CajaUsuarioBN = $o_FCO_CajaUsuarioFN->selectByPk( $this->getIdCaja(), $this->getIdUsuario(), $this->getIdCompania(), $this->getIdSucursal() );
        if ( is_null( $o_FCO_CajaUsuarioBN ) )
        {
            $s_SQLQuery1 = "INSERT INTO FCO_CajaUsuario ( ";
            $s_SQLQuery2 = "VALUES ( ";
            $s_Separator = "";
            if ( !is_null( $this->getIdCaja() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdCaja";
                $s_SQLQuery2 .= $s_Separator."".$this->getIdCaja()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdUsuario() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdUsuario";
                $s_SQLQuery2 .= $s_Separator."'".$this->getIdUsuario()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdCompania() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdCompania";
                $s_SQLQuery2 .= $s_Separator."".$this->getIdCompania()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdSucursal() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdSucursal";
                $s_SQLQuery2 .= $s_Separator."".$this->getIdSucursal()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEnUsoFlag() ) )
            {
                $s_SQLQuery1 .= $s_Separator."EnUsoFlag";
                $s_SQLQuery2 .= $s_Separator."".$this->getEnUsoFlag()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaCreacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaCreacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioCreacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UsuarioCreacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUsuarioCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaModificacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaModificacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaModificacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioModificacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UsuarioModificacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUsuarioModificacion()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery = $s_SQLQuery1." ) ".$s_SQLQuery2." );";
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
        }
        else
        {
            throw new Exception( "El id ya esta registrado." );
        }
        return true;
    }

    /* Actualiza los datos del registro */
    public function update()
    {
        $this->validateRecord();
        if ( true )
        {
            $s_SQLQuery = "UPDATE FCO_CajaUsuario SET ";
            $s_Separator = "";
            if ( !is_null( $this->getEnUsoFlag() ) )
            {
                $s_SQLQuery .= $s_Separator."EnUsoFlag = ".$this->getEnUsoFlag()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaCreacion() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaCreacion = '".$this->getFechaCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioCreacion() ) )
            {
                $s_SQLQuery .= $s_Separator."UsuarioCreacion = '".$this->getUsuarioCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaModificacion() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaModificacion = '".$this->getFechaModificacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioModificacion() ) )
            {
                $s_SQLQuery .= $s_Separator."UsuarioModificacion = '".$this->getUsuarioModificacion()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery .= " WHERE  IdCaja = ".$this->getIdCaja()." AND  IdUsuario = '".$this->getIdUsuario()."' AND  IdCompania = ".$this->getIdCompania()." AND  IdSucursal = ".$this->getIdSucursal().";";
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }

            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
        }
        else
        {
            throw new Exception( "El id no esta registrado." );
        }
        return true;
    }

    /* Elimina el registro */
    public function delete()
    {
        $s_SQLQuery = "DELETE FROM FCO_CajaUsuario WHERE  IdCaja = ".$this->getIdCaja()." AND  IdUsuario = '".$this->getIdUsuario()."' AND  IdCompania = ".$this->getIdCompania()." AND  IdSucursal = ".$this->getIdSucursal().";";
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = Conexion::getConexion();
        $o_Statement = $o_Resource->createStatement();
        $o_Statement->executeQuery( $s_SQLQuery );
        return true;
    }

}
?>