<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: CP_Terminos.xml */
/* Generado: 2021-07-14 02:15:30 */

/* Mantenimiento de los registros de la tabla CP_Terminos */
abstract class BaseCP_TerminosDP extends CP_TerminosBV
{
    /* Constructor ( Establece los valores desde un objeto CP_TerminosBN ) */
    public function __construct( CP_TerminosBN $o_CP_TerminosBN = null )
    {
        parent::__construct();
        if ( !is_null( $o_CP_TerminosBN ) )
        {
            $this->setByBN( $o_CP_TerminosBN );
        }
    }

    public $b_Debug = false;

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Establece los valores desde un objeto CP_TerminosBN */
    public function setByBN( CP_TerminosBN $o_CP_TerminosBN )
    {
        if ( !is_null( $o_CP_TerminosBN->getTerminoId() ) )
        {
            $this->setTerminoId( $o_CP_TerminosBN->getTerminoId() );
        }
        if ( !is_null( $o_CP_TerminosBN->getNombre() ) )
        {
            $this->setNombre( $o_CP_TerminosBN->getNombre() );
        }
        if ( !is_null( $o_CP_TerminosBN->getDescripcion() ) )
        {
            $this->setDescripcion( $o_CP_TerminosBN->getDescripcion() );
        }
        if ( !is_null( $o_CP_TerminosBN->getCantidad() ) )
        {
            $this->setCantidad( $o_CP_TerminosBN->getCantidad() );
        }
        if ( !is_null( $o_CP_TerminosBN->getEstado() ) )
        {
            $this->setEstado( $o_CP_TerminosBN->getEstado() );
        }
        if ( !is_null( $o_CP_TerminosBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_CP_TerminosBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_CP_TerminosBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_CP_TerminosBN->getFechaCreacion() );
        }
        if ( !is_null( $o_CP_TerminosBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_CP_TerminosBN->getUsuarioModificacion() );
        }
        if ( !is_null( $o_CP_TerminosBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_CP_TerminosBN->getFechaModificacion() );
        }
    }

    /* Graba un nuevo registro */
    public function save()
    {
        $this->validateRecord();
        $o_CP_TerminosFN = new CP_TerminosFN();
        $o_CP_TerminosBN = $o_CP_TerminosFN->selectByPk( $this->getTerminoId() );
        if ( is_null( $o_CP_TerminosBN ) )
        {
            $s_SQLQuery1 = "INSERT INTO CP_Terminos ( ";
            $s_SQLQuery2 = "VALUES ( ";
            $s_Separator = "";
            if ( !is_null( $this->getTerminoId() ) )
            {
                $s_SQLQuery1 .= $s_Separator."TerminoId";
                $s_SQLQuery2 .= $s_Separator."".$this->getTerminoId()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getNombre() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Nombre";
                $s_SQLQuery2 .= $s_Separator."'".$this->getNombre()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getDescripcion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Descripcion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getDescripcion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getCantidad() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Cantidad";
                $s_SQLQuery2 .= $s_Separator."".$this->getCantidad()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEstado() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Estado";
                $s_SQLQuery2 .= $s_Separator."'".$this->getEstado()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioCreacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UsuarioCreacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUsuarioCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaCreacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaCreacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioModificacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UsuarioModificacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUsuarioModificacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaModificacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaModificacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaModificacion()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery = $s_SQLQuery1." ) ".$s_SQLQuery2." );";
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
        }
        else
        {
            throw new Exception( "El id ya esta registrado." );
        }
        return true;
    }

    /* Actualiza los datos del registro */
    public function update()
    {
        $this->validateRecord();
        if ( true )
        {
            $s_SQLQuery = "UPDATE CP_Terminos SET ";
            $s_Separator = "";
            if ( !is_null( $this->getNombre() ) )
            {
                $s_SQLQuery .= $s_Separator."Nombre = '".$this->getNombre()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getDescripcion() ) )
            {
                $s_SQLQuery .= $s_Separator."Descripcion = '".$this->getDescripcion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getCantidad() ) )
            {
                $s_SQLQuery .= $s_Separator."Cantidad = ".$this->getCantidad()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEstado() ) )
            {
                $s_SQLQuery .= $s_Separator."Estado = '".$this->getEstado()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioCreacion() ) )
            {
                $s_SQLQuery .= $s_Separator."UsuarioCreacion = '".$this->getUsuarioCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaCreacion() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaCreacion = '".$this->getFechaCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioModificacion() ) )
            {
                $s_SQLQuery .= $s_Separator."UsuarioModificacion = '".$this->getUsuarioModificacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaModificacion() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaModificacion = '".$this->getFechaModificacion()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery .= " WHERE  TerminoId = ".$this->getTerminoId().";";
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }

            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
        }
        else
        {
            throw new Exception( "El id no esta registrado." );
        }
        return true;
    }

    /* Elimina el registro */
    public function delete()
    {
        $s_SQLQuery = "DELETE FROM CP_Terminos WHERE  TerminoId = ".$this->getTerminoId().";";
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = Conexion::getConexion();
        $o_Statement = $o_Resource->createStatement();
        $o_Statement->executeQuery( $s_SQLQuery );
        return true;
    }

}
?>