<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: CP_MetodosPago.xml */
/* Generado: 2021-07-14 02:15:37 */

/* Mantenimiento de los registros de la tabla CP_MetodosPago */
abstract class BaseCP_MetodosPagoDP extends CP_MetodosPagoBV
{
    /* Constructor ( Establece los valores desde un objeto CP_MetodosPagoBN ) */
    public function __construct( CP_MetodosPagoBN $o_CP_MetodosPagoBN = null )
    {
        parent::__construct();
        if ( !is_null( $o_CP_MetodosPagoBN ) )
        {
            $this->setByBN( $o_CP_MetodosPagoBN );
        }
    }

    public $b_Debug = false;

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Establece los valores desde un objeto CP_MetodosPagoBN */
    public function setByBN( CP_MetodosPagoBN $o_CP_MetodosPagoBN )
    {
        if ( !is_null( $o_CP_MetodosPagoBN->getMetodoPagoId() ) )
        {
            $this->setMetodoPagoId( $o_CP_MetodosPagoBN->getMetodoPagoId() );
        }
        if ( !is_null( $o_CP_MetodosPagoBN->getNombre() ) )
        {
            $this->setNombre( $o_CP_MetodosPagoBN->getNombre() );
        }
        if ( !is_null( $o_CP_MetodosPagoBN->getDescripcion() ) )
        {
            $this->setDescripcion( $o_CP_MetodosPagoBN->getDescripcion() );
        }
        if ( !is_null( $o_CP_MetodosPagoBN->getEstado() ) )
        {
            $this->setEstado( $o_CP_MetodosPagoBN->getEstado() );
        }
        if ( !is_null( $o_CP_MetodosPagoBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_CP_MetodosPagoBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_CP_MetodosPagoBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_CP_MetodosPagoBN->getFechaCreacion() );
        }
        if ( !is_null( $o_CP_MetodosPagoBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_CP_MetodosPagoBN->getUsuarioModificacion() );
        }
        if ( !is_null( $o_CP_MetodosPagoBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_CP_MetodosPagoBN->getFechaModificacion() );
        }
    }

    /* Graba un nuevo registro */
    public function save()
    {
        $this->validateRecord();
        $o_CP_MetodosPagoFN = new CP_MetodosPagoFN();
        $o_CP_MetodosPagoBN = $o_CP_MetodosPagoFN->selectByPk( $this->getMetodoPagoId() );
        if ( is_null( $o_CP_MetodosPagoBN ) )
        {
            $s_SQLQuery1 = "INSERT INTO CP_MetodosPago ( ";
            $s_SQLQuery2 = "VALUES ( ";
            $s_Separator = "";
            if ( !is_null( $this->getMetodoPagoId() ) )
            {
                $s_SQLQuery1 .= $s_Separator."MetodoPagoId";
                $s_SQLQuery2 .= $s_Separator."".$this->getMetodoPagoId()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getNombre() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Nombre";
                $s_SQLQuery2 .= $s_Separator."'".$this->getNombre()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getDescripcion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Descripcion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getDescripcion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEstado() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Estado";
                $s_SQLQuery2 .= $s_Separator."'".$this->getEstado()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioCreacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UsuarioCreacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUsuarioCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaCreacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaCreacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioModificacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UsuarioModificacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUsuarioModificacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaModificacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaModificacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaModificacion()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery = $s_SQLQuery1." ) ".$s_SQLQuery2." );";
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
        }
        else
        {
            throw new Exception( "El id ya esta registrado." );
        }
        return true;
    }

    /* Actualiza los datos del registro */
    public function update()
    {
        $this->validateRecord();
        if ( true )
        {
            $s_SQLQuery = "UPDATE CP_MetodosPago SET ";
            $s_Separator = "";
            if ( !is_null( $this->getNombre() ) )
            {
                $s_SQLQuery .= $s_Separator."Nombre = '".$this->getNombre()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getDescripcion() ) )
            {
                $s_SQLQuery .= $s_Separator."Descripcion = '".$this->getDescripcion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEstado() ) )
            {
                $s_SQLQuery .= $s_Separator."Estado = '".$this->getEstado()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioCreacion() ) )
            {
                $s_SQLQuery .= $s_Separator."UsuarioCreacion = '".$this->getUsuarioCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaCreacion() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaCreacion = '".$this->getFechaCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioModificacion() ) )
            {
                $s_SQLQuery .= $s_Separator."UsuarioModificacion = '".$this->getUsuarioModificacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaModificacion() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaModificacion = '".$this->getFechaModificacion()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery .= " WHERE  MetodoPagoId = ".$this->getMetodoPagoId().";";
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }

            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
        }
        else
        {
            throw new Exception( "El id no esta registrado." );
        }
        return true;
    }

    /* Elimina el registro */
    public function delete()
    {
        $s_SQLQuery = "DELETE FROM CP_MetodosPago WHERE  MetodoPagoId = ".$this->getMetodoPagoId().";";
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = Conexion::getConexion();
        $o_Statement = $o_Resource->createStatement();
        $o_Statement->executeQuery( $s_SQLQuery );
        return true;
    }

}
?>