<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: ALM_VehiculoSucursal.xml */
/* Generado: 2020-08-18 04:21:25 */

/* Mantenimiento de los registros de la tabla ALM_VehiculoSucursal */
abstract class BaseALM_VehiculoSucursalDP extends ALM_VehiculoSucursalBV
{
    /* Constructor ( Establece los valores desde un objeto ALM_VehiculoSucursalBN ) */
    public function __construct( ALM_VehiculoSucursalBN $o_ALM_VehiculoSucursalBN = null )
    {
        parent::__construct();
        if ( !is_null( $o_ALM_VehiculoSucursalBN ) )
        {
            $this->setByBN( $o_ALM_VehiculoSucursalBN );
        }
    }

    public $b_Debug = false;

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Establece los valores desde un objeto ALM_VehiculoSucursalBN */
    public function setByBN( ALM_VehiculoSucursalBN $o_ALM_VehiculoSucursalBN )
    {
        if ( !is_null( $o_ALM_VehiculoSucursalBN->getIdVehiculoSucursal() ) )
        {
            $this->setIdVehiculoSucursal( $o_ALM_VehiculoSucursalBN->getIdVehiculoSucursal() );
        }
        if ( !is_null( $o_ALM_VehiculoSucursalBN->getIdSucursal() ) )
        {
            $this->setIdSucursal( $o_ALM_VehiculoSucursalBN->getIdSucursal() );
        }
        if ( !is_null( $o_ALM_VehiculoSucursalBN->getMarca() ) )
        {
            $this->setMarca( $o_ALM_VehiculoSucursalBN->getMarca() );
        }
        if ( !is_null( $o_ALM_VehiculoSucursalBN->getPlaca() ) )
        {
            $this->setPlaca( $o_ALM_VehiculoSucursalBN->getPlaca() );
        }
        if ( !is_null( $o_ALM_VehiculoSucursalBN->getEstado() ) )
        {
            $this->setEstado( $o_ALM_VehiculoSucursalBN->getEstado() );
        }
        if ( !is_null( $o_ALM_VehiculoSucursalBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_ALM_VehiculoSucursalBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_ALM_VehiculoSucursalBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_ALM_VehiculoSucursalBN->getFechaCreacion() );
        }
        if ( !is_null( $o_ALM_VehiculoSucursalBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_ALM_VehiculoSucursalBN->getUsuarioModificacion() );
        }
        if ( !is_null( $o_ALM_VehiculoSucursalBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_ALM_VehiculoSucursalBN->getFechaModificacion() );
        }
    }

    /* Graba un nuevo registro */
    public function save()
    {
        $this->validateRecord();
        $o_ALM_VehiculoSucursalFN = new ALM_VehiculoSucursalFN();
        $o_ALM_VehiculoSucursalBN = $o_ALM_VehiculoSucursalFN->selectByPk( $this->getIdVehiculoSucursal() );
        if ( is_null( $o_ALM_VehiculoSucursalBN ) )
        {
            $s_SQLQuery1 = "INSERT INTO ALM_VehiculoSucursal ( ";
            $s_SQLQuery2 = "VALUES ( ";
            $s_Separator = "";
            if ( !is_null( $this->getIdVehiculoSucursal() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdVehiculoSucursal";
                $s_SQLQuery2 .= $s_Separator."".$this->getIdVehiculoSucursal()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdSucursal() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdSucursal";
                $s_SQLQuery2 .= $s_Separator."".$this->getIdSucursal()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getMarca() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Marca";
                $s_SQLQuery2 .= $s_Separator."'".$this->getMarca()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getPlaca() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Placa";
                $s_SQLQuery2 .= $s_Separator."'".$this->getPlaca()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEstado() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Estado";
                $s_SQLQuery2 .= $s_Separator."'".$this->getEstado()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioCreacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UsuarioCreacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUsuarioCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaCreacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaCreacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioModificacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UsuarioModificacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUsuarioModificacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaModificacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaModificacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaModificacion()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery = $s_SQLQuery1." ) ".$s_SQLQuery2." );";
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        }
        else
        {
            throw new Exception( "El id ya esta registrado." );
        }
        return true;
    }

    /* Actualiza los datos del registro */
    public function update()
    {
        $this->validateRecord();
        if ( true )
        {
            $s_SQLQuery = "UPDATE ALM_VehiculoSucursal SET ";
            $s_Separator = "";
            if ( !is_null( $this->getIdSucursal() ) )
            {
                $s_SQLQuery .= $s_Separator."IdSucursal = ".$this->getIdSucursal()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getMarca() ) )
            {
                $s_SQLQuery .= $s_Separator."Marca = '".$this->getMarca()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getPlaca() ) )
            {
                $s_SQLQuery .= $s_Separator."Placa = '".$this->getPlaca()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEstado() ) )
            {
                $s_SQLQuery .= $s_Separator."Estado = '".$this->getEstado()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioCreacion() ) )
            {
                $s_SQLQuery .= $s_Separator."UsuarioCreacion = '".$this->getUsuarioCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaCreacion() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaCreacion = '".$this->getFechaCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioModificacion() ) )
            {
                $s_SQLQuery .= $s_Separator."UsuarioModificacion = '".$this->getUsuarioModificacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaModificacion() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaModificacion = '".$this->getFechaModificacion()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery .= " WHERE  IdVehiculoSucursal = ".$this->getIdVehiculoSucursal().";";
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        }
        else
        {
            throw new Exception( "El id no esta registrado." );
        }
        return true;
    }

    /* Elimina el registro */
    public function delete()
    {
        $s_SQLQuery = "DELETE FROM ALM_VehiculoSucursal WHERE  IdVehiculoSucursal = ".$this->getIdVehiculoSucursal().";";
        $o_Resource = Conexion::getConexion();
        $o_Statement = $o_Resource->createStatement();
        $o_Statement->executeQuery( $s_SQLQuery );
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        return true;
    }

}
?>