<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: ALM_ItemStockDetHis.xml */
/* Generado: 2020-08-18 04:21:24 */

/* Mantenimiento de los registros de la tabla ALM_ItemStockDetHis */
abstract class BaseALM_ItemStockDetHisDP extends ALM_ItemStockDetHisBV
{
    /* Constructor ( Establece los valores desde un objeto ALM_ItemStockDetHisBN ) */
    public function __construct( ALM_ItemStockDetHisBN $o_ALM_ItemStockDetHisBN = null )
    {
        parent::__construct();
        if ( !is_null( $o_ALM_ItemStockDetHisBN ) )
        {
            $this->setByBN( $o_ALM_ItemStockDetHisBN );
        }
    }

    public $b_Debug = false;

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Establece los valores desde un objeto ALM_ItemStockDetHisBN */
    public function setByBN( ALM_ItemStockDetHisBN $o_ALM_ItemStockDetHisBN )
    {
        if ( !is_null( $o_ALM_ItemStockDetHisBN->getIdCompania() ) )
        {
            $this->setIdCompania( $o_ALM_ItemStockDetHisBN->getIdCompania() );
        }
        if ( !is_null( $o_ALM_ItemStockDetHisBN->getIdSucursal() ) )
        {
            $this->setIdSucursal( $o_ALM_ItemStockDetHisBN->getIdSucursal() );
        }
        if ( !is_null( $o_ALM_ItemStockDetHisBN->getIdFecha() ) )
        {
            $this->setIdFecha( $o_ALM_ItemStockDetHisBN->getIdFecha() );
        }
        if ( !is_null( $o_ALM_ItemStockDetHisBN->getIdAlmacen() ) )
        {
            $this->setIdAlmacen( $o_ALM_ItemStockDetHisBN->getIdAlmacen() );
        }
        if ( !is_null( $o_ALM_ItemStockDetHisBN->getIdLote() ) )
        {
            $this->setIdLote( $o_ALM_ItemStockDetHisBN->getIdLote() );
        }
        if ( !is_null( $o_ALM_ItemStockDetHisBN->getIdItem() ) )
        {
            $this->setIdItem( $o_ALM_ItemStockDetHisBN->getIdItem() );
        }
        if ( !is_null( $o_ALM_ItemStockDetHisBN->getStockFisico() ) )
        {
            $this->setStockFisico( $o_ALM_ItemStockDetHisBN->getStockFisico() );
        }
        if ( !is_null( $o_ALM_ItemStockDetHisBN->getCosto() ) )
        {
            $this->setCosto( $o_ALM_ItemStockDetHisBN->getCosto() );
        }
        if ( !is_null( $o_ALM_ItemStockDetHisBN->getCostoDolares() ) )
        {
            $this->setCostoDolares( $o_ALM_ItemStockDetHisBN->getCostoDolares() );
        }
        if ( !is_null( $o_ALM_ItemStockDetHisBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_ALM_ItemStockDetHisBN->getFechaCreacion() );
        }
        if ( !is_null( $o_ALM_ItemStockDetHisBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_ALM_ItemStockDetHisBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_ALM_ItemStockDetHisBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_ALM_ItemStockDetHisBN->getFechaModificacion() );
        }
        if ( !is_null( $o_ALM_ItemStockDetHisBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_ALM_ItemStockDetHisBN->getUsuarioModificacion() );
        }
    }

    /* Graba un nuevo registro */
    public function save()
    {
        $this->validateRecord();
        $o_ALM_ItemStockDetHisFN = new ALM_ItemStockDetHisFN();
        $o_ALM_ItemStockDetHisBN = $o_ALM_ItemStockDetHisFN->selectByPk( $this->getIdCompania(), $this->getIdSucursal(), $this->getIdFecha(), $this->getIdAlmacen(), $this->getIdLote(), $this->getIdItem() );
        if ( is_null( $o_ALM_ItemStockDetHisBN ) )
        {
            $s_SQLQuery1 = "INSERT INTO ALM_ItemStockDetHis ( ";
            $s_SQLQuery2 = "VALUES ( ";
            $s_Separator = "";
            if ( !is_null( $this->getIdCompania() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdCompania";
                $s_SQLQuery2 .= $s_Separator."".$this->getIdCompania()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdSucursal() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdSucursal";
                $s_SQLQuery2 .= $s_Separator."".$this->getIdSucursal()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdFecha() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdFecha";
                $s_SQLQuery2 .= $s_Separator."'".$this->getIdFecha()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdAlmacen() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdAlmacen";
                $s_SQLQuery2 .= $s_Separator."'".$this->getIdAlmacen()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdLote() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdLote";
                $s_SQLQuery2 .= $s_Separator."'".$this->getIdLote()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdItem() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdItem";
                $s_SQLQuery2 .= $s_Separator."'".$this->getIdItem()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getStockFisico() ) )
            {
                $s_SQLQuery1 .= $s_Separator."StockFisico";
                $s_SQLQuery2 .= $s_Separator."".$this->getStockFisico()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getCosto() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Costo";
                $s_SQLQuery2 .= $s_Separator."".$this->getCosto()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getCostoDolares() ) )
            {
                $s_SQLQuery1 .= $s_Separator."CostoDolares";
                $s_SQLQuery2 .= $s_Separator."".$this->getCostoDolares()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaCreacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaCreacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioCreacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UsuarioCreacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUsuarioCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaModificacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaModificacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaModificacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioModificacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UsuarioModificacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUsuarioModificacion()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery = $s_SQLQuery1." ) ".$s_SQLQuery2." );";
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        }
        else
        {
            throw new Exception( "El id ya esta registrado." );
        }
        return true;
    }

    /* Actualiza los datos del registro */
    public function update()
    {
        $this->validateRecord();
        if ( true )
        {
            $s_SQLQuery = "UPDATE ALM_ItemStockDetHis SET ";
            $s_Separator = "";
            if ( !is_null( $this->getStockFisico() ) )
            {
                $s_SQLQuery .= $s_Separator."StockFisico = ".$this->getStockFisico()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getCosto() ) )
            {
                $s_SQLQuery .= $s_Separator."Costo = ".$this->getCosto()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getCostoDolares() ) )
            {
                $s_SQLQuery .= $s_Separator."CostoDolares = ".$this->getCostoDolares()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaCreacion() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaCreacion = '".$this->getFechaCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioCreacion() ) )
            {
                $s_SQLQuery .= $s_Separator."UsuarioCreacion = '".$this->getUsuarioCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaModificacion() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaModificacion = '".$this->getFechaModificacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioModificacion() ) )
            {
                $s_SQLQuery .= $s_Separator."UsuarioModificacion = '".$this->getUsuarioModificacion()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery .= " WHERE  IdCompania = ".$this->getIdCompania()." AND  IdSucursal = ".$this->getIdSucursal()." AND  IdFecha = '".$this->getIdFecha()."' AND  IdAlmacen = '".$this->getIdAlmacen()."' AND  IdLote = '".$this->getIdLote()."' AND  IdItem = '".$this->getIdItem()."';";
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        }
        else
        {
            throw new Exception( "El id no esta registrado." );
        }
        return true;
    }

    /* Elimina el registro */
    public function delete()
    {
        $s_SQLQuery = "DELETE FROM ALM_ItemStockDetHis WHERE  IdCompania = ".$this->getIdCompania()." AND  IdSucursal = ".$this->getIdSucursal()." AND  IdFecha = '".$this->getIdFecha()."' AND  IdAlmacen = '".$this->getIdAlmacen()."' AND  IdLote = '".$this->getIdLote()."' AND  IdItem = '".$this->getIdItem()."';";
        $o_Resource = Conexion::getConexion();
        $o_Statement = $o_Resource->createStatement();
        $o_Statement->executeQuery( $s_SQLQuery );
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        return true;
    }

}
?>