<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: ALM_ItemMast.xml */
/* Generado: 2022-12-12 23:29:39 */

/* Mantenimiento de los registros de la tabla ALM_ItemMast */
abstract class BaseALM_ItemMastDP extends ALM_ItemMastBV
{
    /* Constructor ( Establece los valores desde un objeto ALM_ItemMastBN ) */
    public function __construct( ALM_ItemMastBN $o_ALM_ItemMastBN = null )
    {
        parent::__construct();
        if ( !is_null( $o_ALM_ItemMastBN ) )
        {
            $this->setByBN( $o_ALM_ItemMastBN );
        }
    }

    public $b_Debug = false;

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Establece los valores desde un objeto ALM_ItemMastBN */
    public function setByBN( ALM_ItemMastBN $o_ALM_ItemMastBN )
    {
        if ( !is_null( $o_ALM_ItemMastBN->getIdItem() ) )
        {
            $this->setIdItem( $o_ALM_ItemMastBN->getIdItem() );
        }
        if ( !is_null( $o_ALM_ItemMastBN->getIdMarca() ) )
        {
            $this->setIdMarca( $o_ALM_ItemMastBN->getIdMarca() );
        }
        if ( !is_null( $o_ALM_ItemMastBN->getIdItemTipo() ) )
        {
            $this->setIdItemTipo( $o_ALM_ItemMastBN->getIdItemTipo() );
        }
        if ( !is_null( $o_ALM_ItemMastBN->getDescripcionIngles() ) )
        {
            $this->setDescripcionIngles( $o_ALM_ItemMastBN->getDescripcionIngles() );
        }
        if ( !is_null( $o_ALM_ItemMastBN->getDescripcionCompleta() ) )
        {
            $this->setDescripcionCompleta( $o_ALM_ItemMastBN->getDescripcionCompleta() );
        }
        if ( !is_null( $o_ALM_ItemMastBN->getNumeroDeParte() ) )
        {
            $this->setNumeroDeParte( $o_ALM_ItemMastBN->getNumeroDeParte() );
        }
        if ( !is_null( $o_ALM_ItemMastBN->getCodigoInterno() ) )
        {
            $this->setCodigoInterno( $o_ALM_ItemMastBN->getCodigoInterno() );
        }
        if ( !is_null( $o_ALM_ItemMastBN->getCodigoInterno2() ) )
        {
            $this->setCodigoInterno2( $o_ALM_ItemMastBN->getCodigoInterno2() );
        }
        if ( !is_null( $o_ALM_ItemMastBN->getIdItemFiscal() ) )
        {
            $this->setIdItemFiscal( $o_ALM_ItemMastBN->getIdItemFiscal() );
        }
        if ( !is_null( $o_ALM_ItemMastBN->getCodigoSunat() ) )
        {
            $this->setCodigoSunat( $o_ALM_ItemMastBN->getCodigoSunat() );
        }
        if ( !is_null( $o_ALM_ItemMastBN->getUnidadCodigo() ) )
        {
            $this->setUnidadCodigo( $o_ALM_ItemMastBN->getUnidadCodigo() );
        }
        if ( !is_null( $o_ALM_ItemMastBN->getUnidadCompra() ) )
        {
            $this->setUnidadCompra( $o_ALM_ItemMastBN->getUnidadCompra() );
        }
        if ( !is_null( $o_ALM_ItemMastBN->getUnidadVenta() ) )
        {
            $this->setUnidadVenta( $o_ALM_ItemMastBN->getUnidadVenta() );
        }
        if ( !is_null( $o_ALM_ItemMastBN->getUnidadAlmacenaje() ) )
        {
            $this->setUnidadAlmacenaje( $o_ALM_ItemMastBN->getUnidadAlmacenaje() );
        }
        if ( !is_null( $o_ALM_ItemMastBN->getUnidadEmbalaje() ) )
        {
            $this->setUnidadEmbalaje( $o_ALM_ItemMastBN->getUnidadEmbalaje() );
        }
        if ( !is_null( $o_ALM_ItemMastBN->getClasificacionComercial() ) )
        {
            $this->setClasificacionComercial( $o_ALM_ItemMastBN->getClasificacionComercial() );
        }
        if ( !is_null( $o_ALM_ItemMastBN->getCodigoBarras() ) )
        {
            $this->setCodigoBarras( $o_ALM_ItemMastBN->getCodigoBarras() );
        }
        if ( !is_null( $o_ALM_ItemMastBN->getCodigoBarrasFabricante() ) )
        {
            $this->setCodigoBarrasFabricante( $o_ALM_ItemMastBN->getCodigoBarrasFabricante() );
        }
        if ( !is_null( $o_ALM_ItemMastBN->getCodigoBarras2() ) )
        {
            $this->setCodigoBarras2( $o_ALM_ItemMastBN->getCodigoBarras2() );
        }
        if ( !is_null( $o_ALM_ItemMastBN->getMonedaCodigo() ) )
        {
            $this->setMonedaCodigo( $o_ALM_ItemMastBN->getMonedaCodigo() );
        }
        if ( !is_null( $o_ALM_ItemMastBN->getPrecioCosto() ) )
        {
            $this->setPrecioCosto( $o_ALM_ItemMastBN->getPrecioCosto() );
        }
        if ( !is_null( $o_ALM_ItemMastBN->getPrecioVenta() ) )
        {
            $this->setPrecioVenta( $o_ALM_ItemMastBN->getPrecioVenta() );
        }
        if ( !is_null( $o_ALM_ItemMastBN->getUtilidadPorcentaje() ) )
        {
            $this->setUtilidadPorcentaje( $o_ALM_ItemMastBN->getUtilidadPorcentaje() );
        }
        if ( !is_null( $o_ALM_ItemMastBN->getPrecioUnitarioLocal() ) )
        {
            $this->setPrecioUnitarioLocal( $o_ALM_ItemMastBN->getPrecioUnitarioLocal() );
        }
        if ( !is_null( $o_ALM_ItemMastBN->getPrecioUnitarioDolares() ) )
        {
            $this->setPrecioUnitarioDolares( $o_ALM_ItemMastBN->getPrecioUnitarioDolares() );
        }
        if ( !is_null( $o_ALM_ItemMastBN->getDisponibleVentaFlag() ) )
        {
            $this->setDisponibleVentaFlag( $o_ALM_ItemMastBN->getDisponibleVentaFlag() );
        }
        if ( !is_null( $o_ALM_ItemMastBN->getManejoxLoteFlag() ) )
        {
            $this->setManejoxLoteFlag( $o_ALM_ItemMastBN->getManejoxLoteFlag() );
        }
        if ( !is_null( $o_ALM_ItemMastBN->getManejoxSerieFlag() ) )
        {
            $this->setManejoxSerieFlag( $o_ALM_ItemMastBN->getManejoxSerieFlag() );
        }
        if ( !is_null( $o_ALM_ItemMastBN->getManejoxUnidadFlag() ) )
        {
            $this->setManejoxUnidadFlag( $o_ALM_ItemMastBN->getManejoxUnidadFlag() );
        }
        if ( !is_null( $o_ALM_ItemMastBN->getNoAfectoImpuestoVentasFlag() ) )
        {
            $this->setNoAfectoImpuestoVentasFlag( $o_ALM_ItemMastBN->getNoAfectoImpuestoVentasFlag() );
        }
        if ( !is_null( $o_ALM_ItemMastBN->getDisponibleTransferenciaFlag() ) )
        {
            $this->setDisponibleTransferenciaFlag( $o_ALM_ItemMastBN->getDisponibleTransferenciaFlag() );
        }
        if ( !is_null( $o_ALM_ItemMastBN->getStockMinimo() ) )
        {
            $this->setStockMinimo( $o_ALM_ItemMastBN->getStockMinimo() );
        }
        if ( !is_null( $o_ALM_ItemMastBN->getStockMaximo() ) )
        {
            $this->setStockMaximo( $o_ALM_ItemMastBN->getStockMaximo() );
        }
        if ( !is_null( $o_ALM_ItemMastBN->getStockMinFlag() ) )
        {
            $this->setStockMinFlag( $o_ALM_ItemMastBN->getStockMinFlag() );
        }
        if ( !is_null( $o_ALM_ItemMastBN->getLotedeVenta() ) )
        {
            $this->setLotedeVenta( $o_ALM_ItemMastBN->getLotedeVenta() );
        }
        if ( !is_null( $o_ALM_ItemMastBN->getEstado() ) )
        {
            $this->setEstado( $o_ALM_ItemMastBN->getEstado() );
        }
        if ( !is_null( $o_ALM_ItemMastBN->getNombreArchivo() ) )
        {
            $this->setNombreArchivo( $o_ALM_ItemMastBN->getNombreArchivo() );
        }
        if ( !is_null( $o_ALM_ItemMastBN->getUbicacionURL() ) )
        {
            $this->setUbicacionURL( $o_ALM_ItemMastBN->getUbicacionURL() );
        }
        if ( !is_null( $o_ALM_ItemMastBN->getUbicacionFisica() ) )
        {
            $this->setUbicacionFisica( $o_ALM_ItemMastBN->getUbicacionFisica() );
        }
        if ( !is_null( $o_ALM_ItemMastBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_ALM_ItemMastBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_ALM_ItemMastBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_ALM_ItemMastBN->getFechaCreacion() );
        }
        if ( !is_null( $o_ALM_ItemMastBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_ALM_ItemMastBN->getUsuarioModificacion() );
        }
        if ( !is_null( $o_ALM_ItemMastBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_ALM_ItemMastBN->getFechaModificacion() );
        }
        if ( !is_null( $o_ALM_ItemMastBN->getIdLinea() ) )
        {
            $this->setIdLinea( $o_ALM_ItemMastBN->getIdLinea() );
        }
        if ( !is_null( $o_ALM_ItemMastBN->getIdFamilia() ) )
        {
            $this->setIdFamilia( $o_ALM_ItemMastBN->getIdFamilia() );
        }
        if ( !is_null( $o_ALM_ItemMastBN->getIdSubFamilia() ) )
        {
            $this->setIdSubFamilia( $o_ALM_ItemMastBN->getIdSubFamilia() );
        }
        if ( !is_null( $o_ALM_ItemMastBN->getIdProcedencia() ) )
        {
            $this->setIdProcedencia( $o_ALM_ItemMastBN->getIdProcedencia() );
        }
        if ( !is_null( $o_ALM_ItemMastBN->getTipoGarantiaId() ) )
        {
            $this->setTipoGarantiaId( $o_ALM_ItemMastBN->getTipoGarantiaId() );
        }
        if ( !is_null( $o_ALM_ItemMastBN->getIdTipoOperatividad() ) )
        {
            $this->setIdTipoOperatividad( $o_ALM_ItemMastBN->getIdTipoOperatividad() );
        }
        if ( !is_null( $o_ALM_ItemMastBN->getPesoGramos() ) )
        {
            $this->setPesoGramos( $o_ALM_ItemMastBN->getPesoGramos() );
        }
        if ( !is_null( $o_ALM_ItemMastBN->getAfectoPercepcionIGVFlag() ) )
        {
            $this->setAfectoPercepcionIGVFlag( $o_ALM_ItemMastBN->getAfectoPercepcionIGVFlag() );
        }
        if ( !is_null( $o_ALM_ItemMastBN->getAfectoDetraccionFlag() ) )
        {
            $this->setAfectoDetraccionFlag( $o_ALM_ItemMastBN->getAfectoDetraccionFlag() );
        }
        if ( !is_null( $o_ALM_ItemMastBN->getIdDetraccion() ) )
        {
            $this->setIdDetraccion( $o_ALM_ItemMastBN->getIdDetraccion() );
        }
        if ( !is_null( $o_ALM_ItemMastBN->getIdPersona() ) )
        {
            $this->setIdPersona( $o_ALM_ItemMastBN->getIdPersona() );
        }
        if ( !is_null( $o_ALM_ItemMastBN->getCantidadUnidad() ) )
        {
            $this->setCantidadUnidad( $o_ALM_ItemMastBN->getCantidadUnidad() );
        }
        if ( !is_null( $o_ALM_ItemMastBN->getCantidadUnidadCompra() ) )
        {
            $this->setCantidadUnidadCompra( $o_ALM_ItemMastBN->getCantidadUnidadCompra() );
        }
        if ( !is_null( $o_ALM_ItemMastBN->getDescripcionLarga() ) )
        {
            $this->setDescripcionLarga( $o_ALM_ItemMastBN->getDescripcionLarga() );
        }
        if ( !is_null( $o_ALM_ItemMastBN->getEsInventariableFlag() ) )
        {
            $this->setEsInventariableFlag( $o_ALM_ItemMastBN->getEsInventariableFlag() );
        }
        if ( !is_null( $o_ALM_ItemMastBN->getFusionarLoteFlag() ) )
        {
            $this->setFusionarLoteFlag( $o_ALM_ItemMastBN->getFusionarLoteFlag() );
        }
        if ( !is_null( $o_ALM_ItemMastBN->getEsServicioConDias() ) )
        {
            $this->setEsServicioConDias( $o_ALM_ItemMastBN->getEsServicioConDias() );
        }
        if ( !is_null( $o_ALM_ItemMastBN->getUsarDisponibleStock() ) )
        {
            $this->setUsarDisponibleStock( $o_ALM_ItemMastBN->getUsarDisponibleStock() );
        }
        if ( !is_null( $o_ALM_ItemMastBN->getUsarResevableStock() ) )
        {
            $this->setUsarResevableStock( $o_ALM_ItemMastBN->getUsarResevableStock() );
        }
        if ( !is_null( $o_ALM_ItemMastBN->getEsParaVenta() ) )
        {
            $this->setEsParaVenta( $o_ALM_ItemMastBN->getEsParaVenta() );
        }
        if ( !is_null( $o_ALM_ItemMastBN->getIdRangoVenta() ) )
        {
            $this->setIdRangoVenta( $o_ALM_ItemMastBN->getIdRangoVenta() );
        }
        if ( !is_null( $o_ALM_ItemMastBN->getEsParaAlquiler() ) )
        {
            $this->setEsParaAlquiler( $o_ALM_ItemMastBN->getEsParaAlquiler() );
        }
        if ( !is_null( $o_ALM_ItemMastBN->getIdRangoAlquiler() ) )
        {
            $this->setIdRangoAlquiler( $o_ALM_ItemMastBN->getIdRangoAlquiler() );
        }
    }

    /* Graba un nuevo registro */
    public function save()
    {
        $this->validateRecord();
        $o_ALM_ItemMastFN = new ALM_ItemMastFN();
        $o_ALM_ItemMastBN = $o_ALM_ItemMastFN->selectByPk( $this->getIdItem() );
        if ( is_null( $o_ALM_ItemMastBN ) )
        {
            $s_SQLQuery1 = "INSERT INTO ALM_ItemMast ( ";
            $s_SQLQuery2 = "VALUES ( ";
            $s_Separator = "";
            if ( !is_null( $this->getIdItem() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdItem";
                $s_SQLQuery2 .= $s_Separator."'".$this->getIdItem()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdMarca() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdMarca";
                $s_SQLQuery2 .= $s_Separator."'".$this->getIdMarca()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdItemTipo() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdItemTipo";
                $s_SQLQuery2 .= $s_Separator."'".$this->getIdItemTipo()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getDescripcionIngles() ) )
            {
                $s_SQLQuery1 .= $s_Separator."DescripcionIngles";
                $s_SQLQuery2 .= $s_Separator."'".$this->getDescripcionIngles()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getDescripcionCompleta() ) )
            {
                $s_SQLQuery1 .= $s_Separator."DescripcionCompleta";
                $s_SQLQuery2 .= $s_Separator."'".$this->getDescripcionCompleta()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getNumeroDeParte() ) )
            {
                $s_SQLQuery1 .= $s_Separator."NumeroDeParte";
                $s_SQLQuery2 .= $s_Separator."'".$this->getNumeroDeParte()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getCodigoInterno() ) )
            {
                $s_SQLQuery1 .= $s_Separator."CodigoInterno";
                $s_SQLQuery2 .= $s_Separator."'".$this->getCodigoInterno()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getCodigoInterno2() ) )
            {
                $s_SQLQuery1 .= $s_Separator."CodigoInterno2";
                $s_SQLQuery2 .= $s_Separator."'".$this->getCodigoInterno2()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdItemFiscal() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdItemFiscal";
                $s_SQLQuery2 .= $s_Separator."".$this->getIdItemFiscal()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getCodigoSunat() ) )
            {
                $s_SQLQuery1 .= $s_Separator."CodigoSunat";
                $s_SQLQuery2 .= $s_Separator."'".$this->getCodigoSunat()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUnidadCodigo() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UnidadCodigo";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUnidadCodigo()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUnidadCompra() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UnidadCompra";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUnidadCompra()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUnidadVenta() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UnidadVenta";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUnidadVenta()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUnidadAlmacenaje() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UnidadAlmacenaje";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUnidadAlmacenaje()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUnidadEmbalaje() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UnidadEmbalaje";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUnidadEmbalaje()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getClasificacionComercial() ) )
            {
                $s_SQLQuery1 .= $s_Separator."ClasificacionComercial";
                $s_SQLQuery2 .= $s_Separator."'".$this->getClasificacionComercial()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getCodigoBarras() ) )
            {
                $s_SQLQuery1 .= $s_Separator."CodigoBarras";
                $s_SQLQuery2 .= $s_Separator."'".$this->getCodigoBarras()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getCodigoBarrasFabricante() ) )
            {
                $s_SQLQuery1 .= $s_Separator."CodigoBarrasFabricante";
                $s_SQLQuery2 .= $s_Separator."'".$this->getCodigoBarrasFabricante()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getCodigoBarras2() ) )
            {
                $s_SQLQuery1 .= $s_Separator."CodigoBarras2";
                $s_SQLQuery2 .= $s_Separator."'".$this->getCodigoBarras2()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getMonedaCodigo() ) )
            {
                $s_SQLQuery1 .= $s_Separator."MonedaCodigo";
                $s_SQLQuery2 .= $s_Separator."'".$this->getMonedaCodigo()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getPrecioCosto() ) )
            {
                $s_SQLQuery1 .= $s_Separator."PrecioCosto";
                $s_SQLQuery2 .= $s_Separator."".$this->getPrecioCosto()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getPrecioVenta() ) )
            {
                $s_SQLQuery1 .= $s_Separator."PrecioVenta";
                $s_SQLQuery2 .= $s_Separator."".$this->getPrecioVenta()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUtilidadPorcentaje() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UtilidadPorcentaje";
                $s_SQLQuery2 .= $s_Separator."".$this->getUtilidadPorcentaje()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getPrecioUnitarioLocal() ) )
            {
                $s_SQLQuery1 .= $s_Separator."PrecioUnitarioLocal";
                $s_SQLQuery2 .= $s_Separator."".$this->getPrecioUnitarioLocal()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getPrecioUnitarioDolares() ) )
            {
                $s_SQLQuery1 .= $s_Separator."PrecioUnitarioDolares";
                $s_SQLQuery2 .= $s_Separator."".$this->getPrecioUnitarioDolares()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getDisponibleVentaFlag() ) )
            {
                $s_SQLQuery1 .= $s_Separator."DisponibleVentaFlag";
                $s_SQLQuery2 .= $s_Separator."'".$this->getDisponibleVentaFlag()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getManejoxLoteFlag() ) )
            {
                $s_SQLQuery1 .= $s_Separator."ManejoxLoteFlag";
                $s_SQLQuery2 .= $s_Separator."'".$this->getManejoxLoteFlag()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getManejoxSerieFlag() ) )
            {
                $s_SQLQuery1 .= $s_Separator."ManejoxSerieFlag";
                $s_SQLQuery2 .= $s_Separator."'".$this->getManejoxSerieFlag()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getManejoxUnidadFlag() ) )
            {
                $s_SQLQuery1 .= $s_Separator."ManejoxUnidadFlag";
                $s_SQLQuery2 .= $s_Separator."'".$this->getManejoxUnidadFlag()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getNoAfectoImpuestoVentasFlag() ) )
            {
                $s_SQLQuery1 .= $s_Separator."NoAfectoImpuestoVentasFlag";
                $s_SQLQuery2 .= $s_Separator."'".$this->getNoAfectoImpuestoVentasFlag()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getDisponibleTransferenciaFlag() ) )
            {
                $s_SQLQuery1 .= $s_Separator."DisponibleTransferenciaFlag";
                $s_SQLQuery2 .= $s_Separator."'".$this->getDisponibleTransferenciaFlag()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getStockMinimo() ) )
            {
                $s_SQLQuery1 .= $s_Separator."StockMinimo";
                $s_SQLQuery2 .= $s_Separator."".$this->getStockMinimo()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getStockMaximo() ) )
            {
                $s_SQLQuery1 .= $s_Separator."StockMaximo";
                $s_SQLQuery2 .= $s_Separator."".$this->getStockMaximo()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getStockMinFlag() ) )
            {
                $s_SQLQuery1 .= $s_Separator."StockMinFlag";
                $s_SQLQuery2 .= $s_Separator."'".$this->getStockMinFlag()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getLotedeVenta() ) )
            {
                $s_SQLQuery1 .= $s_Separator."LotedeVenta";
                $s_SQLQuery2 .= $s_Separator."".$this->getLotedeVenta()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEstado() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Estado";
                $s_SQLQuery2 .= $s_Separator."'".$this->getEstado()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getNombreArchivo() ) )
            {
                $s_SQLQuery1 .= $s_Separator."NombreArchivo";
                $s_SQLQuery2 .= $s_Separator."'".$this->getNombreArchivo()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUbicacionURL() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UbicacionURL";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUbicacionURL()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUbicacionFisica() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UbicacionFisica";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUbicacionFisica()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioCreacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UsuarioCreacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUsuarioCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaCreacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaCreacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioModificacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UsuarioModificacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUsuarioModificacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaModificacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaModificacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaModificacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdLinea() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdLinea";
                $s_SQLQuery2 .= $s_Separator."".$this->getIdLinea()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdFamilia() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdFamilia";
                $s_SQLQuery2 .= $s_Separator."".$this->getIdFamilia()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdSubFamilia() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdSubFamilia";
                $s_SQLQuery2 .= $s_Separator."".$this->getIdSubFamilia()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdProcedencia() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdProcedencia";
                $s_SQLQuery2 .= $s_Separator."'".$this->getIdProcedencia()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getTipoGarantiaId() ) )
            {
                $s_SQLQuery1 .= $s_Separator."TipoGarantiaId";
                $s_SQLQuery2 .= $s_Separator."'".$this->getTipoGarantiaId()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdTipoOperatividad() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdTipoOperatividad";
                $s_SQLQuery2 .= $s_Separator."'".$this->getIdTipoOperatividad()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getPesoGramos() ) )
            {
                $s_SQLQuery1 .= $s_Separator."PesoGramos";
                $s_SQLQuery2 .= $s_Separator."".$this->getPesoGramos()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getAfectoPercepcionIGVFlag() ) )
            {
                $s_SQLQuery1 .= $s_Separator."AfectoPercepcionIGVFlag";
                $s_SQLQuery2 .= $s_Separator."'".$this->getAfectoPercepcionIGVFlag()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getAfectoDetraccionFlag() ) )
            {
                $s_SQLQuery1 .= $s_Separator."AfectoDetraccionFlag";
                $s_SQLQuery2 .= $s_Separator."'".$this->getAfectoDetraccionFlag()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdDetraccion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdDetraccion";
                $s_SQLQuery2 .= $s_Separator."".$this->getIdDetraccion()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdPersona() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdPersona";
                $s_SQLQuery2 .= $s_Separator."".$this->getIdPersona()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getCantidadUnidad() ) )
            {
                $s_SQLQuery1 .= $s_Separator."CantidadUnidad";
                $s_SQLQuery2 .= $s_Separator."".$this->getCantidadUnidad()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getCantidadUnidadCompra() ) )
            {
                $s_SQLQuery1 .= $s_Separator."CantidadUnidadCompra";
                $s_SQLQuery2 .= $s_Separator."".$this->getCantidadUnidadCompra()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getDescripcionLarga() ) )
            {
                $s_SQLQuery1 .= $s_Separator."DescripcionLarga";
                $s_SQLQuery2 .= $s_Separator."'".$this->getDescripcionLarga()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEsInventariableFlag() ) )
            {
                $s_SQLQuery1 .= $s_Separator."EsInventariableFlag";
                $s_SQLQuery2 .= $s_Separator."'".$this->getEsInventariableFlag()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFusionarLoteFlag() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FusionarLoteFlag";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFusionarLoteFlag()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEsServicioConDias() ) )
            {
                $s_SQLQuery1 .= $s_Separator."EsServicioConDias";
                $s_SQLQuery2 .= $s_Separator."'".$this->getEsServicioConDias()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsarDisponibleStock() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UsarDisponibleStock";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUsarDisponibleStock()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsarResevableStock() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UsarResevableStock";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUsarResevableStock()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEsParaVenta() ) )
            {
                $s_SQLQuery1 .= $s_Separator."EsParaVenta";
                $s_SQLQuery2 .= $s_Separator."'".$this->getEsParaVenta()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdRangoVenta() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdRangoVenta";
                $s_SQLQuery2 .= $s_Separator."".$this->getIdRangoVenta()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEsParaAlquiler() ) )
            {
                $s_SQLQuery1 .= $s_Separator."EsParaAlquiler";
                $s_SQLQuery2 .= $s_Separator."'".$this->getEsParaAlquiler()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdRangoAlquiler() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdRangoAlquiler";
                $s_SQLQuery2 .= $s_Separator."".$this->getIdRangoAlquiler()."";
                $s_Separator = ", ";
            }
            $s_SQLQuery = $s_SQLQuery1." ) ".$s_SQLQuery2." );";
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
        }
        else
        {
            throw new Exception( "El id ya esta registrado." );
        }
        return true;
    }

    /* Actualiza los datos del registro */
    public function update()
    {
        $this->validateRecord();
        if ( true )
        {
            $s_SQLQuery = "UPDATE ALM_ItemMast SET ";
            $s_Separator = "";
            if ( !is_null( $this->getIdMarca() ) )
            {
                $s_SQLQuery .= $s_Separator."IdMarca = '".$this->getIdMarca()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdItemTipo() ) )
            {
                $s_SQLQuery .= $s_Separator."IdItemTipo = '".$this->getIdItemTipo()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getDescripcionIngles() ) )
            {
                $s_SQLQuery .= $s_Separator."DescripcionIngles = '".$this->getDescripcionIngles()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getDescripcionCompleta() ) )
            {
                $s_SQLQuery .= $s_Separator."DescripcionCompleta = '".$this->getDescripcionCompleta()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getNumeroDeParte() ) )
            {
                $s_SQLQuery .= $s_Separator."NumeroDeParte = '".$this->getNumeroDeParte()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getCodigoInterno() ) )
            {
                $s_SQLQuery .= $s_Separator."CodigoInterno = '".$this->getCodigoInterno()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getCodigoInterno2() ) )
            {
                $s_SQLQuery .= $s_Separator."CodigoInterno2 = '".$this->getCodigoInterno2()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdItemFiscal() ) )
            {
                $s_SQLQuery .= $s_Separator."IdItemFiscal = ".$this->getIdItemFiscal()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getCodigoSunat() ) )
            {
                $s_SQLQuery .= $s_Separator."CodigoSunat = '".$this->getCodigoSunat()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUnidadCodigo() ) )
            {
                $s_SQLQuery .= $s_Separator."UnidadCodigo = '".$this->getUnidadCodigo()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUnidadCompra() ) )
            {
                $s_SQLQuery .= $s_Separator."UnidadCompra = '".$this->getUnidadCompra()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUnidadVenta() ) )
            {
                $s_SQLQuery .= $s_Separator."UnidadVenta = '".$this->getUnidadVenta()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUnidadAlmacenaje() ) )
            {
                $s_SQLQuery .= $s_Separator."UnidadAlmacenaje = '".$this->getUnidadAlmacenaje()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUnidadEmbalaje() ) )
            {
                $s_SQLQuery .= $s_Separator."UnidadEmbalaje = '".$this->getUnidadEmbalaje()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getClasificacionComercial() ) )
            {
                $s_SQLQuery .= $s_Separator."ClasificacionComercial = '".$this->getClasificacionComercial()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getCodigoBarras() ) )
            {
                $s_SQLQuery .= $s_Separator."CodigoBarras = '".$this->getCodigoBarras()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getCodigoBarrasFabricante() ) )
            {
                $s_SQLQuery .= $s_Separator."CodigoBarrasFabricante = '".$this->getCodigoBarrasFabricante()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getCodigoBarras2() ) )
            {
                $s_SQLQuery .= $s_Separator."CodigoBarras2 = '".$this->getCodigoBarras2()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getMonedaCodigo() ) )
            {
                $s_SQLQuery .= $s_Separator."MonedaCodigo = '".$this->getMonedaCodigo()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getPrecioCosto() ) )
            {
                $s_SQLQuery .= $s_Separator."PrecioCosto = ".$this->getPrecioCosto()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getPrecioVenta() ) )
            {
                $s_SQLQuery .= $s_Separator."PrecioVenta = ".$this->getPrecioVenta()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUtilidadPorcentaje() ) )
            {
                $s_SQLQuery .= $s_Separator."UtilidadPorcentaje = ".$this->getUtilidadPorcentaje()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getPrecioUnitarioLocal() ) )
            {
                $s_SQLQuery .= $s_Separator."PrecioUnitarioLocal = ".$this->getPrecioUnitarioLocal()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getPrecioUnitarioDolares() ) )
            {
                $s_SQLQuery .= $s_Separator."PrecioUnitarioDolares = ".$this->getPrecioUnitarioDolares()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getDisponibleVentaFlag() ) )
            {
                $s_SQLQuery .= $s_Separator."DisponibleVentaFlag = '".$this->getDisponibleVentaFlag()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getManejoxLoteFlag() ) )
            {
                $s_SQLQuery .= $s_Separator."ManejoxLoteFlag = '".$this->getManejoxLoteFlag()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getManejoxSerieFlag() ) )
            {
                $s_SQLQuery .= $s_Separator."ManejoxSerieFlag = '".$this->getManejoxSerieFlag()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getManejoxUnidadFlag() ) )
            {
                $s_SQLQuery .= $s_Separator."ManejoxUnidadFlag = '".$this->getManejoxUnidadFlag()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getNoAfectoImpuestoVentasFlag() ) )
            {
                $s_SQLQuery .= $s_Separator."NoAfectoImpuestoVentasFlag = '".$this->getNoAfectoImpuestoVentasFlag()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getDisponibleTransferenciaFlag() ) )
            {
                $s_SQLQuery .= $s_Separator."DisponibleTransferenciaFlag = '".$this->getDisponibleTransferenciaFlag()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getStockMinimo() ) )
            {
                $s_SQLQuery .= $s_Separator."StockMinimo = ".$this->getStockMinimo()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getStockMaximo() ) )
            {
                $s_SQLQuery .= $s_Separator."StockMaximo = ".$this->getStockMaximo()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getStockMinFlag() ) )
            {
                $s_SQLQuery .= $s_Separator."StockMinFlag = '".$this->getStockMinFlag()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getLotedeVenta() ) )
            {
                $s_SQLQuery .= $s_Separator."LotedeVenta = ".$this->getLotedeVenta()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEstado() ) )
            {
                $s_SQLQuery .= $s_Separator."Estado = '".$this->getEstado()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getNombreArchivo() ) )
            {
                $s_SQLQuery .= $s_Separator."NombreArchivo = '".$this->getNombreArchivo()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUbicacionURL() ) )
            {
                $s_SQLQuery .= $s_Separator."UbicacionURL = '".$this->getUbicacionURL()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUbicacionFisica() ) )
            {
                $s_SQLQuery .= $s_Separator."UbicacionFisica = '".$this->getUbicacionFisica()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioCreacion() ) )
            {
                $s_SQLQuery .= $s_Separator."UsuarioCreacion = '".$this->getUsuarioCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaCreacion() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaCreacion = '".$this->getFechaCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioModificacion() ) )
            {
                $s_SQLQuery .= $s_Separator."UsuarioModificacion = '".$this->getUsuarioModificacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaModificacion() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaModificacion = '".$this->getFechaModificacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdLinea() ) )
            {
                $s_SQLQuery .= $s_Separator."IdLinea = ".$this->getIdLinea()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdFamilia() ) )
            {
                $s_SQLQuery .= $s_Separator."IdFamilia = ".$this->getIdFamilia()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdSubFamilia() ) )
            {
                $s_SQLQuery .= $s_Separator."IdSubFamilia = ".$this->getIdSubFamilia()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdProcedencia() ) )
            {
                $s_SQLQuery .= $s_Separator."IdProcedencia = '".$this->getIdProcedencia()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getTipoGarantiaId() ) )
            {
                $s_SQLQuery .= $s_Separator."TipoGarantiaId = '".$this->getTipoGarantiaId()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdTipoOperatividad() ) )
            {
                $s_SQLQuery .= $s_Separator."IdTipoOperatividad = '".$this->getIdTipoOperatividad()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getPesoGramos() ) )
            {
                $s_SQLQuery .= $s_Separator."PesoGramos = ".$this->getPesoGramos()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getAfectoPercepcionIGVFlag() ) )
            {
                $s_SQLQuery .= $s_Separator."AfectoPercepcionIGVFlag = '".$this->getAfectoPercepcionIGVFlag()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getAfectoDetraccionFlag() ) )
            {
                $s_SQLQuery .= $s_Separator."AfectoDetraccionFlag = '".$this->getAfectoDetraccionFlag()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdDetraccion() ) )
            {
                $s_SQLQuery .= $s_Separator."IdDetraccion = ".$this->getIdDetraccion()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdPersona() ) )
            {
                $s_SQLQuery .= $s_Separator."IdPersona = ".$this->getIdPersona()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getCantidadUnidad() ) )
            {
                $s_SQLQuery .= $s_Separator."CantidadUnidad = ".$this->getCantidadUnidad()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getCantidadUnidadCompra() ) )
            {
                $s_SQLQuery .= $s_Separator."CantidadUnidadCompra = ".$this->getCantidadUnidadCompra()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getDescripcionLarga() ) )
            {
                $s_SQLQuery .= $s_Separator."DescripcionLarga = '".$this->getDescripcionLarga()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEsInventariableFlag() ) )
            {
                $s_SQLQuery .= $s_Separator."EsInventariableFlag = '".$this->getEsInventariableFlag()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFusionarLoteFlag() ) )
            {
                $s_SQLQuery .= $s_Separator."FusionarLoteFlag = '".$this->getFusionarLoteFlag()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEsServicioConDias() ) )
            {
                $s_SQLQuery .= $s_Separator."EsServicioConDias = '".$this->getEsServicioConDias()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsarDisponibleStock() ) )
            {
                $s_SQLQuery .= $s_Separator."UsarDisponibleStock = '".$this->getUsarDisponibleStock()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsarResevableStock() ) )
            {
                $s_SQLQuery .= $s_Separator."UsarResevableStock = '".$this->getUsarResevableStock()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEsParaVenta() ) )
            {
                $s_SQLQuery .= $s_Separator."EsParaVenta = '".$this->getEsParaVenta()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdRangoVenta() ) )
            {
                $s_SQLQuery .= $s_Separator."IdRangoVenta = ".$this->getIdRangoVenta()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEsParaAlquiler() ) )
            {
                $s_SQLQuery .= $s_Separator."EsParaAlquiler = '".$this->getEsParaAlquiler()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdRangoAlquiler() ) )
            {
                $s_SQLQuery .= $s_Separator."IdRangoAlquiler = ".$this->getIdRangoAlquiler()."";
                $s_Separator = ", ";
            }
            $s_SQLQuery .= " WHERE  IdItem = '".$this->getIdItem()."';";
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }

            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
        }
        else
        {
            throw new Exception( "El id no esta registrado." );
        }
        return true;
    }

    /* Elimina el registro */
    public function delete()
    {
        $s_SQLQuery = "DELETE FROM ALM_ItemMast WHERE  IdItem = '".$this->getIdItem()."';";
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = Conexion::getConexion();
        $o_Statement = $o_Resource->createStatement();
        $o_Statement->executeQuery( $s_SQLQuery );
        return true;
    }

}
?>