<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: ALM_InventarioFisico.xml */
/* Generado: 2020-08-18 04:21:23 */

/* Mantenimiento de los registros de la tabla ALM_InventarioFisico */
abstract class BaseALM_InventarioFisicoDP extends ALM_InventarioFisicoBV
{
    /* Constructor ( Establece los valores desde un objeto ALM_InventarioFisicoBN ) */
    public function __construct( ALM_InventarioFisicoBN $o_ALM_InventarioFisicoBN = null )
    {
        parent::__construct();
        if ( !is_null( $o_ALM_InventarioFisicoBN ) )
        {
            $this->setByBN( $o_ALM_InventarioFisicoBN );
        }
    }

    public $b_Debug = false;

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Establece los valores desde un objeto ALM_InventarioFisicoBN */
    public function setByBN( ALM_InventarioFisicoBN $o_ALM_InventarioFisicoBN )
    {
        if ( !is_null( $o_ALM_InventarioFisicoBN->getIdCompania() ) )
        {
            $this->setIdCompania( $o_ALM_InventarioFisicoBN->getIdCompania() );
        }
        if ( !is_null( $o_ALM_InventarioFisicoBN->getIdNumeroInventario() ) )
        {
            $this->setIdNumeroInventario( $o_ALM_InventarioFisicoBN->getIdNumeroInventario() );
        }
        if ( !is_null( $o_ALM_InventarioFisicoBN->getFechaInventario() ) )
        {
            $this->setFechaInventario( $o_ALM_InventarioFisicoBN->getFechaInventario() );
        }
        if ( !is_null( $o_ALM_InventarioFisicoBN->getInventariadoPor() ) )
        {
            $this->setInventariadoPor( $o_ALM_InventarioFisicoBN->getInventariadoPor() );
        }
        if ( !is_null( $o_ALM_InventarioFisicoBN->getComentarios() ) )
        {
            $this->setComentarios( $o_ALM_InventarioFisicoBN->getComentarios() );
        }
        if ( !is_null( $o_ALM_InventarioFisicoBN->getEstado() ) )
        {
            $this->setEstado( $o_ALM_InventarioFisicoBN->getEstado() );
        }
        if ( !is_null( $o_ALM_InventarioFisicoBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_ALM_InventarioFisicoBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_ALM_InventarioFisicoBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_ALM_InventarioFisicoBN->getFechaCreacion() );
        }
        if ( !is_null( $o_ALM_InventarioFisicoBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_ALM_InventarioFisicoBN->getUsuarioModificacion() );
        }
        if ( !is_null( $o_ALM_InventarioFisicoBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_ALM_InventarioFisicoBN->getFechaModificacion() );
        }
    }

    /* Graba un nuevo registro */
    public function save()
    {
        $this->validateRecord();
        $o_ALM_InventarioFisicoFN = new ALM_InventarioFisicoFN();
        $o_ALM_InventarioFisicoBN = $o_ALM_InventarioFisicoFN->selectByPk( $this->getIdCompania(), $this->getIdNumeroInventario() );
        if ( is_null( $o_ALM_InventarioFisicoBN ) )
        {
            $s_SQLQuery1 = "INSERT INTO ALM_InventarioFisico ( ";
            $s_SQLQuery2 = "VALUES ( ";
            $s_Separator = "";
            if ( !is_null( $this->getIdCompania() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdCompania";
                $s_SQLQuery2 .= $s_Separator."".$this->getIdCompania()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdNumeroInventario() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdNumeroInventario";
                $s_SQLQuery2 .= $s_Separator."'".$this->getIdNumeroInventario()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaInventario() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaInventario";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaInventario()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getInventariadoPor() ) )
            {
                $s_SQLQuery1 .= $s_Separator."InventariadoPor";
                $s_SQLQuery2 .= $s_Separator."'".$this->getInventariadoPor()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getComentarios() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Comentarios";
                $s_SQLQuery2 .= $s_Separator."'".$this->getComentarios()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEstado() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Estado";
                $s_SQLQuery2 .= $s_Separator."'".$this->getEstado()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioCreacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UsuarioCreacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUsuarioCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaCreacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaCreacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioModificacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UsuarioModificacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUsuarioModificacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaModificacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaModificacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaModificacion()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery = $s_SQLQuery1." ) ".$s_SQLQuery2." );";
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        }
        else
        {
            throw new Exception( "El id ya esta registrado." );
        }
        return true;
    }

    /* Actualiza los datos del registro */
    public function update()
    {
        $this->validateRecord();
        if ( true )
        {
            $s_SQLQuery = "UPDATE ALM_InventarioFisico SET ";
            $s_Separator = "";
            if ( !is_null( $this->getFechaInventario() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaInventario = '".$this->getFechaInventario()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getInventariadoPor() ) )
            {
                $s_SQLQuery .= $s_Separator."InventariadoPor = '".$this->getInventariadoPor()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getComentarios() ) )
            {
                $s_SQLQuery .= $s_Separator."Comentarios = '".$this->getComentarios()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getEstado() ) )
            {
                $s_SQLQuery .= $s_Separator."Estado = '".$this->getEstado()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioCreacion() ) )
            {
                $s_SQLQuery .= $s_Separator."UsuarioCreacion = '".$this->getUsuarioCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaCreacion() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaCreacion = '".$this->getFechaCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioModificacion() ) )
            {
                $s_SQLQuery .= $s_Separator."UsuarioModificacion = '".$this->getUsuarioModificacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaModificacion() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaModificacion = '".$this->getFechaModificacion()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery .= " WHERE  IdCompania = ".$this->getIdCompania()." AND  IdNumeroInventario = '".$this->getIdNumeroInventario()."';";
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        }
        else
        {
            throw new Exception( "El id no esta registrado." );
        }
        return true;
    }

    /* Elimina el registro */
    public function delete()
    {
        $s_SQLQuery = "DELETE FROM ALM_InventarioFisico WHERE  IdCompania = ".$this->getIdCompania()." AND  IdNumeroInventario = '".$this->getIdNumeroInventario()."';";
        $o_Resource = Conexion::getConexion();
        $o_Statement = $o_Resource->createStatement();
        $o_Statement->executeQuery( $s_SQLQuery );
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        return true;
    }

}
?>