<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: ALM_CajaChicaItem.xml */
/* Generado: 2020-08-18 04:21:23 */

/* Mantenimiento de los registros de la tabla ALM_CajaChicaItem */
abstract class BaseALM_CajaChicaItemDP extends ALM_CajaChicaItemBV
{
    /* Constructor ( Establece los valores desde un objeto ALM_CajaChicaItemBN ) */
    public function __construct( ALM_CajaChicaItemBN $o_ALM_CajaChicaItemBN = null )
    {
        parent::__construct();
        if ( !is_null( $o_ALM_CajaChicaItemBN ) )
        {
            $this->setByBN( $o_ALM_CajaChicaItemBN );
        }
    }

    public $b_Debug = false;

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Establece los valores desde un objeto ALM_CajaChicaItemBN */
    public function setByBN( ALM_CajaChicaItemBN $o_ALM_CajaChicaItemBN )
    {
        if ( !is_null( $o_ALM_CajaChicaItemBN->getIdCajaDet() ) )
        {
            $this->setIdCajaDet( $o_ALM_CajaChicaItemBN->getIdCajaDet() );
        }
        if ( !is_null( $o_ALM_CajaChicaItemBN->getIdSecuencia() ) )
        {
            $this->setIdSecuencia( $o_ALM_CajaChicaItemBN->getIdSecuencia() );
        }
        if ( !is_null( $o_ALM_CajaChicaItemBN->getIdItem() ) )
        {
            $this->setIdItem( $o_ALM_CajaChicaItemBN->getIdItem() );
        }
        if ( !is_null( $o_ALM_CajaChicaItemBN->getDescripcion() ) )
        {
            $this->setDescripcion( $o_ALM_CajaChicaItemBN->getDescripcion() );
        }
        if ( !is_null( $o_ALM_CajaChicaItemBN->getCantidad() ) )
        {
            $this->setCantidad( $o_ALM_CajaChicaItemBN->getCantidad() );
        }
        if ( !is_null( $o_ALM_CajaChicaItemBN->getMontoUnitarioConIGV() ) )
        {
            $this->setMontoUnitarioConIGV( $o_ALM_CajaChicaItemBN->getMontoUnitarioConIGV() );
        }
        if ( !is_null( $o_ALM_CajaChicaItemBN->getMontoSubTotal() ) )
        {
            $this->setMontoSubTotal( $o_ALM_CajaChicaItemBN->getMontoSubTotal() );
        }
        if ( !is_null( $o_ALM_CajaChicaItemBN->getMontoIGV() ) )
        {
            $this->setMontoIGV( $o_ALM_CajaChicaItemBN->getMontoIGV() );
        }
        if ( !is_null( $o_ALM_CajaChicaItemBN->getMontoTotal() ) )
        {
            $this->setMontoTotal( $o_ALM_CajaChicaItemBN->getMontoTotal() );
        }
        if ( !is_null( $o_ALM_CajaChicaItemBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_ALM_CajaChicaItemBN->getFechaCreacion() );
        }
        if ( !is_null( $o_ALM_CajaChicaItemBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_ALM_CajaChicaItemBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_ALM_CajaChicaItemBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_ALM_CajaChicaItemBN->getFechaModificacion() );
        }
        if ( !is_null( $o_ALM_CajaChicaItemBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_ALM_CajaChicaItemBN->getUsuarioModificacion() );
        }
    }

    /* Graba un nuevo registro */
    public function save()
    {
        $this->validateRecord();
        $o_ALM_CajaChicaItemFN = new ALM_CajaChicaItemFN();
        $o_ALM_CajaChicaItemBN = $o_ALM_CajaChicaItemFN->selectByPk( $this->getIdCajaDet(), $this->getIdSecuencia() );
        if ( is_null( $o_ALM_CajaChicaItemBN ) )
        {
            $s_SQLQuery1 = "INSERT INTO ALM_CajaChicaItem ( ";
            $s_SQLQuery2 = "VALUES ( ";
            $s_Separator = "";
            if ( !is_null( $this->getIdCajaDet() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdCajaDet";
                $s_SQLQuery2 .= $s_Separator."".$this->getIdCajaDet()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdSecuencia() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdSecuencia";
                $s_SQLQuery2 .= $s_Separator."".$this->getIdSecuencia()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getIdItem() ) )
            {
                $s_SQLQuery1 .= $s_Separator."IdItem";
                $s_SQLQuery2 .= $s_Separator."'".$this->getIdItem()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getDescripcion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Descripcion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getDescripcion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getCantidad() ) )
            {
                $s_SQLQuery1 .= $s_Separator."Cantidad";
                $s_SQLQuery2 .= $s_Separator."".$this->getCantidad()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getMontoUnitarioConIGV() ) )
            {
                $s_SQLQuery1 .= $s_Separator."MontoUnitarioConIGV";
                $s_SQLQuery2 .= $s_Separator."".$this->getMontoUnitarioConIGV()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getMontoSubTotal() ) )
            {
                $s_SQLQuery1 .= $s_Separator."MontoSubTotal";
                $s_SQLQuery2 .= $s_Separator."".$this->getMontoSubTotal()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getMontoIGV() ) )
            {
                $s_SQLQuery1 .= $s_Separator."MontoIGV";
                $s_SQLQuery2 .= $s_Separator."".$this->getMontoIGV()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getMontoTotal() ) )
            {
                $s_SQLQuery1 .= $s_Separator."MontoTotal";
                $s_SQLQuery2 .= $s_Separator."".$this->getMontoTotal()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaCreacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaCreacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioCreacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UsuarioCreacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUsuarioCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaModificacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."FechaModificacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getFechaModificacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioModificacion() ) )
            {
                $s_SQLQuery1 .= $s_Separator."UsuarioModificacion";
                $s_SQLQuery2 .= $s_Separator."'".$this->getUsuarioModificacion()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery = $s_SQLQuery1." ) ".$s_SQLQuery2." );";
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        }
        else
        {
            throw new Exception( "El id ya esta registrado." );
        }
        return true;
    }

    /* Actualiza los datos del registro */
    public function update()
    {
        $this->validateRecord();
        if ( true )
        {
            $s_SQLQuery = "UPDATE ALM_CajaChicaItem SET ";
            $s_Separator = "";
            if ( !is_null( $this->getIdItem() ) )
            {
                $s_SQLQuery .= $s_Separator."IdItem = '".$this->getIdItem()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getDescripcion() ) )
            {
                $s_SQLQuery .= $s_Separator."Descripcion = '".$this->getDescripcion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getCantidad() ) )
            {
                $s_SQLQuery .= $s_Separator."Cantidad = ".$this->getCantidad()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getMontoUnitarioConIGV() ) )
            {
                $s_SQLQuery .= $s_Separator."MontoUnitarioConIGV = ".$this->getMontoUnitarioConIGV()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getMontoSubTotal() ) )
            {
                $s_SQLQuery .= $s_Separator."MontoSubTotal = ".$this->getMontoSubTotal()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getMontoIGV() ) )
            {
                $s_SQLQuery .= $s_Separator."MontoIGV = ".$this->getMontoIGV()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getMontoTotal() ) )
            {
                $s_SQLQuery .= $s_Separator."MontoTotal = ".$this->getMontoTotal()."";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaCreacion() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaCreacion = '".$this->getFechaCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioCreacion() ) )
            {
                $s_SQLQuery .= $s_Separator."UsuarioCreacion = '".$this->getUsuarioCreacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getFechaModificacion() ) )
            {
                $s_SQLQuery .= $s_Separator."FechaModificacion = '".$this->getFechaModificacion()."'";
                $s_Separator = ", ";
            }
            if ( !is_null( $this->getUsuarioModificacion() ) )
            {
                $s_SQLQuery .= $s_Separator."UsuarioModificacion = '".$this->getUsuarioModificacion()."'";
                $s_Separator = ", ";
            }
            $s_SQLQuery .= " WHERE  IdCajaDet = ".$this->getIdCajaDet()." AND  IdSecuencia = ".$this->getIdSecuencia().";";
            $o_Resource = Conexion::getConexion();
            $o_Statement = $o_Resource->createStatement();
            $o_Statement->executeQuery( $s_SQLQuery );
            if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        }
        else
        {
            throw new Exception( "El id no esta registrado." );
        }
        return true;
    }

    /* Elimina el registro */
    public function delete()
    {
        $s_SQLQuery = "DELETE FROM ALM_CajaChicaItem WHERE  IdCajaDet = ".$this->getIdCajaDet()." AND  IdSecuencia = ".$this->getIdSecuencia().";";
        $o_Resource = Conexion::getConexion();
        $o_Statement = $o_Resource->createStatement();
        $o_Statement->executeQuery( $s_SQLQuery );
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        return true;
    }

}
?>