<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: VTA_TipoDocumentoMotivo.xml */
/* Generado: 2022-08-20 01:42:00 */

/* Validacion del contenido de los campos campos de la tabla VTA_TipoDocumentoMotivo */
abstract class BaseVTA_TipoDocumentoMotivoBV extends VTA_TipoDocumentoMotivoBN
{
    /* Contiene la clase que valida el tipo de dato */
    private $o_Validator; // Contiene el objeto que realizara la validacion de tipo de dato.
    private $s_ValidatorMessage; // Contiene la ultima observacion de la validacion del tipo de dato.

    /* Constructor ( Establece la clase que valida los tipos de datos y establece los valores por defecto ) */
    public function __construct()
    {
        /* Establecemos el objeto que realizara la validacion del tipo de dato */
        $this->o_Validator = new utilValidDataType();

        /* Establecemos los valores por defecto */
    }

    /* Valida en tipo de dato */
    private function validateData( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull )
    {
        $this->s_ValidatorMessage = null;
        if( !$this->o_Validator->validate( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull ) )
        {
            $this->s_ValidatorMessage = $this->o_Validator->getMessage();
        }
        return is_null( $this->s_ValidatorMessage );
    }

    /* Valida y establece el valor del campo IdTipoDocumentoMotivo */
    public function setIdTipoDocumentoMotivo( $i_IdTipoDocumentoMotivo, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdTipoDocumentoMotivo, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdTipoDocumentoMotivo ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdTipoDocumentoMotivo( $i_IdTipoDocumentoMotivo );
        return true;
    }

    /* Valida y establece el valor del campo IdTipoDocumento */
    public function setIdTipoDocumento( $s_IdTipoDocumento, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdTipoDocumento, "VARCHAR", 2, 0, false ) )
            {
                throw new Exception( "El campo IdTipoDocumento ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdTipoDocumento( $s_IdTipoDocumento );
        return true;
    }

    /* Valida y establece el valor del campo Descripcion */
    public function setDescripcion( $s_Descripcion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Descripcion, "VARCHAR", 150, 0, false ) )
            {
                throw new Exception( "El campo Descripcion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDescripcion( $s_Descripcion );
        return true;
    }

    /* Valida y establece el valor del campo CodigoFiscal */
    public function setCodigoFiscal( $s_CodigoFiscal, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_CodigoFiscal, "VARCHAR", 2, 0, false ) )
            {
                throw new Exception( "El campo CodigoFiscal ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setCodigoFiscal( $s_CodigoFiscal );
        return true;
    }

    /* Valida y establece el valor del campo CodigoFiscalPr */
    public function setCodigoFiscalPr( $i_CodigoFiscalPr, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_CodigoFiscalPr, "TINYINT", 4, 0, false ) )
            {
                throw new Exception( "El campo CodigoFiscalPr ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setCodigoFiscalPr( $i_CodigoFiscalPr );
        return true;
    }

    /* Valida y establece el valor del campo Estado */
    public function setEstado( $s_Estado, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Estado, "VARCHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo Estado ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setEstado( $s_Estado );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioCreacion */
    public function setUsuarioCreacion( $s_UsuarioCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioCreacion, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo UsuarioCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioCreacion( $s_UsuarioCreacion );
        return true;
    }

    /* Valida y establece el valor del campo FechaCreacion */
    public function setFechaCreacion( $d_FechaCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaCreacion, "DATETIME", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaCreacion( $d_FechaCreacion );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioModificacion */
    public function setUsuarioModificacion( $s_UsuarioModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioModificacion, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo UsuarioModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioModificacion( $s_UsuarioModificacion );
        return true;
    }

    /* Valida y establece el valor del campo FechaModificacion */
    public function setFechaModificacion( $d_FechaModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaModificacion, "DATETIME", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaModificacion( $d_FechaModificacion );
        return true;
    }

    /* Valida el contenido del registro */
    public function validateRecord()
    {
        $this->setIdTipoDocumentoMotivo( $this->getIdTipoDocumentoMotivo(), false );
        $this->setIdTipoDocumento( $this->getIdTipoDocumento(), true );
        $this->setDescripcion( $this->getDescripcion(), true );
        $this->setCodigoFiscal( $this->getCodigoFiscal(), true );
        $this->setCodigoFiscalPr( $this->getCodigoFiscalPr(), true );
        $this->setEstado( $this->getEstado(), true );
        $this->setUsuarioCreacion( $this->getUsuarioCreacion(), true );
        $this->setFechaCreacion( $this->getFechaCreacion(), true );
        $this->setUsuarioModificacion( $this->getUsuarioModificacion(), true );
        $this->setFechaModificacion( $this->getFechaModificacion(), true );
        return true;
    }
}
?>