<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: VTA_TipoDocumento.xml */
/* Generado: 2021-07-16 07:04:07 */

/* Validacion del contenido de los campos campos de la tabla VTA_TipoDocumento */
abstract class BaseVTA_TipoDocumentoBV extends VTA_TipoDocumentoBN
{
    /* Contiene la clase que valida el tipo de dato */
    private $o_Validator; // Contiene el objeto que realizara la validacion de tipo de dato.
    private $s_ValidatorMessage; // Contiene la ultima observacion de la validacion del tipo de dato.

    /* Constructor ( Establece la clase que valida los tipos de datos y establece los valores por defecto ) */
    public function __construct()
    {
        /* Establecemos el objeto que realizara la validacion del tipo de dato */
        $this->o_Validator = new utilValidDataType();

        /* Establecemos los valores por defecto */
    }

    /* Valida en tipo de dato */
    private function validateData( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull )
    {
        $this->s_ValidatorMessage = null;
        if( !$this->o_Validator->validate( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull ) )
        {
            $this->s_ValidatorMessage = $this->o_Validator->getMessage();
        }
        return is_null( $this->s_ValidatorMessage );
    }

    /* Valida y establece el valor del campo IdTipoDocumento */
    public function setIdTipoDocumento( $s_IdTipoDocumento, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdTipoDocumento, "CHAR", 2, 0, false ) )
            {
                throw new Exception( "El campo IdTipoDocumento ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdTipoDocumento( $s_IdTipoDocumento );
        return true;
    }

    /* Valida y establece el valor del campo DescripcionLocal */
    public function setDescripcionLocal( $s_DescripcionLocal, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_DescripcionLocal, "VARCHAR", 250, 0, false ) )
            {
                throw new Exception( "El campo DescripcionLocal ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDescripcionLocal( $s_DescripcionLocal );
        return true;
    }

    /* Valida y establece el valor del campo TipoDocumentoCod */
    public function setTipoDocumentoCod( $s_TipoDocumentoCod, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_TipoDocumentoCod, "VARCHAR", 3, 0, false ) )
            {
                throw new Exception( "El campo TipoDocumentoCod ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setTipoDocumentoCod( $s_TipoDocumentoCod );
        return true;
    }

    /* Valida y establece el valor del campo Secuencia */
    public function setSecuencia( $s_Secuencia, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Secuencia, "VARCHAR", 3, 0, false ) )
            {
                throw new Exception( "El campo Secuencia ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setSecuencia( $s_Secuencia );
        return true;
    }

    /* Valida y establece el valor del campo DescripcionIngles */
    public function setDescripcionIngles( $s_DescripcionIngles, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_DescripcionIngles, "VARCHAR", 50, 0, false ) )
            {
                throw new Exception( "El campo DescripcionIngles ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDescripcionIngles( $s_DescripcionIngles );
        return true;
    }

    /* Valida y establece el valor del campo EsFiscalFlag */
    public function setEsFiscalFlag( $s_EsFiscalFlag, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_EsFiscalFlag, "CHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo EsFiscalFlag ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setEsFiscalFlag( $s_EsFiscalFlag );
        return true;
    }

    /* Valida y establece el valor del campo CodigoFiscal */
    public function setCodigoFiscal( $s_CodigoFiscal, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_CodigoFiscal, "VARCHAR", 2, 0, false ) )
            {
                throw new Exception( "El campo CodigoFiscal ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setCodigoFiscal( $s_CodigoFiscal );
        return true;
    }

    /* Valida y establece el valor del campo CodigoFiscalPrs */
    public function setCodigoFiscalPrs( $s_CodigoFiscalPrs, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_CodigoFiscalPrs, "VARCHAR", 2, 0, false ) )
            {
                throw new Exception( "El campo CodigoFiscalPrs ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setCodigoFiscalPrs( $s_CodigoFiscalPrs );
        return true;
    }

    /* Valida y establece el valor del campo GenerarProvisionFlag */
    public function setGenerarProvisionFlag( $s_GenerarProvisionFlag, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_GenerarProvisionFlag, "CHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo GenerarProvisionFlag ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setGenerarProvisionFlag( $s_GenerarProvisionFlag );
        return true;
    }

    /* Valida y establece el valor del campo CuentaContableLocal */
    public function setCuentaContableLocal( $s_CuentaContableLocal, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_CuentaContableLocal, "VARCHAR", 20, 0, false ) )
            {
                throw new Exception( "El campo CuentaContableLocal ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setCuentaContableLocal( $s_CuentaContableLocal );
        return true;
    }

    /* Valida y establece el valor del campo CuentaContableDolares */
    public function setCuentaContableDolares( $s_CuentaContableDolares, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_CuentaContableDolares, "VARCHAR", 20, 0, false ) )
            {
                throw new Exception( "El campo CuentaContableDolares ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setCuentaContableDolares( $s_CuentaContableDolares );
        return true;
    }

    /* Valida y establece el valor del campo CuentaDudosaLocal */
    public function setCuentaDudosaLocal( $s_CuentaDudosaLocal, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_CuentaDudosaLocal, "VARCHAR", 20, 0, false ) )
            {
                throw new Exception( "El campo CuentaDudosaLocal ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setCuentaDudosaLocal( $s_CuentaDudosaLocal );
        return true;
    }

    /* Valida y establece el valor del campo CuentaDudosaDolares */
    public function setCuentaDudosaDolares( $s_CuentaDudosaDolares, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_CuentaDudosaDolares, "VARCHAR", 20, 0, false ) )
            {
                throw new Exception( "El campo CuentaDudosaDolares ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setCuentaDudosaDolares( $s_CuentaDudosaDolares );
        return true;
    }

    /* Valida y establece el valor del campo CuentaDudosaProvisionLocal */
    public function setCuentaDudosaProvisionLocal( $s_CuentaDudosaProvisionLocal, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_CuentaDudosaProvisionLocal, "VARCHAR", 20, 0, false ) )
            {
                throw new Exception( "El campo CuentaDudosaProvisionLocal ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setCuentaDudosaProvisionLocal( $s_CuentaDudosaProvisionLocal );
        return true;
    }

    /* Valida y establece el valor del campo CuentaDudosaProvisionDolares */
    public function setCuentaDudosaProvisionDolares( $s_CuentaDudosaProvisionDolares, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_CuentaDudosaProvisionDolares, "VARCHAR", 20, 0, false ) )
            {
                throw new Exception( "El campo CuentaDudosaProvisionDolares ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setCuentaDudosaProvisionDolares( $s_CuentaDudosaProvisionDolares );
        return true;
    }

    /* Valida y establece el valor del campo Clasificacion */
    public function setClasificacion( $s_Clasificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Clasificacion, "VARCHAR", 2, 0, false ) )
            {
                throw new Exception( "El campo Clasificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setClasificacion( $s_Clasificacion );
        return true;
    }

    /* Valida y establece el valor del campo NumeroLineasImpresion */
    public function setNumeroLineasImpresion( $i_NumeroLineasImpresion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_NumeroLineasImpresion, "TINYINT", 4, 0, false ) )
            {
                throw new Exception( "El campo NumeroLineasImpresion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setNumeroLineasImpresion( $i_NumeroLineasImpresion );
        return true;
    }

    /* Valida y establece el valor del campo DisponibleIngresoManualFlag */
    public function setDisponibleIngresoManualFlag( $s_DisponibleIngresoManualFlag, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_DisponibleIngresoManualFlag, "CHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo DisponibleIngresoManualFlag ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDisponibleIngresoManualFlag( $s_DisponibleIngresoManualFlag );
        return true;
    }

    /* Valida y establece el valor del campo Estado */
    public function setEstado( $s_Estado, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Estado, "CHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo Estado ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setEstado( $s_Estado );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioModificacion */
    public function setUsuarioModificacion( $s_UsuarioModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioModificacion, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo UsuarioModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioModificacion( $s_UsuarioModificacion );
        return true;
    }

    /* Valida y establece el valor del campo FechaModificacion */
    public function setFechaModificacion( $d_FechaModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaModificacion, "TIMESTAMP", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaModificacion( $d_FechaModificacion );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioCreacion */
    public function setUsuarioCreacion( $s_UsuarioCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioCreacion, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo UsuarioCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioCreacion( $s_UsuarioCreacion );
        return true;
    }

    /* Valida y establece el valor del campo FechaCreacion */
    public function setFechaCreacion( $d_FechaCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaCreacion, "TIMESTAMP", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaCreacion( $d_FechaCreacion );
        return true;
    }

    /* Valida el contenido del registro */
    public function validateRecord()
    {
        $this->setIdTipoDocumento( $this->getIdTipoDocumento(), false );
        $this->setDescripcionLocal( $this->getDescripcionLocal(), true );
        $this->setTipoDocumentoCod( $this->getTipoDocumentoCod(), true );
        $this->setSecuencia( $this->getSecuencia(), true );
        $this->setDescripcionIngles( $this->getDescripcionIngles(), true );
        $this->setEsFiscalFlag( $this->getEsFiscalFlag(), true );
        $this->setCodigoFiscal( $this->getCodigoFiscal(), true );
        $this->setCodigoFiscalPrs( $this->getCodigoFiscalPrs(), true );
        $this->setGenerarProvisionFlag( $this->getGenerarProvisionFlag(), true );
        $this->setCuentaContableLocal( $this->getCuentaContableLocal(), true );
        $this->setCuentaContableDolares( $this->getCuentaContableDolares(), true );
        $this->setCuentaDudosaLocal( $this->getCuentaDudosaLocal(), true );
        $this->setCuentaDudosaDolares( $this->getCuentaDudosaDolares(), true );
        $this->setCuentaDudosaProvisionLocal( $this->getCuentaDudosaProvisionLocal(), true );
        $this->setCuentaDudosaProvisionDolares( $this->getCuentaDudosaProvisionDolares(), true );
        $this->setClasificacion( $this->getClasificacion(), true );
        $this->setNumeroLineasImpresion( $this->getNumeroLineasImpresion(), true );
        $this->setDisponibleIngresoManualFlag( $this->getDisponibleIngresoManualFlag(), true );
        $this->setEstado( $this->getEstado(), true );
        $this->setUsuarioModificacion( $this->getUsuarioModificacion(), true );
        $this->setFechaModificacion( $this->getFechaModificacion(), true );
        $this->setUsuarioCreacion( $this->getUsuarioCreacion(), true );
        $this->setFechaCreacion( $this->getFechaCreacion(), true );
        return true;
    }
}
?>