<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: VTA_PrsProyectos.xml */
/* Generado: 2021-05-25 04:23:20 */

/* Validacion del contenido de los campos campos de la tabla VTA_PrsProyectos */
abstract class BaseVTA_PrsProyectosBV extends VTA_PrsProyectosBN
{
    /* Contiene la clase que valida el tipo de dato */
    private $o_Validator; // Contiene el objeto que realizara la validacion de tipo de dato.
    private $s_ValidatorMessage; // Contiene la ultima observacion de la validacion del tipo de dato.

    /* Constructor ( Establece la clase que valida los tipos de datos y establece los valores por defecto ) */
    public function __construct()
    {
        /* Establecemos el objeto que realizara la validacion del tipo de dato */
        $this->o_Validator = new utilValidDataType();

        /* Establecemos los valores por defecto */
    }

    /* Valida en tipo de dato */
    private function validateData( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull )
    {
        $this->s_ValidatorMessage = null;
        if( !$this->o_Validator->validate( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull ) )
        {
            $this->s_ValidatorMessage = $this->o_Validator->getMessage();
        }
        return is_null( $this->s_ValidatorMessage );
    }

    /* Valida y establece el valor del campo IdProyecto */
    public function setIdProyecto( $i_IdProyecto, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdProyecto, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdProyecto ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdProyecto( $i_IdProyecto );
        return true;
    }

    /* Valida y establece el valor del campo IdPersona */
    public function setIdPersona( $i_IdPersona, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdPersona, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdPersona ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdPersona( $i_IdPersona );
        return true;
    }

    /* Valida y establece el valor del campo ClienteNombre */
    public function setClienteNombre( $s_ClienteNombre, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ClienteNombre, "VARCHAR", 500, 0, false ) )
            {
                throw new Exception( "El campo ClienteNombre ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setClienteNombre( $s_ClienteNombre );
        return true;
    }

    /* Valida y establece el valor del campo ClienteTipoDocu */
    public function setClienteTipoDocu( $s_ClienteTipoDocu, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ClienteTipoDocu, "VARCHAR", 50, 0, false ) )
            {
                throw new Exception( "El campo ClienteTipoDocu ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setClienteTipoDocu( $s_ClienteTipoDocu );
        return true;
    }

    /* Valida y establece el valor del campo ClienteNroDocu */
    public function setClienteNroDocu( $s_ClienteNroDocu, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ClienteNroDocu, "VARCHAR", 50, 0, false ) )
            {
                throw new Exception( "El campo ClienteNroDocu ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setClienteNroDocu( $s_ClienteNroDocu );
        return true;
    }

    /* Valida y establece el valor del campo NombreCompleto */
    public function setNombreCompleto( $s_NombreCompleto, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_NombreCompleto, "VARCHAR", 500, 0, false ) )
            {
                throw new Exception( "El campo NombreCompleto ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setNombreCompleto( $s_NombreCompleto );
        return true;
    }

    /* Valida y establece el valor del campo NombreProyecto */
    public function setNombreProyecto( $s_NombreProyecto, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_NombreProyecto, "VARCHAR", 500, 0, false ) )
            {
                throw new Exception( "El campo NombreProyecto ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setNombreProyecto( $s_NombreProyecto );
        return true;
    }

    /* Valida y establece el valor del campo Contacto */
    public function setContacto( $s_Contacto, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Contacto, "VARCHAR", 500, 0, false ) )
            {
                throw new Exception( "El campo Contacto ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setContacto( $s_Contacto );
        return true;
    }

    /* Valida y establece el valor del campo TipoDocumento */
    public function setTipoDocumento( $s_TipoDocumento, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_TipoDocumento, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo TipoDocumento ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setTipoDocumento( $s_TipoDocumento );
        return true;
    }

    /* Valida y establece el valor del campo NroDocumento */
    public function setNroDocumento( $s_NroDocumento, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_NroDocumento, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo NroDocumento ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setNroDocumento( $s_NroDocumento );
        return true;
    }

    /* Valida y establece el valor del campo Cargo */
    public function setCargo( $s_Cargo, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Cargo, "VARCHAR", 200, 0, false ) )
            {
                throw new Exception( "El campo Cargo ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setCargo( $s_Cargo );
        return true;
    }

    /* Valida y establece el valor del campo Telefono */
    public function setTelefono( $s_Telefono, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Telefono, "VARCHAR", 200, 0, false ) )
            {
                throw new Exception( "El campo Telefono ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setTelefono( $s_Telefono );
        return true;
    }

    /* Valida y establece el valor del campo Correo */
    public function setCorreo( $s_Correo, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Correo, "VARCHAR", 200, 0, false ) )
            {
                throw new Exception( "El campo Correo ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setCorreo( $s_Correo );
        return true;
    }

    /* Valida y establece el valor del campo Estado */
    public function setEstado( $s_Estado, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Estado, "VARCHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo Estado ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setEstado( $s_Estado );
        return true;
    }

    /* Valida y establece el valor del campo EstadoDevolucion */
    public function setEstadoDevolucion( $s_EstadoDevolucion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_EstadoDevolucion, "VARCHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo EstadoDevolucion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setEstadoDevolucion( $s_EstadoDevolucion );
        return true;
    }

    /* Valida y establece el valor del campo FechaInicioDespacho */
    public function setFechaInicioDespacho( $d_FechaInicioDespacho, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaInicioDespacho, "DATE", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaInicioDespacho ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaInicioDespacho( $d_FechaInicioDespacho );
        return true;
    }

    /* Valida y establece el valor del campo FechaFinDespacho */
    public function setFechaFinDespacho( $d_FechaFinDespacho, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaFinDespacho, "DATE", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaFinDespacho ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaFinDespacho( $d_FechaFinDespacho );
        return true;
    }

    /* Valida y establece el valor del campo Departamento */
    public function setDepartamento( $s_Departamento, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Departamento, "VARCHAR", 10, 0, false ) )
            {
                throw new Exception( "El campo Departamento ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDepartamento( $s_Departamento );
        return true;
    }

    /* Valida y establece el valor del campo Provincia */
    public function setProvincia( $s_Provincia, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Provincia, "VARCHAR", 10, 0, false ) )
            {
                throw new Exception( "El campo Provincia ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setProvincia( $s_Provincia );
        return true;
    }

    /* Valida y establece el valor del campo Distrito */
    public function setDistrito( $s_Distrito, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Distrito, "VARCHAR", 10, 0, false ) )
            {
                throw new Exception( "El campo Distrito ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDistrito( $s_Distrito );
        return true;
    }

    /* Valida y establece el valor del campo Direccion */
    public function setDireccion( $s_Direccion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Direccion, "VARCHAR", 500, 0, false ) )
            {
                throw new Exception( "El campo Direccion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDireccion( $s_Direccion );
        return true;
    }

    /* Valida y establece el valor del campo FechaCreacion */
    public function setFechaCreacion( $d_FechaCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaCreacion, "TIMESTAMP", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaCreacion( $d_FechaCreacion );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioCreacion */
    public function setUsuarioCreacion( $s_UsuarioCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioCreacion, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo UsuarioCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioCreacion( $s_UsuarioCreacion );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioModificacion */
    public function setUsuarioModificacion( $s_UsuarioModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioModificacion, "VARCHAR", 25, 0, false ) )
            {
                throw new Exception( "El campo UsuarioModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioModificacion( $s_UsuarioModificacion );
        return true;
    }

    /* Valida y establece el valor del campo FechaModificacion */
    public function setFechaModificacion( $d_FechaModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaModificacion, "TIMESTAMP", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaModificacion( $d_FechaModificacion );
        return true;
    }

    /* Valida el contenido del registro */
    public function validateRecord()
    {
        $this->setIdProyecto( $this->getIdProyecto(), false );
        $this->setIdPersona( $this->getIdPersona(), true );
        $this->setClienteNombre( $this->getClienteNombre(), true );
        $this->setClienteTipoDocu( $this->getClienteTipoDocu(), true );
        $this->setClienteNroDocu( $this->getClienteNroDocu(), true );
        $this->setNombreCompleto( $this->getNombreCompleto(), true );
        $this->setNombreProyecto( $this->getNombreProyecto(), true );
        $this->setContacto( $this->getContacto(), true );
        $this->setTipoDocumento( $this->getTipoDocumento(), true );
        $this->setNroDocumento( $this->getNroDocumento(), true );
        $this->setCargo( $this->getCargo(), true );
        $this->setTelefono( $this->getTelefono(), true );
        $this->setCorreo( $this->getCorreo(), true );
        $this->setEstado( $this->getEstado(), true );
        $this->setEstadoDevolucion( $this->getEstadoDevolucion(), true );
        $this->setFechaInicioDespacho( $this->getFechaInicioDespacho(), true );
        $this->setFechaFinDespacho( $this->getFechaFinDespacho(), true );
        $this->setDepartamento( $this->getDepartamento(), true );
        $this->setProvincia( $this->getProvincia(), true );
        $this->setDistrito( $this->getDistrito(), true );
        $this->setDireccion( $this->getDireccion(), true );
        $this->setFechaCreacion( $this->getFechaCreacion(), true );
        $this->setUsuarioCreacion( $this->getUsuarioCreacion(), true );
        $this->setUsuarioModificacion( $this->getUsuarioModificacion(), true );
        $this->setFechaModificacion( $this->getFechaModificacion(), true );
        return true;
    }
}
?>