<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: VTA_OrdenTipo.xml */
/* Generado: 2020-08-18 04:21:32 */

/* Validacion del contenido de los campos campos de la tabla VTA_OrdenTipo */
abstract class BaseVTA_OrdenTipoBV extends VTA_OrdenTipoBN
{
    /* Contiene la clase que valida el tipo de dato */
    private $o_Validator; // Contiene el objeto que realizara la validacion de tipo de dato.
    private $s_ValidatorMessage; // Contiene la ultima observacion de la validacion del tipo de dato.

    /* Constructor ( Establece la clase que valida los tipos de datos y establece los valores por defecto ) */
    public function __construct()
    {
        /* Establecemos el objeto que realizara la validacion del tipo de dato */
        $this->o_Validator = new utilValidDataType();

        /* Establecemos los valores por defecto */
    }

    /* Valida en tipo de dato */
    private function validateData( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull )
    {
        $this->s_ValidatorMessage = null;
        if( !$this->o_Validator->validate( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull ) )
        {
            $this->s_ValidatorMessage = $this->o_Validator->getMessage();
        }
        return is_null( $this->s_ValidatorMessage );
    }

    /* Valida y establece el valor del campo OrdenTipoId */
    public function setOrdenTipoId( $i_OrdenTipoId, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_OrdenTipoId, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo OrdenTipoId ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setOrdenTipoId( $i_OrdenTipoId );
        return true;
    }

    /* Valida y establece el valor del campo OrdenTipoCod */
    public function setOrdenTipoCod( $s_OrdenTipoCod, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_OrdenTipoCod, "VARCHAR", 3, 0, false ) )
            {
                throw new Exception( "El campo OrdenTipoCod ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setOrdenTipoCod( $s_OrdenTipoCod );
        return true;
    }

    /* Valida y establece el valor del campo OrdenTipoDescripcion */
    public function setOrdenTipoDescripcion( $s_OrdenTipoDescripcion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_OrdenTipoDescripcion, "VARCHAR", 50, 0, false ) )
            {
                throw new Exception( "El campo OrdenTipoDescripcion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setOrdenTipoDescripcion( $s_OrdenTipoDescripcion );
        return true;
    }

    /* Valida y establece el valor del campo OrdenTipoPrefijo */
    public function setOrdenTipoPrefijo( $s_OrdenTipoPrefijo, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_OrdenTipoPrefijo, "VARCHAR", 2, 0, false ) )
            {
                throw new Exception( "El campo OrdenTipoPrefijo ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setOrdenTipoPrefijo( $s_OrdenTipoPrefijo );
        return true;
    }

    /* Valida y establece el valor del campo DocRefTipo */
    public function setDocRefTipo( $s_DocRefTipo, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_DocRefTipo, "VARCHAR", 3, 0, false ) )
            {
                throw new Exception( "El campo DocRefTipo ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDocRefTipo( $s_DocRefTipo );
        return true;
    }

    /* Valida y establece el valor del campo OrdenTipoPublico */
    public function setOrdenTipoPublico( $s_OrdenTipoPublico, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_OrdenTipoPublico, "VARCHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo OrdenTipoPublico ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setOrdenTipoPublico( $s_OrdenTipoPublico );
        return true;
    }

    /* Valida y establece el valor del campo OrdenTipoEstado */
    public function setOrdenTipoEstado( $s_OrdenTipoEstado, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_OrdenTipoEstado, "VARCHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo OrdenTipoEstado ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setOrdenTipoEstado( $s_OrdenTipoEstado );
        return true;
    }

    /* Valida y establece el valor del campo OrdenCreacion */
    public function setOrdenCreacion( $s_OrdenCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_OrdenCreacion, "VARCHAR", 25, 0, false ) )
            {
                throw new Exception( "El campo OrdenCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setOrdenCreacion( $s_OrdenCreacion );
        return true;
    }

    /* Valida y establece el valor del campo FechaCreacion */
    public function setFechaCreacion( $d_FechaCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaCreacion, "TIMESTAMP", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaCreacion( $d_FechaCreacion );
        return true;
    }

    /* Valida el contenido del registro */
    public function validateRecord()
    {
        $this->setOrdenTipoId( $this->getOrdenTipoId(), false );
        $this->setOrdenTipoCod( $this->getOrdenTipoCod(), true );
        $this->setOrdenTipoDescripcion( $this->getOrdenTipoDescripcion(), true );
        $this->setOrdenTipoPrefijo( $this->getOrdenTipoPrefijo(), true );
        $this->setDocRefTipo( $this->getDocRefTipo(), true );
        $this->setOrdenTipoPublico( $this->getOrdenTipoPublico(), true );
        $this->setOrdenTipoEstado( $this->getOrdenTipoEstado(), true );
        $this->setOrdenCreacion( $this->getOrdenCreacion(), true );
        $this->setFechaCreacion( $this->getFechaCreacion(), true );
        return true;
    }
}
?>