<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: VTA_OrdenTipoArchivo.xml */
/* Generado: 2021-03-04 17:43:48 */

/* Validacion del contenido de los campos campos de la tabla VTA_OrdenTipoArchivo */
abstract class BaseVTA_OrdenTipoArchivoBV extends VTA_OrdenTipoArchivoBN
{
    /* Contiene la clase que valida el tipo de dato */
    private $o_Validator; // Contiene el objeto que realizara la validacion de tipo de dato.
    private $s_ValidatorMessage; // Contiene la ultima observacion de la validacion del tipo de dato.

    /* Constructor ( Establece la clase que valida los tipos de datos y establece los valores por defecto ) */
    public function __construct()
    {
        /* Establecemos el objeto que realizara la validacion del tipo de dato */
        $this->o_Validator = new utilValidDataType();

        /* Establecemos los valores por defecto */
    }

    /* Valida en tipo de dato */
    private function validateData( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull )
    {
        $this->s_ValidatorMessage = null;
        if( !$this->o_Validator->validate( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull ) )
        {
            $this->s_ValidatorMessage = $this->o_Validator->getMessage();
        }
        return is_null( $this->s_ValidatorMessage );
    }

    /* Valida y establece el valor del campo TipoId */
    public function setTipoId( $i_TipoId, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_TipoId, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo TipoId ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setTipoId( $i_TipoId );
        return true;
    }

    /* Valida y establece el valor del campo Descripcion */
    public function setDescripcion( $s_Descripcion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Descripcion, "VARCHAR", 255, 0, false ) )
            {
                throw new Exception( "El campo Descripcion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDescripcion( $s_Descripcion );
        return true;
    }

    /* Valida y establece el valor del campo Secuencia */
    public function setSecuencia( $s_Secuencia, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Secuencia, "VARCHAR", 3, 0, false ) )
            {
                throw new Exception( "El campo Secuencia ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setSecuencia( $s_Secuencia );
        return true;
    }

    /* Valida y establece el valor del campo FlagValidacion */
    public function setFlagValidacion( $i_FlagValidacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_FlagValidacion, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo FlagValidacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFlagValidacion( $i_FlagValidacion );
        return true;
    }

    /* Valida y establece el valor del campo Estado */
    public function setEstado( $s_Estado, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Estado, "VARCHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo Estado ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setEstado( $s_Estado );
        return true;
    }

    /* Valida el contenido del registro */
    public function validateRecord()
    {
        $this->setTipoId( $this->getTipoId(), false );
        $this->setDescripcion( $this->getDescripcion(), true );
        $this->setSecuencia( $this->getSecuencia(), true );
        $this->setFlagValidacion( $this->getFlagValidacion(), true );
        $this->setEstado( $this->getEstado(), true );
        return true;
    }
}
?>