<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: VTA_DocumentoCuotas.xml */
/* Generado: 2022-09-29 19:36:24 */

/* Validacion del contenido de los campos campos de la tabla VTA_DocumentoCuotas */
abstract class BaseVTA_DocumentoCuotasBV extends VTA_DocumentoCuotasBN
{
    /* Contiene la clase que valida el tipo de dato */
    private $o_Validator; // Contiene el objeto que realizara la validacion de tipo de dato.
    private $s_ValidatorMessage; // Contiene la ultima observacion de la validacion del tipo de dato.

    /* Constructor ( Establece la clase que valida los tipos de datos y establece los valores por defecto ) */
    public function __construct()
    {
        /* Establecemos el objeto que realizara la validacion del tipo de dato */
        $this->o_Validator = new utilValidDataType();

        /* Establecemos los valores por defecto */
    }

    /* Valida en tipo de dato */
    private function validateData( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull )
    {
        $this->s_ValidatorMessage = null;
        if( !$this->o_Validator->validate( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull ) )
        {
            $this->s_ValidatorMessage = $this->o_Validator->getMessage();
        }
        return is_null( $this->s_ValidatorMessage );
    }

    /* Valida y establece el valor del campo CuotaId */
    public function setCuotaId( $i_CuotaId, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_CuotaId, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo CuotaId ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setCuotaId( $i_CuotaId );
        return true;
    }

    /* Valida y establece el valor del campo NumeroDocumentoId */
    public function setNumeroDocumentoId( $i_NumeroDocumentoId, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_NumeroDocumentoId, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo NumeroDocumentoId ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setNumeroDocumentoId( $i_NumeroDocumentoId );
        return true;
    }

    /* Valida y establece el valor del campo CuotaMonto */
    public function setCuotaMonto( $f_CuotaMonto, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_CuotaMonto, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo CuotaMonto ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setCuotaMonto( $f_CuotaMonto );
        return true;
    }

    /* Valida y establece el valor del campo CuotaFecha */
    public function setCuotaFecha( $d_CuotaFecha, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_CuotaFecha, "DATE", 0, 0, false ) )
            {
                throw new Exception( "El campo CuotaFecha ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setCuotaFecha( $d_CuotaFecha );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioCreacion */
    public function setUsuarioCreacion( $s_UsuarioCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioCreacion, "VARCHAR", 25, 0, false ) )
            {
                throw new Exception( "El campo UsuarioCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioCreacion( $s_UsuarioCreacion );
        return true;
    }

    /* Valida y establece el valor del campo FechaCreacion */
    public function setFechaCreacion( $d_FechaCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaCreacion, "TIMESTAMP", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaCreacion( $d_FechaCreacion );
        return true;
    }

    /* Valida el contenido del registro */
    public function validateRecord()
    {
        $this->setCuotaId( $this->getCuotaId(), false );
        $this->setNumeroDocumentoId( $this->getNumeroDocumentoId(), true );
        $this->setCuotaMonto( $this->getCuotaMonto(), true );
        $this->setCuotaFecha( $this->getCuotaFecha(), true );
        $this->setUsuarioCreacion( $this->getUsuarioCreacion(), true );
        $this->setFechaCreacion( $this->getFechaCreacion(), true );
        return true;
    }
}
?>