<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: VTA_Documento.xml */
/* Generado: 2022-08-20 00:12:28 */

/* Validacion del contenido de los campos campos de la tabla VTA_Documento */
abstract class BaseVTA_DocumentoBV extends VTA_DocumentoBN
{
    /* Contiene la clase que valida el tipo de dato */
    private $o_Validator; // Contiene el objeto que realizara la validacion de tipo de dato.
    private $s_ValidatorMessage; // Contiene la ultima observacion de la validacion del tipo de dato.

    /* Constructor ( Establece la clase que valida los tipos de datos y establece los valores por defecto ) */
    public function __construct()
    {
        /* Establecemos el objeto que realizara la validacion del tipo de dato */
        $this->o_Validator = new utilValidDataType();

        /* Establecemos los valores por defecto */
    }

    /* Valida en tipo de dato */
    private function validateData( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull )
    {
        $this->s_ValidatorMessage = null;
        if( !$this->o_Validator->validate( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull ) )
        {
            $this->s_ValidatorMessage = $this->o_Validator->getMessage();
        }
        return is_null( $this->s_ValidatorMessage );
    }

    /* Valida y establece el valor del campo IdTipoDocumento */
    public function setIdTipoDocumento( $s_IdTipoDocumento, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdTipoDocumento, "CHAR", 2, 0, false ) )
            {
                throw new Exception( "El campo IdTipoDocumento ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdTipoDocumento( $s_IdTipoDocumento );
        return true;
    }

    /* Valida y establece el valor del campo IdCompania */
    public function setIdCompania( $i_IdCompania, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdCompania, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdCompania ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdCompania( $i_IdCompania );
        return true;
    }

    /* Valida y establece el valor del campo NumeroDocumento */
    public function setNumeroDocumento( $s_NumeroDocumento, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_NumeroDocumento, "VARCHAR", 20, 0, false ) )
            {
                throw new Exception( "El campo NumeroDocumento ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setNumeroDocumento( $s_NumeroDocumento );
        return true;
    }

    /* Valida y establece el valor del campo Sucursal */
    public function setSucursal( $s_Sucursal, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Sucursal, "VARCHAR", 10, 0, false ) )
            {
                throw new Exception( "El campo Sucursal ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setSucursal( $s_Sucursal );
        return true;
    }

    /* Valida y establece el valor del campo IdAlmacen */
    public function setIdAlmacen( $s_IdAlmacen, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdAlmacen, "CHAR", 10, 0, false ) )
            {
                throw new Exception( "El campo IdAlmacen ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdAlmacen( $s_IdAlmacen );
        return true;
    }

    /* Valida y establece el valor del campo AlmacenDespacho */
    public function setAlmacenDespacho( $s_AlmacenDespacho, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_AlmacenDespacho, "VARCHAR", 10, 0, false ) )
            {
                throw new Exception( "El campo AlmacenDespacho ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setAlmacenDespacho( $s_AlmacenDespacho );
        return true;
    }

    /* Valida y establece el valor del campo IdFormaPago */
    public function setIdFormaPago( $s_IdFormaPago, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdFormaPago, "VARCHAR", 100, 0, false ) )
            {
                throw new Exception( "El campo IdFormaPago ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdFormaPago( $s_IdFormaPago );
        return true;
    }

    /* Valida y establece el valor del campo FormaPagoCod */
    public function setFormaPagoCod( $s_FormaPagoCod, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_FormaPagoCod, "VARCHAR", 100, 0, false ) )
            {
                throw new Exception( "El campo FormaPagoCod ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFormaPagoCod( $s_FormaPagoCod );
        return true;
    }

    /* Valida y establece el valor del campo TerminoPago */
    public function setTerminoPago( $i_TerminoPago, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_TerminoPago, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo TerminoPago ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setTerminoPago( $i_TerminoPago );
        return true;
    }

    /* Valida y establece el valor del campo IdCierre */
    public function setIdCierre( $i_IdCierre, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdCierre, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdCierre ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdCierre( $i_IdCierre );
        return true;
    }

    /* Valida y establece el valor del campo IdCaja */
    public function setIdCaja( $i_IdCaja, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdCaja, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdCaja ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdCaja( $i_IdCaja );
        return true;
    }

    /* Valida y establece el valor del campo IdTurno */
    public function setIdTurno( $i_IdTurno, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdTurno, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdTurno ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdTurno( $i_IdTurno );
        return true;
    }

    /* Valida y establece el valor del campo IdProyecto */
    public function setIdProyecto( $i_IdProyecto, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdProyecto, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdProyecto ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdProyecto( $i_IdProyecto );
        return true;
    }

    /* Valida y establece el valor del campo IdMotivo */
    public function setIdMotivo( $i_IdMotivo, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdMotivo, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdMotivo ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdMotivo( $i_IdMotivo );
        return true;
    }

    /* Valida y establece el valor del campo DocumentoCod */
    public function setDocumentoCod( $s_DocumentoCod, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_DocumentoCod, "VARCHAR", 3, 0, false ) )
            {
                throw new Exception( "El campo DocumentoCod ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDocumentoCod( $s_DocumentoCod );
        return true;
    }

    /* Valida y establece el valor del campo DocumentoSerie */
    public function setDocumentoSerie( $s_DocumentoSerie, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_DocumentoSerie, "VARCHAR", 5, 0, false ) )
            {
                throw new Exception( "El campo DocumentoSerie ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDocumentoSerie( $s_DocumentoSerie );
        return true;
    }

    /* Valida y establece el valor del campo DocumentoNumero */
    public function setDocumentoNumero( $s_DocumentoNumero, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_DocumentoNumero, "VARCHAR", 10, 0, false ) )
            {
                throw new Exception( "El campo DocumentoNumero ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDocumentoNumero( $s_DocumentoNumero );
        return true;
    }

    /* Valida y establece el valor del campo NumeroComprobante */
    public function setNumeroComprobante( $s_NumeroComprobante, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_NumeroComprobante, "VARCHAR", 25, 0, false ) )
            {
                throw new Exception( "El campo NumeroComprobante ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setNumeroComprobante( $s_NumeroComprobante );
        return true;
    }

    /* Valida y establece el valor del campo Periodo */
    public function setPeriodo( $s_Periodo, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Periodo, "VARCHAR", 10, 0, false ) )
            {
                throw new Exception( "El campo Periodo ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setPeriodo( $s_Periodo );
        return true;
    }

    /* Valida y establece el valor del campo FechaDocumento */
    public function setFechaDocumento( $d_FechaDocumento, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaDocumento, "DATETIME", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaDocumento ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaDocumento( $d_FechaDocumento );
        return true;
    }

    /* Valida y establece el valor del campo FechaVencimiento */
    public function setFechaVencimiento( $d_FechaVencimiento, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaVencimiento, "DATETIME", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaVencimiento ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaVencimiento( $d_FechaVencimiento );
        return true;
    }

    /* Valida y establece el valor del campo DocumentoParentId */
    public function setDocumentoParentId( $i_DocumentoParentId, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_DocumentoParentId, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo DocumentoParentId ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDocumentoParentId( $i_DocumentoParentId );
        return true;
    }

    /* Valida y establece el valor del campo DocumentoParentCod */
    public function setDocumentoParentCod( $s_DocumentoParentCod, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_DocumentoParentCod, "VARCHAR", 15, 0, false ) )
            {
                throw new Exception( "El campo DocumentoParentCod ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDocumentoParentCod( $s_DocumentoParentCod );
        return true;
    }

    /* Valida y establece el valor del campo ClienteNumero */
    public function setClienteNumero( $s_ClienteNumero, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ClienteNumero, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo ClienteNumero ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setClienteNumero( $s_ClienteNumero );
        return true;
    }

    /* Valida y establece el valor del campo ClienteTipoDoc */
    public function setClienteTipoDoc( $s_ClienteTipoDoc, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ClienteTipoDoc, "VARCHAR", 3, 0, false ) )
            {
                throw new Exception( "El campo ClienteTipoDoc ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setClienteTipoDoc( $s_ClienteTipoDoc );
        return true;
    }

    /* Valida y establece el valor del campo ClienteRUC */
    public function setClienteRUC( $s_ClienteRUC, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ClienteRUC, "VARCHAR", 20, 0, false ) )
            {
                throw new Exception( "El campo ClienteRUC ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setClienteRUC( $s_ClienteRUC );
        return true;
    }

    /* Valida y establece el valor del campo ClienteNombre */
    public function setClienteNombre( $s_ClienteNombre, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ClienteNombre, "VARCHAR", 1000, 0, false ) )
            {
                throw new Exception( "El campo ClienteNombre ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setClienteNombre( $s_ClienteNombre );
        return true;
    }

    /* Valida y establece el valor del campo ClienteDireccionSecuencia */
    public function setClienteDireccionSecuencia( $f_ClienteDireccionSecuencia, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_ClienteDireccionSecuencia, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo ClienteDireccionSecuencia ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setClienteDireccionSecuencia( $f_ClienteDireccionSecuencia );
        return true;
    }

    /* Valida y establece el valor del campo ClienteDireccion */
    public function setClienteDireccion( $s_ClienteDireccion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ClienteDireccion, "VARCHAR", 500, 0, false ) )
            {
                throw new Exception( "El campo ClienteDireccion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setClienteDireccion( $s_ClienteDireccion );
        return true;
    }

    /* Valida y establece el valor del campo ClienteReferencia */
    public function setClienteReferencia( $s_ClienteReferencia, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ClienteReferencia, "VARCHAR", 100, 0, false ) )
            {
                throw new Exception( "El campo ClienteReferencia ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setClienteReferencia( $s_ClienteReferencia );
        return true;
    }

    /* Valida y establece el valor del campo ClienteContacto */
    public function setClienteContacto( $s_ClienteContacto, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ClienteContacto, "VARCHAR", 60, 0, false ) )
            {
                throw new Exception( "El campo ClienteContacto ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setClienteContacto( $s_ClienteContacto );
        return true;
    }

    /* Valida y establece el valor del campo Departamento */
    public function setDepartamento( $s_Departamento, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Departamento, "VARCHAR", 100, 0, false ) )
            {
                throw new Exception( "El campo Departamento ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDepartamento( $s_Departamento );
        return true;
    }

    /* Valida y establece el valor del campo Provincia */
    public function setProvincia( $s_Provincia, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Provincia, "VARCHAR", 100, 0, false ) )
            {
                throw new Exception( "El campo Provincia ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setProvincia( $s_Provincia );
        return true;
    }

    /* Valida y establece el valor del campo Distrito */
    public function setDistrito( $s_Distrito, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Distrito, "VARCHAR", 100, 0, false ) )
            {
                throw new Exception( "El campo Distrito ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDistrito( $s_Distrito );
        return true;
    }

    /* Valida y establece el valor del campo Ubigeo */
    public function setUbigeo( $s_Ubigeo, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Ubigeo, "VARCHAR", 15, 0, false ) )
            {
                throw new Exception( "El campo Ubigeo ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUbigeo( $s_Ubigeo );
        return true;
    }

    /* Valida y establece el valor del campo TipoFacturacion */
    public function setTipoFacturacion( $s_TipoFacturacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_TipoFacturacion, "VARCHAR", 3, 0, false ) )
            {
                throw new Exception( "El campo TipoFacturacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setTipoFacturacion( $s_TipoFacturacion );
        return true;
    }

    /* Valida y establece el valor del campo OrdenCompraRef */
    public function setOrdenCompraRef( $s_OrdenCompraRef, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_OrdenCompraRef, "VARCHAR", 50, 0, false ) )
            {
                throw new Exception( "El campo OrdenCompraRef ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setOrdenCompraRef( $s_OrdenCompraRef );
        return true;
    }

    /* Valida y establece el valor del campo TipoVenta */
    public function setTipoVenta( $s_TipoVenta, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_TipoVenta, "VARCHAR", 3, 0, false ) )
            {
                throw new Exception( "El campo TipoVenta ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setTipoVenta( $s_TipoVenta );
        return true;
    }

    /* Valida y establece el valor del campo Vendedor */
    public function setVendedor( $s_Vendedor, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Vendedor, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo Vendedor ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setVendedor( $s_Vendedor );
        return true;
    }

    /* Valida y establece el valor del campo DetraccionTipoId */
    public function setDetraccionTipoId( $i_DetraccionTipoId, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_DetraccionTipoId, "INT", 10, 0, false ) )
            {
                throw new Exception( "El campo DetraccionTipoId ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDetraccionTipoId( $i_DetraccionTipoId );
        return true;
    }

    /* Valida y establece el valor del campo DetraccionPorcentaje */
    public function setDetraccionPorcentaje( $f_DetraccionPorcentaje, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_DetraccionPorcentaje, "DECIMAL", 10, 4, false ) )
            {
                throw new Exception( "El campo DetraccionPorcentaje ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDetraccionPorcentaje( $f_DetraccionPorcentaje );
        return true;
    }

    /* Valida y establece el valor del campo DetraccionMedPagoId */
    public function setDetraccionMedPagoId( $i_DetraccionMedPagoId, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_DetraccionMedPagoId, "INT", 10, 0, false ) )
            {
                throw new Exception( "El campo DetraccionMedPagoId ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDetraccionMedPagoId( $i_DetraccionMedPagoId );
        return true;
    }

    /* Valida y establece el valor del campo DetraccionTotal */
    public function setDetraccionTotal( $f_DetraccionTotal, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_DetraccionTotal, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo DetraccionTotal ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDetraccionTotal( $f_DetraccionTotal );
        return true;
    }

    /* Valida y establece el valor del campo EsAgenteRetenedor */
    public function setEsAgenteRetenedor( $i_EsAgenteRetenedor, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_EsAgenteRetenedor, "INT", 10, 0, false ) )
            {
                throw new Exception( "El campo EsAgenteRetenedor ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setEsAgenteRetenedor( $i_EsAgenteRetenedor );
        return true;
    }

    /* Valida y establece el valor del campo RetencionTipoId */
    public function setRetencionTipoId( $i_RetencionTipoId, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_RetencionTipoId, "INT", 10, 0, false ) )
            {
                throw new Exception( "El campo RetencionTipoId ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setRetencionTipoId( $i_RetencionTipoId );
        return true;
    }

    /* Valida y establece el valor del campo RetencionBaseImponible */
    public function setRetencionBaseImponible( $f_RetencionBaseImponible, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_RetencionBaseImponible, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo RetencionBaseImponible ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setRetencionBaseImponible( $f_RetencionBaseImponible );
        return true;
    }

    /* Valida y establece el valor del campo RetencionPorcentaje */
    public function setRetencionPorcentaje( $f_RetencionPorcentaje, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_RetencionPorcentaje, "DECIMAL", 10, 4, false ) )
            {
                throw new Exception( "El campo RetencionPorcentaje ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setRetencionPorcentaje( $f_RetencionPorcentaje );
        return true;
    }

    /* Valida y establece el valor del campo RetencionTotal */
    public function setRetencionTotal( $f_RetencionTotal, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_RetencionTotal, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo RetencionTotal ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setRetencionTotal( $f_RetencionTotal );
        return true;
    }

    /* Valida y establece el valor del campo TipodeCambio */
    public function setTipodeCambio( $f_TipodeCambio, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_TipodeCambio, "DECIMAL", 10, 4, false ) )
            {
                throw new Exception( "El campo TipodeCambio ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setTipodeCambio( $f_TipodeCambio );
        return true;
    }

    /* Valida y establece el valor del campo MonedaDocumento */
    public function setMonedaDocumento( $s_MonedaDocumento, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_MonedaDocumento, "VARCHAR", 2, 0, false ) )
            {
                throw new Exception( "El campo MonedaDocumento ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setMonedaDocumento( $s_MonedaDocumento );
        return true;
    }

    /* Valida y establece el valor del campo MontoSubTotal */
    public function setMontoSubTotal( $f_MontoSubTotal, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_MontoSubTotal, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo MontoSubTotal ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setMontoSubTotal( $f_MontoSubTotal );
        return true;
    }

    /* Valida y establece el valor del campo MontoSubTotalMN */
    public function setMontoSubTotalMN( $f_MontoSubTotalMN, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_MontoSubTotalMN, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo MontoSubTotalMN ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setMontoSubTotalMN( $f_MontoSubTotalMN );
        return true;
    }

    /* Valida y establece el valor del campo MontoAfecto */
    public function setMontoAfecto( $f_MontoAfecto, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_MontoAfecto, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo MontoAfecto ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setMontoAfecto( $f_MontoAfecto );
        return true;
    }

    /* Valida y establece el valor del campo MontoAfectoMN */
    public function setMontoAfectoMN( $f_MontoAfectoMN, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_MontoAfectoMN, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo MontoAfectoMN ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setMontoAfectoMN( $f_MontoAfectoMN );
        return true;
    }

    /* Valida y establece el valor del campo MontoNoAfecto */
    public function setMontoNoAfecto( $f_MontoNoAfecto, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_MontoNoAfecto, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo MontoNoAfecto ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setMontoNoAfecto( $f_MontoNoAfecto );
        return true;
    }

    /* Valida y establece el valor del campo MontoNoAfectoMN */
    public function setMontoNoAfectoMN( $f_MontoNoAfectoMN, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_MontoNoAfectoMN, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo MontoNoAfectoMN ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setMontoNoAfectoMN( $f_MontoNoAfectoMN );
        return true;
    }

    /* Valida y establece el valor del campo MontoExonerado */
    public function setMontoExonerado( $f_MontoExonerado, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_MontoExonerado, "DECIMAL", 12, 6, false ) )
            {
                throw new Exception( "El campo MontoExonerado ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setMontoExonerado( $f_MontoExonerado );
        return true;
    }

    /* Valida y establece el valor del campo MontoExoneradoMN */
    public function setMontoExoneradoMN( $f_MontoExoneradoMN, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_MontoExoneradoMN, "DECIMAL", 12, 6, false ) )
            {
                throw new Exception( "El campo MontoExoneradoMN ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setMontoExoneradoMN( $f_MontoExoneradoMN );
        return true;
    }

    /* Valida y establece el valor del campo MontoGratuito */
    public function setMontoGratuito( $f_MontoGratuito, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_MontoGratuito, "DECIMAL", 12, 6, false ) )
            {
                throw new Exception( "El campo MontoGratuito ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setMontoGratuito( $f_MontoGratuito );
        return true;
    }

    /* Valida y establece el valor del campo MontoGratuitoMN */
    public function setMontoGratuitoMN( $f_MontoGratuitoMN, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_MontoGratuitoMN, "DECIMAL", 12, 6, false ) )
            {
                throw new Exception( "El campo MontoGratuitoMN ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setMontoGratuitoMN( $f_MontoGratuitoMN );
        return true;
    }

    /* Valida y establece el valor del campo MontoImpuestos */
    public function setMontoImpuestos( $f_MontoImpuestos, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_MontoImpuestos, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo MontoImpuestos ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setMontoImpuestos( $f_MontoImpuestos );
        return true;
    }

    /* Valida y establece el valor del campo MontoImpuestoMN */
    public function setMontoImpuestoMN( $f_MontoImpuestoMN, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_MontoImpuestoMN, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo MontoImpuestoMN ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setMontoImpuestoMN( $f_MontoImpuestoMN );
        return true;
    }

    /* Valida y establece el valor del campo MontoDescuentos */
    public function setMontoDescuentos( $f_MontoDescuentos, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_MontoDescuentos, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo MontoDescuentos ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setMontoDescuentos( $f_MontoDescuentos );
        return true;
    }

    /* Valida y establece el valor del campo MontoDescuentosMN */
    public function setMontoDescuentosMN( $f_MontoDescuentosMN, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_MontoDescuentosMN, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo MontoDescuentosMN ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setMontoDescuentosMN( $f_MontoDescuentosMN );
        return true;
    }

    /* Valida y establece el valor del campo MontoDescuentoLinea */
    public function setMontoDescuentoLinea( $f_MontoDescuentoLinea, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_MontoDescuentoLinea, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo MontoDescuentoLinea ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setMontoDescuentoLinea( $f_MontoDescuentoLinea );
        return true;
    }

    /* Valida y establece el valor del campo MontoDescuentoLineaMN */
    public function setMontoDescuentoLineaMN( $f_MontoDescuentoLineaMN, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_MontoDescuentoLineaMN, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo MontoDescuentoLineaMN ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setMontoDescuentoLineaMN( $f_MontoDescuentoLineaMN );
        return true;
    }

    /* Valida y establece el valor del campo MontoAnticipo */
    public function setMontoAnticipo( $f_MontoAnticipo, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_MontoAnticipo, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo MontoAnticipo ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setMontoAnticipo( $f_MontoAnticipo );
        return true;
    }

    /* Valida y establece el valor del campo MontoAnticipoMN */
    public function setMontoAnticipoMN( $f_MontoAnticipoMN, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_MontoAnticipoMN, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo MontoAnticipoMN ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setMontoAnticipoMN( $f_MontoAnticipoMN );
        return true;
    }

    /* Valida y establece el valor del campo MontoRedondeo */
    public function setMontoRedondeo( $f_MontoRedondeo, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_MontoRedondeo, "DECIMAL", 6, 2, false ) )
            {
                throw new Exception( "El campo MontoRedondeo ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setMontoRedondeo( $f_MontoRedondeo );
        return true;
    }

    /* Valida y establece el valor del campo MontoRedondeoMN */
    public function setMontoRedondeoMN( $f_MontoRedondeoMN, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_MontoRedondeoMN, "DECIMAL", 6, 2, false ) )
            {
                throw new Exception( "El campo MontoRedondeoMN ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setMontoRedondeoMN( $f_MontoRedondeoMN );
        return true;
    }

    /* Valida y establece el valor del campo MontoTotal */
    public function setMontoTotal( $f_MontoTotal, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_MontoTotal, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo MontoTotal ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setMontoTotal( $f_MontoTotal );
        return true;
    }

    /* Valida y establece el valor del campo MontoTotalMN */
    public function setMontoTotalMN( $f_MontoTotalMN, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_MontoTotalMN, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo MontoTotalMN ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setMontoTotalMN( $f_MontoTotalMN );
        return true;
    }

    /* Valida y establece el valor del campo MontoPagado */
    public function setMontoPagado( $f_MontoPagado, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_MontoPagado, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo MontoPagado ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setMontoPagado( $f_MontoPagado );
        return true;
    }

    /* Valida y establece el valor del campo MontoPagadoMN */
    public function setMontoPagadoMN( $f_MontoPagadoMN, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_MontoPagadoMN, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo MontoPagadoMN ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setMontoPagadoMN( $f_MontoPagadoMN );
        return true;
    }

    /* Valida y establece el valor del campo MontoSaldo */
    public function setMontoSaldo( $f_MontoSaldo, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_MontoSaldo, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo MontoSaldo ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setMontoSaldo( $f_MontoSaldo );
        return true;
    }

    /* Valida y establece el valor del campo MontoSaldoMN */
    public function setMontoSaldoMN( $f_MontoSaldoMN, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_MontoSaldoMN, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo MontoSaldoMN ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setMontoSaldoMN( $f_MontoSaldoMN );
        return true;
    }

    /* Valida y establece el valor del campo FechaFacturacion */
    public function setFechaFacturacion( $d_FechaFacturacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaFacturacion, "DATETIME", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaFacturacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaFacturacion( $d_FechaFacturacion );
        return true;
    }

    /* Valida y establece el valor del campo FechaAprobacion */
    public function setFechaAprobacion( $d_FechaAprobacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaAprobacion, "DATETIME", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaAprobacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaAprobacion( $d_FechaAprobacion );
        return true;
    }

    /* Valida y establece el valor del campo NotaCreditoDocumento */
    public function setNotaCreditoDocumento( $s_NotaCreditoDocumento, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_NotaCreditoDocumento, "VARCHAR", 20, 0, false ) )
            {
                throw new Exception( "El campo NotaCreditoDocumento ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setNotaCreditoDocumento( $s_NotaCreditoDocumento );
        return true;
    }

    /* Valida y establece el valor del campo NotaDebitoDocumento */
    public function setNotaDebitoDocumento( $s_NotaDebitoDocumento, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_NotaDebitoDocumento, "VARCHAR", 20, 0, false ) )
            {
                throw new Exception( "El campo NotaDebitoDocumento ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setNotaDebitoDocumento( $s_NotaDebitoDocumento );
        return true;
    }

    /* Valida y establece el valor del campo ImpresionPendienteFlag */
    public function setImpresionPendienteFlag( $s_ImpresionPendienteFlag, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ImpresionPendienteFlag, "CHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo ImpresionPendienteFlag ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setImpresionPendienteFlag( $s_ImpresionPendienteFlag );
        return true;
    }

    /* Valida y establece el valor del campo FechaImpresion */
    public function setFechaImpresion( $d_FechaImpresion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaImpresion, "DATETIME", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaImpresion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaImpresion( $d_FechaImpresion );
        return true;
    }

    /* Valida y establece el valor del campo ImpresionGuiaRemFlag */
    public function setImpresionGuiaRemFlag( $s_ImpresionGuiaRemFlag, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ImpresionGuiaRemFlag, "VARCHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo ImpresionGuiaRemFlag ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setImpresionGuiaRemFlag( $s_ImpresionGuiaRemFlag );
        return true;
    }

    /* Valida y establece el valor del campo FechaImpresionGuiRem */
    public function setFechaImpresionGuiRem( $d_FechaImpresionGuiRem, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaImpresionGuiRem, "DATETIME", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaImpresionGuiRem ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaImpresionGuiRem( $d_FechaImpresionGuiRem );
        return true;
    }

    /* Valida y establece el valor del campo NumeroRefAdicional1 */
    public function setNumeroRefAdicional1( $s_NumeroRefAdicional1, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_NumeroRefAdicional1, "VARCHAR", 255, 0, false ) )
            {
                throw new Exception( "El campo NumeroRefAdicional1 ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setNumeroRefAdicional1( $s_NumeroRefAdicional1 );
        return true;
    }

    /* Valida y establece el valor del campo FechaRefAdicional1 */
    public function setFechaRefAdicional1( $d_FechaRefAdicional1, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaRefAdicional1, "DATETIME", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaRefAdicional1 ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaRefAdicional1( $d_FechaRefAdicional1 );
        return true;
    }

    /* Valida y establece el valor del campo Comentario */
    public function setComentario( $s_Comentario, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Comentario, "VARCHAR", 100, 0, false ) )
            {
                throw new Exception( "El campo Comentario ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setComentario( $s_Comentario );
        return true;
    }

    /* Valida y establece el valor del campo AnulacionComentario */
    public function setAnulacionComentario( $s_AnulacionComentario, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_AnulacionComentario, "VARCHAR", 100, 0, false ) )
            {
                throw new Exception( "El campo AnulacionComentario ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setAnulacionComentario( $s_AnulacionComentario );
        return true;
    }

    /* Valida y establece el valor del campo CanalVenta */
    public function setCanalVenta( $s_CanalVenta, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_CanalVenta, "VARCHAR", 10, 0, false ) )
            {
                throw new Exception( "El campo CanalVenta ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setCanalVenta( $s_CanalVenta );
        return true;
    }

    /* Valida y establece el valor del campo FechaCobranza */
    public function setFechaCobranza( $d_FechaCobranza, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaCobranza, "DATETIME", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaCobranza ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaCobranza( $d_FechaCobranza );
        return true;
    }

    /* Valida y establece el valor del campo CobranzaEstado */
    public function setCobranzaEstado( $s_CobranzaEstado, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_CobranzaEstado, "VARCHAR", 2, 0, false ) )
            {
                throw new Exception( "El campo CobranzaEstado ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setCobranzaEstado( $s_CobranzaEstado );
        return true;
    }

    /* Valida y establece el valor del campo Estado */
    public function setEstado( $s_Estado, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Estado, "CHAR", 2, 0, false ) )
            {
                throw new Exception( "El campo Estado ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setEstado( $s_Estado );
        return true;
    }
    
    /* Valida y establece el valor del campo Comision */
    public function setComision( $s_Comision, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Comision, "DECIMAL", 10, 2, false ) )
            {
                throw new Exception( "El campo Comision ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setComision( $s_Comision );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioModificacion */
    public function setUsuarioModificacion( $s_UsuarioModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioModificacion, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo UsuarioModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioModificacion( $s_UsuarioModificacion );
        return true;
    }

    /* Valida y establece el valor del campo FechaModificacion */
    public function setFechaModificacion( $d_FechaModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaModificacion, "TIMESTAMP", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaModificacion( $d_FechaModificacion );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioCreacion */
    public function setUsuarioCreacion( $s_UsuarioCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioCreacion, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo UsuarioCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioCreacion( $s_UsuarioCreacion );
        return true;
    }

    /* Valida y establece el valor del campo FechaCreacion */
    public function setFechaCreacion( $d_FechaCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaCreacion, "DATETIME", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaCreacion( $d_FechaCreacion );
        return true;
    }

    /* Valida el contenido del registro */
    public function validateRecord()
    {
        $this->setIdTipoDocumento( $this->getIdTipoDocumento(), false );
        $this->setIdCompania( $this->getIdCompania(), false );
        $this->setNumeroDocumento( $this->getNumeroDocumento(), false );
        $this->setSucursal( $this->getSucursal(), true );
        $this->setIdAlmacen( $this->getIdAlmacen(), true );
        $this->setAlmacenDespacho( $this->getAlmacenDespacho(), true );
        $this->setIdFormaPago( $this->getIdFormaPago(), true );
        $this->setFormaPagoCod( $this->getFormaPagoCod(), true );
        $this->setTerminoPago( $this->getTerminoPago(), true );
        $this->setIdCierre( $this->getIdCierre(), true );
        $this->setIdCaja( $this->getIdCaja(), true );
        $this->setIdTurno( $this->getIdTurno(), true );
        $this->setIdProyecto( $this->getIdProyecto(), true );
        $this->setIdMotivo( $this->getIdMotivo(), true );
        $this->setDocumentoCod( $this->getDocumentoCod(), true );
        $this->setDocumentoSerie( $this->getDocumentoSerie(), true );
        $this->setDocumentoNumero( $this->getDocumentoNumero(), true );
        $this->setNumeroComprobante( $this->getNumeroComprobante(), true );
        $this->setPeriodo( $this->getPeriodo(), true );
        $this->setFechaDocumento( $this->getFechaDocumento(), true );
        $this->setFechaVencimiento( $this->getFechaVencimiento(), true );
        $this->setDocumentoParentId( $this->getDocumentoParentId(), true );
        $this->setDocumentoParentCod( $this->getDocumentoParentCod(), true );
        $this->setClienteNumero( $this->getClienteNumero(), true );
        $this->setClienteTipoDoc( $this->getClienteTipoDoc(), true );
        $this->setClienteRUC( $this->getClienteRUC(), true );
        $this->setClienteNombre( $this->getClienteNombre(), true );
        $this->setClienteDireccionSecuencia( $this->getClienteDireccionSecuencia(), true );
        $this->setClienteDireccion( $this->getClienteDireccion(), true );
        $this->setClienteReferencia( $this->getClienteReferencia(), true );
        $this->setClienteContacto( $this->getClienteContacto(), true );
        $this->setDepartamento( $this->getDepartamento(), true );
        $this->setProvincia( $this->getProvincia(), true );
        $this->setDistrito( $this->getDistrito(), true );
        $this->setUbigeo( $this->getUbigeo(), true );
        $this->setTipoFacturacion( $this->getTipoFacturacion(), true );
        $this->setOrdenCompraRef( $this->getOrdenCompraRef(), true );
        $this->setTipoVenta( $this->getTipoVenta(), true );
        $this->setVendedor( $this->getVendedor(), true );
        $this->setDetraccionTipoId( $this->getDetraccionTipoId(), true );
        $this->setDetraccionPorcentaje( $this->getDetraccionPorcentaje(), true );
        $this->setDetraccionMedPagoId( $this->getDetraccionMedPagoId(), true );
        $this->setDetraccionTotal( $this->getDetraccionTotal(), true );
        $this->setEsAgenteRetenedor( $this->getEsAgenteRetenedor(), true );
        $this->setRetencionTipoId( $this->getRetencionTipoId(), true );
        $this->setRetencionBaseImponible( $this->getRetencionBaseImponible(), true );
        $this->setRetencionPorcentaje( $this->getRetencionPorcentaje(), true );
        $this->setRetencionTotal( $this->getRetencionTotal(), true );
        $this->setTipodeCambio( $this->getTipodeCambio(), true );
        $this->setMonedaDocumento( $this->getMonedaDocumento(), true );
        $this->setMontoSubTotal( $this->getMontoSubTotal(), true );
        $this->setMontoSubTotalMN( $this->getMontoSubTotalMN(), true );
        $this->setMontoAfecto( $this->getMontoAfecto(), true );
        $this->setMontoAfectoMN( $this->getMontoAfectoMN(), true );
        $this->setMontoNoAfecto( $this->getMontoNoAfecto(), true );
        $this->setMontoNoAfectoMN( $this->getMontoNoAfectoMN(), true );
        $this->setMontoExonerado( $this->getMontoExonerado(), true );
        $this->setMontoExoneradoMN( $this->getMontoExoneradoMN(), true );
        $this->setMontoGratuito( $this->getMontoGratuito(), true );
        $this->setMontoGratuitoMN( $this->getMontoGratuitoMN(), true );
        $this->setMontoImpuestos( $this->getMontoImpuestos(), true );
        $this->setMontoImpuestoMN( $this->getMontoImpuestoMN(), true );
        $this->setMontoDescuentos( $this->getMontoDescuentos(), true );
        $this->setMontoDescuentosMN( $this->getMontoDescuentosMN(), true );
        $this->setMontoDescuentoLinea( $this->getMontoDescuentoLinea(), true );
        $this->setMontoDescuentoLineaMN( $this->getMontoDescuentoLineaMN(), true );
        $this->setMontoAnticipo( $this->getMontoAnticipo(), true );
        $this->setMontoAnticipoMN( $this->getMontoAnticipoMN(), true );
        $this->setMontoRedondeo( $this->getMontoRedondeo(), true );
        $this->setMontoRedondeoMN( $this->getMontoRedondeoMN(), true );
        $this->setMontoTotal( $this->getMontoTotal(), true );
        $this->setMontoTotalMN( $this->getMontoTotalMN(), true );
        $this->setMontoPagado( $this->getMontoPagado(), true );
        $this->setMontoPagadoMN( $this->getMontoPagadoMN(), true );
        $this->setMontoSaldo( $this->getMontoSaldo(), true );
        $this->setMontoSaldoMN( $this->getMontoSaldoMN(), true );
        $this->setFechaFacturacion( $this->getFechaFacturacion(), true );
        $this->setFechaAprobacion( $this->getFechaAprobacion(), true );
        $this->setNotaCreditoDocumento( $this->getNotaCreditoDocumento(), true );
        $this->setNotaDebitoDocumento( $this->getNotaDebitoDocumento(), true );
        $this->setImpresionPendienteFlag( $this->getImpresionPendienteFlag(), true );
        $this->setFechaImpresion( $this->getFechaImpresion(), true );
        $this->setImpresionGuiaRemFlag( $this->getImpresionGuiaRemFlag(), true );
        $this->setFechaImpresionGuiRem( $this->getFechaImpresionGuiRem(), true );
        $this->setNumeroRefAdicional1( $this->getNumeroRefAdicional1(), true );
        $this->setFechaRefAdicional1( $this->getFechaRefAdicional1(), true );
        $this->setComentario( $this->getComentario(), true );
        $this->setAnulacionComentario( $this->getAnulacionComentario(), true );
        $this->setCanalVenta( $this->getCanalVenta(), true );
        $this->setFechaCobranza( $this->getFechaCobranza(), true );
        $this->setCobranzaEstado( $this->getCobranzaEstado(), true );
        $this->setEstado( $this->getEstado(), true );
        $this->setComision( $this->getComision(), true );
        $this->setUsuarioModificacion( $this->getUsuarioModificacion(), true );
        $this->setFechaModificacion( $this->getFechaModificacion(), true );
        $this->setUsuarioCreacion( $this->getUsuarioCreacion(), true );
        $this->setFechaCreacion( $this->getFechaCreacion(), true );
        return true;
    }
}
?>