<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: TR_Vehiculo.xml */
/* Generado: 2022-11-26 03:12:52 */

/* Validacion del contenido de los campos campos de la tabla TR_Vehiculo */
abstract class BaseTR_VehiculoBV extends TR_VehiculoBN
{
    /* Contiene la clase que valida el tipo de dato */
    private $o_Validator; // Contiene el objeto que realizara la validacion de tipo de dato.
    private $s_ValidatorMessage; // Contiene la ultima observacion de la validacion del tipo de dato.

    /* Constructor ( Establece la clase que valida los tipos de datos y establece los valores por defecto ) */
    public function __construct()
    {
        /* Establecemos el objeto que realizara la validacion del tipo de dato */
        $this->o_Validator = new utilValidDataType();

        /* Establecemos los valores por defecto */
    }

    /* Valida en tipo de dato */
    private function validateData( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull )
    {
        $this->s_ValidatorMessage = null;
        if( !$this->o_Validator->validate( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull ) )
        {
            $this->s_ValidatorMessage = $this->o_Validator->getMessage();
        }
        return is_null( $this->s_ValidatorMessage );
    }

    /* Valida y establece el valor del campo IdVehiculo */
    public function setIdVehiculo( $i_IdVehiculo, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdVehiculo, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdVehiculo ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdVehiculo( $i_IdVehiculo );
        return true;
    }

    /* Valida y establece el valor del campo IdCompania */
    public function setIdCompania( $i_IdCompania, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdCompania, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdCompania ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdCompania( $i_IdCompania );
        return true;
    }

    /* Valida y establece el valor del campo IdSucursal */
    public function setIdSucursal( $i_IdSucursal, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdSucursal, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdSucursal ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdSucursal( $i_IdSucursal );
        return true;
    }

    /* Valida y establece el valor del campo VehiculoPlaca */
    public function setVehiculoPlaca( $s_VehiculoPlaca, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_VehiculoPlaca, "VARCHAR", 20, 0, false ) )
            {
                throw new Exception( "El campo VehiculoPlaca ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setVehiculoPlaca( $s_VehiculoPlaca );
        return true;
    }

    /* Valida y establece el valor del campo VehiculoPlaca2 */
    public function setVehiculoPlaca2( $s_VehiculoPlaca2, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_VehiculoPlaca2, "VARCHAR", 20, 0, false ) )
            {
                throw new Exception( "El campo VehiculoPlaca2 ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setVehiculoPlaca2( $s_VehiculoPlaca2 );
        return true;
    }

    /* Valida y establece el valor del campo VehiculoMarca */
    public function setVehiculoMarca( $s_VehiculoMarca, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_VehiculoMarca, "VARCHAR", 50, 0, false ) )
            {
                throw new Exception( "El campo VehiculoMarca ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setVehiculoMarca( $s_VehiculoMarca );
        return true;
    }

    /* Valida y establece el valor del campo VehiculoMdelo */
    public function setVehiculoMdelo( $s_VehiculoMdelo, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_VehiculoMdelo, "VARCHAR", 50, 0, false ) )
            {
                throw new Exception( "El campo VehiculoMdelo ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setVehiculoMdelo( $s_VehiculoMdelo );
        return true;
    }

    /* Valida y establece el valor del campo NroMotor */
    public function setNroMotor( $s_NroMotor, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_NroMotor, "VARCHAR", 20, 0, false ) )
            {
                throw new Exception( "El campo NroMotor ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setNroMotor( $s_NroMotor );
        return true;
    }

    /* Valida y establece el valor del campo Altura */
    public function setAltura( $s_Altura, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Altura, "VARCHAR", 20, 0, false ) )
            {
                throw new Exception( "El campo Altura ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setAltura( $s_Altura );
        return true;
    }

    /* Valida y establece el valor del campo Volumen */
    public function setVolumen( $s_Volumen, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Volumen, "VARCHAR", 20, 0, false ) )
            {
                throw new Exception( "El campo Volumen ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setVolumen( $s_Volumen );
        return true;
    }

    /* Valida y establece el valor del campo NroSOAT */
    public function setNroSOAT( $s_NroSOAT, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_NroSOAT, "VARCHAR", 20, 0, false ) )
            {
                throw new Exception( "El campo NroSOAT ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setNroSOAT( $s_NroSOAT );
        return true;
    }

    /* Valida y establece el valor del campo VencSOAT */
    public function setVencSOAT( $d_VencSOAT, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_VencSOAT, "TIMESTAMP", 0, 0, false ) )
            {
                throw new Exception( "El campo VencSOAT ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setVencSOAT( $d_VencSOAT );
        return true;
    }

    /* Valida y establece el valor del campo NroMTC */
    public function setNroMTC( $s_NroMTC, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_NroMTC, "VARCHAR", 20, 0, false ) )
            {
                throw new Exception( "El campo NroMTC ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setNroMTC( $s_NroMTC );
        return true;
    }

    /* Valida y establece el valor del campo TransportTipoDoc */
    public function setTransportTipoDoc( $i_TransportTipoDoc, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_TransportTipoDoc, "TINYINT", 4, 0, false ) )
            {
                throw new Exception( "El campo TransportTipoDoc ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setTransportTipoDoc( $i_TransportTipoDoc );
        return true;
    }

    /* Valida y establece el valor del campo TransportNumDoc */
    public function setTransportNumDoc( $s_TransportNumDoc, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_TransportNumDoc, "VARCHAR", 50, 0, false ) )
            {
                throw new Exception( "El campo TransportNumDoc ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setTransportNumDoc( $s_TransportNumDoc );
        return true;
    }

    /* Valida y establece el valor del campo TransportNombre */
    public function setTransportNombre( $s_TransportNombre, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_TransportNombre, "VARCHAR", 200, 0, false ) )
            {
                throw new Exception( "El campo TransportNombre ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setTransportNombre( $s_TransportNombre );
        return true;
    }

    /* Valida y establece el valor del campo Estado */
    public function setEstado( $s_Estado, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Estado, "VARCHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo Estado ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setEstado( $s_Estado );
        return true;
    }

    /* Valida y establece el valor del campo FechaCreacion */
    public function setFechaCreacion( $d_FechaCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaCreacion, "DATETIME", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaCreacion( $d_FechaCreacion );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioCreacion */
    public function setUsuarioCreacion( $s_UsuarioCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioCreacion, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo UsuarioCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioCreacion( $s_UsuarioCreacion );
        return true;
    }

    /* Valida y establece el valor del campo FechaModificacion */
    public function setFechaModificacion( $d_FechaModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaModificacion, "TIMESTAMP", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaModificacion( $d_FechaModificacion );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioModificacion */
    public function setUsuarioModificacion( $s_UsuarioModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioModificacion, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo UsuarioModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioModificacion( $s_UsuarioModificacion );
        return true;
    }

    /* Valida el contenido del registro */
    public function validateRecord()
    {
        $this->setIdVehiculo( $this->getIdVehiculo(), false );
        $this->setIdCompania( $this->getIdCompania(), true );
        $this->setIdSucursal( $this->getIdSucursal(), true );
        $this->setVehiculoPlaca( $this->getVehiculoPlaca(), true );
        $this->setVehiculoPlaca2( $this->getVehiculoPlaca2(), true );
        $this->setVehiculoMarca( $this->getVehiculoMarca(), true );
        $this->setVehiculoMdelo( $this->getVehiculoMdelo(), true );
        $this->setNroMotor( $this->getNroMotor(), true );
        $this->setAltura( $this->getAltura(), true );
        $this->setVolumen( $this->getVolumen(), true );
        $this->setNroSOAT( $this->getNroSOAT(), true );
        $this->setVencSOAT( $this->getVencSOAT(), true );
        $this->setNroMTC( $this->getNroMTC(), true );
        $this->setTransportTipoDoc( $this->getTransportTipoDoc(), true );
        $this->setTransportNumDoc( $this->getTransportNumDoc(), true );
        $this->setTransportNombre( $this->getTransportNombre(), true );
        $this->setEstado( $this->getEstado(), true );
        $this->setFechaCreacion( $this->getFechaCreacion(), true );
        $this->setUsuarioCreacion( $this->getUsuarioCreacion(), true );
        $this->setFechaModificacion( $this->getFechaModificacion(), true );
        $this->setUsuarioModificacion( $this->getUsuarioModificacion(), true );
        return true;
    }
}
?>