<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: sys_parametros.xml */
/* Generado: 2020-08-18 04:21:32 */

/* Validacion del contenido de los campos campos de la tabla sys_parametros */
abstract class BaseSys_parametrosBV extends Sys_parametrosBN
{
    /* Contiene la clase que valida el tipo de dato */
    private $o_Validator; // Contiene el objeto que realizara la validacion de tipo de dato.
    private $s_ValidatorMessage; // Contiene la ultima observacion de la validacion del tipo de dato.

    /* Constructor ( Establece la clase que valida los tipos de datos y establece los valores por defecto ) */
    public function __construct()
    {
        /* Establecemos el objeto que realizara la validacion del tipo de dato */
        $this->o_Validator = new utilValidDataType();

        /* Establecemos los valores por defecto */
    }

    /* Valida en tipo de dato */
    private function validateData( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull )
    {
        $this->s_ValidatorMessage = null;
        if( !$this->o_Validator->validate( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull ) )
        {
            $this->s_ValidatorMessage = $this->o_Validator->getMessage();
        }
        return is_null( $this->s_ValidatorMessage );
    }

    /* Valida y establece el valor del campo parametroid */
    public function setParametroid( $s_Parametroid, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Parametroid, "VARCHAR", 10, 0, false ) )
            {
                throw new Exception( "El campo parametroid ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setParametroid( $s_Parametroid );
        return true;
    }

    /* Valida y establece el valor del campo parametrocod */
    public function setParametrocod( $s_Parametrocod, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Parametrocod, "VARCHAR", 10, 0, false ) )
            {
                throw new Exception( "El campo parametrocod ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setParametrocod( $s_Parametrocod );
        return true;
    }

    /* Valida y establece el valor del campo paramtetrovalor */
    public function setParamtetrovalor( $s_Paramtetrovalor, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Paramtetrovalor, "VARCHAR", 50, 0, false ) )
            {
                throw new Exception( "El campo paramtetrovalor ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setParamtetrovalor( $s_Paramtetrovalor );
        return true;
    }

    /* Valida y establece el valor del campo Comentario */
    public function setComentario( $s_Comentario, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Comentario, "VARCHAR", 200, 0, false ) )
            {
                throw new Exception( "El campo Comentario ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setComentario( $s_Comentario );
        return true;
    }

    /* Valida el contenido del registro */
    public function validateRecord()
    {
        $this->setParametroid( $this->getParametroid(), false );
        $this->setParametrocod( $this->getParametrocod(), false );
        $this->setParamtetrovalor( $this->getParamtetrovalor(), true );
        $this->setComentario( $this->getComentario(), true );
        return true;
    }
}
?>