<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: SR_MovimientoDetalle.xml */
/* Generado: 2020-08-18 04:21:31 */

/* Validacion del contenido de los campos campos de la tabla SR_MovimientoDetalle */
abstract class BaseSR_MovimientoDetalleBV extends SR_MovimientoDetalleBN
{
    /* Contiene la clase que valida el tipo de dato */
    private $o_Validator; // Contiene el objeto que realizara la validacion de tipo de dato.
    private $s_ValidatorMessage; // Contiene la ultima observacion de la validacion del tipo de dato.

    /* Constructor ( Establece la clase que valida los tipos de datos y establece los valores por defecto ) */
    public function __construct()
    {
        /* Establecemos el objeto que realizara la validacion del tipo de dato */
        $this->o_Validator = new utilValidDataType();

        /* Establecemos los valores por defecto */
    }

    /* Valida en tipo de dato */
    private function validateData( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull )
    {
        $this->s_ValidatorMessage = null;
        if( !$this->o_Validator->validate( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull ) )
        {
            $this->s_ValidatorMessage = $this->o_Validator->getMessage();
        }
        return is_null( $this->s_ValidatorMessage );
    }

    /* Valida y establece el valor del campo MovimientoDetalleId */
    public function setMovimientoDetalleId( $i_MovimientoDetalleId, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_MovimientoDetalleId, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo MovimientoDetalleId ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setMovimientoDetalleId( $i_MovimientoDetalleId );
        return true;
    }

    /* Valida y establece el valor del campo MovimientoId */
    public function setMovimientoId( $i_MovimientoId, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_MovimientoId, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo MovimientoId ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setMovimientoId( $i_MovimientoId );
        return true;
    }

    /* Valida y establece el valor del campo ProductoId */
    public function setProductoId( $s_ProductoId, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ProductoId, "VARCHAR", 25, 0, false ) )
            {
                throw new Exception( "El campo ProductoId ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setProductoId( $s_ProductoId );
        return true;
    }

    /* Valida y establece el valor del campo IdLote */
    public function setIdLote( $s_IdLote, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdLote, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo IdLote ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdLote( $s_IdLote );
        return true;
    }

    /* Valida y establece el valor del campo Cantidad */
    public function setCantidad( $i_Cantidad, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_Cantidad, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo Cantidad ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setCantidad( $i_Cantidad );
        return true;
    }

    /* Valida y establece el valor del campo CantidadEscaneada */
    public function setCantidadEscaneada( $i_CantidadEscaneada, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_CantidadEscaneada, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo CantidadEscaneada ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setCantidadEscaneada( $i_CantidadEscaneada );
        return true;
    }

    /* Valida y establece el valor del campo InicioEscaneo */
    public function setInicioEscaneo( $d_InicioEscaneo, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_InicioEscaneo, "DATETIME", 0, 0, false ) )
            {
                throw new Exception( "El campo InicioEscaneo ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setInicioEscaneo( $d_InicioEscaneo );
        return true;
    }

    /* Valida y establece el valor del campo FinEscaneo */
    public function setFinEscaneo( $d_FinEscaneo, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FinEscaneo, "DATETIME", 0, 0, false ) )
            {
                throw new Exception( "El campo FinEscaneo ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFinEscaneo( $d_FinEscaneo );
        return true;
    }

    /* Valida y establece el valor del campo PorSerie */
    public function setPorSerie( $s_PorSerie, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_PorSerie, "VARCHAR", 3, 0, false ) )
            {
                throw new Exception( "El campo PorSerie ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setPorSerie( $s_PorSerie );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioRegistro */
    public function setUsuarioRegistro( $s_UsuarioRegistro, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioRegistro, "VARCHAR", 25, 0, false ) )
            {
                throw new Exception( "El campo UsuarioRegistro ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioRegistro( $s_UsuarioRegistro );
        return true;
    }

    /* Valida y establece el valor del campo FechaRegistro */
    public function setFechaRegistro( $d_FechaRegistro, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaRegistro, "TIMESTAMP", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaRegistro ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaRegistro( $d_FechaRegistro );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioActualizacion */
    public function setUsuarioActualizacion( $s_UsuarioActualizacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioActualizacion, "VARCHAR", 25, 0, false ) )
            {
                throw new Exception( "El campo UsuarioActualizacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioActualizacion( $s_UsuarioActualizacion );
        return true;
    }

    /* Valida y establece el valor del campo FechaActualizacion */
    public function setFechaActualizacion( $d_FechaActualizacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaActualizacion, "TIMESTAMP", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaActualizacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaActualizacion( $d_FechaActualizacion );
        return true;
    }

    /* Valida el contenido del registro */
    public function validateRecord()
    {
        $this->setMovimientoDetalleId( $this->getMovimientoDetalleId(), false );
        $this->setMovimientoId( $this->getMovimientoId(), true );
        $this->setProductoId( $this->getProductoId(), true );
        $this->setIdLote( $this->getIdLote(), true );
        $this->setCantidad( $this->getCantidad(), true );
        $this->setCantidadEscaneada( $this->getCantidadEscaneada(), true );
        $this->setInicioEscaneo( $this->getInicioEscaneo(), true );
        $this->setFinEscaneo( $this->getFinEscaneo(), true );
        $this->setPorSerie( $this->getPorSerie(), true );
        $this->setUsuarioRegistro( $this->getUsuarioRegistro(), true );
        $this->setFechaRegistro( $this->getFechaRegistro(), true );
        $this->setUsuarioActualizacion( $this->getUsuarioActualizacion(), true );
        $this->setFechaActualizacion( $this->getFechaActualizacion(), true );
        return true;
    }
}
?>