<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: SR_Movimiento.xml */
/* Generado: 2021-08-25 23:09:49 */

/* Validacion del contenido de los campos campos de la tabla SR_Movimiento */
abstract class BaseSR_MovimientoBV extends SR_MovimientoBN
{
    /* Contiene la clase que valida el tipo de dato */
    private $o_Validator; // Contiene el objeto que realizara la validacion de tipo de dato.
    private $s_ValidatorMessage; // Contiene la ultima observacion de la validacion del tipo de dato.

    /* Constructor ( Establece la clase que valida los tipos de datos y establece los valores por defecto ) */
    public function __construct()
    {
        /* Establecemos el objeto que realizara la validacion del tipo de dato */
        $this->o_Validator = new utilValidDataType();

        /* Establecemos los valores por defecto */
    }

    /* Valida en tipo de dato */
    private function validateData( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull )
    {
        $this->s_ValidatorMessage = null;
        if( !$this->o_Validator->validate( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull ) )
        {
            $this->s_ValidatorMessage = $this->o_Validator->getMessage();
        }
        return is_null( $this->s_ValidatorMessage );
    }

    /* Valida y establece el valor del campo MovimientoId */
    public function setMovimientoId( $i_MovimientoId, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_MovimientoId, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo MovimientoId ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setMovimientoId( $i_MovimientoId );
        return true;
    }

    /* Valida y establece el valor del campo IdCompania */
    public function setIdCompania( $i_IdCompania, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdCompania, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdCompania ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdCompania( $i_IdCompania );
        return true;
    }

    /* Valida y establece el valor del campo IdSucursal */
    public function setIdSucursal( $i_IdSucursal, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdSucursal, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdSucursal ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdSucursal( $i_IdSucursal );
        return true;
    }

    /* Valida y establece el valor del campo Fecha */
    public function setFecha( $d_Fecha, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_Fecha, "DATETIME", 0, 0, false ) )
            {
                throw new Exception( "El campo Fecha ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFecha( $d_Fecha );
        return true;
    }

    /* Valida y establece el valor del campo TipoMovimiento */
    public function setTipoMovimiento( $s_TipoMovimiento, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_TipoMovimiento, "VARCHAR", 5, 0, false ) )
            {
                throw new Exception( "El campo TipoMovimiento ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setTipoMovimiento( $s_TipoMovimiento );
        return true;
    }

    /* Valida y establece el valor del campo Operacion */
    public function setOperacion( $s_Operacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Operacion, "VARCHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo Operacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setOperacion( $s_Operacion );
        return true;
    }

    /* Valida y establece el valor del campo Almacen */
    public function setAlmacen( $s_Almacen, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Almacen, "VARCHAR", 10, 0, false ) )
            {
                throw new Exception( "El campo Almacen ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setAlmacen( $s_Almacen );
        return true;
    }

    /* Valida y establece el valor del campo ReferenciaTipo */
    public function setReferenciaTipo( $s_ReferenciaTipo, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ReferenciaTipo, "VARCHAR", 3, 0, false ) )
            {
                throw new Exception( "El campo ReferenciaTipo ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setReferenciaTipo( $s_ReferenciaTipo );
        return true;
    }

    /* Valida y establece el valor del campo ReferenciaNumero */
    public function setReferenciaNumero( $s_ReferenciaNumero, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ReferenciaNumero, "VARCHAR", 15, 0, false ) )
            {
                throw new Exception( "El campo ReferenciaNumero ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setReferenciaNumero( $s_ReferenciaNumero );
        return true;
    }

    /* Valida y establece el valor del campo ReferenciaSecuencia */
    public function setReferenciaSecuencia( $i_ReferenciaSecuencia, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_ReferenciaSecuencia, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo ReferenciaSecuencia ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setReferenciaSecuencia( $i_ReferenciaSecuencia );
        return true;
    }

    /* Valida y establece el valor del campo ReferenciaId */
    public function setReferenciaId( $s_ReferenciaId, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ReferenciaId, "VARCHAR", 25, 0, false ) )
            {
                throw new Exception( "El campo ReferenciaId ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setReferenciaId( $s_ReferenciaId );
        return true;
    }

    /* Valida y establece el valor del campo ReferenciaFecha */
    public function setReferenciaFecha( $d_ReferenciaFecha, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_ReferenciaFecha, "DATETIME", 0, 0, false ) )
            {
                throw new Exception( "El campo ReferenciaFecha ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setReferenciaFecha( $d_ReferenciaFecha );
        return true;
    }

    /* Valida y establece el valor del campo InicioEscaneo */
    public function setInicioEscaneo( $d_InicioEscaneo, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_InicioEscaneo, "DATETIME", 0, 0, false ) )
            {
                throw new Exception( "El campo InicioEscaneo ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setInicioEscaneo( $d_InicioEscaneo );
        return true;
    }

    /* Valida y establece el valor del campo FinEscaneo */
    public function setFinEscaneo( $d_FinEscaneo, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FinEscaneo, "DATETIME", 0, 0, false ) )
            {
                throw new Exception( "El campo FinEscaneo ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFinEscaneo( $d_FinEscaneo );
        return true;
    }

    /* Valida y establece el valor del campo Comentario */
    public function setComentario( $u_Comentario, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $u_Comentario, "TEXT", 0, 0, false ) )
            {
                throw new Exception( "El campo Comentario ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setComentario( $u_Comentario );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioAprob */
    public function setUsuarioAprob( $s_UsuarioAprob, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioAprob, "VARCHAR", 25, 0, false ) )
            {
                throw new Exception( "El campo UsuarioAprob ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioAprob( $s_UsuarioAprob );
        return true;
    }

    /* Valida y establece el valor del campo FechaAprob */
    public function setFechaAprob( $d_FechaAprob, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaAprob, "DATETIME", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaAprob ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaAprob( $d_FechaAprob );
        return true;
    }

    /* Valida y establece el valor del campo EstadoAprob */
    public function setEstadoAprob( $s_EstadoAprob, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_EstadoAprob, "VARCHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo EstadoAprob ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setEstadoAprob( $s_EstadoAprob );
        return true;
    }

    /* Valida y establece el valor del campo ComentarioAprob */
    public function setComentarioAprob( $s_ComentarioAprob, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ComentarioAprob, "VARCHAR", 1000, 0, false ) )
            {
                throw new Exception( "El campo ComentarioAprob ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setComentarioAprob( $s_ComentarioAprob );
        return true;
    }

    /* Valida y establece el valor del campo Estado */
    public function setEstado( $s_Estado, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Estado, "VARCHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo Estado ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setEstado( $s_Estado );
        return true;
    }

    /* Valida y establece el valor del campo ImpresionEstado */
    public function setImpresionEstado( $s_ImpresionEstado, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ImpresionEstado, "VARCHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo ImpresionEstado ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setImpresionEstado( $s_ImpresionEstado );
        return true;
    }

    /* Valida y establece el valor del campo ControlEstadoSerie */
    public function setControlEstadoSerie( $s_ControlEstadoSerie, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ControlEstadoSerie, "VARCHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo ControlEstadoSerie ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setControlEstadoSerie( $s_ControlEstadoSerie );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioRegistro */
    public function setUsuarioRegistro( $s_UsuarioRegistro, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioRegistro, "VARCHAR", 25, 0, false ) )
            {
                throw new Exception( "El campo UsuarioRegistro ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioRegistro( $s_UsuarioRegistro );
        return true;
    }

    /* Valida y establece el valor del campo FechaRegistro */
    public function setFechaRegistro( $d_FechaRegistro, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaRegistro, "TIMESTAMP", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaRegistro ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaRegistro( $d_FechaRegistro );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioModificacion */
    public function setUsuarioModificacion( $s_UsuarioModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioModificacion, "VARCHAR", 25, 0, false ) )
            {
                throw new Exception( "El campo UsuarioModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioModificacion( $s_UsuarioModificacion );
        return true;
    }

    /* Valida y establece el valor del campo FechaModificacion */
    public function setFechaModificacion( $d_FechaModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaModificacion, "TIMESTAMP", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaModificacion( $d_FechaModificacion );
        return true;
    }

    /* Valida el contenido del registro */
    public function validateRecord()
    {
        $this->setMovimientoId( $this->getMovimientoId(), false );
        $this->setIdCompania( $this->getIdCompania(), true );
        $this->setIdSucursal( $this->getIdSucursal(), true );
        $this->setFecha( $this->getFecha(), true );
        $this->setTipoMovimiento( $this->getTipoMovimiento(), true );
        $this->setOperacion( $this->getOperacion(), true );
        $this->setAlmacen( $this->getAlmacen(), true );
        $this->setReferenciaTipo( $this->getReferenciaTipo(), true );
        $this->setReferenciaNumero( $this->getReferenciaNumero(), true );
        $this->setReferenciaSecuencia( $this->getReferenciaSecuencia(), true );
        $this->setReferenciaId( $this->getReferenciaId(), true );
        $this->setReferenciaFecha( $this->getReferenciaFecha(), true );
        $this->setInicioEscaneo( $this->getInicioEscaneo(), true );
        $this->setFinEscaneo( $this->getFinEscaneo(), true );
        $this->setComentario( $this->getComentario(), true );
        $this->setUsuarioAprob( $this->getUsuarioAprob(), true );
        $this->setFechaAprob( $this->getFechaAprob(), true );
        $this->setEstadoAprob( $this->getEstadoAprob(), true );
        $this->setComentarioAprob( $this->getComentarioAprob(), true );
        $this->setEstado( $this->getEstado(), true );
        $this->setImpresionEstado( $this->getImpresionEstado(), true );
        $this->setControlEstadoSerie( $this->getControlEstadoSerie(), true );
        $this->setUsuarioRegistro( $this->getUsuarioRegistro(), true );
        $this->setFechaRegistro( $this->getFechaRegistro(), true );
        $this->setUsuarioModificacion( $this->getUsuarioModificacion(), true );
        $this->setFechaModificacion( $this->getFechaModificacion(), true );
        return true;
    }
}
?>