<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: SR_GuiaRemisionH.xml */
/* Generado: 2024-08-25 21:43:26 */

/* Validacion del contenido de los campos campos de la tabla SR_GuiaRemisionH */
abstract class BaseSR_GuiaRemisionHBV extends SR_GuiaRemisionHBN
{
    /* Contiene la clase que valida el tipo de dato */
    private $o_Validator; // Contiene el objeto que realizara la validacion de tipo de dato.
    private $s_ValidatorMessage; // Contiene la ultima observacion de la validacion del tipo de dato.

    /* Constructor ( Establece la clase que valida los tipos de datos y establece los valores por defecto ) */
    public function __construct()
    {
        /* Establecemos el objeto que realizara la validacion del tipo de dato */
        $this->o_Validator = new utilValidDataType();

        /* Establecemos los valores por defecto */
    }

    /* Valida en tipo de dato */
    private function validateData( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull )
    {
        $this->s_ValidatorMessage = null;
        if( !$this->o_Validator->validate( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull ) )
        {
            $this->s_ValidatorMessage = $this->o_Validator->getMessage();
        }
        return is_null( $this->s_ValidatorMessage );
    }

    /* Valida y establece el valor del campo GuiaRemisionId */
    public function setGuiaRemisionId( $s_GuiaRemisionId, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_GuiaRemisionId, "VARCHAR", 15, 0, false ) )
            {
                throw new Exception( "El campo GuiaRemisionId ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setGuiaRemisionId( $s_GuiaRemisionId );
        return true;
    }

    /* Valida y establece el valor del campo IdCompania */
    public function setIdCompania( $i_IdCompania, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdCompania, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdCompania ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdCompania( $i_IdCompania );
        return true;
    }

    /* Valida y establece el valor del campo IdSucursal */
    public function setIdSucursal( $i_IdSucursal, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdSucursal, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdSucursal ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdSucursal( $i_IdSucursal );
        return true;
    }

    /* Valida y establece el valor del campo TipoGuia */
    public function setTipoGuia( $s_TipoGuia, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_TipoGuia, "VARCHAR", 5, 0, false ) )
            {
                throw new Exception( "El campo TipoGuia ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setTipoGuia( $s_TipoGuia );
        return true;
    }

    /* Valida y establece el valor del campo GuiaSerie */
    public function setGuiaSerie( $s_GuiaSerie, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_GuiaSerie, "VARCHAR", 4, 0, false ) )
            {
                throw new Exception( "El campo GuiaSerie ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setGuiaSerie( $s_GuiaSerie );
        return true;
    }

    /* Valida y establece el valor del campo GuiaNumero */
    public function setGuiaNumero( $s_GuiaNumero, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_GuiaNumero, "VARCHAR", 10, 0, false ) )
            {
                throw new Exception( "El campo GuiaNumero ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setGuiaNumero( $s_GuiaNumero );
        return true;
    }

    /* Valida y establece el valor del campo GuiaFecha */
    public function setGuiaFecha( $d_GuiaFecha, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_GuiaFecha, "DATETIME", 0, 0, false ) )
            {
                throw new Exception( "El campo GuiaFecha ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setGuiaFecha( $d_GuiaFecha );
        return true;
    }

    /* Valida y establece el valor del campo FechaIniTraslado */
    public function setFechaIniTraslado( $d_FechaIniTraslado, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaIniTraslado, "DATE", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaIniTraslado ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaIniTraslado( $d_FechaIniTraslado );
        return true;
    }

    /* Valida y establece el valor del campo IdProyecto */
    public function setIdProyecto( $i_IdProyecto, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdProyecto, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdProyecto ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdProyecto( $i_IdProyecto );
        return true;
    }

    /* Valida y establece el valor del campo OrdenTipoComercialId */
    public function setOrdenTipoComercialId( $i_OrdenTipoComercialId, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_OrdenTipoComercialId, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo OrdenTipoComercialId ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setOrdenTipoComercialId( $i_OrdenTipoComercialId );
        return true;
    }

    /* Valida y establece el valor del campo ReferenciaParentId */
    public function setReferenciaParentId( $i_ReferenciaParentId, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_ReferenciaParentId, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo ReferenciaParentId ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setReferenciaParentId( $i_ReferenciaParentId );
        return true;
    }

    /* Valida y establece el valor del campo ReferenciaParentNum */
    public function setReferenciaParentNum( $s_ReferenciaParentNum, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ReferenciaParentNum, "VARCHAR", 25, 0, false ) )
            {
                throw new Exception( "El campo ReferenciaParentNum ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setReferenciaParentNum( $s_ReferenciaParentNum );
        return true;
    }

    /* Valida y establece el valor del campo ReferenciaIdTipoDocumento */
    public function setReferenciaIdTipoDocumento( $s_ReferenciaIdTipoDocumento, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ReferenciaIdTipoDocumento, "VARCHAR", 2, 0, false ) )
            {
                throw new Exception( "El campo ReferenciaIdTipoDocumento ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setReferenciaIdTipoDocumento( $s_ReferenciaIdTipoDocumento );
        return true;
    }

    /* Valida y establece el valor del campo ReferenciaTipo */
    public function setReferenciaTipo( $s_ReferenciaTipo, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ReferenciaTipo, "VARCHAR", 4, 0, false ) )
            {
                throw new Exception( "El campo ReferenciaTipo ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setReferenciaTipo( $s_ReferenciaTipo );
        return true;
    }

    /* Valida y establece el valor del campo ReferenciaNumero */
    public function setReferenciaNumero( $s_ReferenciaNumero, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ReferenciaNumero, "VARCHAR", 25, 0, false ) )
            {
                throw new Exception( "El campo ReferenciaNumero ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setReferenciaNumero( $s_ReferenciaNumero );
        return true;
    }

    /* Valida y establece el valor del campo ReferenciaNumeroDocumento */
    public function setReferenciaNumeroDocumento( $s_ReferenciaNumeroDocumento, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ReferenciaNumeroDocumento, "VARCHAR", 20, 0, false ) )
            {
                throw new Exception( "El campo ReferenciaNumeroDocumento ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setReferenciaNumeroDocumento( $s_ReferenciaNumeroDocumento );
        return true;
    }

    /* Valida y establece el valor del campo MovimientoId */
    public function setMovimientoId( $i_MovimientoId, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_MovimientoId, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo MovimientoId ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setMovimientoId( $i_MovimientoId );
        return true;
    }

    /* Valida y establece el valor del campo MovimientoDetId */
    public function setMovimientoDetId( $i_MovimientoDetId, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_MovimientoDetId, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo MovimientoDetId ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setMovimientoDetId( $i_MovimientoDetId );
        return true;
    }

    /* Valida y establece el valor del campo FechaInicioAlq */
    public function setFechaInicioAlq( $d_FechaInicioAlq, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaInicioAlq, "DATE", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaInicioAlq ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaInicioAlq( $d_FechaInicioAlq );
        return true;
    }

    /* Valida y establece el valor del campo FechaFinAlq */
    public function setFechaFinAlq( $d_FechaFinAlq, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaFinAlq, "DATE", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaFinAlq ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaFinAlq( $d_FechaFinAlq );
        return true;
    }

    /* Valida y establece el valor del campo EmpresaTipoDoc */
    public function setEmpresaTipoDoc( $s_EmpresaTipoDoc, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_EmpresaTipoDoc, "VARCHAR", 3, 0, false ) )
            {
                throw new Exception( "El campo EmpresaTipoDoc ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setEmpresaTipoDoc( $s_EmpresaTipoDoc );
        return true;
    }

    /* Valida y establece el valor del campo EmpresaNumDoc */
    public function setEmpresaNumDoc( $s_EmpresaNumDoc, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_EmpresaNumDoc, "VARCHAR", 15, 0, false ) )
            {
                throw new Exception( "El campo EmpresaNumDoc ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setEmpresaNumDoc( $s_EmpresaNumDoc );
        return true;
    }

    /* Valida y establece el valor del campo EmpresaInfoAdicional */
    public function setEmpresaInfoAdicional( $s_EmpresaInfoAdicional, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_EmpresaInfoAdicional, "VARCHAR", 250, 0, false ) )
            {
                throw new Exception( "El campo EmpresaInfoAdicional ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setEmpresaInfoAdicional( $s_EmpresaInfoAdicional );
        return true;
    }

    /* Valida y establece el valor del campo EmpresaDireccion */
    public function setEmpresaDireccion( $s_EmpresaDireccion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_EmpresaDireccion, "VARCHAR", 250, 0, false ) )
            {
                throw new Exception( "El campo EmpresaDireccion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setEmpresaDireccion( $s_EmpresaDireccion );
        return true;
    }

    /* Valida y establece el valor del campo ClienteNombre */
    public function setClienteNombre( $s_ClienteNombre, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ClienteNombre, "VARCHAR", 1000, 0, false ) )
            {
                throw new Exception( "El campo ClienteNombre ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setClienteNombre( $s_ClienteNombre );
        return true;
    }

    /* Valida y establece el valor del campo ClienteTipoDocumento */
    public function setClienteTipoDocumento( $s_ClienteTipoDocumento, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ClienteTipoDocumento, "VARCHAR", 3, 0, false ) )
            {
                throw new Exception( "El campo ClienteTipoDocumento ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setClienteTipoDocumento( $s_ClienteTipoDocumento );
        return true;
    }

    /* Valida y establece el valor del campo ClienteNumDocumento */
    public function setClienteNumDocumento( $s_ClienteNumDocumento, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ClienteNumDocumento, "VARCHAR", 15, 0, false ) )
            {
                throw new Exception( "El campo ClienteNumDocumento ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setClienteNumDocumento( $s_ClienteNumDocumento );
        return true;
    }

    /* Valida y establece el valor del campo DepartamentoOrigen */
    public function setDepartamentoOrigen( $s_DepartamentoOrigen, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_DepartamentoOrigen, "VARCHAR", 250, 0, false ) )
            {
                throw new Exception( "El campo DepartamentoOrigen ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDepartamentoOrigen( $s_DepartamentoOrigen );
        return true;
    }

    /* Valida y establece el valor del campo ProvinciaOrigen */
    public function setProvinciaOrigen( $s_ProvinciaOrigen, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ProvinciaOrigen, "VARCHAR", 250, 0, false ) )
            {
                throw new Exception( "El campo ProvinciaOrigen ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setProvinciaOrigen( $s_ProvinciaOrigen );
        return true;
    }

    /* Valida y establece el valor del campo DistritoOrigen */
    public function setDistritoOrigen( $s_DistritoOrigen, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_DistritoOrigen, "VARCHAR", 250, 0, false ) )
            {
                throw new Exception( "El campo DistritoOrigen ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDistritoOrigen( $s_DistritoOrigen );
        return true;
    }

    /* Valida y establece el valor del campo DireccionOrigen */
    public function setDireccionOrigen( $s_DireccionOrigen, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_DireccionOrigen, "VARCHAR", 500, 0, false ) )
            {
                throw new Exception( "El campo DireccionOrigen ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDireccionOrigen( $s_DireccionOrigen );
        return true;
    }

    /* Valida y establece el valor del campo UbigeoOrigen */
    public function setUbigeoOrigen( $s_UbigeoOrigen, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UbigeoOrigen, "VARCHAR", 25, 0, false ) )
            {
                throw new Exception( "El campo UbigeoOrigen ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUbigeoOrigen( $s_UbigeoOrigen );
        return true;
    }

    /* Valida y establece el valor del campo DepartamentoDestino */
    public function setDepartamentoDestino( $s_DepartamentoDestino, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_DepartamentoDestino, "VARCHAR", 250, 0, false ) )
            {
                throw new Exception( "El campo DepartamentoDestino ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDepartamentoDestino( $s_DepartamentoDestino );
        return true;
    }

    /* Valida y establece el valor del campo ProvinciaDestino */
    public function setProvinciaDestino( $s_ProvinciaDestino, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ProvinciaDestino, "VARCHAR", 250, 0, false ) )
            {
                throw new Exception( "El campo ProvinciaDestino ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setProvinciaDestino( $s_ProvinciaDestino );
        return true;
    }

    /* Valida y establece el valor del campo DistritoDestino */
    public function setDistritoDestino( $s_DistritoDestino, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_DistritoDestino, "VARCHAR", 250, 0, false ) )
            {
                throw new Exception( "El campo DistritoDestino ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDistritoDestino( $s_DistritoDestino );
        return true;
    }

    /* Valida y establece el valor del campo DireccionDestino */
    public function setDireccionDestino( $s_DireccionDestino, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_DireccionDestino, "VARCHAR", 500, 0, false ) )
            {
                throw new Exception( "El campo DireccionDestino ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDireccionDestino( $s_DireccionDestino );
        return true;
    }

    /* Valida y establece el valor del campo UbigeoDestino */
    public function setUbigeoDestino( $s_UbigeoDestino, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UbigeoDestino, "VARCHAR", 25, 0, false ) )
            {
                throw new Exception( "El campo UbigeoDestino ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUbigeoDestino( $s_UbigeoDestino );
        return true;
    }

    /* Valida y establece el valor del campo IdVehiculo */
    public function setIdVehiculo( $i_IdVehiculo, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdVehiculo, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdVehiculo ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdVehiculo( $i_IdVehiculo );
        return true;
    }

    /* Valida y establece el valor del campo IdChofer */
    public function setIdChofer( $i_IdChofer, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdChofer, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdChofer ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdChofer( $i_IdChofer );
        return true;
    }

    /* Valida y establece el valor del campo MotivoTrasladoId */
    public function setMotivoTrasladoId( $s_MotivoTrasladoId, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_MotivoTrasladoId, "VARCHAR", 10, 0, false ) )
            {
                throw new Exception( "El campo MotivoTrasladoId ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setMotivoTrasladoId( $s_MotivoTrasladoId );
        return true;
    }

    /* Valida y establece el valor del campo ModalidadTransporteId */
    public function setModalidadTransporteId( $s_ModalidadTransporteId, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ModalidadTransporteId, "VARCHAR", 10, 0, false ) )
            {
                throw new Exception( "El campo ModalidadTransporteId ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setModalidadTransporteId( $s_ModalidadTransporteId );
        return true;
    }

    /* Valida y establece el valor del campo PesoTotal */
    public function setPesoTotal( $f_PesoTotal, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_PesoTotal, "DECIMAL", 10, 2, false ) )
            {
                throw new Exception( "El campo PesoTotal ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setPesoTotal( $f_PesoTotal );
        return true;
    }

    /* Valida y establece el valor del campo NumeroBultos */
    public function setNumeroBultos( $i_NumeroBultos, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_NumeroBultos, "TINYINT", 4, 0, false ) )
            {
                throw new Exception( "El campo NumeroBultos ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setNumeroBultos( $i_NumeroBultos );
        return true;
    }

    /* Valida y establece el valor del campo ConductorDocumentoTipo */
    public function setConductorDocumentoTipo( $i_ConductorDocumentoTipo, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_ConductorDocumentoTipo, "TINYINT", 4, 0, false ) )
            {
                throw new Exception( "El campo ConductorDocumentoTipo ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setConductorDocumentoTipo( $i_ConductorDocumentoTipo );
        return true;
    }

    /* Valida y establece el valor del campo ConductorDocumentoNumero */
    public function setConductorDocumentoNumero( $s_ConductorDocumentoNumero, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ConductorDocumentoNumero, "VARCHAR", 50, 0, false ) )
            {
                throw new Exception( "El campo ConductorDocumentoNumero ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setConductorDocumentoNumero( $s_ConductorDocumentoNumero );
        return true;
    }

    /* Valida y establece el valor del campo ConductorDenominacion */
    public function setConductorDenominacion( $s_ConductorDenominacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ConductorDenominacion, "VARCHAR", 500, 0, false ) )
            {
                throw new Exception( "El campo ConductorDenominacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setConductorDenominacion( $s_ConductorDenominacion );
        return true;
    }

    /* Valida y establece el valor del campo ConductorNombre */
    public function setConductorNombre( $s_ConductorNombre, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ConductorNombre, "VARCHAR", 250, 0, false ) )
            {
                throw new Exception( "El campo ConductorNombre ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setConductorNombre( $s_ConductorNombre );
        return true;
    }

    /* Valida y establece el valor del campo ConductorApellido */
    public function setConductorApellido( $s_ConductorApellido, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ConductorApellido, "VARCHAR", 250, 0, false ) )
            {
                throw new Exception( "El campo ConductorApellido ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setConductorApellido( $s_ConductorApellido );
        return true;
    }

    /* Valida y establece el valor del campo ConductorNumeroLicencia */
    public function setConductorNumeroLicencia( $s_ConductorNumeroLicencia, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ConductorNumeroLicencia, "VARCHAR", 50, 0, false ) )
            {
                throw new Exception( "El campo ConductorNumeroLicencia ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setConductorNumeroLicencia( $s_ConductorNumeroLicencia );
        return true;
    }

    /* Valida y establece el valor del campo TransportistaDocumentoTipo */
    public function setTransportistaDocumentoTipo( $i_TransportistaDocumentoTipo, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_TransportistaDocumentoTipo, "TINYINT", 4, 0, false ) )
            {
                throw new Exception( "El campo TransportistaDocumentoTipo ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setTransportistaDocumentoTipo( $i_TransportistaDocumentoTipo );
        return true;
    }

    /* Valida y establece el valor del campo TransportistaDocumentoNumero */
    public function setTransportistaDocumentoNumero( $s_TransportistaDocumentoNumero, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_TransportistaDocumentoNumero, "VARCHAR", 50, 0, false ) )
            {
                throw new Exception( "El campo TransportistaDocumentoNumero ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setTransportistaDocumentoNumero( $s_TransportistaDocumentoNumero );
        return true;
    }

    /* Valida y establece el valor del campo TransportistaDenominacion */
    public function setTransportistaDenominacion( $s_TransportistaDenominacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_TransportistaDenominacion, "VARCHAR", 500, 0, false ) )
            {
                throw new Exception( "El campo TransportistaDenominacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setTransportistaDenominacion( $s_TransportistaDenominacion );
        return true;
    }

    /* Valida y establece el valor del campo TransportistaPlacaNumero */
    public function setTransportistaPlacaNumero( $s_TransportistaPlacaNumero, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_TransportistaPlacaNumero, "VARCHAR", 50, 0, false ) )
            {
                throw new Exception( "El campo TransportistaPlacaNumero ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setTransportistaPlacaNumero( $s_TransportistaPlacaNumero );
        return true;
    }

    /* Valida y establece el valor del campo Comentario */
    public function setComentario( $s_Comentario, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Comentario, "VARCHAR", 1000, 0, false ) )
            {
                throw new Exception( "El campo Comentario ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setComentario( $s_Comentario );
        return true;
    }

    /* Valida y establece el valor del campo IdTipoDocumento */
    public function setIdTipoDocumento( $s_IdTipoDocumento, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdTipoDocumento, "VARCHAR", 5, 0, false ) )
            {
                throw new Exception( "El campo IdTipoDocumento ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdTipoDocumento( $s_IdTipoDocumento );
        return true;
    }

    /* Valida y establece el valor del campo IdNumeroDocumento */
    public function setIdNumeroDocumento( $s_IdNumeroDocumento, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdNumeroDocumento, "VARCHAR", 10, 0, false ) )
            {
                throw new Exception( "El campo IdNumeroDocumento ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdNumeroDocumento( $s_IdNumeroDocumento );
        return true;
    }

    /* Valida y establece el valor del campo IdTransaccion */
    public function setIdTransaccion( $s_IdTransaccion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdTransaccion, "VARCHAR", 5, 0, false ) )
            {
                throw new Exception( "El campo IdTransaccion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdTransaccion( $s_IdTransaccion );
        return true;
    }

    /* Valida y establece el valor del campo MensajeException */
    public function setMensajeException( $s_MensajeException, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_MensajeException, "VARCHAR", 1000, 0, false ) )
            {
                throw new Exception( "El campo MensajeException ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setMensajeException( $s_MensajeException );
        return true;
    }

    /* Valida y establece el valor del campo Estado */
    public function setEstado( $s_Estado, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Estado, "VARCHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo Estado ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setEstado( $s_Estado );
        return true;
    }

    /* Valida y establece el valor del campo EstadoDevolucion */
    public function setEstadoDevolucion( $s_EstadoDevolucion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_EstadoDevolucion, "VARCHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo EstadoDevolucion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setEstadoDevolucion( $s_EstadoDevolucion );
        return true;
    }

    /* Valida y establece el valor del campo EstadoSunat */
    public function setEstadoSunat( $s_EstadoSunat, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_EstadoSunat, "VARCHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo EstadoSunat ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setEstadoSunat( $s_EstadoSunat );
        return true;
    }

    /* Valida y establece el valor del campo TipoDeComprobante */
    public function setTipoDeComprobante( $i_TipoDeComprobante, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_TipoDeComprobante, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo TipoDeComprobante ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setTipoDeComprobante( $i_TipoDeComprobante );
        return true;
    }

    /* Valida y establece el valor del campo Enlace */
    public function setEnlace( $s_Enlace, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Enlace, "VARCHAR", 250, 0, false ) )
            {
                throw new Exception( "El campo Enlace ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setEnlace( $s_Enlace );
        return true;
    }

    /* Valida y establece el valor del campo AceptadaPorSunat */
    public function setAceptadaPorSunat( $s_AceptadaPorSunat, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_AceptadaPorSunat, "VARCHAR", 2, 0, false ) )
            {
                throw new Exception( "El campo AceptadaPorSunat ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setAceptadaPorSunat( $s_AceptadaPorSunat );
        return true;
    }

    /* Valida y establece el valor del campo SunatDescription */
    public function setSunatDescription( $s_SunatDescription, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_SunatDescription, "VARCHAR", 250, 0, false ) )
            {
                throw new Exception( "El campo SunatDescription ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setSunatDescription( $s_SunatDescription );
        return true;
    }

    /* Valida y establece el valor del campo SunatNote */
    public function setSunatNote( $s_SunatNote, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_SunatNote, "VARCHAR", 250, 0, false ) )
            {
                throw new Exception( "El campo SunatNote ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setSunatNote( $s_SunatNote );
        return true;
    }

    /* Valida y establece el valor del campo SunatResponsecode */
    public function setSunatResponsecode( $s_SunatResponsecode, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_SunatResponsecode, "VARCHAR", 1000, 0, false ) )
            {
                throw new Exception( "El campo SunatResponsecode ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setSunatResponsecode( $s_SunatResponsecode );
        return true;
    }

    /* Valida y establece el valor del campo SunatSoapError */
    public function setSunatSoapError( $s_SunatSoapError, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_SunatSoapError, "VARCHAR", 250, 0, false ) )
            {
                throw new Exception( "El campo SunatSoapError ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setSunatSoapError( $s_SunatSoapError );
        return true;
    }

    /* Valida y establece el valor del campo PdfZipBase64 */
    public function setPdfZipBase64( $s_PdfZipBase64, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_PdfZipBase64, "VARCHAR", 250, 0, false ) )
            {
                throw new Exception( "El campo PdfZipBase64 ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setPdfZipBase64( $s_PdfZipBase64 );
        return true;
    }

    /* Valida y establece el valor del campo XmlZipBase64 */
    public function setXmlZipBase64( $s_XmlZipBase64, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_XmlZipBase64, "VARCHAR", 250, 0, false ) )
            {
                throw new Exception( "El campo XmlZipBase64 ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setXmlZipBase64( $s_XmlZipBase64 );
        return true;
    }

    /* Valida y establece el valor del campo CdrZipBase64 */
    public function setCdrZipBase64( $s_CdrZipBase64, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_CdrZipBase64, "VARCHAR", 250, 0, false ) )
            {
                throw new Exception( "El campo CdrZipBase64 ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setCdrZipBase64( $s_CdrZipBase64 );
        return true;
    }

    /* Valida y establece el valor del campo EnlaceDelPdf */
    public function setEnlaceDelPdf( $s_EnlaceDelPdf, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_EnlaceDelPdf, "VARCHAR", 250, 0, false ) )
            {
                throw new Exception( "El campo EnlaceDelPdf ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setEnlaceDelPdf( $s_EnlaceDelPdf );
        return true;
    }

    /* Valida y establece el valor del campo EnlaceDelXml */
    public function setEnlaceDelXml( $s_EnlaceDelXml, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_EnlaceDelXml, "VARCHAR", 250, 0, false ) )
            {
                throw new Exception( "El campo EnlaceDelXml ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setEnlaceDelXml( $s_EnlaceDelXml );
        return true;
    }

    /* Valida y establece el valor del campo EnlaceDelCdr */
    public function setEnlaceDelCdr( $s_EnlaceDelCdr, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_EnlaceDelCdr, "VARCHAR", 250, 0, false ) )
            {
                throw new Exception( "El campo EnlaceDelCdr ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setEnlaceDelCdr( $s_EnlaceDelCdr );
        return true;
    }

    /* Valida y establece el valor del campo ErrorsResponse */
    public function setErrorsResponse( $u_ErrorsResponse, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $u_ErrorsResponse, "TEXT", 0, 0, false ) )
            {
                throw new Exception( "El campo ErrorsResponse ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setErrorsResponse( $u_ErrorsResponse );
        return true;
    }

    /* Valida y establece el valor del campo ErrorsCodigo */
    public function setErrorsCodigo( $s_ErrorsCodigo, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ErrorsCodigo, "VARCHAR", 10, 0, false ) )
            {
                throw new Exception( "El campo ErrorsCodigo ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setErrorsCodigo( $s_ErrorsCodigo );
        return true;
    }

    /* Valida y establece el valor del campo NotaImportante */
    public function setNotaImportante( $s_NotaImportante, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_NotaImportante, "VARCHAR", 1000, 0, false ) )
            {
                throw new Exception( "El campo NotaImportante ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setNotaImportante( $s_NotaImportante );
        return true;
    }

    /* Valida y establece el valor del campo DataJson */
    public function setDataJson( $u_DataJson, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $u_DataJson, "MEDIUMTEXT", 0, 0, false ) )
            {
                throw new Exception( "El campo DataJson ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDataJson( $u_DataJson );
        return true;
    }

    /* Valida y establece el valor del campo FechaRegistro */
    public function setFechaRegistro( $d_FechaRegistro, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaRegistro, "DATETIME", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaRegistro ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaRegistro( $d_FechaRegistro );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioRegistro */
    public function setUsuarioRegistro( $s_UsuarioRegistro, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioRegistro, "VARCHAR", 25, 0, false ) )
            {
                throw new Exception( "El campo UsuarioRegistro ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioRegistro( $s_UsuarioRegistro );
        return true;
    }

    /* Valida y establece el valor del campo FechaModificacion */
    public function setFechaModificacion( $d_FechaModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaModificacion, "TIMESTAMP", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaModificacion( $d_FechaModificacion );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioModificacion */
    public function setUsuarioModificacion( $s_UsuarioModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioModificacion, "VARCHAR", 25, 0, false ) )
            {
                throw new Exception( "El campo UsuarioModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioModificacion( $s_UsuarioModificacion );
        return true;
    }

    /* Valida el contenido del registro */
    public function validateRecord()
    {
        $this->setGuiaRemisionId( $this->getGuiaRemisionId(), false );
        $this->setIdCompania( $this->getIdCompania(), true );
        $this->setIdSucursal( $this->getIdSucursal(), true );
        $this->setTipoGuia( $this->getTipoGuia(), true );
        $this->setGuiaSerie( $this->getGuiaSerie(), true );
        $this->setGuiaNumero( $this->getGuiaNumero(), true );
        $this->setGuiaFecha( $this->getGuiaFecha(), true );
        $this->setFechaIniTraslado( $this->getFechaIniTraslado(), true );
        $this->setIdProyecto( $this->getIdProyecto(), true );
        $this->setOrdenTipoComercialId( $this->getOrdenTipoComercialId(), true );
        $this->setReferenciaParentId( $this->getReferenciaParentId(), true );
        $this->setReferenciaParentNum( $this->getReferenciaParentNum(), true );
        $this->setReferenciaIdTipoDocumento( $this->getReferenciaIdTipoDocumento(), true );
        $this->setReferenciaTipo( $this->getReferenciaTipo(), true );
        $this->setReferenciaNumero( $this->getReferenciaNumero(), true );
        $this->setReferenciaNumeroDocumento( $this->getReferenciaNumeroDocumento(), true );
        $this->setMovimientoId( $this->getMovimientoId(), true );
        $this->setMovimientoDetId( $this->getMovimientoDetId(), true );
        $this->setFechaInicioAlq( $this->getFechaInicioAlq(), true );
        $this->setFechaFinAlq( $this->getFechaFinAlq(), true );
        $this->setEmpresaTipoDoc( $this->getEmpresaTipoDoc(), true );
        $this->setEmpresaNumDoc( $this->getEmpresaNumDoc(), true );
        $this->setEmpresaInfoAdicional( $this->getEmpresaInfoAdicional(), true );
        $this->setEmpresaDireccion( $this->getEmpresaDireccion(), true );
        $this->setClienteNombre( $this->getClienteNombre(), true );
        $this->setClienteTipoDocumento( $this->getClienteTipoDocumento(), true );
        $this->setClienteNumDocumento( $this->getClienteNumDocumento(), true );
        $this->setDepartamentoOrigen( $this->getDepartamentoOrigen(), true );
        $this->setProvinciaOrigen( $this->getProvinciaOrigen(), true );
        $this->setDistritoOrigen( $this->getDistritoOrigen(), true );
        $this->setDireccionOrigen( $this->getDireccionOrigen(), true );
        $this->setUbigeoOrigen( $this->getUbigeoOrigen(), true );
        $this->setDepartamentoDestino( $this->getDepartamentoDestino(), true );
        $this->setProvinciaDestino( $this->getProvinciaDestino(), true );
        $this->setDistritoDestino( $this->getDistritoDestino(), true );
        $this->setDireccionDestino( $this->getDireccionDestino(), true );
        $this->setUbigeoDestino( $this->getUbigeoDestino(), true );
        $this->setIdVehiculo( $this->getIdVehiculo(), true );
        $this->setIdChofer( $this->getIdChofer(), true );
        $this->setMotivoTrasladoId( $this->getMotivoTrasladoId(), true );
        $this->setModalidadTransporteId( $this->getModalidadTransporteId(), true );
        $this->setPesoTotal( $this->getPesoTotal(), true );
        $this->setNumeroBultos( $this->getNumeroBultos(), true );
        $this->setConductorDocumentoTipo( $this->getConductorDocumentoTipo(), true );
        $this->setConductorDocumentoNumero( $this->getConductorDocumentoNumero(), true );
        $this->setConductorDenominacion( $this->getConductorDenominacion(), true );
        $this->setConductorNombre( $this->getConductorNombre(), true );
        $this->setConductorApellido( $this->getConductorApellido(), true );
        $this->setConductorNumeroLicencia( $this->getConductorNumeroLicencia(), true );
        $this->setTransportistaDocumentoTipo( $this->getTransportistaDocumentoTipo(), true );
        $this->setTransportistaDocumentoNumero( $this->getTransportistaDocumentoNumero(), true );
        $this->setTransportistaDenominacion( $this->getTransportistaDenominacion(), true );
        $this->setTransportistaPlacaNumero( $this->getTransportistaPlacaNumero(), true );
        $this->setComentario( $this->getComentario(), true );
        $this->setIdTipoDocumento( $this->getIdTipoDocumento(), true );
        $this->setIdNumeroDocumento( $this->getIdNumeroDocumento(), true );
        $this->setIdTransaccion( $this->getIdTransaccion(), true );
        $this->setMensajeException( $this->getMensajeException(), true );
        $this->setEstado( $this->getEstado(), true );
        $this->setEstadoDevolucion( $this->getEstadoDevolucion(), true );
        $this->setEstadoSunat( $this->getEstadoSunat(), true );
        $this->setTipoDeComprobante( $this->getTipoDeComprobante(), true );
        $this->setEnlace( $this->getEnlace(), true );
        $this->setAceptadaPorSunat( $this->getAceptadaPorSunat(), true );
        $this->setSunatDescription( $this->getSunatDescription(), true );
        $this->setSunatNote( $this->getSunatNote(), true );
        $this->setSunatResponsecode( $this->getSunatResponsecode(), true );
        $this->setSunatSoapError( $this->getSunatSoapError(), true );
        $this->setPdfZipBase64( $this->getPdfZipBase64(), true );
        $this->setXmlZipBase64( $this->getXmlZipBase64(), true );
        $this->setCdrZipBase64( $this->getCdrZipBase64(), true );
        $this->setEnlaceDelPdf( $this->getEnlaceDelPdf(), true );
        $this->setEnlaceDelXml( $this->getEnlaceDelXml(), true );
        $this->setEnlaceDelCdr( $this->getEnlaceDelCdr(), true );
        $this->setErrorsResponse( $this->getErrorsResponse(), true );
        $this->setErrorsCodigo( $this->getErrorsCodigo(), true );
        $this->setNotaImportante( $this->getNotaImportante(), true );
        $this->setDataJson( $this->getDataJson(), true );
        $this->setFechaRegistro( $this->getFechaRegistro(), true );
        $this->setUsuarioRegistro( $this->getUsuarioRegistro(), true );
        $this->setFechaModificacion( $this->getFechaModificacion(), true );
        $this->setUsuarioModificacion( $this->getUsuarioModificacion(), true );
        return true;
    }
}
?>