<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: SR_EstadoDevolucion.xml */
/* Generado: 2021-06-26 01:39:41 */

/* Validacion del contenido de los campos campos de la tabla SR_EstadoDevolucion */
abstract class BaseSR_EstadoDevolucionBV extends SR_EstadoDevolucionBN
{
    /* Contiene la clase que valida el tipo de dato */
    private $o_Validator; // Contiene el objeto que realizara la validacion de tipo de dato.
    private $s_ValidatorMessage; // Contiene la ultima observacion de la validacion del tipo de dato.

    /* Constructor ( Establece la clase que valida los tipos de datos y establece los valores por defecto ) */
    public function __construct()
    {
        /* Establecemos el objeto que realizara la validacion del tipo de dato */
        $this->o_Validator = new utilValidDataType();

        /* Establecemos los valores por defecto */
    }

    /* Valida en tipo de dato */
    private function validateData( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull )
    {
        $this->s_ValidatorMessage = null;
        if( !$this->o_Validator->validate( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull ) )
        {
            $this->s_ValidatorMessage = $this->o_Validator->getMessage();
        }
        return is_null( $this->s_ValidatorMessage );
    }

    /* Valida y establece el valor del campo EstadoDevolucionId */
    public function setEstadoDevolucionId( $s_EstadoDevolucionId, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_EstadoDevolucionId, "VARCHAR", 2, 0, false ) )
            {
                throw new Exception( "El campo EstadoDevolucionId ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setEstadoDevolucionId( $s_EstadoDevolucionId );
        return true;
    }

    /* Valida y establece el valor del campo Descripcion */
    public function setDescripcion( $s_Descripcion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Descripcion, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo Descripcion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDescripcion( $s_Descripcion );
        return true;
    }

    /* Valida y establece el valor del campo FlagCobroExtra */
    public function setFlagCobroExtra( $s_FlagCobroExtra, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_FlagCobroExtra, "VARCHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo FlagCobroExtra ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFlagCobroExtra( $s_FlagCobroExtra );
        return true;
    }

    /* Valida y establece el valor del campo FlagSalida */
    public function setFlagSalida( $s_FlagSalida, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_FlagSalida, "VARCHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo FlagSalida ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFlagSalida( $s_FlagSalida );
        return true;
    }

    /* Valida y establece el valor del campo FlagEntrada */
    public function setFlagEntrada( $s_FlagEntrada, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_FlagEntrada, "VARCHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo FlagEntrada ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFlagEntrada( $s_FlagEntrada );
        return true;
    }

    /* Valida y establece el valor del campo FlagVentaServicio */
    public function setFlagVentaServicio( $s_FlagVentaServicio, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_FlagVentaServicio, "VARCHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo FlagVentaServicio ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFlagVentaServicio( $s_FlagVentaServicio );
        return true;
    }

    /* Valida y establece el valor del campo FlagVentaProducto */
    public function setFlagVentaProducto( $s_FlagVentaProducto, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_FlagVentaProducto, "VARCHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo FlagVentaProducto ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFlagVentaProducto( $s_FlagVentaProducto );
        return true;
    }

    /* Valida y establece el valor del campo Color */
    public function setColor( $s_Color, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Color, "VARCHAR", 7, 0, false ) )
            {
                throw new Exception( "El campo Color ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setColor( $s_Color );
        return true;
    }

    /* Valida y establece el valor del campo IdAlmacen */
    public function setIdAlmacen( $s_IdAlmacen, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdAlmacen, "VARCHAR", 10, 0, false ) )
            {
                throw new Exception( "El campo IdAlmacen ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdAlmacen( $s_IdAlmacen );
        return true;
    }

    /* Valida y establece el valor del campo IdItemServicio */
    public function setIdItemServicio( $s_IdItemServicio, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdItemServicio, "VARCHAR", 25, 0, false ) )
            {
                throw new Exception( "El campo IdItemServicio ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdItemServicio( $s_IdItemServicio );
        return true;
    }

    /* Valida y establece el valor del campo FechaCreacion */
    public function setFechaCreacion( $d_FechaCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaCreacion, "DATETIME", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaCreacion( $d_FechaCreacion );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioCreacion */
    public function setUsuarioCreacion( $s_UsuarioCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioCreacion, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo UsuarioCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioCreacion( $s_UsuarioCreacion );
        return true;
    }

    /* Valida y establece el valor del campo FechaModificacion */
    public function setFechaModificacion( $d_FechaModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaModificacion, "DATETIME", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaModificacion( $d_FechaModificacion );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioModificacion */
    public function setUsuarioModificacion( $s_UsuarioModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioModificacion, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo UsuarioModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioModificacion( $s_UsuarioModificacion );
        return true;
    }

    /* Valida el contenido del registro */
    public function validateRecord()
    {
        $this->setEstadoDevolucionId( $this->getEstadoDevolucionId(), false );
        $this->setDescripcion( $this->getDescripcion(), true );
        $this->setFlagCobroExtra( $this->getFlagCobroExtra(), true );
        $this->setFlagSalida( $this->getFlagSalida(), true );
        $this->setFlagEntrada( $this->getFlagEntrada(), true );
        $this->setFlagVentaServicio( $this->getFlagVentaServicio(), true );
        $this->setFlagVentaProducto( $this->getFlagVentaProducto(), true );
        $this->setColor( $this->getColor(), true );
        $this->setIdAlmacen( $this->getIdAlmacen(), true );
        $this->setIdItemServicio( $this->getIdItemServicio(), true );
        $this->setFechaCreacion( $this->getFechaCreacion(), true );
        $this->setUsuarioCreacion( $this->getUsuarioCreacion(), true );
        $this->setFechaModificacion( $this->getFechaModificacion(), true );
        $this->setUsuarioModificacion( $this->getUsuarioModificacion(), true );
        return true;
    }
}
?>