<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: SR_DevolucionFacturacion.xml */
/* Generado: 2021-07-04 00:45:36 */

/* Validacion del contenido de los campos campos de la tabla SR_DevolucionFacturacion */
abstract class BaseSR_DevolucionFacturacionBV extends SR_DevolucionFacturacionBN
{
    /* Contiene la clase que valida el tipo de dato */
    private $o_Validator; // Contiene el objeto que realizara la validacion de tipo de dato.
    private $s_ValidatorMessage; // Contiene la ultima observacion de la validacion del tipo de dato.

    /* Constructor ( Establece la clase que valida los tipos de datos y establece los valores por defecto ) */
    public function __construct()
    {
        /* Establecemos el objeto que realizara la validacion del tipo de dato */
        $this->o_Validator = new utilValidDataType();

        /* Establecemos los valores por defecto */
    }

    /* Valida en tipo de dato */
    private function validateData( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull )
    {
        $this->s_ValidatorMessage = null;
        if( !$this->o_Validator->validate( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull ) )
        {
            $this->s_ValidatorMessage = $this->o_Validator->getMessage();
        }
        return is_null( $this->s_ValidatorMessage );
    }

    /* Valida y establece el valor del campo DevolFactId */
    public function setDevolFactId( $i_DevolFactId, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_DevolFactId, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo DevolFactId ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDevolFactId( $i_DevolFactId );
        return true;
    }

    /* Valida y establece el valor del campo IdCompania */
    public function setIdCompania( $i_IdCompania, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdCompania, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdCompania ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdCompania( $i_IdCompania );
        return true;
    }

    /* Valida y establece el valor del campo IdSucursal */
    public function setIdSucursal( $i_IdSucursal, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdSucursal, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdSucursal ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdSucursal( $i_IdSucursal );
        return true;
    }

    /* Valida y establece el valor del campo IdProyecto */
    public function setIdProyecto( $i_IdProyecto, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdProyecto, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdProyecto ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdProyecto( $i_IdProyecto );
        return true;
    }

    /* Valida y establece el valor del campo IdPersona */
    public function setIdPersona( $i_IdPersona, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdPersona, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdPersona ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdPersona( $i_IdPersona );
        return true;
    }

    /* Valida y establece el valor del campo GrupoId */
    public function setGrupoId( $s_GrupoId, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_GrupoId, "VARCHAR", 20, 0, false ) )
            {
                throw new Exception( "El campo GrupoId ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setGrupoId( $s_GrupoId );
        return true;
    }

    /* Valida y establece el valor del campo TipoEstado */
    public function setTipoEstado( $s_TipoEstado, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_TipoEstado, "VARCHAR", 15, 0, false ) )
            {
                throw new Exception( "El campo TipoEstado ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setTipoEstado( $s_TipoEstado );
        return true;
    }

    /* Valida y establece el valor del campo EstadoDesc */
    public function setEstadoDesc( $s_EstadoDesc, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_EstadoDesc, "VARCHAR", 15, 0, false ) )
            {
                throw new Exception( "El campo EstadoDesc ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setEstadoDesc( $s_EstadoDesc );
        return true;
    }

    /* Valida y establece el valor del campo IdItem */
    public function setIdItem( $s_IdItem, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdItem, "VARCHAR", 25, 0, false ) )
            {
                throw new Exception( "El campo IdItem ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdItem( $s_IdItem );
        return true;
    }

    /* Valida y establece el valor del campo DescripcionItem */
    public function setDescripcionItem( $s_DescripcionItem, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_DescripcionItem, "VARCHAR", 255, 0, false ) )
            {
                throw new Exception( "El campo DescripcionItem ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDescripcionItem( $s_DescripcionItem );
        return true;
    }

    /* Valida y establece el valor del campo FechaCorte */
    public function setFechaCorte( $d_FechaCorte, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaCorte, "DATE", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaCorte ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaCorte( $d_FechaCorte );
        return true;
    }

    /* Valida y establece el valor del campo SubTotal */
    public function setSubTotal( $f_SubTotal, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_SubTotal, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo SubTotal ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setSubTotal( $f_SubTotal );
        return true;
    }

    /* Valida y establece el valor del campo MontoIGV */
    public function setMontoIGV( $f_MontoIGV, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_MontoIGV, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo MontoIGV ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setMontoIGV( $f_MontoIGV );
        return true;
    }

    /* Valida y establece el valor del campo MontoTotal */
    public function setMontoTotal( $f_MontoTotal, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_MontoTotal, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo MontoTotal ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setMontoTotal( $f_MontoTotal );
        return true;
    }

    /* Valida y establece el valor del campo Estado */
    public function setEstado( $s_Estado, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Estado, "VARCHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo Estado ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setEstado( $s_Estado );
        return true;
    }

    /* Valida y establece el valor del campo IdTipoDocumento */
    public function setIdTipoDocumento( $s_IdTipoDocumento, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdTipoDocumento, "VARCHAR", 5, 0, false ) )
            {
                throw new Exception( "El campo IdTipoDocumento ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdTipoDocumento( $s_IdTipoDocumento );
        return true;
    }

    /* Valida y establece el valor del campo NumeroDocumento */
    public function setNumeroDocumento( $s_NumeroDocumento, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_NumeroDocumento, "VARCHAR", 10, 0, false ) )
            {
                throw new Exception( "El campo NumeroDocumento ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setNumeroDocumento( $s_NumeroDocumento );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioCreacion */
    public function setUsuarioCreacion( $s_UsuarioCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioCreacion, "VARCHAR", 25, 0, false ) )
            {
                throw new Exception( "El campo UsuarioCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioCreacion( $s_UsuarioCreacion );
        return true;
    }

    /* Valida y establece el valor del campo FechaCreacion */
    public function setFechaCreacion( $d_FechaCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaCreacion, "TIMESTAMP", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaCreacion( $d_FechaCreacion );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioModificacion */
    public function setUsuarioModificacion( $s_UsuarioModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioModificacion, "VARCHAR", 25, 0, false ) )
            {
                throw new Exception( "El campo UsuarioModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioModificacion( $s_UsuarioModificacion );
        return true;
    }

    /* Valida y establece el valor del campo FechaModificacion */
    public function setFechaModificacion( $d_FechaModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaModificacion, "TIMESTAMP", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaModificacion( $d_FechaModificacion );
        return true;
    }

    /* Valida el contenido del registro */
    public function validateRecord()
    {
        $this->setDevolFactId( $this->getDevolFactId(), false );
        $this->setIdCompania( $this->getIdCompania(), true );
        $this->setIdSucursal( $this->getIdSucursal(), true );
        $this->setIdProyecto( $this->getIdProyecto(), true );
        $this->setIdPersona( $this->getIdPersona(), true );
        $this->setGrupoId( $this->getGrupoId(), true );
        $this->setTipoEstado( $this->getTipoEstado(), true );
        $this->setEstadoDesc( $this->getEstadoDesc(), true );
        $this->setIdItem( $this->getIdItem(), true );
        $this->setDescripcionItem( $this->getDescripcionItem(), true );
        $this->setFechaCorte( $this->getFechaCorte(), true );
        $this->setSubTotal( $this->getSubTotal(), true );
        $this->setMontoIGV( $this->getMontoIGV(), true );
        $this->setMontoTotal( $this->getMontoTotal(), true );
        $this->setEstado( $this->getEstado(), true );
        $this->setIdTipoDocumento( $this->getIdTipoDocumento(), true );
        $this->setNumeroDocumento( $this->getNumeroDocumento(), true );
        $this->setUsuarioCreacion( $this->getUsuarioCreacion(), true );
        $this->setFechaCreacion( $this->getFechaCreacion(), true );
        $this->setUsuarioModificacion( $this->getUsuarioModificacion(), true );
        $this->setFechaModificacion( $this->getFechaModificacion(), true );
        return true;
    }
}
?>