<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: SR_DevolucionDetalle.xml */
/* Generado: 2021-07-06 18:57:55 */

/* Validacion del contenido de los campos campos de la tabla SR_DevolucionDetalle */
abstract class BaseSR_DevolucionDetalleBV extends SR_DevolucionDetalleBN
{
    /* Contiene la clase que valida el tipo de dato */
    private $o_Validator; // Contiene el objeto que realizara la validacion de tipo de dato.
    private $s_ValidatorMessage; // Contiene la ultima observacion de la validacion del tipo de dato.

    /* Constructor ( Establece la clase que valida los tipos de datos y establece los valores por defecto ) */
    public function __construct()
    {
        /* Establecemos el objeto que realizara la validacion del tipo de dato */
        $this->o_Validator = new utilValidDataType();

        /* Establecemos los valores por defecto */
    }

    /* Valida en tipo de dato */
    private function validateData( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull )
    {
        $this->s_ValidatorMessage = null;
        if( !$this->o_Validator->validate( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull ) )
        {
            $this->s_ValidatorMessage = $this->o_Validator->getMessage();
        }
        return is_null( $this->s_ValidatorMessage );
    }

    /* Valida y establece el valor del campo DevolucionDetId */
    public function setDevolucionDetId( $i_DevolucionDetId, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_DevolucionDetId, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo DevolucionDetId ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDevolucionDetId( $i_DevolucionDetId );
        return true;
    }

    /* Valida y establece el valor del campo DevolucionCabId */
    public function setDevolucionCabId( $i_DevolucionCabId, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_DevolucionCabId, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo DevolucionCabId ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDevolucionCabId( $i_DevolucionCabId );
        return true;
    }

    /* Valida y establece el valor del campo EstadoDevolucionId */
    public function setEstadoDevolucionId( $s_EstadoDevolucionId, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_EstadoDevolucionId, "VARCHAR", 2, 0, false ) )
            {
                throw new Exception( "El campo EstadoDevolucionId ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setEstadoDevolucionId( $s_EstadoDevolucionId );
        return true;
    }

    /* Valida y establece el valor del campo IdItem */
    public function setIdItem( $s_IdItem, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdItem, "VARCHAR", 20, 0, false ) )
            {
                throw new Exception( "El campo IdItem ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdItem( $s_IdItem );
        return true;
    }

    /* Valida y establece el valor del campo ItemDescripcion */
    public function setItemDescripcion( $s_ItemDescripcion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ItemDescripcion, "VARCHAR", 140, 0, false ) )
            {
                throw new Exception( "El campo ItemDescripcion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setItemDescripcion( $s_ItemDescripcion );
        return true;
    }

    /* Valida y establece el valor del campo CantidadDevolucion */
    public function setCantidadDevolucion( $f_CantidadDevolucion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_CantidadDevolucion, "DECIMAL", 10, 2, false ) )
            {
                throw new Exception( "El campo CantidadDevolucion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setCantidadDevolucion( $f_CantidadDevolucion );
        return true;
    }

    /* Valida y establece el valor del campo ComentarioDevolucion */
    public function setComentarioDevolucion( $s_ComentarioDevolucion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ComentarioDevolucion, "VARCHAR", 250, 0, false ) )
            {
                throw new Exception( "El campo ComentarioDevolucion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setComentarioDevolucion( $s_ComentarioDevolucion );
        return true;
    }

    /* Valida y establece el valor del campo TipoComentDevolucion */
    public function setTipoComentDevolucion( $s_TipoComentDevolucion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_TipoComentDevolucion, "VARCHAR", 15, 0, false ) )
            {
                throw new Exception( "El campo TipoComentDevolucion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setTipoComentDevolucion( $s_TipoComentDevolucion );
        return true;
    }

    /* Valida y establece el valor del campo EstadoFacturacion */
    public function setEstadoFacturacion( $s_EstadoFacturacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_EstadoFacturacion, "VARCHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo EstadoFacturacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setEstadoFacturacion( $s_EstadoFacturacion );
        return true;
    }

    /* Valida y establece el valor del campo DevolFactId */
    public function setDevolFactId( $i_DevolFactId, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_DevolFactId, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo DevolFactId ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDevolFactId( $i_DevolFactId );
        return true;
    }

    /* Valida y establece el valor del campo PrecioUnitVentaDevolucion */
    public function setPrecioUnitVentaDevolucion( $f_PrecioUnitVentaDevolucion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_PrecioUnitVentaDevolucion, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo PrecioUnitVentaDevolucion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setPrecioUnitVentaDevolucion( $f_PrecioUnitVentaDevolucion );
        return true;
    }

    /* Valida y establece el valor del campo FechaCreacion */
    public function setFechaCreacion( $d_FechaCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaCreacion, "DATETIME", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaCreacion( $d_FechaCreacion );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioCreacion */
    public function setUsuarioCreacion( $s_UsuarioCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioCreacion, "VARCHAR", 50, 0, false ) )
            {
                throw new Exception( "El campo UsuarioCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioCreacion( $s_UsuarioCreacion );
        return true;
    }

    /* Valida el contenido del registro */
    public function validateRecord()
    {
        $this->setDevolucionDetId( $this->getDevolucionDetId(), false );
        $this->setDevolucionCabId( $this->getDevolucionCabId(), true );
        $this->setEstadoDevolucionId( $this->getEstadoDevolucionId(), true );
        $this->setIdItem( $this->getIdItem(), true );
        $this->setItemDescripcion( $this->getItemDescripcion(), true );
        $this->setCantidadDevolucion( $this->getCantidadDevolucion(), true );
        $this->setComentarioDevolucion( $this->getComentarioDevolucion(), true );
        $this->setTipoComentDevolucion( $this->getTipoComentDevolucion(), true );
        $this->setEstadoFacturacion( $this->getEstadoFacturacion(), true );
        $this->setDevolFactId( $this->getDevolFactId(), true );
        $this->setPrecioUnitVentaDevolucion( $this->getPrecioUnitVentaDevolucion(), true );
        $this->setFechaCreacion( $this->getFechaCreacion(), true );
        $this->setUsuarioCreacion( $this->getUsuarioCreacion(), true );
        return true;
    }
}
?>