<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: SRV_UbicacionClienteDet.xml */
/* Generado: 2020-08-18 04:21:30 */

/* Validacion del contenido de los campos campos de la tabla SRV_UbicacionClienteDet */
abstract class BaseSRV_UbicacionClienteDetBV extends SRV_UbicacionClienteDetBN
{
    /* Contiene la clase que valida el tipo de dato */
    private $o_Validator; // Contiene el objeto que realizara la validacion de tipo de dato.
    private $s_ValidatorMessage; // Contiene la ultima observacion de la validacion del tipo de dato.

    /* Constructor ( Establece la clase que valida los tipos de datos y establece los valores por defecto ) */
    public function __construct()
    {
        /* Establecemos el objeto que realizara la validacion del tipo de dato */
        $this->o_Validator = new utilValidDataType();

        /* Establecemos los valores por defecto */
    }

    /* Valida en tipo de dato */
    private function validateData( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull )
    {
        $this->s_ValidatorMessage = null;
        if( !$this->o_Validator->validate( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull ) )
        {
            $this->s_ValidatorMessage = $this->o_Validator->getMessage();
        }
        return is_null( $this->s_ValidatorMessage );
    }

    /* Valida y establece el valor del campo IdUbicacionClienteH */
    public function setIdUbicacionClienteH( $i_IdUbicacionClienteH, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdUbicacionClienteH, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdUbicacionClienteH ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdUbicacionClienteH( $i_IdUbicacionClienteH );
        return true;
    }

    /* Valida y establece el valor del campo IdUbicacion */
    public function setIdUbicacion( $i_IdUbicacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdUbicacion, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdUbicacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdUbicacion( $i_IdUbicacion );
        return true;
    }

    /* Valida y establece el valor del campo IdTipoDocumento */
    public function setIdTipoDocumento( $s_IdTipoDocumento, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdTipoDocumento, "CHAR", 2, 0, false ) )
            {
                throw new Exception( "El campo IdTipoDocumento ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdTipoDocumento( $s_IdTipoDocumento );
        return true;
    }

    /* Valida y establece el valor del campo IdCompania */
    public function setIdCompania( $i_IdCompania, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdCompania, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdCompania ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdCompania( $i_IdCompania );
        return true;
    }

    /* Valida y establece el valor del campo IdSucursal */
    public function setIdSucursal( $i_IdSucursal, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdSucursal, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdSucursal ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdSucursal( $i_IdSucursal );
        return true;
    }

    /* Valida y establece el valor del campo NumeroDocumento */
    public function setNumeroDocumento( $s_NumeroDocumento, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_NumeroDocumento, "VARCHAR", 20, 0, false ) )
            {
                throw new Exception( "El campo NumeroDocumento ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setNumeroDocumento( $s_NumeroDocumento );
        return true;
    }

    /* Valida y establece el valor del campo DocumentoCod */
    public function setDocumentoCod( $s_DocumentoCod, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_DocumentoCod, "VARCHAR", 3, 0, false ) )
            {
                throw new Exception( "El campo DocumentoCod ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDocumentoCod( $s_DocumentoCod );
        return true;
    }

    /* Valida y establece el valor del campo DocumentoSerie */
    public function setDocumentoSerie( $s_DocumentoSerie, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_DocumentoSerie, "VARCHAR", 5, 0, false ) )
            {
                throw new Exception( "El campo DocumentoSerie ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDocumentoSerie( $s_DocumentoSerie );
        return true;
    }

    /* Valida y establece el valor del campo DocumentoNumero */
    public function setDocumentoNumero( $s_DocumentoNumero, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_DocumentoNumero, "VARCHAR", 10, 0, false ) )
            {
                throw new Exception( "El campo DocumentoNumero ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDocumentoNumero( $s_DocumentoNumero );
        return true;
    }

    /* Valida y establece el valor del campo IdPersona */
    public function setIdPersona( $i_IdPersona, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdPersona, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdPersona ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdPersona( $i_IdPersona );
        return true;
    }

    /* Valida y establece el valor del campo NombreCompleto */
    public function setNombreCompleto( $s_NombreCompleto, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_NombreCompleto, "VARCHAR", 500, 0, false ) )
            {
                throw new Exception( "El campo NombreCompleto ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setNombreCompleto( $s_NombreCompleto );
        return true;
    }

    /* Valida y establece el valor del campo MontoTotal */
    public function setMontoTotal( $f_MontoTotal, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_MontoTotal, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo MontoTotal ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setMontoTotal( $f_MontoTotal );
        return true;
    }

    /* Valida y establece el valor del campo Estado */
    public function setEstado( $s_Estado, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Estado, "CHAR", 2, 0, false ) )
            {
                throw new Exception( "El campo Estado ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setEstado( $s_Estado );
        return true;
    }

    /* Valida y establece el valor del campo FechaCreacion */
    public function setFechaCreacion( $d_FechaCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaCreacion, "TIMESTAMP", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaCreacion( $d_FechaCreacion );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioCreacion */
    public function setUsuarioCreacion( $s_UsuarioCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioCreacion, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo UsuarioCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioCreacion( $s_UsuarioCreacion );
        return true;
    }

    /* Valida y establece el valor del campo FechaModificacion */
    public function setFechaModificacion( $d_FechaModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaModificacion, "TIMESTAMP", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaModificacion( $d_FechaModificacion );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioModificacion */
    public function setUsuarioModificacion( $s_UsuarioModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioModificacion, "VARCHAR", 60, 0, false ) )
            {
                throw new Exception( "El campo UsuarioModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioModificacion( $s_UsuarioModificacion );
        return true;
    }

    /* Valida el contenido del registro */
    public function validateRecord()
    {
        $this->setIdUbicacionClienteH( $this->getIdUbicacionClienteH(), false );
        $this->setIdUbicacion( $this->getIdUbicacion(), true );
        $this->setIdTipoDocumento( $this->getIdTipoDocumento(), true );
        $this->setIdCompania( $this->getIdCompania(), true );
        $this->setIdSucursal( $this->getIdSucursal(), true );
        $this->setNumeroDocumento( $this->getNumeroDocumento(), false );
        $this->setDocumentoCod( $this->getDocumentoCod(), true );
        $this->setDocumentoSerie( $this->getDocumentoSerie(), true );
        $this->setDocumentoNumero( $this->getDocumentoNumero(), true );
        $this->setIdPersona( $this->getIdPersona(), true );
        $this->setNombreCompleto( $this->getNombreCompleto(), true );
        $this->setMontoTotal( $this->getMontoTotal(), true );
        $this->setEstado( $this->getEstado(), true );
        $this->setFechaCreacion( $this->getFechaCreacion(), true );
        $this->setUsuarioCreacion( $this->getUsuarioCreacion(), true );
        $this->setFechaModificacion( $this->getFechaModificacion(), true );
        $this->setUsuarioModificacion( $this->getUsuarioModificacion(), true );
        return true;
    }
}
?>