<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: SEG_UsuarioSesion.xml */
/* Generado: 2020-08-18 04:21:30 */

/* Validacion del contenido de los campos campos de la tabla SEG_UsuarioSesion */
abstract class BaseSEG_UsuarioSesionBV extends SEG_UsuarioSesionBN
{
    /* Contiene la clase que valida el tipo de dato */
    private $o_Validator; // Contiene el objeto que realizara la validacion de tipo de dato.
    private $s_ValidatorMessage; // Contiene la ultima observacion de la validacion del tipo de dato.

    /* Constructor ( Establece la clase que valida los tipos de datos y establece los valores por defecto ) */
    public function __construct()
    {
        /* Establecemos el objeto que realizara la validacion del tipo de dato */
        $this->o_Validator = new utilValidDataType();

        /* Establecemos los valores por defecto */
    }

    /* Valida en tipo de dato */
    private function validateData( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull )
    {
        $this->s_ValidatorMessage = null;
        if( !$this->o_Validator->validate( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull ) )
        {
            $this->s_ValidatorMessage = $this->o_Validator->getMessage();
        }
        return is_null( $this->s_ValidatorMessage );
    }

    /* Valida y establece el valor del campo Id */
    public function setId( $i_Id, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_Id, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo Id ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setId( $i_Id );
        return true;
    }

    /* Valida y establece el valor del campo IP */
    public function setIP( $s_IP, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IP, "VARCHAR", 50, 0, false ) )
            {
                throw new Exception( "El campo IP ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIP( $s_IP );
        return true;
    }

    /* Valida y establece el valor del campo IdRol */
    public function setIdRol( $s_IdRol, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdRol, "VARCHAR", 16, 0, false ) )
            {
                throw new Exception( "El campo IdRol ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdRol( $s_IdRol );
        return true;
    }

    /* Valida y establece el valor del campo IdUsuario */
    public function setIdUsuario( $s_IdUsuario, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdUsuario, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo IdUsuario ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdUsuario( $s_IdUsuario );
        return true;
    }

    /* Valida y establece el valor del campo FechaCreacion */
    public function setFechaCreacion( $d_FechaCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaCreacion, "DATETIME", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaCreacion( $d_FechaCreacion );
        return true;
    }

    /* Valida el contenido del registro */
    public function validateRecord()
    {
        $this->setId( $this->getId(), false );
        $this->setIP( $this->getIP(), true );
        $this->setIdRol( $this->getIdRol(), true );
        $this->setIdUsuario( $this->getIdUsuario(), true );
        $this->setFechaCreacion( $this->getFechaCreacion(), true );
        return true;
    }
}
?>