<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: SEG_Usuario.xml */
/* Generado: 2022-01-25 15:46:04 */

/* Validacion del contenido de los campos campos de la tabla SEG_Usuario */
abstract class BaseSEG_UsuarioBV extends SEG_UsuarioBN
{
    /* Contiene la clase que valida el tipo de dato */
    private $o_Validator; // Contiene el objeto que realizara la validacion de tipo de dato.
    private $s_ValidatorMessage; // Contiene la ultima observacion de la validacion del tipo de dato.

    /* Constructor ( Establece la clase que valida los tipos de datos y establece los valores por defecto ) */
    public function __construct()
    {
        /* Establecemos el objeto que realizara la validacion del tipo de dato */
        $this->o_Validator = new utilValidDataType();

        /* Establecemos los valores por defecto */
    }

    /* Valida en tipo de dato */
    private function validateData( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull )
    {
        $this->s_ValidatorMessage = null;
        if( !$this->o_Validator->validate( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull ) )
        {
            $this->s_ValidatorMessage = $this->o_Validator->getMessage();
        }
        return is_null( $this->s_ValidatorMessage );
    }

    /* Valida y establece el valor del campo IdUsuario */
    public function setIdUsuario( $s_IdUsuario, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdUsuario, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo IdUsuario ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdUsuario( $s_IdUsuario );
        return true;
    }

    /* Valida y establece el valor del campo IdCompania */
    public function setIdCompania( $i_IdCompania, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdCompania, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdCompania ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdCompania( $i_IdCompania );
        return true;
    }

    /* Valida y establece el valor del campo IdRol */
    public function setIdRol( $s_IdRol, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdRol, "VARCHAR", 16, 0, false ) )
            {
                throw new Exception( "El campo IdRol ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdRol( $s_IdRol );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioNombre */
    public function setUsuarioNombre( $s_UsuarioNombre, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioNombre, "VARCHAR", 500, 0, false ) )
            {
                throw new Exception( "El campo UsuarioNombre ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioNombre( $s_UsuarioNombre );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioPassword */
    public function setUsuarioPassword( $s_UsuarioPassword, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioPassword, "VARCHAR", 40, 0, false ) )
            {
                throw new Exception( "El campo UsuarioPassword ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioPassword( $s_UsuarioPassword );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioContrasenia */
    public function setUsuarioContrasenia( $s_UsuarioContrasenia, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioContrasenia, "VARCHAR", 40, 0, false ) )
            {
                throw new Exception( "El campo UsuarioContrasenia ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioContrasenia( $s_UsuarioContrasenia );
        return true;
    }

    /* Valida y establece el valor del campo FechaCambioPwd */
    public function setFechaCambioPwd( $d_FechaCambioPwd, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaCambioPwd, "DATE", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaCambioPwd ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaCambioPwd( $d_FechaCambioPwd );
        return true;
    }

    /* Valida y establece el valor del campo HoraCambioPwd */
    public function setHoraCambioPwd( $d_HoraCambioPwd, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_HoraCambioPwd, "DATETIME", 0, 0, false ) )
            {
                throw new Exception( "El campo HoraCambioPwd ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setHoraCambioPwd( $d_HoraCambioPwd );
        return true;
    }

    /* Valida y establece el valor del campo PermisoAdPwd */
    public function setPermisoAdPwd( $i_PermisoAdPwd, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_PermisoAdPwd, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo PermisoAdPwd ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setPermisoAdPwd( $i_PermisoAdPwd );
        return true;
    }

    /* Valida y establece el valor del campo ContadorPwd */
    public function setContadorPwd( $i_ContadorPwd, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_ContadorPwd, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo ContadorPwd ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setContadorPwd( $i_ContadorPwd );
        return true;
    }

    /* Valida y establece el valor del campo EnUso */
    public function setEnUso( $s_EnUso, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_EnUso, "CHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo EnUso ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setEnUso( $s_EnUso );
        return true;
    }

    /* Valida y establece el valor del campo DeshabilitadoFlg */
    public function setDeshabilitadoFlg( $s_DeshabilitadoFlg, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_DeshabilitadoFlg, "CHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo DeshabilitadoFlg ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDeshabilitadoFlg( $s_DeshabilitadoFlg );
        return true;
    }

    /* Valida y establece el valor del campo LogonFecha */
    public function setLogonFecha( $d_LogonFecha, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_LogonFecha, "DATE", 0, 0, false ) )
            {
                throw new Exception( "El campo LogonFecha ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setLogonFecha( $d_LogonFecha );
        return true;
    }

    /* Valida y establece el valor del campo LogonHora */
    public function setLogonHora( $d_LogonHora, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_LogonHora, "DATETIME", 0, 0, false ) )
            {
                throw new Exception( "El campo LogonHora ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setLogonHora( $d_LogonHora );
        return true;
    }

    /* Valida y establece el valor del campo Idioma */
    public function setIdioma( $s_Idioma, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Idioma, "VARCHAR", 6, 0, false ) )
            {
                throw new Exception( "El campo Idioma ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdioma( $s_Idioma );
        return true;
    }

    /* Valida y establece el valor del campo InicioFecha */
    public function setInicioFecha( $d_InicioFecha, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_InicioFecha, "DATE", 0, 0, false ) )
            {
                throw new Exception( "El campo InicioFecha ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setInicioFecha( $d_InicioFecha );
        return true;
    }

    /* Valida y establece el valor del campo FinFecha */
    public function setFinFecha( $d_FinFecha, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FinFecha, "DATE", 0, 0, false ) )
            {
                throw new Exception( "El campo FinFecha ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFinFecha( $d_FinFecha );
        return true;
    }

    /* Valida y establece el valor del campo DireccionIP */
    public function setDireccionIP( $s_DireccionIP, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_DireccionIP, "VARCHAR", 16, 0, false ) )
            {
                throw new Exception( "El campo DireccionIP ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDireccionIP( $s_DireccionIP );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioImagen */
    public function setUsuarioImagen( $s_UsuarioImagen, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioImagen, "VARCHAR", 240, 0, false ) )
            {
                throw new Exception( "El campo UsuarioImagen ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioImagen( $s_UsuarioImagen );
        return true;
    }

    /* Valida y establece el valor del campo Correo */
    public function setCorreo( $s_Correo, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Correo, "VARCHAR", 50, 0, false ) )
            {
                throw new Exception( "El campo Correo ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setCorreo( $s_Correo );
        return true;
    }

    /* Valida y establece el valor del campo FechaCreacion */
    public function setFechaCreacion( $d_FechaCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaCreacion, "TIMESTAMP", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaCreacion( $d_FechaCreacion );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioCreacion */
    public function setUsuarioCreacion( $s_UsuarioCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioCreacion, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo UsuarioCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioCreacion( $s_UsuarioCreacion );
        return true;
    }

    /* Valida y establece el valor del campo FechaModificacion */
    public function setFechaModificacion( $d_FechaModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaModificacion, "TIMESTAMP", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaModificacion( $d_FechaModificacion );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioModificacion */
    public function setUsuarioModificacion( $s_UsuarioModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioModificacion, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo UsuarioModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioModificacion( $s_UsuarioModificacion );
        return true;
    }

    /* Valida el contenido del registro */
    public function validateRecord()
    {
        $this->setIdUsuario( $this->getIdUsuario(), false );
        $this->setIdCompania( $this->getIdCompania(), true );
        $this->setIdRol( $this->getIdRol(), true );
        $this->setUsuarioNombre( $this->getUsuarioNombre(), true );
        $this->setUsuarioPassword( $this->getUsuarioPassword(), true );
        $this->setUsuarioContrasenia( $this->getUsuarioContrasenia(), true );
        $this->setFechaCambioPwd( $this->getFechaCambioPwd(), true );
        $this->setHoraCambioPwd( $this->getHoraCambioPwd(), true );
        $this->setPermisoAdPwd( $this->getPermisoAdPwd(), true );
        $this->setContadorPwd( $this->getContadorPwd(), true );
        $this->setEnUso( $this->getEnUso(), true );
        $this->setDeshabilitadoFlg( $this->getDeshabilitadoFlg(), true );
        $this->setLogonFecha( $this->getLogonFecha(), true );
        $this->setLogonHora( $this->getLogonHora(), true );
        $this->setIdioma( $this->getIdioma(), true );
        $this->setInicioFecha( $this->getInicioFecha(), true );
        $this->setFinFecha( $this->getFinFecha(), true );
        $this->setDireccionIP( $this->getDireccionIP(), true );
        $this->setUsuarioImagen( $this->getUsuarioImagen(), true );
        $this->setCorreo( $this->getCorreo(), true );
        $this->setFechaCreacion( $this->getFechaCreacion(), true );
        $this->setUsuarioCreacion( $this->getUsuarioCreacion(), true );
        $this->setFechaModificacion( $this->getFechaModificacion(), true );
        $this->setUsuarioModificacion( $this->getUsuarioModificacion(), true );
        return true;
    }
}
?>