<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: SEG_Tarea.xml */
/* Generado: 2020-08-18 04:21:30 */

/* Validacion del contenido de los campos campos de la tabla SEG_Tarea */
abstract class BaseSEG_TareaBV extends SEG_TareaBN
{
    /* Contiene la clase que valida el tipo de dato */
    private $o_Validator; // Contiene el objeto que realizara la validacion de tipo de dato.
    private $s_ValidatorMessage; // Contiene la ultima observacion de la validacion del tipo de dato.

    /* Constructor ( Establece la clase que valida los tipos de datos y establece los valores por defecto ) */
    public function __construct()
    {
        /* Establecemos el objeto que realizara la validacion del tipo de dato */
        $this->o_Validator = new utilValidDataType();

        /* Establecemos los valores por defecto */
    }

    /* Valida en tipo de dato */
    private function validateData( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull )
    {
        $this->s_ValidatorMessage = null;
        if( !$this->o_Validator->validate( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull ) )
        {
            $this->s_ValidatorMessage = $this->o_Validator->getMessage();
        }
        return is_null( $this->s_ValidatorMessage );
    }

    /* Valida y establece el valor del campo IdTarea */
    public function setIdTarea( $s_IdTarea, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdTarea, "VARCHAR", 40, 0, false ) )
            {
                throw new Exception( "El campo IdTarea ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdTarea( $s_IdTarea );
        return true;
    }

    /* Valida y establece el valor del campo TareaDescripcion */
    public function setTareaDescripcion( $s_TareaDescripcion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_TareaDescripcion, "VARCHAR", 50, 0, false ) )
            {
                throw new Exception( "El campo TareaDescripcion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setTareaDescripcion( $s_TareaDescripcion );
        return true;
    }

    /* Valida y establece el valor del campo BotonTexto */
    public function setBotonTexto( $s_BotonTexto, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_BotonTexto, "VARCHAR", 40, 0, false ) )
            {
                throw new Exception( "El campo BotonTexto ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setBotonTexto( $s_BotonTexto );
        return true;
    }

    /* Valida y establece el valor del campo TareaTipo */
    public function setTareaTipo( $s_TareaTipo, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_TareaTipo, "VARCHAR", 4, 0, false ) )
            {
                throw new Exception( "El campo TareaTipo ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setTareaTipo( $s_TareaTipo );
        return true;
    }

    /* Valida y establece el valor del campo ScriptId */
    public function setScriptId( $s_ScriptId, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ScriptId, "VARCHAR", 40, 0, false ) )
            {
                throw new Exception( "El campo ScriptId ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setScriptId( $s_ScriptId );
        return true;
    }

    /* Valida y establece el valor del campo DeshabilitadoFlg */
    public function setDeshabilitadoFlg( $s_DeshabilitadoFlg, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_DeshabilitadoFlg, "CHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo DeshabilitadoFlg ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDeshabilitadoFlg( $s_DeshabilitadoFlg );
        return true;
    }

    /* Valida y establece el valor del campo IdPatron */
    public function setIdPatron( $s_IdPatron, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdPatron, "VARCHAR", 16, 0, false ) )
            {
                throw new Exception( "El campo IdPatron ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdPatron( $s_IdPatron );
        return true;
    }

    /* Valida y establece el valor del campo IdSubSistema */
    public function setIdSubSistema( $s_IdSubSistema, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdSubSistema, "VARCHAR", 10, 0, false ) )
            {
                throw new Exception( "El campo IdSubSistema ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdSubSistema( $s_IdSubSistema );
        return true;
    }

    /* Valida y establece el valor del campo InicialPassthru */
    public function setInicialPassthru( $s_InicialPassthru, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_InicialPassthru, "VARCHAR", 40, 0, false ) )
            {
                throw new Exception( "El campo InicialPassthru ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setInicialPassthru( $s_InicialPassthru );
        return true;
    }

    /* Valida y establece el valor del campo SeleccionFixed */
    public function setSeleccionFixed( $s_SeleccionFixed, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_SeleccionFixed, "VARCHAR", 255, 0, false ) )
            {
                throw new Exception( "El campo SeleccionFixed ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setSeleccionFixed( $s_SeleccionFixed );
        return true;
    }

    /* Valida y establece el valor del campo SeleccionTemp */
    public function setSeleccionTemp( $s_SeleccionTemp, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_SeleccionTemp, "VARCHAR", 255, 0, false ) )
            {
                throw new Exception( "El campo SeleccionTemp ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setSeleccionTemp( $s_SeleccionTemp );
        return true;
    }

    /* Valida y establece el valor del campo Settings */
    public function setSettings( $s_Settings, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Settings, "VARCHAR", 40, 0, false ) )
            {
                throw new Exception( "El campo Settings ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setSettings( $s_Settings );
        return true;
    }

    /* Valida y establece el valor del campo OrdenarPor */
    public function setOrdenarPor( $s_OrdenarPor, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_OrdenarPor, "VARCHAR", 255, 0, false ) )
            {
                throw new Exception( "El campo OrdenarPor ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setOrdenarPor( $s_OrdenarPor );
        return true;
    }

    /* Valida y establece el valor del campo MantenerDatos */
    public function setMantenerDatos( $s_MantenerDatos, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_MantenerDatos, "CHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo MantenerDatos ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setMantenerDatos( $s_MantenerDatos );
        return true;
    }

    /* Valida y establece el valor del campo LogSqlQuery */
    public function setLogSqlQuery( $s_LogSqlQuery, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_LogSqlQuery, "CHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo LogSqlQuery ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setLogSqlQuery( $s_LogSqlQuery );
        return true;
    }

    /* Valida y establece el valor del campo ScreenRefresh */
    public function setScreenRefresh( $i_ScreenRefresh, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_ScreenRefresh, "INT", 1, 0, false ) )
            {
                throw new Exception( "El campo ScreenRefresh ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setScreenRefresh( $i_ScreenRefresh );
        return true;
    }

    /* Valida y establece el valor del campo UsaHttps */
    public function setUsaHttps( $s_UsaHttps, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsaHttps, "CHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo UsaHttps ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsaHttps( $s_UsaHttps );
        return true;
    }

    /* Valida y establece el valor del campo FechaCreacion */
    public function setFechaCreacion( $d_FechaCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaCreacion, "TIMESTAMP", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaCreacion( $d_FechaCreacion );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioCreacion */
    public function setUsuarioCreacion( $s_UsuarioCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioCreacion, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo UsuarioCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioCreacion( $s_UsuarioCreacion );
        return true;
    }

    /* Valida y establece el valor del campo FechaModificacion */
    public function setFechaModificacion( $d_FechaModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaModificacion, "TIMESTAMP", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaModificacion( $d_FechaModificacion );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioModificacion */
    public function setUsuarioModificacion( $s_UsuarioModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioModificacion, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo UsuarioModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioModificacion( $s_UsuarioModificacion );
        return true;
    }

    /* Valida el contenido del registro */
    public function validateRecord()
    {
        $this->setIdTarea( $this->getIdTarea(), false );
        $this->setTareaDescripcion( $this->getTareaDescripcion(), true );
        $this->setBotonTexto( $this->getBotonTexto(), true );
        $this->setTareaTipo( $this->getTareaTipo(), true );
        $this->setScriptId( $this->getScriptId(), true );
        $this->setDeshabilitadoFlg( $this->getDeshabilitadoFlg(), true );
        $this->setIdPatron( $this->getIdPatron(), true );
        $this->setIdSubSistema( $this->getIdSubSistema(), true );
        $this->setInicialPassthru( $this->getInicialPassthru(), true );
        $this->setSeleccionFixed( $this->getSeleccionFixed(), true );
        $this->setSeleccionTemp( $this->getSeleccionTemp(), true );
        $this->setSettings( $this->getSettings(), true );
        $this->setOrdenarPor( $this->getOrdenarPor(), true );
        $this->setMantenerDatos( $this->getMantenerDatos(), true );
        $this->setLogSqlQuery( $this->getLogSqlQuery(), true );
        $this->setScreenRefresh( $this->getScreenRefresh(), true );
        $this->setUsaHttps( $this->getUsaHttps(), true );
        $this->setFechaCreacion( $this->getFechaCreacion(), true );
        $this->setUsuarioCreacion( $this->getUsuarioCreacion(), true );
        $this->setFechaModificacion( $this->getFechaModificacion(), true );
        $this->setUsuarioModificacion( $this->getUsuarioModificacion(), true );
        return true;
    }
}
?>