<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: SEG_Patron.xml */
/* Generado: 2020-08-18 04:21:30 */

/* Validacion del contenido de los campos campos de la tabla SEG_Patron */
abstract class BaseSEG_PatronBV extends SEG_PatronBN
{
    /* Contiene la clase que valida el tipo de dato */
    private $o_Validator; // Contiene el objeto que realizara la validacion de tipo de dato.
    private $s_ValidatorMessage; // Contiene la ultima observacion de la validacion del tipo de dato.

    /* Constructor ( Establece la clase que valida los tipos de datos y establece los valores por defecto ) */
    public function __construct()
    {
        /* Establecemos el objeto que realizara la validacion del tipo de dato */
        $this->o_Validator = new utilValidDataType();

        /* Establecemos los valores por defecto */
    }

    /* Valida en tipo de dato */
    private function validateData( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull )
    {
        $this->s_ValidatorMessage = null;
        if( !$this->o_Validator->validate( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull ) )
        {
            $this->s_ValidatorMessage = $this->o_Validator->getMessage();
        }
        return is_null( $this->s_ValidatorMessage );
    }

    /* Valida y establece el valor del campo IdPatron */
    public function setIdPatron( $s_IdPatron, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdPatron, "VARCHAR", 16, 0, false ) )
            {
                throw new Exception( "El campo IdPatron ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdPatron( $s_IdPatron );
        return true;
    }

    /* Valida y establece el valor del campo PatronDescripcion */
    public function setPatronDescripcion( $s_PatronDescripcion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_PatronDescripcion, "VARCHAR", 60, 0, false ) )
            {
                throw new Exception( "El campo PatronDescripcion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setPatronDescripcion( $s_PatronDescripcion );
        return true;
    }

    /* Valida y establece el valor del campo PatronLongDesc */
    public function setPatronLongDesc( $i_PatronLongDesc, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_PatronLongDesc, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo PatronLongDesc ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setPatronLongDesc( $i_PatronLongDesc );
        return true;
    }

    /* Valida y establece el valor del campo VisibleScreen */
    public function setVisibleScreen( $s_VisibleScreen, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_VisibleScreen, "CHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo VisibleScreen ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setVisibleScreen( $s_VisibleScreen );
        return true;
    }

    /* Valida y establece el valor del campo ContextoPreselec */
    public function setContextoPreselec( $s_ContextoPreselec, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ContextoPreselec, "CHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo ContextoPreselec ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setContextoPreselec( $s_ContextoPreselec );
        return true;
    }

    /* Valida y establece el valor del campo MantenerDatos */
    public function setMantenerDatos( $s_MantenerDatos, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_MantenerDatos, "CHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo MantenerDatos ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setMantenerDatos( $s_MantenerDatos );
        return true;
    }

    /* Valida y establece el valor del campo FechaCreacion */
    public function setFechaCreacion( $d_FechaCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaCreacion, "TIMESTAMP", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaCreacion( $d_FechaCreacion );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioCreacion */
    public function setUsuarioCreacion( $s_UsuarioCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioCreacion, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo UsuarioCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioCreacion( $s_UsuarioCreacion );
        return true;
    }

    /* Valida y establece el valor del campo FechaModificacion */
    public function setFechaModificacion( $d_FechaModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaModificacion, "TIMESTAMP", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaModificacion( $d_FechaModificacion );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioModificacion */
    public function setUsuarioModificacion( $s_UsuarioModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioModificacion, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo UsuarioModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioModificacion( $s_UsuarioModificacion );
        return true;
    }

    /* Valida el contenido del registro */
    public function validateRecord()
    {
        $this->setIdPatron( $this->getIdPatron(), false );
        $this->setPatronDescripcion( $this->getPatronDescripcion(), true );
        $this->setPatronLongDesc( $this->getPatronLongDesc(), true );
        $this->setVisibleScreen( $this->getVisibleScreen(), true );
        $this->setContextoPreselec( $this->getContextoPreselec(), true );
        $this->setMantenerDatos( $this->getMantenerDatos(), true );
        $this->setFechaCreacion( $this->getFechaCreacion(), true );
        $this->setUsuarioCreacion( $this->getUsuarioCreacion(), true );
        $this->setFechaModificacion( $this->getFechaModificacion(), true );
        $this->setUsuarioModificacion( $this->getUsuarioModificacion(), true );
        return true;
    }
}
?>