<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: PR_Grupo.xml */
/* Generado: 2020-08-18 04:21:29 */

/* Validacion del contenido de los campos campos de la tabla PR_Grupo */
abstract class BasePR_GrupoBV extends PR_GrupoBN
{
    /* Contiene la clase que valida el tipo de dato */
    private $o_Validator; // Contiene el objeto que realizara la validacion de tipo de dato.
    private $s_ValidatorMessage; // Contiene la ultima observacion de la validacion del tipo de dato.

    /* Constructor ( Establece la clase que valida los tipos de datos y establece los valores por defecto ) */
    public function __construct()
    {
        /* Establecemos el objeto que realizara la validacion del tipo de dato */
        $this->o_Validator = new utilValidDataType();

        /* Establecemos los valores por defecto */
    }

    /* Valida en tipo de dato */
    private function validateData( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull )
    {
        $this->s_ValidatorMessage = null;
        if( !$this->o_Validator->validate( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull ) )
        {
            $this->s_ValidatorMessage = $this->o_Validator->getMessage();
        }
        return is_null( $this->s_ValidatorMessage );
    }

    /* Valida y establece el valor del campo IdPrGrupo */
    public function setIdPrGrupo( $s_IdPrGrupo, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdPrGrupo, "VARCHAR", 10, 0, false ) )
            {
                throw new Exception( "El campo IdPrGrupo ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdPrGrupo( $s_IdPrGrupo );
        return true;
    }

    /* Valida y establece el valor del campo IdCompania */
    public function setIdCompania( $i_IdCompania, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdCompania, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdCompania ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdCompania( $i_IdCompania );
        return true;
    }

    /* Valida y establece el valor del campo IdSucursal */
    public function setIdSucursal( $i_IdSucursal, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdSucursal, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdSucursal ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdSucursal( $i_IdSucursal );
        return true;
    }

    /* Valida y establece el valor del campo IdPrTipoId */
    public function setIdPrTipoId( $s_IdPrTipoId, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdPrTipoId, "VARCHAR", 2, 0, false ) )
            {
                throw new Exception( "El campo IdPrTipoId ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdPrTipoId( $s_IdPrTipoId );
        return true;
    }

    /* Valida y establece el valor del campo FechaInicio */
    public function setFechaInicio( $d_FechaInicio, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaInicio, "DATETIME", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaInicio ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaInicio( $d_FechaInicio );
        return true;
    }

    /* Valida y establece el valor del campo FechaExpiracion */
    public function setFechaExpiracion( $d_FechaExpiracion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaExpiracion, "DATETIME", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaExpiracion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaExpiracion( $d_FechaExpiracion );
        return true;
    }

    /* Valida y establece el valor del campo DescripcionPromo */
    public function setDescripcionPromo( $s_DescripcionPromo, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_DescripcionPromo, "VARCHAR", 250, 0, false ) )
            {
                throw new Exception( "El campo DescripcionPromo ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDescripcionPromo( $s_DescripcionPromo );
        return true;
    }

    /* Valida y establece el valor del campo Estado */
    public function setEstado( $s_Estado, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Estado, "VARCHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo Estado ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setEstado( $s_Estado );
        return true;
    }

    /* Valida y establece el valor del campo IdLinea */
    public function setIdLinea( $i_IdLinea, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdLinea, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdLinea ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdLinea( $i_IdLinea );
        return true;
    }

    /* Valida y establece el valor del campo IdFamilia */
    public function setIdFamilia( $i_IdFamilia, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdFamilia, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdFamilia ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdFamilia( $i_IdFamilia );
        return true;
    }

    /* Valida y establece el valor del campo Valor */
    public function setValor( $s_Valor, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Valor, "VARCHAR", 20, 0, false ) )
            {
                throw new Exception( "El campo Valor ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setValor( $s_Valor );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioCreacion */
    public function setUsuarioCreacion( $s_UsuarioCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioCreacion, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo UsuarioCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioCreacion( $s_UsuarioCreacion );
        return true;
    }

    /* Valida y establece el valor del campo FechaCreacion */
    public function setFechaCreacion( $d_FechaCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaCreacion, "DATETIME", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaCreacion( $d_FechaCreacion );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioModificacion */
    public function setUsuarioModificacion( $s_UsuarioModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioModificacion, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo UsuarioModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioModificacion( $s_UsuarioModificacion );
        return true;
    }

    /* Valida y establece el valor del campo FechaModificacion */
    public function setFechaModificacion( $d_FechaModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaModificacion, "TIMESTAMP", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaModificacion( $d_FechaModificacion );
        return true;
    }

    /* Valida el contenido del registro */
    public function validateRecord()
    {
        $this->setIdPrGrupo( $this->getIdPrGrupo(), false );
        $this->setIdCompania( $this->getIdCompania(), true );
        $this->setIdSucursal( $this->getIdSucursal(), true );
        $this->setIdPrTipoId( $this->getIdPrTipoId(), true );
        $this->setFechaInicio( $this->getFechaInicio(), true );
        $this->setFechaExpiracion( $this->getFechaExpiracion(), true );
        $this->setDescripcionPromo( $this->getDescripcionPromo(), true );
        $this->setEstado( $this->getEstado(), true );
        $this->setIdLinea( $this->getIdLinea(), true );
        $this->setIdFamilia( $this->getIdFamilia(), true );
        $this->setValor( $this->getValor(), true );
        $this->setUsuarioCreacion( $this->getUsuarioCreacion(), true );
        $this->setFechaCreacion( $this->getFechaCreacion(), true );
        $this->setUsuarioModificacion( $this->getUsuarioModificacion(), true );
        $this->setFechaModificacion( $this->getFechaModificacion(), true );
        return true;
    }
}
?>