<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: PRD_OrdenDet.xml */
/* Generado: 2021-03-26 22:09:47 */

/* Validacion del contenido de los campos campos de la tabla PRD_OrdenDet */
abstract class BasePRD_OrdenDetBV extends PRD_OrdenDetBN
{
    /* Contiene la clase que valida el tipo de dato */
    private $o_Validator; // Contiene el objeto que realizara la validacion de tipo de dato.
    private $s_ValidatorMessage; // Contiene la ultima observacion de la validacion del tipo de dato.

    /* Constructor ( Establece la clase que valida los tipos de datos y establece los valores por defecto ) */
    public function __construct()
    {
        /* Establecemos el objeto que realizara la validacion del tipo de dato */
        $this->o_Validator = new utilValidDataType();

        /* Establecemos los valores por defecto */
    }

    /* Valida en tipo de dato */
    private function validateData( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull )
    {
        $this->s_ValidatorMessage = null;
        if( !$this->o_Validator->validate( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull ) )
        {
            $this->s_ValidatorMessage = $this->o_Validator->getMessage();
        }
        return is_null( $this->s_ValidatorMessage );
    }

    /* Valida y establece el valor del campo IdOrdenDet */
    public function setIdOrdenDet( $i_IdOrdenDet, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdOrdenDet, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdOrdenDet ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdOrdenDet( $i_IdOrdenDet );
        return true;
    }

    /* Valida y establece el valor del campo IdOrdenCab */
    public function setIdOrdenCab( $i_IdOrdenCab, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdOrdenCab, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdOrdenCab ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdOrdenCab( $i_IdOrdenCab );
        return true;
    }

    /* Valida y establece el valor del campo IdItem */
    public function setIdItem( $s_IdItem, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdItem, "VARCHAR", 10, 0, false ) )
            {
                throw new Exception( "El campo IdItem ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdItem( $s_IdItem );
        return true;
    }

    /* Valida y establece el valor del campo ItemTipo */
    public function setItemTipo( $s_ItemTipo, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ItemTipo, "VARCHAR", 10, 0, false ) )
            {
                throw new Exception( "El campo ItemTipo ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setItemTipo( $s_ItemTipo );
        return true;
    }

    /* Valida y establece el valor del campo DescripcionItem */
    public function setDescripcionItem( $s_DescripcionItem, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_DescripcionItem, "VARCHAR", 250, 0, false ) )
            {
                throw new Exception( "El campo DescripcionItem ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDescripcionItem( $s_DescripcionItem );
        return true;
    }

    /* Valida y establece el valor del campo IdUnidad */
    public function setIdUnidad( $i_IdUnidad, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdUnidad, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdUnidad ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdUnidad( $i_IdUnidad );
        return true;
    }

    /* Valida y establece el valor del campo CantidadPedida */
    public function setCantidadPedida( $f_CantidadPedida, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_CantidadPedida, "DECIMAL", 10, 2, false ) )
            {
                throw new Exception( "El campo CantidadPedida ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setCantidadPedida( $f_CantidadPedida );
        return true;
    }

    /* Valida y establece el valor del campo CantidadRecibida */
    public function setCantidadRecibida( $f_CantidadRecibida, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_CantidadRecibida, "DECIMAL", 10, 2, false ) )
            {
                throw new Exception( "El campo CantidadRecibida ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setCantidadRecibida( $f_CantidadRecibida );
        return true;
    }

    /* Valida y establece el valor del campo PrecioCostoUnit */
    public function setPrecioCostoUnit( $f_PrecioCostoUnit, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_PrecioCostoUnit, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo PrecioCostoUnit ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setPrecioCostoUnit( $f_PrecioCostoUnit );
        return true;
    }

    /* Valida y establece el valor del campo PrecioCostoTotal */
    public function setPrecioCostoTotal( $f_PrecioCostoTotal, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_PrecioCostoTotal, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo PrecioCostoTotal ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setPrecioCostoTotal( $f_PrecioCostoTotal );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioCreacion */
    public function setUsuarioCreacion( $s_UsuarioCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioCreacion, "VARCHAR", 25, 0, false ) )
            {
                throw new Exception( "El campo UsuarioCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioCreacion( $s_UsuarioCreacion );
        return true;
    }

    /* Valida y establece el valor del campo FechaCreacion */
    public function setFechaCreacion( $d_FechaCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaCreacion, "TIMESTAMP", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaCreacion( $d_FechaCreacion );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioModificacion */
    public function setUsuarioModificacion( $s_UsuarioModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioModificacion, "VARCHAR", 25, 0, false ) )
            {
                throw new Exception( "El campo UsuarioModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioModificacion( $s_UsuarioModificacion );
        return true;
    }

    /* Valida y establece el valor del campo FechaModificacion */
    public function setFechaModificacion( $d_FechaModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaModificacion, "TIMESTAMP", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaModificacion( $d_FechaModificacion );
        return true;
    }

    /* Valida el contenido del registro */
    public function validateRecord()
    {
        $this->setIdOrdenDet( $this->getIdOrdenDet(), false );
        $this->setIdOrdenCab( $this->getIdOrdenCab(), true );
        $this->setIdItem( $this->getIdItem(), true );
        $this->setItemTipo( $this->getItemTipo(), true );
        $this->setDescripcionItem( $this->getDescripcionItem(), true );
        $this->setIdUnidad( $this->getIdUnidad(), true );
        $this->setCantidadPedida( $this->getCantidadPedida(), true );
        $this->setCantidadRecibida( $this->getCantidadRecibida(), true );
        $this->setPrecioCostoUnit( $this->getPrecioCostoUnit(), true );
        $this->setPrecioCostoTotal( $this->getPrecioCostoTotal(), true );
        $this->setUsuarioCreacion( $this->getUsuarioCreacion(), true );
        $this->setFechaCreacion( $this->getFechaCreacion(), true );
        $this->setUsuarioModificacion( $this->getUsuarioModificacion(), true );
        $this->setFechaModificacion( $this->getFechaModificacion(), true );
        return true;
    }
}
?>