<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: PLA_MarcacionRegistro.xml */
/* Generado: 2020-08-18 04:21:29 */

/* Validacion del contenido de los campos campos de la tabla PLA_MarcacionRegistro */
abstract class BasePLA_MarcacionRegistroBV extends PLA_MarcacionRegistroBN
{
    /* Contiene la clase que valida el tipo de dato */
    private $o_Validator; // Contiene el objeto que realizara la validacion de tipo de dato.
    private $s_ValidatorMessage; // Contiene la ultima observacion de la validacion del tipo de dato.

    /* Constructor ( Establece la clase que valida los tipos de datos y establece los valores por defecto ) */
    public function __construct()
    {
        /* Establecemos el objeto que realizara la validacion del tipo de dato */
        $this->o_Validator = new utilValidDataType();

        /* Establecemos los valores por defecto */
    }

    /* Valida en tipo de dato */
    private function validateData( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull )
    {
        $this->s_ValidatorMessage = null;
        if( !$this->o_Validator->validate( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull ) )
        {
            $this->s_ValidatorMessage = $this->o_Validator->getMessage();
        }
        return is_null( $this->s_ValidatorMessage );
    }

    /* Valida y establece el valor del campo IdRegistro */
    public function setIdRegistro( $s_IdRegistro, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdRegistro, "VARCHAR", 2, 0, false ) )
            {
                throw new Exception( "El campo IdRegistro ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdRegistro( $s_IdRegistro );
        return true;
    }

    /* Valida y establece el valor del campo Descripcion */
    public function setDescripcion( $s_Descripcion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Descripcion, "VARCHAR", 300, 0, false ) )
            {
                throw new Exception( "El campo Descripcion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDescripcion( $s_Descripcion );
        return true;
    }

    /* Valida y establece el valor del campo Secuencia */
    public function setSecuencia( $i_Secuencia, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_Secuencia, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo Secuencia ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setSecuencia( $i_Secuencia );
        return true;
    }

    /* Valida y establece el valor del campo Estado */
    public function setEstado( $s_Estado, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Estado, "VARCHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo Estado ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setEstado( $s_Estado );
        return true;
    }

    /* Valida y establece el valor del campo ObligatorioFlag */
    public function setObligatorioFlag( $i_ObligatorioFlag, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_ObligatorioFlag, "TINYINT", 4, 0, false ) )
            {
                throw new Exception( "El campo ObligatorioFlag ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setObligatorioFlag( $i_ObligatorioFlag );
        return true;
    }

    /* Valida y establece el valor del campo IdEquivalente */
    public function setIdEquivalente( $i_IdEquivalente, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdEquivalente, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdEquivalente ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdEquivalente( $i_IdEquivalente );
        return true;
    }

    /* Valida el contenido del registro */
    public function validateRecord()
    {
        $this->setIdRegistro( $this->getIdRegistro(), false );
        $this->setDescripcion( $this->getDescripcion(), true );
        $this->setSecuencia( $this->getSecuencia(), true );
        $this->setEstado( $this->getEstado(), true );
        $this->setObligatorioFlag( $this->getObligatorioFlag(), true );
        $this->setIdEquivalente( $this->getIdEquivalente(), true );
        return true;
    }
}
?>