<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: MST_TipoOperacionMast.xml */
/* Generado: 2020-08-18 04:21:28 */

/* Validacion del contenido de los campos campos de la tabla MST_TipoOperacionMast */
abstract class BaseMST_TipoOperacionMastBV extends MST_TipoOperacionMastBN
{
    /* Contiene la clase que valida el tipo de dato */
    private $o_Validator; // Contiene el objeto que realizara la validacion de tipo de dato.
    private $s_ValidatorMessage; // Contiene la ultima observacion de la validacion del tipo de dato.

    /* Constructor ( Establece la clase que valida los tipos de datos y establece los valores por defecto ) */
    public function __construct()
    {
        /* Establecemos el objeto que realizara la validacion del tipo de dato */
        $this->o_Validator = new utilValidDataType();

        /* Establecemos los valores por defecto */
    }

    /* Valida en tipo de dato */
    private function validateData( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull )
    {
        $this->s_ValidatorMessage = null;
        if( !$this->o_Validator->validate( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull ) )
        {
            $this->s_ValidatorMessage = $this->o_Validator->getMessage();
        }
        return is_null( $this->s_ValidatorMessage );
    }

    /* Valida y establece el valor del campo IdOperacion */
    public function setIdOperacion( $s_IdOperacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdOperacion, "VARCHAR", 2, 0, false ) )
            {
                throw new Exception( "El campo IdOperacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdOperacion( $s_IdOperacion );
        return true;
    }

    /* Valida y establece el valor del campo Descripcion */
    public function setDescripcion( $s_Descripcion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Descripcion, "VARCHAR", 200, 0, false ) )
            {
                throw new Exception( "El campo Descripcion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDescripcion( $s_Descripcion );
        return true;
    }

    /* Valida y establece el valor del campo Estado */
    public function setEstado( $s_Estado, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Estado, "VARCHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo Estado ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setEstado( $s_Estado );
        return true;
    }

    /* Valida y establece el valor del campo FechaCreacion */
    public function setFechaCreacion( $d_FechaCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaCreacion, "DATETIME", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaCreacion( $d_FechaCreacion );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioCreacion */
    public function setUsuarioCreacion( $s_UsuarioCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioCreacion, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo UsuarioCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioCreacion( $s_UsuarioCreacion );
        return true;
    }

    /* Valida el contenido del registro */
    public function validateRecord()
    {
        $this->setIdOperacion( $this->getIdOperacion(), false );
        $this->setDescripcion( $this->getDescripcion(), true );
        $this->setEstado( $this->getEstado(), true );
        $this->setFechaCreacion( $this->getFechaCreacion(), true );
        $this->setUsuarioCreacion( $this->getUsuarioCreacion(), true );
        return true;
    }
}
?>