<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: MST_ReferenciaProductoCatTalla.xml */
/* Generado: 2024-08-20 23:01:57 */

/* Validacion del contenido de los campos campos de la tabla MST_ReferenciaProductoCatTalla */
abstract class BaseMST_ReferenciaProductoCatTallaBV extends MST_ReferenciaProductoCatTallaBN
{
    /* Contiene la clase que valida el tipo de dato */
    private $o_Validator; // Contiene el objeto que realizara la validacion de tipo de dato.
    private $s_ValidatorMessage; // Contiene la ultima observacion de la validacion del tipo de dato.

    /* Constructor ( Establece la clase que valida los tipos de datos y establece los valores por defecto ) */
    public function __construct()
    {
        /* Establecemos el objeto que realizara la validacion del tipo de dato */
        $this->o_Validator = new utilValidDataType();

        /* Establecemos los valores por defecto */
    }

    /* Valida en tipo de dato */
    private function validateData( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull )
    {
        $this->s_ValidatorMessage = null;
        if( !$this->o_Validator->validate( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull ) )
        {
            $this->s_ValidatorMessage = $this->o_Validator->getMessage();
        }
        return is_null( $this->s_ValidatorMessage );
    }

    /* Valida y establece el valor del campo IdReferencia */
    public function setIdReferencia( $i_IdReferencia, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdReferencia, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdReferencia ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdReferencia( $i_IdReferencia );
        return true;
    }

    /* Valida y establece el valor del campo IdColor */
    public function setIdColor( $i_IdColor, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdColor, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdColor ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdColor( $i_IdColor );
        return true;
    }

    /* Valida y establece el valor del campo IdCatTalla */
    public function setIdCatTalla( $i_IdCatTalla, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdCatTalla, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdCatTalla ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdCatTalla( $i_IdCatTalla );
        return true;
    }

    /* Valida y establece el valor del campo Aplicado */
    public function setAplicado( $i_Aplicado, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_Aplicado, "INT", 10, 0, false ) )
            {
                throw new Exception( "El campo Aplicado ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setAplicado( $i_Aplicado );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioCreacion */
    public function setUsuarioCreacion( $s_UsuarioCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioCreacion, "VARCHAR", 25, 0, false ) )
            {
                throw new Exception( "El campo UsuarioCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioCreacion( $s_UsuarioCreacion );
        return true;
    }

    /* Valida y establece el valor del campo FechaCreacion */
    public function setFechaCreacion( $d_FechaCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaCreacion, "DATETIME", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaCreacion( $d_FechaCreacion );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioModificacion */
    public function setUsuarioModificacion( $s_UsuarioModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioModificacion, "VARCHAR", 25, 0, false ) )
            {
                throw new Exception( "El campo UsuarioModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioModificacion( $s_UsuarioModificacion );
        return true;
    }

    /* Valida y establece el valor del campo FechaModificacion */
    public function setFechaModificacion( $d_FechaModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaModificacion, "DATETIME", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaModificacion( $d_FechaModificacion );
        return true;
    }

    /* Valida el contenido del registro */
    public function validateRecord()
    {
        $this->setIdReferencia( $this->getIdReferencia(), false );
        $this->setIdColor( $this->getIdColor(), false );
        $this->setIdCatTalla( $this->getIdCatTalla(), false );
        $this->setAplicado( $this->getAplicado(), true );
        $this->setUsuarioCreacion( $this->getUsuarioCreacion(), true );
        $this->setFechaCreacion( $this->getFechaCreacion(), true );
        $this->setUsuarioModificacion( $this->getUsuarioModificacion(), true );
        $this->setFechaModificacion( $this->getFechaModificacion(), true );
        return true;
    }
}
?>