<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: MST_Rango.xml */
/* Generado: 2021-02-01 05:17:53 */

/* Validacion del contenido de los campos campos de la tabla MST_Rango */
abstract class BaseMST_RangoBV extends MST_RangoBN
{
    /* Contiene la clase que valida el tipo de dato */
    private $o_Validator; // Contiene el objeto que realizara la validacion de tipo de dato.
    private $s_ValidatorMessage; // Contiene la ultima observacion de la validacion del tipo de dato.

    /* Constructor ( Establece la clase que valida los tipos de datos y establece los valores por defecto ) */
    public function __construct()
    {
        /* Establecemos el objeto que realizara la validacion del tipo de dato */
        $this->o_Validator = new utilValidDataType();

        /* Establecemos los valores por defecto */
    }

    /* Valida en tipo de dato */
    private function validateData( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull )
    {
        $this->s_ValidatorMessage = null;
        if( !$this->o_Validator->validate( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull ) )
        {
            $this->s_ValidatorMessage = $this->o_Validator->getMessage();
        }
        return is_null( $this->s_ValidatorMessage );
    }

    /* Valida y establece el valor del campo IdRango */
    public function setIdRango( $i_IdRango, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdRango, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdRango ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdRango( $i_IdRango );
        return true;
    }

    /* Valida y establece el valor del campo Descripcion */
    public function setDescripcion( $s_Descripcion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Descripcion, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo Descripcion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDescripcion( $s_Descripcion );
        return true;
    }

    /* Valida y establece el valor del campo FlagAlquiler */
    public function setFlagAlquiler( $i_FlagAlquiler, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_FlagAlquiler, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo FlagAlquiler ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFlagAlquiler( $i_FlagAlquiler );
        return true;
    }

    /* Valida y establece el valor del campo FlagVenta */
    public function setFlagVenta( $i_FlagVenta, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_FlagVenta, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo FlagVenta ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFlagVenta( $i_FlagVenta );
        return true;
    }

    /* Valida y establece el valor del campo FlagEncofrado */
    public function setFlagEncofrado( $i_FlagEncofrado, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_FlagEncofrado, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo FlagEncofrado ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFlagEncofrado( $i_FlagEncofrado );
        return true;
    }

    /* Valida y establece el valor del campo FlagDescuentoAdelanto */
    public function setFlagDescuentoAdelanto( $i_FlagDescuentoAdelanto, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_FlagDescuentoAdelanto, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo FlagDescuentoAdelanto ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFlagDescuentoAdelanto( $i_FlagDescuentoAdelanto );
        return true;
    }

    /* Valida y establece el valor del campo FlagDescuentoContado */
    public function setFlagDescuentoContado( $i_FlagDescuentoContado, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_FlagDescuentoContado, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo FlagDescuentoContado ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFlagDescuentoContado( $i_FlagDescuentoContado );
        return true;
    }

    /* Valida y establece el valor del campo Estado */
    public function setEstado( $s_Estado, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Estado, "VARCHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo Estado ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setEstado( $s_Estado );
        return true;
    }

    /* Valida y establece el valor del campo FechaCreacion */
    public function setFechaCreacion( $d_FechaCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaCreacion, "DATETIME", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaCreacion( $d_FechaCreacion );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioCreacion */
    public function setUsuarioCreacion( $s_UsuarioCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioCreacion, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo UsuarioCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioCreacion( $s_UsuarioCreacion );
        return true;
    }

    /* Valida y establece el valor del campo FechaModificacion */
    public function setFechaModificacion( $d_FechaModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaModificacion, "DATETIME", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaModificacion( $d_FechaModificacion );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioModificacion */
    public function setUsuarioModificacion( $s_UsuarioModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioModificacion, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo UsuarioModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioModificacion( $s_UsuarioModificacion );
        return true;
    }

    /* Valida el contenido del registro */
    public function validateRecord()
    {
        $this->setIdRango( $this->getIdRango(), false );
        $this->setDescripcion( $this->getDescripcion(), true );
        $this->setFlagAlquiler( $this->getFlagAlquiler(), true );
        $this->setFlagVenta( $this->getFlagVenta(), true );
        $this->setFlagEncofrado( $this->getFlagEncofrado(), true );
        $this->setFlagDescuentoAdelanto( $this->getFlagDescuentoAdelanto(), true );
        $this->setFlagDescuentoContado( $this->getFlagDescuentoContado(), true );
        $this->setEstado( $this->getEstado(), true );
        $this->setFechaCreacion( $this->getFechaCreacion(), true );
        $this->setUsuarioCreacion( $this->getUsuarioCreacion(), true );
        $this->setFechaModificacion( $this->getFechaModificacion(), true );
        $this->setUsuarioModificacion( $this->getUsuarioModificacion(), true );
        return true;
    }
}
?>