<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: MST_ItemUbicacion.xml */
/* Generado: 2020-08-18 04:21:27 */

/* Validacion del contenido de los campos campos de la tabla MST_ItemUbicacion */
abstract class BaseMST_ItemUbicacionBV extends MST_ItemUbicacionBN
{
    /* Contiene la clase que valida el tipo de dato */
    private $o_Validator; // Contiene el objeto que realizara la validacion de tipo de dato.
    private $s_ValidatorMessage; // Contiene la ultima observacion de la validacion del tipo de dato.

    /* Constructor ( Establece la clase que valida los tipos de datos y establece los valores por defecto ) */
    public function __construct()
    {
        /* Establecemos el objeto que realizara la validacion del tipo de dato */
        $this->o_Validator = new utilValidDataType();

        /* Establecemos los valores por defecto */
    }

    /* Valida en tipo de dato */
    private function validateData( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull )
    {
        $this->s_ValidatorMessage = null;
        if( !$this->o_Validator->validate( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull ) )
        {
            $this->s_ValidatorMessage = $this->o_Validator->getMessage();
        }
        return is_null( $this->s_ValidatorMessage );
    }

    /* Valida y establece el valor del campo IdItem */
    public function setIdItem( $s_IdItem, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdItem, "VARCHAR", 20, 0, false ) )
            {
                throw new Exception( "El campo IdItem ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdItem( $s_IdItem );
        return true;
    }

    /* Valida y establece el valor del campo IdCategoria */
    public function setIdCategoria( $i_IdCategoria, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdCategoria, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdCategoria ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdCategoria( $i_IdCategoria );
        return true;
    }

    /* Valida y establece el valor del campo IdTipoUbicacion */
    public function setIdTipoUbicacion( $i_IdTipoUbicacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdTipoUbicacion, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdTipoUbicacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdTipoUbicacion( $i_IdTipoUbicacion );
        return true;
    }

    /* Valida y establece el valor del campo HoraHabitacion */
    public function setHoraHabitacion( $i_HoraHabitacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_HoraHabitacion, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo HoraHabitacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setHoraHabitacion( $i_HoraHabitacion );
        return true;
    }

    /* Valida el contenido del registro */
    public function validateRecord()
    {
        $this->setIdItem( $this->getIdItem(), false );
        $this->setIdCategoria( $this->getIdCategoria(), true );
        $this->setIdTipoUbicacion( $this->getIdTipoUbicacion(), true );
        $this->setHoraHabitacion( $this->getHoraHabitacion(), true );
        return true;
    }
}
?>