<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: MST_ClienteMast.xml */
/* Generado: 2021-09-13 17:10:55 */

/* Validacion del contenido de los campos campos de la tabla MST_ClienteMast */
abstract class BaseMST_ClienteMastBV extends MST_ClienteMastBN
{
    /* Contiene la clase que valida el tipo de dato */
    private $o_Validator; // Contiene el objeto que realizara la validacion de tipo de dato.
    private $s_ValidatorMessage; // Contiene la ultima observacion de la validacion del tipo de dato.

    /* Constructor ( Establece la clase que valida los tipos de datos y establece los valores por defecto ) */
    public function __construct()
    {
        /* Establecemos el objeto que realizara la validacion del tipo de dato */
        $this->o_Validator = new utilValidDataType();

        /* Establecemos los valores por defecto */
    }

    /* Valida en tipo de dato */
    private function validateData( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull )
    {
        $this->s_ValidatorMessage = null;
        if( !$this->o_Validator->validate( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull ) )
        {
            $this->s_ValidatorMessage = $this->o_Validator->getMessage();
        }
        return is_null( $this->s_ValidatorMessage );
    }

    /* Valida y establece el valor del campo IdCliente */
    public function setIdCliente( $i_IdCliente, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdCliente, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdCliente ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdCliente( $i_IdCliente );
        return true;
    }

    /* Valida y establece el valor del campo Clasificacion */
    public function setClasificacion( $s_Clasificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Clasificacion, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo Clasificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setClasificacion( $s_Clasificacion );
        return true;
    }

    /* Valida y establece el valor del campo LineaCredito */
    public function setLineaCredito( $i_LineaCredito, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_LineaCredito, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo LineaCredito ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setLineaCredito( $i_LineaCredito );
        return true;
    }

    /* Valida y establece el valor del campo IngresoMensual */
    public function setIngresoMensual( $f_IngresoMensual, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_IngresoMensual, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo IngresoMensual ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIngresoMensual( $f_IngresoMensual );
        return true;
    }

    /* Valida y establece el valor del campo Vendedor */
    public function setVendedor( $i_Vendedor, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_Vendedor, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo Vendedor ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setVendedor( $i_Vendedor );
        return true;
    }

    /* Valida y establece el valor del campo VendedorCod */
    public function setVendedorCod( $s_VendedorCod, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_VendedorCod, "VARCHAR", 50, 0, false ) )
            {
                throw new Exception( "El campo VendedorCod ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setVendedorCod( $s_VendedorCod );
        return true;
    }

    /* Valida y establece el valor del campo FormadePago */
    public function setFormadePago( $s_FormadePago, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_FormadePago, "VARCHAR", 3, 0, false ) )
            {
                throw new Exception( "El campo FormadePago ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFormadePago( $s_FormadePago );
        return true;
    }

    /* Valida y establece el valor del campo TotalAcumulado */
    public function setTotalAcumulado( $f_TotalAcumulado, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_TotalAcumulado, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo TotalAcumulado ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setTotalAcumulado( $f_TotalAcumulado );
        return true;
    }

    /* Valida y establece el valor del campo TipoServicio */
    public function setTipoServicio( $s_TipoServicio, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_TipoServicio, "CHAR", 6, 0, false ) )
            {
                throw new Exception( "El campo TipoServicio ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setTipoServicio( $s_TipoServicio );
        return true;
    }

    /* Valida y establece el valor del campo NumeroDiasCobranza */
    public function setNumeroDiasCobranza( $i_NumeroDiasCobranza, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_NumeroDiasCobranza, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo NumeroDiasCobranza ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setNumeroDiasCobranza( $i_NumeroDiasCobranza );
        return true;
    }

    /* Valida y establece el valor del campo PagoEfectivoFlag */
    public function setPagoEfectivoFlag( $s_PagoEfectivoFlag, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_PagoEfectivoFlag, "CHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo PagoEfectivoFlag ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setPagoEfectivoFlag( $s_PagoEfectivoFlag );
        return true;
    }

    /* Valida y establece el valor del campo TipoFacturacion */
    public function setTipoFacturacion( $s_TipoFacturacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_TipoFacturacion, "VARCHAR", 3, 0, false ) )
            {
                throw new Exception( "El campo TipoFacturacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setTipoFacturacion( $s_TipoFacturacion );
        return true;
    }

    /* Valida y establece el valor del campo TipoVenta */
    public function setTipoVenta( $s_TipoVenta, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_TipoVenta, "VARCHAR", 3, 0, false ) )
            {
                throw new Exception( "El campo TipoVenta ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setTipoVenta( $s_TipoVenta );
        return true;
    }

    /* Valida y establece el valor del campo FormaFacturacion */
    public function setFormaFacturacion( $s_FormaFacturacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_FormaFacturacion, "VARCHAR", 2, 0, false ) )
            {
                throw new Exception( "El campo FormaFacturacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFormaFacturacion( $s_FormaFacturacion );
        return true;
    }

    /* Valida y establece el valor del campo TipoCliente */
    public function setTipoCliente( $s_TipoCliente, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_TipoCliente, "VARCHAR", 2, 0, false ) )
            {
                throw new Exception( "El campo TipoCliente ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setTipoCliente( $s_TipoCliente );
        return true;
    }

    /* Valida y establece el valor del campo CentroCosto */
    public function setCentroCosto( $s_CentroCosto, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_CentroCosto, "VARCHAR", 10, 0, false ) )
            {
                throw new Exception( "El campo CentroCosto ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setCentroCosto( $s_CentroCosto );
        return true;
    }

    /* Valida y establece el valor del campo CodCanal */
    public function setCodCanal( $s_CodCanal, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_CodCanal, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo CodCanal ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setCodCanal( $s_CodCanal );
        return true;
    }

    /* Valida y establece el valor del campo CreditoHold */
    public function setCreditoHold( $s_CreditoHold, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_CreditoHold, "VARCHAR", 3, 0, false ) )
            {
                throw new Exception( "El campo CreditoHold ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setCreditoHold( $s_CreditoHold );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioModificacion */
    public function setUsuarioModificacion( $s_UsuarioModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioModificacion, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo UsuarioModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioModificacion( $s_UsuarioModificacion );
        return true;
    }

    /* Valida y establece el valor del campo FechaModificacion */
    public function setFechaModificacion( $d_FechaModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaModificacion, "DATETIME", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaModificacion( $d_FechaModificacion );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioCreacion */
    public function setUsuarioCreacion( $s_UsuarioCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioCreacion, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo UsuarioCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioCreacion( $s_UsuarioCreacion );
        return true;
    }

    /* Valida y establece el valor del campo FechaCreacion */
    public function setFechaCreacion( $d_FechaCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaCreacion, "DATETIME", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaCreacion( $d_FechaCreacion );
        return true;
    }

    /* Valida el contenido del registro */
    public function validateRecord()
    {
        $this->setIdCliente( $this->getIdCliente(), false );
        $this->setClasificacion( $this->getClasificacion(), true );
        $this->setLineaCredito( $this->getLineaCredito(), true );
        $this->setIngresoMensual( $this->getIngresoMensual(), true );
        $this->setVendedor( $this->getVendedor(), true );
        $this->setVendedorCod( $this->getVendedorCod(), true );
        $this->setFormadePago( $this->getFormadePago(), true );
        $this->setTotalAcumulado( $this->getTotalAcumulado(), true );
        $this->setTipoServicio( $this->getTipoServicio(), true );
        $this->setNumeroDiasCobranza( $this->getNumeroDiasCobranza(), true );
        $this->setPagoEfectivoFlag( $this->getPagoEfectivoFlag(), true );
        $this->setTipoFacturacion( $this->getTipoFacturacion(), true );
        $this->setTipoVenta( $this->getTipoVenta(), true );
        $this->setFormaFacturacion( $this->getFormaFacturacion(), true );
        $this->setTipoCliente( $this->getTipoCliente(), true );
        $this->setCentroCosto( $this->getCentroCosto(), true );
        $this->setCodCanal( $this->getCodCanal(), true );
        $this->setCreditoHold( $this->getCreditoHold(), true );
        $this->setUsuarioModificacion( $this->getUsuarioModificacion(), true );
        $this->setFechaModificacion( $this->getFechaModificacion(), true );
        $this->setUsuarioCreacion( $this->getUsuarioCreacion(), true );
        $this->setFechaCreacion( $this->getFechaCreacion(), true );
        return true;
    }
}
?>