<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: MST_ClaseSubFamilia.xml */
/* Generado: 2021-11-19 07:55:32 */

/* Validacion del contenido de los campos campos de la tabla MST_ClaseSubFamilia */
abstract class BaseMST_ClaseSubFamiliaBV extends MST_ClaseSubFamiliaBN
{
    /* Contiene la clase que valida el tipo de dato */
    private $o_Validator; // Contiene el objeto que realizara la validacion de tipo de dato.
    private $s_ValidatorMessage; // Contiene la ultima observacion de la validacion del tipo de dato.

    /* Constructor ( Establece la clase que valida los tipos de datos y establece los valores por defecto ) */
    public function __construct()
    {
        /* Establecemos el objeto que realizara la validacion del tipo de dato */
        $this->o_Validator = new utilValidDataType();

        /* Establecemos los valores por defecto */
    }

    /* Valida en tipo de dato */
    private function validateData( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull )
    {
        $this->s_ValidatorMessage = null;
        if( !$this->o_Validator->validate( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull ) )
        {
            $this->s_ValidatorMessage = $this->o_Validator->getMessage();
        }
        return is_null( $this->s_ValidatorMessage );
    }

    /* Valida y establece el valor del campo IdSubFamilia */
    public function setIdSubFamilia( $i_IdSubFamilia, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdSubFamilia, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdSubFamilia ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdSubFamilia( $i_IdSubFamilia );
        return true;
    }

    /* Valida y establece el valor del campo IdLinea */
    public function setIdLinea( $i_IdLinea, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdLinea, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdLinea ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdLinea( $i_IdLinea );
        return true;
    }

    /* Valida y establece el valor del campo IdFamilia */
    public function setIdFamilia( $i_IdFamilia, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdFamilia, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdFamilia ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdFamilia( $i_IdFamilia );
        return true;
    }

    /* Valida y establece el valor del campo Descripcion */
    public function setDescripcion( $s_Descripcion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Descripcion, "VARCHAR", 300, 0, false ) )
            {
                throw new Exception( "El campo Descripcion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDescripcion( $s_Descripcion );
        return true;
    }

    /* Valida y establece el valor del campo Codigo */
    public function setCodigo( $s_Codigo, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Codigo, "VARCHAR", 10, 0, false ) )
            {
                throw new Exception( "El campo Codigo ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setCodigo( $s_Codigo );
        return true;
    }

    /* Valida y establece el valor del campo EsParaAlquiler */
    public function setEsParaAlquiler( $s_EsParaAlquiler, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_EsParaAlquiler, "VARCHAR", 2, 0, false ) )
            {
                throw new Exception( "El campo EsParaAlquiler ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setEsParaAlquiler( $s_EsParaAlquiler );
        return true;
    }

    /* Valida y establece el valor del campo EsParaVenta */
    public function setEsParaVenta( $s_EsParaVenta, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_EsParaVenta, "VARCHAR", 2, 0, false ) )
            {
                throw new Exception( "El campo EsParaVenta ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setEsParaVenta( $s_EsParaVenta );
        return true;
    }

    /* Valida y establece el valor del campo IdRangoAlquiler */
    public function setIdRangoAlquiler( $i_IdRangoAlquiler, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdRangoAlquiler, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdRangoAlquiler ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdRangoAlquiler( $i_IdRangoAlquiler );
        return true;
    }

    /* Valida y establece el valor del campo IdRangoVenta */
    public function setIdRangoVenta( $i_IdRangoVenta, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdRangoVenta, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdRangoVenta ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdRangoVenta( $i_IdRangoVenta );
        return true;
    }

    /* Valida y establece el valor del campo TieneDescuentoAdelanto */
    public function setTieneDescuentoAdelanto( $s_TieneDescuentoAdelanto, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_TieneDescuentoAdelanto, "VARCHAR", 2, 0, false ) )
            {
                throw new Exception( "El campo TieneDescuentoAdelanto ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setTieneDescuentoAdelanto( $s_TieneDescuentoAdelanto );
        return true;
    }

    /* Valida y establece el valor del campo TieneDescuentoContado */
    public function setTieneDescuentoContado( $s_TieneDescuentoContado, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_TieneDescuentoContado, "VARCHAR", 2, 0, false ) )
            {
                throw new Exception( "El campo TieneDescuentoContado ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setTieneDescuentoContado( $s_TieneDescuentoContado );
        return true;
    }

    /* Valida y establece el valor del campo IdRangoDescuentoContado */
    public function setIdRangoDescuentoContado( $i_IdRangoDescuentoContado, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdRangoDescuentoContado, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdRangoDescuentoContado ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdRangoDescuentoContado( $i_IdRangoDescuentoContado );
        return true;
    }

    /* Valida y establece el valor del campo IdRengoDescuentoAdelanto */
    public function setIdRengoDescuentoAdelanto( $i_IdRengoDescuentoAdelanto, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdRengoDescuentoAdelanto, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdRengoDescuentoAdelanto ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdRengoDescuentoAdelanto( $i_IdRengoDescuentoAdelanto );
        return true;
    }

    /* Valida y establece el valor del campo Estado */
    public function setEstado( $s_Estado, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Estado, "VARCHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo Estado ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setEstado( $s_Estado );
        return true;
    }

    /* Valida y establece el valor del campo FechaCreacion */
    public function setFechaCreacion( $d_FechaCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaCreacion, "DATETIME", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaCreacion( $d_FechaCreacion );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioCreacion */
    public function setUsuarioCreacion( $s_UsuarioCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioCreacion, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo UsuarioCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioCreacion( $s_UsuarioCreacion );
        return true;
    }

    /* Valida y establece el valor del campo FechaModificacion */
    public function setFechaModificacion( $d_FechaModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaModificacion, "TIMESTAMP", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaModificacion( $d_FechaModificacion );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioModificacion */
    public function setUsuarioModificacion( $s_UsuarioModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioModificacion, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo UsuarioModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioModificacion( $s_UsuarioModificacion );
        return true;
    }

    /* Valida el contenido del registro */
    public function validateRecord()
    {
        $this->setIdSubFamilia( $this->getIdSubFamilia(), false );
        $this->setIdLinea( $this->getIdLinea(), true );
        $this->setIdFamilia( $this->getIdFamilia(), true );
        $this->setDescripcion( $this->getDescripcion(), true );
        $this->setCodigo( $this->getCodigo(), true );
        $this->setEsParaAlquiler( $this->getEsParaAlquiler(), true );
        $this->setEsParaVenta( $this->getEsParaVenta(), true );
        $this->setIdRangoAlquiler( $this->getIdRangoAlquiler(), true );
        $this->setIdRangoVenta( $this->getIdRangoVenta(), true );
        $this->setTieneDescuentoAdelanto( $this->getTieneDescuentoAdelanto(), true );
        $this->setTieneDescuentoContado( $this->getTieneDescuentoContado(), true );
        $this->setIdRangoDescuentoContado( $this->getIdRangoDescuentoContado(), true );
        $this->setIdRengoDescuentoAdelanto( $this->getIdRengoDescuentoAdelanto(), true );
        $this->setEstado( $this->getEstado(), true );
        $this->setFechaCreacion( $this->getFechaCreacion(), true );
        $this->setUsuarioCreacion( $this->getUsuarioCreacion(), true );
        $this->setFechaModificacion( $this->getFechaModificacion(), true );
        $this->setUsuarioModificacion( $this->getUsuarioModificacion(), true );
        return true;
    }
}
?>