<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: MKT_ItemPromocion.xml */
/* Generado: 2022-02-09 07:47:37 */

/* Validacion del contenido de los campos campos de la tabla MKT_ItemPromocion */
abstract class BaseMKT_ItemPromocionBV extends MKT_ItemPromocionBN
{
    /* Contiene la clase que valida el tipo de dato */
    private $o_Validator; // Contiene el objeto que realizara la validacion de tipo de dato.
    private $s_ValidatorMessage; // Contiene la ultima observacion de la validacion del tipo de dato.

    /* Constructor ( Establece la clase que valida los tipos de datos y establece los valores por defecto ) */
    public function __construct()
    {
        /* Establecemos el objeto que realizara la validacion del tipo de dato */
        $this->o_Validator = new utilValidDataType();

        /* Establecemos los valores por defecto */
    }

    /* Valida en tipo de dato */
    private function validateData( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull )
    {
        $this->s_ValidatorMessage = null;
        if( !$this->o_Validator->validate( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull ) )
        {
            $this->s_ValidatorMessage = $this->o_Validator->getMessage();
        }
        return is_null( $this->s_ValidatorMessage );
    }

    /* Valida y establece el valor del campo IdItemPromo */
    public function setIdItemPromo( $i_IdItemPromo, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdItemPromo, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdItemPromo ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdItemPromo( $i_IdItemPromo );
        return true;
    }

    /* Valida y establece el valor del campo IdItem */
    public function setIdItem( $s_IdItem, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdItem, "VARCHAR", 20, 0, false ) )
            {
                throw new Exception( "El campo IdItem ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdItem( $s_IdItem );
        return true;
    }

    /* Valida y establece el valor del campo IdPromoCab */
    public function setIdPromoCab( $i_IdPromoCab, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdPromoCab, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdPromoCab ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdPromoCab( $i_IdPromoCab );
        return true;
    }

    /* Valida y establece el valor del campo TipoDetalle */
    public function setTipoDetalle( $s_TipoDetalle, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_TipoDetalle, "VARCHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo TipoDetalle ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setTipoDetalle( $s_TipoDetalle );
        return true;
    }

    /* Valida y establece el valor del campo DescripcionItem */
    public function setDescripcionItem( $s_DescripcionItem, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_DescripcionItem, "VARCHAR", 250, 0, false ) )
            {
                throw new Exception( "El campo DescripcionItem ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDescripcionItem( $s_DescripcionItem );
        return true;
    }

    /* Valida y establece el valor del campo CostoSinIGV */
    public function setCostoSinIGV( $f_CostoSinIGV, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_CostoSinIGV, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo CostoSinIGV ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setCostoSinIGV( $f_CostoSinIGV );
        return true;
    }

    /* Valida y establece el valor del campo CostoConIGV */
    public function setCostoConIGV( $f_CostoConIGV, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_CostoConIGV, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo CostoConIGV ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setCostoConIGV( $f_CostoConIGV );
        return true;
    }

    /* Valida y establece el valor del campo Cantidad */
    public function setCantidad( $f_Cantidad, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_Cantidad, "DECIMAL", 10, 2, false ) )
            {
                throw new Exception( "El campo Cantidad ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setCantidad( $f_Cantidad );
        return true;
    }

    /* Valida y establece el valor del campo PrecioSinIGV */
    public function setPrecioSinIGV( $f_PrecioSinIGV, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_PrecioSinIGV, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo PrecioSinIGV ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setPrecioSinIGV( $f_PrecioSinIGV );
        return true;
    }

    /* Valida y establece el valor del campo MontoIGV */
    public function setMontoIGV( $f_MontoIGV, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_MontoIGV, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo MontoIGV ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setMontoIGV( $f_MontoIGV );
        return true;
    }

    /* Valida y establece el valor del campo PrecioConIGV */
    public function setPrecioConIGV( $f_PrecioConIGV, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_PrecioConIGV, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo PrecioConIGV ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setPrecioConIGV( $f_PrecioConIGV );
        return true;
    }

    /* Valida y establece el valor del campo CostoConIGVTotal */
    public function setCostoConIGVTotal( $f_CostoConIGVTotal, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_CostoConIGVTotal, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo CostoConIGVTotal ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setCostoConIGVTotal( $f_CostoConIGVTotal );
        return true;
    }

    /* Valida y establece el valor del campo PrecioConIGVTotal */
    public function setPrecioConIGVTotal( $f_PrecioConIGVTotal, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_PrecioConIGVTotal, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo PrecioConIGVTotal ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setPrecioConIGVTotal( $f_PrecioConIGVTotal );
        return true;
    }

    /* Valida y establece el valor del campo CostoConIGVCalculado */
    public function setCostoConIGVCalculado( $f_CostoConIGVCalculado, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_CostoConIGVCalculado, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo CostoConIGVCalculado ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setCostoConIGVCalculado( $f_CostoConIGVCalculado );
        return true;
    }

    /* Valida y establece el valor del campo PrecioConIGVCalculado */
    public function setPrecioConIGVCalculado( $f_PrecioConIGVCalculado, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_PrecioConIGVCalculado, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo PrecioConIGVCalculado ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setPrecioConIGVCalculado( $f_PrecioConIGVCalculado );
        return true;
    }

    /* Valida el contenido del registro */
    public function validateRecord()
    {
        $this->setIdItemPromo( $this->getIdItemPromo(), false );
        $this->setIdItem( $this->getIdItem(), true );
        $this->setIdPromoCab( $this->getIdPromoCab(), true );
        $this->setTipoDetalle( $this->getTipoDetalle(), true );
        $this->setDescripcionItem( $this->getDescripcionItem(), true );
        $this->setCostoSinIGV( $this->getCostoSinIGV(), true );
        $this->setCostoConIGV( $this->getCostoConIGV(), true );
        $this->setCantidad( $this->getCantidad(), true );
        $this->setPrecioSinIGV( $this->getPrecioSinIGV(), true );
        $this->setMontoIGV( $this->getMontoIGV(), true );
        $this->setPrecioConIGV( $this->getPrecioConIGV(), true );
        $this->setCostoConIGVTotal( $this->getCostoConIGVTotal(), true );
        $this->setPrecioConIGVTotal( $this->getPrecioConIGVTotal(), true );
        $this->setCostoConIGVCalculado( $this->getCostoConIGVCalculado(), true );
        $this->setPrecioConIGVCalculado( $this->getPrecioConIGVCalculado(), true );
        return true;
    }
}
?>