<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: FCO_OrdenRecibo.xml */
/* Generado: 2020-08-18 04:21:26 */

/* Validacion del contenido de los campos campos de la tabla FCO_OrdenRecibo */
abstract class BaseFCO_OrdenReciboBV extends FCO_OrdenReciboBN
{
    /* Contiene la clase que valida el tipo de dato */
    private $o_Validator; // Contiene el objeto que realizara la validacion de tipo de dato.
    private $s_ValidatorMessage; // Contiene la ultima observacion de la validacion del tipo de dato.

    /* Constructor ( Establece la clase que valida los tipos de datos y establece los valores por defecto ) */
    public function __construct()
    {
        /* Establecemos el objeto que realizara la validacion del tipo de dato */
        $this->o_Validator = new utilValidDataType();

        /* Establecemos los valores por defecto */
    }

    /* Valida en tipo de dato */
    private function validateData( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull )
    {
        $this->s_ValidatorMessage = null;
        if( !$this->o_Validator->validate( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull ) )
        {
            $this->s_ValidatorMessage = $this->o_Validator->getMessage();
        }
        return is_null( $this->s_ValidatorMessage );
    }

    /* Valida y establece el valor del campo OrdenId */
    public function setOrdenId( $i_OrdenId, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_OrdenId, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo OrdenId ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setOrdenId( $i_OrdenId );
        return true;
    }

    /* Valida y establece el valor del campo IdDocRecibo */
    public function setIdDocRecibo( $i_IdDocRecibo, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdDocRecibo, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdDocRecibo ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdDocRecibo( $i_IdDocRecibo );
        return true;
    }

    /* Valida y establece el valor del campo OrdenNum */
    public function setOrdenNum( $s_OrdenNum, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_OrdenNum, "VARCHAR", 10, 0, false ) )
            {
                throw new Exception( "El campo OrdenNum ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setOrdenNum( $s_OrdenNum );
        return true;
    }

    /* Valida y establece el valor del campo IdMoneda */
    public function setIdMoneda( $s_IdMoneda, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdMoneda, "VARCHAR", 3, 0, false ) )
            {
                throw new Exception( "El campo IdMoneda ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdMoneda( $s_IdMoneda );
        return true;
    }

    /* Valida y establece el valor del campo TipoCambio */
    public function setTipoCambio( $f_TipoCambio, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_TipoCambio, "DECIMAL", 8, 4, false ) )
            {
                throw new Exception( "El campo TipoCambio ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setTipoCambio( $f_TipoCambio );
        return true;
    }

    /* Valida y establece el valor del campo MontoOrden */
    public function setMontoOrden( $f_MontoOrden, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_MontoOrden, "DECIMAL", 40, 25, false ) )
            {
                throw new Exception( "El campo MontoOrden ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setMontoOrden( $f_MontoOrden );
        return true;
    }

    /* Valida y establece el valor del campo MontoOrdenMN */
    public function setMontoOrdenMN( $f_MontoOrdenMN, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_MontoOrdenMN, "DECIMAL", 40, 25, false ) )
            {
                throw new Exception( "El campo MontoOrdenMN ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setMontoOrdenMN( $f_MontoOrdenMN );
        return true;
    }

    /* Valida y establece el valor del campo MontoOrdenME */
    public function setMontoOrdenME( $f_MontoOrdenME, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_MontoOrdenME, "DECIMAL", 40, 25, false ) )
            {
                throw new Exception( "El campo MontoOrdenME ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setMontoOrdenME( $f_MontoOrdenME );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioCreacion */
    public function setUsuarioCreacion( $s_UsuarioCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioCreacion, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo UsuarioCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioCreacion( $s_UsuarioCreacion );
        return true;
    }

    /* Valida y establece el valor del campo FechaCreacion */
    public function setFechaCreacion( $d_FechaCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaCreacion, "TIMESTAMP", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaCreacion( $d_FechaCreacion );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioModificacion */
    public function setUsuarioModificacion( $s_UsuarioModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioModificacion, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo UsuarioModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioModificacion( $s_UsuarioModificacion );
        return true;
    }

    /* Valida y establece el valor del campo FechaModificacion */
    public function setFechaModificacion( $d_FechaModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaModificacion, "TIMESTAMP", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaModificacion( $d_FechaModificacion );
        return true;
    }

    /* Valida el contenido del registro */
    public function validateRecord()
    {
        $this->setOrdenId( $this->getOrdenId(), false );
        $this->setIdDocRecibo( $this->getIdDocRecibo(), false );
        $this->setOrdenNum( $this->getOrdenNum(), true );
        $this->setIdMoneda( $this->getIdMoneda(), true );
        $this->setTipoCambio( $this->getTipoCambio(), true );
        $this->setMontoOrden( $this->getMontoOrden(), true );
        $this->setMontoOrdenMN( $this->getMontoOrdenMN(), true );
        $this->setMontoOrdenME( $this->getMontoOrdenME(), true );
        $this->setUsuarioCreacion( $this->getUsuarioCreacion(), true );
        $this->setFechaCreacion( $this->getFechaCreacion(), true );
        $this->setUsuarioModificacion( $this->getUsuarioModificacion(), true );
        $this->setFechaModificacion( $this->getFechaModificacion(), true );
        return true;
    }
}
?>