<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: CP_Obligaciones.xml */
/* Generado: 2021-09-02 06:54:24 */

/* Validacion del contenido de los campos campos de la tabla CP_Obligaciones */
abstract class BaseCP_ObligacionesBV extends CP_ObligacionesBN
{
    /* Contiene la clase que valida el tipo de dato */
    private $o_Validator; // Contiene el objeto que realizara la validacion de tipo de dato.
    private $s_ValidatorMessage; // Contiene la ultima observacion de la validacion del tipo de dato.

    /* Constructor ( Establece la clase que valida los tipos de datos y establece los valores por defecto ) */
    public function __construct()
    {
        /* Establecemos el objeto que realizara la validacion del tipo de dato */
        $this->o_Validator = new utilValidDataType();

        /* Establecemos los valores por defecto */
    }

    /* Valida en tipo de dato */
    private function validateData( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull )
    {
        $this->s_ValidatorMessage = null;
        if( !$this->o_Validator->validate( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull ) )
        {
            $this->s_ValidatorMessage = $this->o_Validator->getMessage();
        }
        return is_null( $this->s_ValidatorMessage );
    }

    /* Valida y establece el valor del campo ObligacionesId */
    public function setObligacionesId( $i_ObligacionesId, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_ObligacionesId, "INT", 10, 0, false ) )
            {
                throw new Exception( "El campo ObligacionesId ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setObligacionesId( $i_ObligacionesId );
        return true;
    }

    /* Valida y establece el valor del campo IdCompania */
    public function setIdCompania( $i_IdCompania, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdCompania, "INT", 10, 0, false ) )
            {
                throw new Exception( "El campo IdCompania ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdCompania( $i_IdCompania );
        return true;
    }

    /* Valida y establece el valor del campo IdSucursal */
    public function setIdSucursal( $i_IdSucursal, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdSucursal, "INT", 10, 0, false ) )
            {
                throw new Exception( "El campo IdSucursal ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdSucursal( $i_IdSucursal );
        return true;
    }

    /* Valida y establece el valor del campo IdTipoDocumento */
    public function setIdTipoDocumento( $s_IdTipoDocumento, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdTipoDocumento, "VARCHAR", 5, 0, false ) )
            {
                throw new Exception( "El campo IdTipoDocumento ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdTipoDocumento( $s_IdTipoDocumento );
        return true;
    }

    /* Valida y establece el valor del campo Periodo */
    public function setPeriodo( $s_Periodo, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Periodo, "VARCHAR", 6, 0, false ) )
            {
                throw new Exception( "El campo Periodo ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setPeriodo( $s_Periodo );
        return true;
    }

    /* Valida y establece el valor del campo FechaEmision */
    public function setFechaEmision( $d_FechaEmision, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaEmision, "DATE", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaEmision ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaEmision( $d_FechaEmision );
        return true;
    }

    /* Valida y establece el valor del campo FechaVencimiento */
    public function setFechaVencimiento( $d_FechaVencimiento, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaVencimiento, "DATE", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaVencimiento ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaVencimiento( $d_FechaVencimiento );
        return true;
    }

    /* Valida y establece el valor del campo FechaProgramacion */
    public function setFechaProgramacion( $d_FechaProgramacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaProgramacion, "DATE", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaProgramacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaProgramacion( $d_FechaProgramacion );
        return true;
    }

    /* Valida y establece el valor del campo DocumentoSerie */
    public function setDocumentoSerie( $s_DocumentoSerie, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_DocumentoSerie, "VARCHAR", 50, 0, false ) )
            {
                throw new Exception( "El campo DocumentoSerie ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDocumentoSerie( $s_DocumentoSerie );
        return true;
    }

    /* Valida y establece el valor del campo DocumentoNumero */
    public function setDocumentoNumero( $s_DocumentoNumero, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_DocumentoNumero, "VARCHAR", 50, 0, false ) )
            {
                throw new Exception( "El campo DocumentoNumero ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDocumentoNumero( $s_DocumentoNumero );
        return true;
    }

    /* Valida y establece el valor del campo DocumentoSerieNumero */
    public function setDocumentoSerieNumero( $s_DocumentoSerieNumero, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_DocumentoSerieNumero, "VARCHAR", 50, 0, false ) )
            {
                throw new Exception( "El campo DocumentoSerieNumero ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDocumentoSerieNumero( $s_DocumentoSerieNumero );
        return true;
    }

    /* Valida y establece el valor del campo NumeroOC */
    public function setNumeroOC( $i_NumeroOC, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_NumeroOC, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo NumeroOC ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setNumeroOC( $i_NumeroOC );
        return true;
    }

    /* Valida y establece el valor del campo ProveedorId */
    public function setProveedorId( $i_ProveedorId, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_ProveedorId, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo ProveedorId ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setProveedorId( $i_ProveedorId );
        return true;
    }

    /* Valida y establece el valor del campo ProveedorDocTipo */
    public function setProveedorDocTipo( $s_ProveedorDocTipo, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ProveedorDocTipo, "VARCHAR", 25, 0, false ) )
            {
                throw new Exception( "El campo ProveedorDocTipo ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setProveedorDocTipo( $s_ProveedorDocTipo );
        return true;
    }

    /* Valida y establece el valor del campo ProveedorDocNum */
    public function setProveedorDocNum( $s_ProveedorDocNum, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ProveedorDocNum, "VARCHAR", 25, 0, false ) )
            {
                throw new Exception( "El campo ProveedorDocNum ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setProveedorDocNum( $s_ProveedorDocNum );
        return true;
    }

    /* Valida y establece el valor del campo ProveedorNombre */
    public function setProveedorNombre( $s_ProveedorNombre, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ProveedorNombre, "VARCHAR", 250, 0, false ) )
            {
                throw new Exception( "El campo ProveedorNombre ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setProveedorNombre( $s_ProveedorNombre );
        return true;
    }

    /* Valida y establece el valor del campo IdProyecto */
    public function setIdProyecto( $i_IdProyecto, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdProyecto, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdProyecto ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdProyecto( $i_IdProyecto );
        return true;
    }

    /* Valida y establece el valor del campo ProyectoNombre */
    public function setProyectoNombre( $s_ProyectoNombre, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ProyectoNombre, "VARCHAR", 250, 0, false ) )
            {
                throw new Exception( "El campo ProyectoNombre ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setProyectoNombre( $s_ProyectoNombre );
        return true;
    }

    /* Valida y establece el valor del campo Descripcion */
    public function setDescripcion( $s_Descripcion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Descripcion, "VARCHAR", 250, 0, false ) )
            {
                throw new Exception( "El campo Descripcion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDescripcion( $s_Descripcion );
        return true;
    }

    /* Valida y establece el valor del campo TerminoId */
    public function setTerminoId( $i_TerminoId, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_TerminoId, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo TerminoId ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setTerminoId( $i_TerminoId );
        return true;
    }

    /* Valida y establece el valor del campo MetodoPagoId */
    public function setMetodoPagoId( $i_MetodoPagoId, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_MetodoPagoId, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo MetodoPagoId ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setMetodoPagoId( $i_MetodoPagoId );
        return true;
    }

    /* Valida y establece el valor del campo IdMoneda */
    public function setIdMoneda( $s_IdMoneda, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdMoneda, "VARCHAR", 2, 0, false ) )
            {
                throw new Exception( "El campo IdMoneda ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdMoneda( $s_IdMoneda );
        return true;
    }

    /* Valida y establece el valor del campo TipoCambio */
    public function setTipoCambio( $f_TipoCambio, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_TipoCambio, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo TipoCambio ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setTipoCambio( $f_TipoCambio );
        return true;
    }

    /* Valida y establece el valor del campo AfectoIGV */
    public function setAfectoIGV( $i_AfectoIGV, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_AfectoIGV, "SMALLINT", 6, 0, false ) )
            {
                throw new Exception( "El campo AfectoIGV ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setAfectoIGV( $i_AfectoIGV );
        return true;
    }

    /* Valida y establece el valor del campo MontoAfecto */
    public function setMontoAfecto( $f_MontoAfecto, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_MontoAfecto, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo MontoAfecto ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setMontoAfecto( $f_MontoAfecto );
        return true;
    }

    /* Valida y establece el valor del campo MontoAfectoMN */
    public function setMontoAfectoMN( $f_MontoAfectoMN, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_MontoAfectoMN, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo MontoAfectoMN ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setMontoAfectoMN( $f_MontoAfectoMN );
        return true;
    }

    /* Valida y establece el valor del campo MontoNoAfecto */
    public function setMontoNoAfecto( $f_MontoNoAfecto, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_MontoNoAfecto, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo MontoNoAfecto ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setMontoNoAfecto( $f_MontoNoAfecto );
        return true;
    }

    /* Valida y establece el valor del campo MontoNoAfectoMN */
    public function setMontoNoAfectoMN( $f_MontoNoAfectoMN, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_MontoNoAfectoMN, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo MontoNoAfectoMN ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setMontoNoAfectoMN( $f_MontoNoAfectoMN );
        return true;
    }

    /* Valida y establece el valor del campo MontoIGV */
    public function setMontoIGV( $f_MontoIGV, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_MontoIGV, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo MontoIGV ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setMontoIGV( $f_MontoIGV );
        return true;
    }

    /* Valida y establece el valor del campo MontoIGVMN */
    public function setMontoIGVMN( $f_MontoIGVMN, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_MontoIGVMN, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo MontoIGVMN ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setMontoIGVMN( $f_MontoIGVMN );
        return true;
    }

    /* Valida y establece el valor del campo MontoTotal */
    public function setMontoTotal( $f_MontoTotal, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_MontoTotal, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo MontoTotal ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setMontoTotal( $f_MontoTotal );
        return true;
    }

    /* Valida y establece el valor del campo MontoTotalMN */
    public function setMontoTotalMN( $f_MontoTotalMN, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_MontoTotalMN, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo MontoTotalMN ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setMontoTotalMN( $f_MontoTotalMN );
        return true;
    }

    /* Valida y establece el valor del campo MontoPagado */
    public function setMontoPagado( $f_MontoPagado, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_MontoPagado, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo MontoPagado ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setMontoPagado( $f_MontoPagado );
        return true;
    }

    /* Valida y establece el valor del campo MontoPagadoMN */
    public function setMontoPagadoMN( $f_MontoPagadoMN, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_MontoPagadoMN, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo MontoPagadoMN ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setMontoPagadoMN( $f_MontoPagadoMN );
        return true;
    }

    /* Valida y establece el valor del campo MontoSaldo */
    public function setMontoSaldo( $f_MontoSaldo, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_MontoSaldo, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo MontoSaldo ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setMontoSaldo( $f_MontoSaldo );
        return true;
    }

    /* Valida y establece el valor del campo MontoSaldoMN */
    public function setMontoSaldoMN( $f_MontoSaldoMN, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_MontoSaldoMN, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo MontoSaldoMN ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setMontoSaldoMN( $f_MontoSaldoMN );
        return true;
    }

    /* Valida y establece el valor del campo ComprobanteRefId */
    public function setComprobanteRefId( $i_ComprobanteRefId, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_ComprobanteRefId, "INT", 10, 0, false ) )
            {
                throw new Exception( "El campo ComprobanteRefId ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setComprobanteRefId( $i_ComprobanteRefId );
        return true;
    }

    /* Valida y establece el valor del campo ComprobanteTipoRefId */
    public function setComprobanteTipoRefId( $s_ComprobanteTipoRefId, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ComprobanteTipoRefId, "VARCHAR", 50, 0, false ) )
            {
                throw new Exception( "El campo ComprobanteTipoRefId ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setComprobanteTipoRefId( $s_ComprobanteTipoRefId );
        return true;
    }

    /* Valida y establece el valor del campo ComprobanteSerieNumeroRef */
    public function setComprobanteSerieNumeroRef( $s_ComprobanteSerieNumeroRef, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ComprobanteSerieNumeroRef, "VARCHAR", 50, 0, false ) )
            {
                throw new Exception( "El campo ComprobanteSerieNumeroRef ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setComprobanteSerieNumeroRef( $s_ComprobanteSerieNumeroRef );
        return true;
    }

    /* Valida y establece el valor del campo ComprobanteFechaEmisionRef */
    public function setComprobanteFechaEmisionRef( $d_ComprobanteFechaEmisionRef, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_ComprobanteFechaEmisionRef, "DATE", 0, 0, false ) )
            {
                throw new Exception( "El campo ComprobanteFechaEmisionRef ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setComprobanteFechaEmisionRef( $d_ComprobanteFechaEmisionRef );
        return true;
    }

    /* Valida y establece el valor del campo Estado */
    public function setEstado( $s_Estado, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Estado, "VARCHAR", 2, 0, false ) )
            {
                throw new Exception( "El campo Estado ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setEstado( $s_Estado );
        return true;
    }

    /* Valida y establece el valor del campo EstadoPagado */
    public function setEstadoPagado( $s_EstadoPagado, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_EstadoPagado, "VARCHAR", 2, 0, false ) )
            {
                throw new Exception( "El campo EstadoPagado ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setEstadoPagado( $s_EstadoPagado );
        return true;
    }

    /* Valida y establece el valor del campo FechaPago */
    public function setFechaPago( $d_FechaPago, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaPago, "DATETIME", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaPago ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaPago( $d_FechaPago );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioCreacion */
    public function setUsuarioCreacion( $s_UsuarioCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioCreacion, "VARCHAR", 50, 0, false ) )
            {
                throw new Exception( "El campo UsuarioCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioCreacion( $s_UsuarioCreacion );
        return true;
    }

    /* Valida y establece el valor del campo FechaCreacion */
    public function setFechaCreacion( $d_FechaCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaCreacion, "TIMESTAMP", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaCreacion( $d_FechaCreacion );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioModificacion */
    public function setUsuarioModificacion( $s_UsuarioModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioModificacion, "VARCHAR", 50, 0, false ) )
            {
                throw new Exception( "El campo UsuarioModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioModificacion( $s_UsuarioModificacion );
        return true;
    }

    /* Valida y establece el valor del campo FechaModificacion */
    public function setFechaModificacion( $d_FechaModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaModificacion, "TIMESTAMP", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaModificacion( $d_FechaModificacion );
        return true;
    }

    /* Valida el contenido del registro */
    public function validateRecord()
    {
        $this->setObligacionesId( $this->getObligacionesId(), false );
        $this->setIdCompania( $this->getIdCompania(), true );
        $this->setIdSucursal( $this->getIdSucursal(), true );
        $this->setIdTipoDocumento( $this->getIdTipoDocumento(), true );
        $this->setPeriodo( $this->getPeriodo(), true );
        $this->setFechaEmision( $this->getFechaEmision(), true );
        $this->setFechaVencimiento( $this->getFechaVencimiento(), true );
        $this->setFechaProgramacion( $this->getFechaProgramacion(), true );
        $this->setDocumentoSerie( $this->getDocumentoSerie(), true );
        $this->setDocumentoNumero( $this->getDocumentoNumero(), true );
        $this->setDocumentoSerieNumero( $this->getDocumentoSerieNumero(), true );
        $this->setNumeroOC( $this->getNumeroOC(), true );
        $this->setProveedorId( $this->getProveedorId(), true );
        $this->setProveedorDocTipo( $this->getProveedorDocTipo(), true );
        $this->setProveedorDocNum( $this->getProveedorDocNum(), true );
        $this->setProveedorNombre( $this->getProveedorNombre(), true );
        $this->setIdProyecto( $this->getIdProyecto(), true );
        $this->setProyectoNombre( $this->getProyectoNombre(), true );
        $this->setDescripcion( $this->getDescripcion(), true );
        $this->setTerminoId( $this->getTerminoId(), true );
        $this->setMetodoPagoId( $this->getMetodoPagoId(), true );
        $this->setIdMoneda( $this->getIdMoneda(), true );
        $this->setTipoCambio( $this->getTipoCambio(), true );
        $this->setAfectoIGV( $this->getAfectoIGV(), true );
        $this->setMontoAfecto( $this->getMontoAfecto(), true );
        $this->setMontoAfectoMN( $this->getMontoAfectoMN(), true );
        $this->setMontoNoAfecto( $this->getMontoNoAfecto(), true );
        $this->setMontoNoAfectoMN( $this->getMontoNoAfectoMN(), true );
        $this->setMontoIGV( $this->getMontoIGV(), true );
        $this->setMontoIGVMN( $this->getMontoIGVMN(), true );
        $this->setMontoTotal( $this->getMontoTotal(), true );
        $this->setMontoTotalMN( $this->getMontoTotalMN(), true );
        $this->setMontoPagado( $this->getMontoPagado(), true );
        $this->setMontoPagadoMN( $this->getMontoPagadoMN(), true );
        $this->setMontoSaldo( $this->getMontoSaldo(), true );
        $this->setMontoSaldoMN( $this->getMontoSaldoMN(), true );
        $this->setComprobanteRefId( $this->getComprobanteRefId(), true );
        $this->setComprobanteTipoRefId( $this->getComprobanteTipoRefId(), true );
        $this->setComprobanteSerieNumeroRef( $this->getComprobanteSerieNumeroRef(), true );
        $this->setComprobanteFechaEmisionRef( $this->getComprobanteFechaEmisionRef(), true );
        $this->setEstado( $this->getEstado(), true );
        $this->setEstadoPagado( $this->getEstadoPagado(), true );
        $this->setFechaPago( $this->getFechaPago(), true );
        $this->setUsuarioCreacion( $this->getUsuarioCreacion(), true );
        $this->setFechaCreacion( $this->getFechaCreacion(), true );
        $this->setUsuarioModificacion( $this->getUsuarioModificacion(), true );
        $this->setFechaModificacion( $this->getFechaModificacion(), true );
        return true;
    }
}
?>