<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: CP_DocRecibo.xml */
/* Generado: 2021-10-19 07:59:09 */

/* Validacion del contenido de los campos campos de la tabla CP_DocRecibo */
abstract class BaseCP_DocReciboBV extends CP_DocReciboBN
{
    /* Contiene la clase que valida el tipo de dato */
    private $o_Validator; // Contiene el objeto que realizara la validacion de tipo de dato.
    private $s_ValidatorMessage; // Contiene la ultima observacion de la validacion del tipo de dato.

    /* Constructor ( Establece la clase que valida los tipos de datos y establece los valores por defecto ) */
    public function __construct()
    {
        /* Establecemos el objeto que realizara la validacion del tipo de dato */
        $this->o_Validator = new utilValidDataType();

        /* Establecemos los valores por defecto */
    }

    /* Valida en tipo de dato */
    private function validateData( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull )
    {
        $this->s_ValidatorMessage = null;
        if( !$this->o_Validator->validate( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull ) )
        {
            $this->s_ValidatorMessage = $this->o_Validator->getMessage();
        }
        return is_null( $this->s_ValidatorMessage );
    }

    /* Valida y establece el valor del campo IdDocRecibo */
    public function setIdDocRecibo( $i_IdDocRecibo, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdDocRecibo, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdDocRecibo ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdDocRecibo( $i_IdDocRecibo );
        return true;
    }

    /* Valida y establece el valor del campo IdCompania */
    public function setIdCompania( $i_IdCompania, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdCompania, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdCompania ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdCompania( $i_IdCompania );
        return true;
    }

    /* Valida y establece el valor del campo IdSucursal */
    public function setIdSucursal( $i_IdSucursal, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdSucursal, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdSucursal ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdSucursal( $i_IdSucursal );
        return true;
    }

    /* Valida y establece el valor del campo ParentId */
    public function setParentId( $i_ParentId, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_ParentId, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo ParentId ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setParentId( $i_ParentId );
        return true;
    }

    /* Valida y establece el valor del campo ParentCod */
    public function setParentCod( $s_ParentCod, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ParentCod, "VARCHAR", 10, 0, false ) )
            {
                throw new Exception( "El campo ParentCod ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setParentCod( $s_ParentCod );
        return true;
    }

    /* Valida y establece el valor del campo IdTipoPago */
    public function setIdTipoPago( $i_IdTipoPago, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdTipoPago, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdTipoPago ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdTipoPago( $i_IdTipoPago );
        return true;
    }

    /* Valida y establece el valor del campo IdMoneda */
    public function setIdMoneda( $s_IdMoneda, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdMoneda, "VARCHAR", 3, 0, false ) )
            {
                throw new Exception( "El campo IdMoneda ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdMoneda( $s_IdMoneda );
        return true;
    }

    /* Valida y establece el valor del campo MonedaDes */
    public function setMonedaDes( $s_MonedaDes, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_MonedaDes, "VARCHAR", 250, 0, false ) )
            {
                throw new Exception( "El campo MonedaDes ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setMonedaDes( $s_MonedaDes );
        return true;
    }

    /* Valida y establece el valor del campo ReciboNumero */
    public function setReciboNumero( $s_ReciboNumero, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ReciboNumero, "VARCHAR", 15, 0, false ) )
            {
                throw new Exception( "El campo ReciboNumero ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setReciboNumero( $s_ReciboNumero );
        return true;
    }

    /* Valida y establece el valor del campo ReciboFecha */
    public function setReciboFecha( $d_ReciboFecha, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_ReciboFecha, "DATE", 0, 0, false ) )
            {
                throw new Exception( "El campo ReciboFecha ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setReciboFecha( $d_ReciboFecha );
        return true;
    }

    /* Valida y establece el valor del campo IdBanco */
    public function setIdBanco( $i_IdBanco, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdBanco, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdBanco ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdBanco( $i_IdBanco );
        return true;
    }

    /* Valida y establece el valor del campo IdCuenta */
    public function setIdCuenta( $i_IdCuenta, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdCuenta, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdCuenta ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdCuenta( $i_IdCuenta );
        return true;
    }

    /* Valida y establece el valor del campo NumeroCuenta */
    public function setNumeroCuenta( $s_NumeroCuenta, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_NumeroCuenta, "VARCHAR", 50, 0, false ) )
            {
                throw new Exception( "El campo NumeroCuenta ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setNumeroCuenta( $s_NumeroCuenta );
        return true;
    }

    /* Valida y establece el valor del campo TerminoPago */
    public function setTerminoPago( $i_TerminoPago, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_TerminoPago, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo TerminoPago ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setTerminoPago( $i_TerminoPago );
        return true;
    }

    /* Valida y establece el valor del campo FechaVencimiento */
    public function setFechaVencimiento( $d_FechaVencimiento, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaVencimiento, "DATE", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaVencimiento ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaVencimiento( $d_FechaVencimiento );
        return true;
    }

    /* Valida y establece el valor del campo IdNumeroDocumento */
    public function setIdNumeroDocumento( $s_IdNumeroDocumento, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdNumeroDocumento, "VARCHAR", 20, 0, false ) )
            {
                throw new Exception( "El campo IdNumeroDocumento ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdNumeroDocumento( $s_IdNumeroDocumento );
        return true;
    }

    /* Valida y establece el valor del campo ClaseNombre */
    public function setClaseNombre( $s_ClaseNombre, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ClaseNombre, "VARCHAR", 100, 0, false ) )
            {
                throw new Exception( "El campo ClaseNombre ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setClaseNombre( $s_ClaseNombre );
        return true;
    }

    /* Valida y establece el valor del campo TipoCambio */
    public function setTipoCambio( $f_TipoCambio, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_TipoCambio, "DECIMAL", 10, 4, false ) )
            {
                throw new Exception( "El campo TipoCambio ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setTipoCambio( $f_TipoCambio );
        return true;
    }

    /* Valida y establece el valor del campo IdPersona */
    public function setIdPersona( $i_IdPersona, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdPersona, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdPersona ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdPersona( $i_IdPersona );
        return true;
    }

    /* Valida y establece el valor del campo TipoDocCliente */
    public function setTipoDocCliente( $s_TipoDocCliente, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_TipoDocCliente, "VARCHAR", 20, 0, false ) )
            {
                throw new Exception( "El campo TipoDocCliente ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setTipoDocCliente( $s_TipoDocCliente );
        return true;
    }

    /* Valida y establece el valor del campo NumTipoDocCliente */
    public function setNumTipoDocCliente( $s_NumTipoDocCliente, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_NumTipoDocCliente, "VARCHAR", 20, 0, false ) )
            {
                throw new Exception( "El campo NumTipoDocCliente ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setNumTipoDocCliente( $s_NumTipoDocCliente );
        return true;
    }

    /* Valida y establece el valor del campo NombreCliente */
    public function setNombreCliente( $s_NombreCliente, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_NombreCliente, "VARCHAR", 250, 0, false ) )
            {
                throw new Exception( "El campo NombreCliente ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setNombreCliente( $s_NombreCliente );
        return true;
    }

    /* Valida y establece el valor del campo Descripcion */
    public function setDescripcion( $s_Descripcion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Descripcion, "VARCHAR", 250, 0, false ) )
            {
                throw new Exception( "El campo Descripcion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDescripcion( $s_Descripcion );
        return true;
    }

    /* Valida y establece el valor del campo Monto */
    public function setMonto( $f_Monto, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_Monto, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo Monto ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setMonto( $f_Monto );
        return true;
    }

    /* Valida y establece el valor del campo Saldo */
    public function setSaldo( $f_Saldo, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_Saldo, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo Saldo ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setSaldo( $f_Saldo );
        return true;
    }

    /* Valida y establece el valor del campo MontoMN */
    public function setMontoMN( $f_MontoMN, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_MontoMN, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo MontoMN ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setMontoMN( $f_MontoMN );
        return true;
    }

    /* Valida y establece el valor del campo SaldoMN */
    public function setSaldoMN( $f_SaldoMN, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_SaldoMN, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo SaldoMN ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setSaldoMN( $f_SaldoMN );
        return true;
    }

    /* Valida y establece el valor del campo MontoME */
    public function setMontoME( $f_MontoME, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_MontoME, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo MontoME ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setMontoME( $f_MontoME );
        return true;
    }

    /* Valida y establece el valor del campo SaldoME */
    public function setSaldoME( $f_SaldoME, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_SaldoME, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo SaldoME ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setSaldoME( $f_SaldoME );
        return true;
    }

    /* Valida y establece el valor del campo FechaAprobacion */
    public function setFechaAprobacion( $d_FechaAprobacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaAprobacion, "DATETIME", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaAprobacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaAprobacion( $d_FechaAprobacion );
        return true;
    }

    /* Valida y establece el valor del campo ApruebaUsuario */
    public function setApruebaUsuario( $s_ApruebaUsuario, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ApruebaUsuario, "VARCHAR", 25, 0, false ) )
            {
                throw new Exception( "El campo ApruebaUsuario ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setApruebaUsuario( $s_ApruebaUsuario );
        return true;
    }

    /* Valida y establece el valor del campo FechaCobranza */
    public function setFechaCobranza( $d_FechaCobranza, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaCobranza, "DATETIME", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaCobranza ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaCobranza( $d_FechaCobranza );
        return true;
    }

    /* Valida y establece el valor del campo CobranzaEstado */
    public function setCobranzaEstado( $s_CobranzaEstado, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_CobranzaEstado, "VARCHAR", 2, 0, false ) )
            {
                throw new Exception( "El campo CobranzaEstado ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setCobranzaEstado( $s_CobranzaEstado );
        return true;
    }

    /* Valida y establece el valor del campo FlujoEstado */
    public function setFlujoEstado( $s_FlujoEstado, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_FlujoEstado, "VARCHAR", 2, 0, false ) )
            {
                throw new Exception( "El campo FlujoEstado ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFlujoEstado( $s_FlujoEstado );
        return true;
    }

    /* Valida y establece el valor del campo Estado */
    public function setEstado( $s_Estado, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Estado, "VARCHAR", 2, 0, false ) )
            {
                throw new Exception( "El campo Estado ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setEstado( $s_Estado );
        return true;
    }

    /* Valida y establece el valor del campo FechaCreacion */
    public function setFechaCreacion( $d_FechaCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaCreacion, "TIMESTAMP", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaCreacion( $d_FechaCreacion );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioCreacion */
    public function setUsuarioCreacion( $s_UsuarioCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioCreacion, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo UsuarioCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioCreacion( $s_UsuarioCreacion );
        return true;
    }

    /* Valida y establece el valor del campo FechaModificacion */
    public function setFechaModificacion( $d_FechaModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaModificacion, "TIMESTAMP", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaModificacion( $d_FechaModificacion );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioModificacion */
    public function setUsuarioModificacion( $s_UsuarioModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioModificacion, "VARCHAR", 60, 0, false ) )
            {
                throw new Exception( "El campo UsuarioModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioModificacion( $s_UsuarioModificacion );
        return true;
    }

    /* Valida el contenido del registro */
    public function validateRecord()
    {
        $this->setIdDocRecibo( $this->getIdDocRecibo(), false );
        $this->setIdCompania( $this->getIdCompania(), true );
        $this->setIdSucursal( $this->getIdSucursal(), true );
        $this->setParentId( $this->getParentId(), true );
        $this->setParentCod( $this->getParentCod(), true );
        $this->setIdTipoPago( $this->getIdTipoPago(), true );
        $this->setIdMoneda( $this->getIdMoneda(), true );
        $this->setMonedaDes( $this->getMonedaDes(), true );
        $this->setReciboNumero( $this->getReciboNumero(), true );
        $this->setReciboFecha( $this->getReciboFecha(), true );
        $this->setIdBanco( $this->getIdBanco(), true );
        $this->setIdCuenta( $this->getIdCuenta(), true );
        $this->setNumeroCuenta( $this->getNumeroCuenta(), true );
        $this->setTerminoPago( $this->getTerminoPago(), true );
        $this->setFechaVencimiento( $this->getFechaVencimiento(), true );
        $this->setIdNumeroDocumento( $this->getIdNumeroDocumento(), true );
        $this->setClaseNombre( $this->getClaseNombre(), true );
        $this->setTipoCambio( $this->getTipoCambio(), true );
        $this->setIdPersona( $this->getIdPersona(), true );
        $this->setTipoDocCliente( $this->getTipoDocCliente(), true );
        $this->setNumTipoDocCliente( $this->getNumTipoDocCliente(), true );
        $this->setNombreCliente( $this->getNombreCliente(), true );
        $this->setDescripcion( $this->getDescripcion(), true );
        $this->setMonto( $this->getMonto(), true );
        $this->setSaldo( $this->getSaldo(), true );
        $this->setMontoMN( $this->getMontoMN(), true );
        $this->setSaldoMN( $this->getSaldoMN(), true );
        $this->setMontoME( $this->getMontoME(), true );
        $this->setSaldoME( $this->getSaldoME(), true );
        $this->setFechaAprobacion( $this->getFechaAprobacion(), true );
        $this->setApruebaUsuario( $this->getApruebaUsuario(), true );
        $this->setFechaCobranza( $this->getFechaCobranza(), true );
        $this->setCobranzaEstado( $this->getCobranzaEstado(), true );
        $this->setFlujoEstado( $this->getFlujoEstado(), true );
        $this->setEstado( $this->getEstado(), true );
        $this->setFechaCreacion( $this->getFechaCreacion(), true );
        $this->setUsuarioCreacion( $this->getUsuarioCreacion(), true );
        $this->setFechaModificacion( $this->getFechaModificacion(), true );
        $this->setUsuarioModificacion( $this->getUsuarioModificacion(), true );
        return true;
    }
}
?>