<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: CP_Aplicacion.xml */
/* Generado: 2021-10-19 08:12:22 */

/* Validacion del contenido de los campos campos de la tabla CP_Aplicacion */
abstract class BaseCP_AplicacionBV extends CP_AplicacionBN
{
    /* Contiene la clase que valida el tipo de dato */
    private $o_Validator; // Contiene el objeto que realizara la validacion de tipo de dato.
    private $s_ValidatorMessage; // Contiene la ultima observacion de la validacion del tipo de dato.

    /* Constructor ( Establece la clase que valida los tipos de datos y establece los valores por defecto ) */
    public function __construct()
    {
        /* Establecemos el objeto que realizara la validacion del tipo de dato */
        $this->o_Validator = new utilValidDataType();

        /* Establecemos los valores por defecto */
    }

    /* Valida en tipo de dato */
    private function validateData( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull )
    {
        $this->s_ValidatorMessage = null;
        if( !$this->o_Validator->validate( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull ) )
        {
            $this->s_ValidatorMessage = $this->o_Validator->getMessage();
        }
        return is_null( $this->s_ValidatorMessage );
    }

    /* Valida y establece el valor del campo IdAplicacion */
    public function setIdAplicacion( $i_IdAplicacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdAplicacion, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdAplicacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdAplicacion( $i_IdAplicacion );
        return true;
    }

    /* Valida y establece el valor del campo IdParent */
    public function setIdParent( $i_IdParent, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdParent, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdParent ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdParent( $i_IdParent );
        return true;
    }

    /* Valida y establece el valor del campo IdCompania */
    public function setIdCompania( $i_IdCompania, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdCompania, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdCompania ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdCompania( $i_IdCompania );
        return true;
    }

    /* Valida y establece el valor del campo IdSucursal */
    public function setIdSucursal( $i_IdSucursal, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdSucursal, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdSucursal ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdSucursal( $i_IdSucursal );
        return true;
    }

    /* Valida y establece el valor del campo IdTipoPago */
    public function setIdTipoPago( $i_IdTipoPago, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdTipoPago, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdTipoPago ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdTipoPago( $i_IdTipoPago );
        return true;
    }

    /* Valida y establece el valor del campo IdCaja */
    public function setIdCaja( $i_IdCaja, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdCaja, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdCaja ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdCaja( $i_IdCaja );
        return true;
    }

    /* Valida y establece el valor del campo IdTurno */
    public function setIdTurno( $i_IdTurno, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdTurno, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdTurno ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdTurno( $i_IdTurno );
        return true;
    }

    /* Valida y establece el valor del campo IdCierre */
    public function setIdCierre( $i_IdCierre, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdCierre, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdCierre ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdCierre( $i_IdCierre );
        return true;
    }

    /* Valida y establece el valor del campo IdBanco */
    public function setIdBanco( $i_IdBanco, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdBanco, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdBanco ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdBanco( $i_IdBanco );
        return true;
    }

    /* Valida y establece el valor del campo IdCuenta */
    public function setIdCuenta( $i_IdCuenta, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdCuenta, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdCuenta ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdCuenta( $i_IdCuenta );
        return true;
    }

    /* Valida y establece el valor del campo IdMoneda */
    public function setIdMoneda( $s_IdMoneda, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdMoneda, "VARCHAR", 3, 0, false ) )
            {
                throw new Exception( "El campo IdMoneda ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdMoneda( $s_IdMoneda );
        return true;
    }

    /* Valida y establece el valor del campo MonedaDes */
    public function setMonedaDes( $s_MonedaDes, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_MonedaDes, "VARCHAR", 250, 0, false ) )
            {
                throw new Exception( "El campo MonedaDes ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setMonedaDes( $s_MonedaDes );
        return true;
    }

    /* Valida y establece el valor del campo TipoCambio */
    public function setTipoCambio( $f_TipoCambio, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_TipoCambio, "DECIMAL", 10, 4, false ) )
            {
                throw new Exception( "El campo TipoCambio ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setTipoCambio( $f_TipoCambio );
        return true;
    }

    /* Valida y establece el valor del campo TipoPagoNombre */
    public function setTipoPagoNombre( $s_TipoPagoNombre, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_TipoPagoNombre, "VARCHAR", 250, 0, false ) )
            {
                throw new Exception( "El campo TipoPagoNombre ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setTipoPagoNombre( $s_TipoPagoNombre );
        return true;
    }

    /* Valida y establece el valor del campo IdPersona */
    public function setIdPersona( $i_IdPersona, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdPersona, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdPersona ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdPersona( $i_IdPersona );
        return true;
    }

    /* Valida y establece el valor del campo TipoDocCliente */
    public function setTipoDocCliente( $s_TipoDocCliente, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_TipoDocCliente, "VARCHAR", 20, 0, false ) )
            {
                throw new Exception( "El campo TipoDocCliente ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setTipoDocCliente( $s_TipoDocCliente );
        return true;
    }

    /* Valida y establece el valor del campo NumTipoDocCliente */
    public function setNumTipoDocCliente( $s_NumTipoDocCliente, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_NumTipoDocCliente, "VARCHAR", 20, 0, false ) )
            {
                throw new Exception( "El campo NumTipoDocCliente ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setNumTipoDocCliente( $s_NumTipoDocCliente );
        return true;
    }

    /* Valida y establece el valor del campo NombreCliente */
    public function setNombreCliente( $s_NombreCliente, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_NombreCliente, "VARCHAR", 250, 0, false ) )
            {
                throw new Exception( "El campo NombreCliente ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setNombreCliente( $s_NombreCliente );
        return true;
    }

    /* Valida y establece el valor del campo NombreTipo */
    public function setNombreTipo( $s_NombreTipo, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_NombreTipo, "VARCHAR", 100, 0, false ) )
            {
                throw new Exception( "El campo NombreTipo ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setNombreTipo( $s_NombreTipo );
        return true;
    }

    /* Valida y establece el valor del campo ClaseNombre */
    public function setClaseNombre( $s_ClaseNombre, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ClaseNombre, "VARCHAR", 100, 0, false ) )
            {
                throw new Exception( "El campo ClaseNombre ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setClaseNombre( $s_ClaseNombre );
        return true;
    }

    /* Valida y establece el valor del campo Descripcion */
    public function setDescripcion( $s_Descripcion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Descripcion, "VARCHAR", 100, 0, false ) )
            {
                throw new Exception( "El campo Descripcion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDescripcion( $s_Descripcion );
        return true;
    }

    /* Valida y establece el valor del campo ReciboNumero */
    public function setReciboNumero( $s_ReciboNumero, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ReciboNumero, "VARCHAR", 25, 0, false ) )
            {
                throw new Exception( "El campo ReciboNumero ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setReciboNumero( $s_ReciboNumero );
        return true;
    }

    /* Valida y establece el valor del campo IdDocRecibo */
    public function setIdDocRecibo( $i_IdDocRecibo, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdDocRecibo, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdDocRecibo ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdDocRecibo( $i_IdDocRecibo );
        return true;
    }

    /* Valida y establece el valor del campo IdNumeroDocumento */
    public function setIdNumeroDocumento( $s_IdNumeroDocumento, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdNumeroDocumento, "VARCHAR", 20, 0, false ) )
            {
                throw new Exception( "El campo IdNumeroDocumento ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdNumeroDocumento( $s_IdNumeroDocumento );
        return true;
    }

    /* Valida y establece el valor del campo IdDocNumRef */
    public function setIdDocNumRef( $s_IdDocNumRef, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdDocNumRef, "VARCHAR", 20, 0, false ) )
            {
                throw new Exception( "El campo IdDocNumRef ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdDocNumRef( $s_IdDocNumRef );
        return true;
    }

    /* Valida y establece el valor del campo CodDocRef */
    public function setCodDocRef( $s_CodDocRef, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_CodDocRef, "VARCHAR", 5, 0, false ) )
            {
                throw new Exception( "El campo CodDocRef ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setCodDocRef( $s_CodDocRef );
        return true;
    }

    /* Valida y establece el valor del campo SerieNumeroDocRef */
    public function setSerieNumeroDocRef( $s_SerieNumeroDocRef, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_SerieNumeroDocRef, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo SerieNumeroDocRef ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setSerieNumeroDocRef( $s_SerieNumeroDocRef );
        return true;
    }

    /* Valida y establece el valor del campo MontoTotalDocRef */
    public function setMontoTotalDocRef( $f_MontoTotalDocRef, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_MontoTotalDocRef, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo MontoTotalDocRef ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setMontoTotalDocRef( $f_MontoTotalDocRef );
        return true;
    }

    /* Valida y establece el valor del campo SaldoDocRef */
    public function setSaldoDocRef( $f_SaldoDocRef, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_SaldoDocRef, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo SaldoDocRef ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setSaldoDocRef( $f_SaldoDocRef );
        return true;
    }

    /* Valida y establece el valor del campo FechaDocRef */
    public function setFechaDocRef( $d_FechaDocRef, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaDocRef, "DATETIME", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaDocRef ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaDocRef( $d_FechaDocRef );
        return true;
    }

    /* Valida y establece el valor del campo FechaDocVenRef */
    public function setFechaDocVenRef( $d_FechaDocVenRef, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaDocVenRef, "DATE", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaDocVenRef ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaDocVenRef( $d_FechaDocVenRef );
        return true;
    }

    /* Valida y establece el valor del campo IdMonedaRef */
    public function setIdMonedaRef( $s_IdMonedaRef, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdMonedaRef, "VARCHAR", 3, 0, false ) )
            {
                throw new Exception( "El campo IdMonedaRef ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdMonedaRef( $s_IdMonedaRef );
        return true;
    }

    /* Valida y establece el valor del campo TipoCambioRef */
    public function setTipoCambioRef( $f_TipoCambioRef, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_TipoCambioRef, "DECIMAL", 10, 4, false ) )
            {
                throw new Exception( "El campo TipoCambioRef ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setTipoCambioRef( $f_TipoCambioRef );
        return true;
    }

    /* Valida y establece el valor del campo CodVendedorRef */
    public function setCodVendedorRef( $s_CodVendedorRef, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_CodVendedorRef, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo CodVendedorRef ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setCodVendedorRef( $s_CodVendedorRef );
        return true;
    }

    /* Valida y establece el valor del campo IdAlmacenRef */
    public function setIdAlmacenRef( $s_IdAlmacenRef, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdAlmacenRef, "VARCHAR", 10, 0, false ) )
            {
                throw new Exception( "El campo IdAlmacenRef ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdAlmacenRef( $s_IdAlmacenRef );
        return true;
    }

    /* Valida y establece el valor del campo Periodo */
    public function setPeriodo( $s_Periodo, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Periodo, "VARCHAR", 6, 0, false ) )
            {
                throw new Exception( "El campo Periodo ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setPeriodo( $s_Periodo );
        return true;
    }

    /* Valida y establece el valor del campo FechaAplicacion */
    public function setFechaAplicacion( $d_FechaAplicacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaAplicacion, "DATETIME", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaAplicacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaAplicacion( $d_FechaAplicacion );
        return true;
    }

    /* Valida y establece el valor del campo MontoAplicado */
    public function setMontoAplicado( $f_MontoAplicado, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_MontoAplicado, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo MontoAplicado ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setMontoAplicado( $f_MontoAplicado );
        return true;
    }

    /* Valida y establece el valor del campo MontoAplicacionMN */
    public function setMontoAplicacionMN( $f_MontoAplicacionMN, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_MontoAplicacionMN, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo MontoAplicacionMN ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setMontoAplicacionMN( $f_MontoAplicacionMN );
        return true;
    }

    /* Valida y establece el valor del campo MontoAplicacionME */
    public function setMontoAplicacionME( $f_MontoAplicacionME, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_MontoAplicacionME, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo MontoAplicacionME ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setMontoAplicacionME( $f_MontoAplicacionME );
        return true;
    }

    /* Valida y establece el valor del campo Mostrar */
    public function setMostrar( $s_Mostrar, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Mostrar, "VARCHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo Mostrar ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setMostrar( $s_Mostrar );
        return true;
    }

    /* Valida y establece el valor del campo Estado */
    public function setEstado( $s_Estado, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Estado, "VARCHAR", 2, 0, false ) )
            {
                throw new Exception( "El campo Estado ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setEstado( $s_Estado );
        return true;
    }

    /* Valida y establece el valor del campo FechaCreacion */
    public function setFechaCreacion( $d_FechaCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaCreacion, "TIMESTAMP", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaCreacion( $d_FechaCreacion );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioCreacion */
    public function setUsuarioCreacion( $s_UsuarioCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioCreacion, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo UsuarioCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioCreacion( $s_UsuarioCreacion );
        return true;
    }

    /* Valida y establece el valor del campo FechaModificacion */
    public function setFechaModificacion( $d_FechaModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaModificacion, "TIMESTAMP", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaModificacion( $d_FechaModificacion );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioModificacion */
    public function setUsuarioModificacion( $s_UsuarioModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioModificacion, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo UsuarioModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioModificacion( $s_UsuarioModificacion );
        return true;
    }

    /* Valida el contenido del registro */
    public function validateRecord()
    {
        $this->setIdAplicacion( $this->getIdAplicacion(), false );
        $this->setIdParent( $this->getIdParent(), true );
        $this->setIdCompania( $this->getIdCompania(), true );
        $this->setIdSucursal( $this->getIdSucursal(), true );
        $this->setIdTipoPago( $this->getIdTipoPago(), true );
        $this->setIdCaja( $this->getIdCaja(), true );
        $this->setIdTurno( $this->getIdTurno(), true );
        $this->setIdCierre( $this->getIdCierre(), true );
        $this->setIdBanco( $this->getIdBanco(), true );
        $this->setIdCuenta( $this->getIdCuenta(), true );
        $this->setIdMoneda( $this->getIdMoneda(), true );
        $this->setMonedaDes( $this->getMonedaDes(), true );
        $this->setTipoCambio( $this->getTipoCambio(), true );
        $this->setTipoPagoNombre( $this->getTipoPagoNombre(), true );
        $this->setIdPersona( $this->getIdPersona(), true );
        $this->setTipoDocCliente( $this->getTipoDocCliente(), true );
        $this->setNumTipoDocCliente( $this->getNumTipoDocCliente(), true );
        $this->setNombreCliente( $this->getNombreCliente(), true );
        $this->setNombreTipo( $this->getNombreTipo(), true );
        $this->setClaseNombre( $this->getClaseNombre(), true );
        $this->setDescripcion( $this->getDescripcion(), true );
        $this->setReciboNumero( $this->getReciboNumero(), true );
        $this->setIdDocRecibo( $this->getIdDocRecibo(), true );
        $this->setIdNumeroDocumento( $this->getIdNumeroDocumento(), true );
        $this->setIdDocNumRef( $this->getIdDocNumRef(), true );
        $this->setCodDocRef( $this->getCodDocRef(), true );
        $this->setSerieNumeroDocRef( $this->getSerieNumeroDocRef(), true );
        $this->setMontoTotalDocRef( $this->getMontoTotalDocRef(), true );
        $this->setSaldoDocRef( $this->getSaldoDocRef(), true );
        $this->setFechaDocRef( $this->getFechaDocRef(), true );
        $this->setFechaDocVenRef( $this->getFechaDocVenRef(), true );
        $this->setIdMonedaRef( $this->getIdMonedaRef(), true );
        $this->setTipoCambioRef( $this->getTipoCambioRef(), true );
        $this->setCodVendedorRef( $this->getCodVendedorRef(), true );
        $this->setIdAlmacenRef( $this->getIdAlmacenRef(), true );
        $this->setPeriodo( $this->getPeriodo(), true );
        $this->setFechaAplicacion( $this->getFechaAplicacion(), true );
        $this->setMontoAplicado( $this->getMontoAplicado(), true );
        $this->setMontoAplicacionMN( $this->getMontoAplicacionMN(), true );
        $this->setMontoAplicacionME( $this->getMontoAplicacionME(), true );
        $this->setMostrar( $this->getMostrar(), true );
        $this->setEstado( $this->getEstado(), true );
        $this->setFechaCreacion( $this->getFechaCreacion(), true );
        $this->setUsuarioCreacion( $this->getUsuarioCreacion(), true );
        $this->setFechaModificacion( $this->getFechaModificacion(), true );
        $this->setUsuarioModificacion( $this->getUsuarioModificacion(), true );
        return true;
    }
}
?>