<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: COM_OrdenCompraCabecera.xml */
/* Generado: 2021-08-03 03:19:01 */

/* Validacion del contenido de los campos campos de la tabla COM_OrdenCompraCabecera */
abstract class BaseCOM_OrdenCompraCabeceraBV extends COM_OrdenCompraCabeceraBN
{
    /* Contiene la clase que valida el tipo de dato */
    private $o_Validator; // Contiene el objeto que realizara la validacion de tipo de dato.
    private $s_ValidatorMessage; // Contiene la ultima observacion de la validacion del tipo de dato.

    /* Constructor ( Establece la clase que valida los tipos de datos y establece los valores por defecto ) */
    public function __construct()
    {
        /* Establecemos el objeto que realizara la validacion del tipo de dato */
        $this->o_Validator = new utilValidDataType();

        /* Establecemos los valores por defecto */
    }

    /* Valida en tipo de dato */
    private function validateData( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull )
    {
        $this->s_ValidatorMessage = null;
        if( !$this->o_Validator->validate( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull ) )
        {
            $this->s_ValidatorMessage = $this->o_Validator->getMessage();
        }
        return is_null( $this->s_ValidatorMessage );
    }

    /* Valida y establece el valor del campo IdCompania */
    public function setIdCompania( $i_IdCompania, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdCompania, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdCompania ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdCompania( $i_IdCompania );
        return true;
    }

    /* Valida y establece el valor del campo IdSucursal */
    public function setIdSucursal( $i_IdSucursal, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdSucursal, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdSucursal ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdSucursal( $i_IdSucursal );
        return true;
    }

    /* Valida y establece el valor del campo IdOrdenCompra */
    public function setIdOrdenCompra( $i_IdOrdenCompra, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdOrdenCompra, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdOrdenCompra ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdOrdenCompra( $i_IdOrdenCompra );
        return true;
    }

    /* Valida y establece el valor del campo TipoOrden */
    public function setTipoOrden( $s_TipoOrden, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_TipoOrden, "VARCHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo TipoOrden ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setTipoOrden( $s_TipoOrden );
        return true;
    }

    /* Valida y establece el valor del campo IdProyecto */
    public function setIdProyecto( $i_IdProyecto, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdProyecto, "INT", 10, 0, false ) )
            {
                throw new Exception( "El campo IdProyecto ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdProyecto( $i_IdProyecto );
        return true;
    }

    /* Valida y establece el valor del campo ProyectoNombre */
    public function setProyectoNombre( $s_ProyectoNombre, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ProyectoNombre, "VARCHAR", 300, 0, false ) )
            {
                throw new Exception( "El campo ProyectoNombre ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setProyectoNombre( $s_ProyectoNombre );
        return true;
    }

    /* Valida y establece el valor del campo IdProveedor */
    public function setIdProveedor( $i_IdProveedor, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdProveedor, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdProveedor ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdProveedor( $i_IdProveedor );
        return true;
    }

    /* Valida y establece el valor del campo NombreProveedor */
    public function setNombreProveedor( $s_NombreProveedor, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_NombreProveedor, "VARCHAR", 300, 0, false ) )
            {
                throw new Exception( "El campo NombreProveedor ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setNombreProveedor( $s_NombreProveedor );
        return true;
    }

    /* Valida y establece el valor del campo NumeroInterno */
    public function setNumeroInterno( $s_NumeroInterno, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_NumeroInterno, "VARCHAR", 250, 0, false ) )
            {
                throw new Exception( "El campo NumeroInterno ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setNumeroInterno( $s_NumeroInterno );
        return true;
    }

    /* Valida y establece el valor del campo IdOrdenClasificacion */
    public function setIdOrdenClasificacion( $s_IdOrdenClasificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdOrdenClasificacion, "VARCHAR", 10, 0, false ) )
            {
                throw new Exception( "El campo IdOrdenClasificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdOrdenClasificacion( $s_IdOrdenClasificacion );
        return true;
    }

    /* Valida y establece el valor del campo IdMoneda */
    public function setIdMoneda( $s_IdMoneda, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdMoneda, "VARCHAR", 2, 0, false ) )
            {
                throw new Exception( "El campo IdMoneda ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdMoneda( $s_IdMoneda );
        return true;
    }

    /* Valida y establece el valor del campo IdMonedaPago */
    public function setIdMonedaPago( $s_IdMonedaPago, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdMonedaPago, "VARCHAR", 2, 0, false ) )
            {
                throw new Exception( "El campo IdMonedaPago ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdMonedaPago( $s_IdMonedaPago );
        return true;
    }

    /* Valida y establece el valor del campo TerminoId */
    public function setTerminoId( $i_TerminoId, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_TerminoId, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo TerminoId ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setTerminoId( $i_TerminoId );
        return true;
    }

    /* Valida y establece el valor del campo Descripcion */
    public function setDescripcion( $s_Descripcion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Descripcion, "VARCHAR", 250, 0, false ) )
            {
                throw new Exception( "El campo Descripcion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDescripcion( $s_Descripcion );
        return true;
    }

    /* Valida y establece el valor del campo Observacion */
    public function setObservacion( $s_Observacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Observacion, "VARCHAR", 400, 0, false ) )
            {
                throw new Exception( "El campo Observacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setObservacion( $s_Observacion );
        return true;
    }

    /* Valida y establece el valor del campo ObservacionEntrega */
    public function setObservacionEntrega( $s_ObservacionEntrega, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ObservacionEntrega, "VARCHAR", 400, 0, false ) )
            {
                throw new Exception( "El campo ObservacionEntrega ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setObservacionEntrega( $s_ObservacionEntrega );
        return true;
    }

    /* Valida y establece el valor del campo ObservacionRechazo */
    public function setObservacionRechazo( $s_ObservacionRechazo, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ObservacionRechazo, "VARCHAR", 400, 0, false ) )
            {
                throw new Exception( "El campo ObservacionRechazo ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setObservacionRechazo( $s_ObservacionRechazo );
        return true;
    }

    /* Valida y establece el valor del campo AfectoIGV */
    public function setAfectoIGV( $i_AfectoIGV, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_AfectoIGV, "INT", 10, 0, false ) )
            {
                throw new Exception( "El campo AfectoIGV ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setAfectoIGV( $i_AfectoIGV );
        return true;
    }

    /* Valida y establece el valor del campo MontoAfecto */
    public function setMontoAfecto( $f_MontoAfecto, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_MontoAfecto, "DECIMAL", 10, 2, false ) )
            {
                throw new Exception( "El campo MontoAfecto ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setMontoAfecto( $f_MontoAfecto );
        return true;
    }

    /* Valida y establece el valor del campo MontoNoAfecto */
    public function setMontoNoAfecto( $f_MontoNoAfecto, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_MontoNoAfecto, "DECIMAL", 10, 2, false ) )
            {
                throw new Exception( "El campo MontoNoAfecto ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setMontoNoAfecto( $f_MontoNoAfecto );
        return true;
    }

    /* Valida y establece el valor del campo MontoIGV */
    public function setMontoIGV( $f_MontoIGV, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_MontoIGV, "DECIMAL", 10, 2, false ) )
            {
                throw new Exception( "El campo MontoIGV ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setMontoIGV( $f_MontoIGV );
        return true;
    }

    /* Valida y establece el valor del campo MontoBruto */
    public function setMontoBruto( $f_MontoBruto, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_MontoBruto, "DECIMAL", 10, 2, false ) )
            {
                throw new Exception( "El campo MontoBruto ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setMontoBruto( $f_MontoBruto );
        return true;
    }

    /* Valida y establece el valor del campo MontoPendientePago */
    public function setMontoPendientePago( $f_MontoPendientePago, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_MontoPendientePago, "DECIMAL", 10, 2, false ) )
            {
                throw new Exception( "El campo MontoPendientePago ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setMontoPendientePago( $f_MontoPendientePago );
        return true;
    }

    /* Valida y establece el valor del campo Estado */
    public function setEstado( $s_Estado, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Estado, "VARCHAR", 2, 0, false ) )
            {
                throw new Exception( "El campo Estado ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setEstado( $s_Estado );
        return true;
    }

    /* Valida y establece el valor del campo TipoCambio */
    public function setTipoCambio( $f_TipoCambio, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_TipoCambio, "DECIMAL", 10, 4, false ) )
            {
                throw new Exception( "El campo TipoCambio ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setTipoCambio( $f_TipoCambio );
        return true;
    }

    /* Valida y establece el valor del campo FechaCreacion */
    public function setFechaCreacion( $d_FechaCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaCreacion, "TIMESTAMP", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaCreacion( $d_FechaCreacion );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioCreacion */
    public function setUsuarioCreacion( $s_UsuarioCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioCreacion, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo UsuarioCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioCreacion( $s_UsuarioCreacion );
        return true;
    }

    /* Valida y establece el valor del campo FechaModificacion */
    public function setFechaModificacion( $d_FechaModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaModificacion, "DATETIME", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaModificacion( $d_FechaModificacion );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioModificacion */
    public function setUsuarioModificacion( $s_UsuarioModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioModificacion, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo UsuarioModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioModificacion( $s_UsuarioModificacion );
        return true;
    }

    /* Valida y establece el valor del campo IdAlmacenEntrega */
    public function setIdAlmacenEntrega( $s_IdAlmacenEntrega, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdAlmacenEntrega, "CHAR", 10, 0, false ) )
            {
                throw new Exception( "El campo IdAlmacenEntrega ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdAlmacenEntrega( $s_IdAlmacenEntrega );
        return true;
    }

    /* Valida y establece el valor del campo FechaEntrega */
    public function setFechaEntrega( $d_FechaEntrega, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaEntrega, "DATETIME", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaEntrega ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaEntrega( $d_FechaEntrega );
        return true;
    }

    /* Valida y establece el valor del campo IdAlmacenIngreso */
    public function setIdAlmacenIngreso( $s_IdAlmacenIngreso, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdAlmacenIngreso, "CHAR", 10, 0, false ) )
            {
                throw new Exception( "El campo IdAlmacenIngreso ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdAlmacenIngreso( $s_IdAlmacenIngreso );
        return true;
    }

    /* Valida y establece el valor del campo PreparadoPor */
    public function setPreparadoPor( $s_PreparadoPor, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_PreparadoPor, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo PreparadoPor ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setPreparadoPor( $s_PreparadoPor );
        return true;
    }

    /* Valida y establece el valor del campo FechaPreparacion */
    public function setFechaPreparacion( $d_FechaPreparacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaPreparacion, "DATETIME", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaPreparacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaPreparacion( $d_FechaPreparacion );
        return true;
    }

    /* Valida y establece el valor del campo AprobadoPor */
    public function setAprobadoPor( $s_AprobadoPor, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_AprobadoPor, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo AprobadoPor ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setAprobadoPor( $s_AprobadoPor );
        return true;
    }

    /* Valida y establece el valor del campo FechaAprobacion */
    public function setFechaAprobacion( $d_FechaAprobacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaAprobacion, "DATETIME", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaAprobacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaAprobacion( $d_FechaAprobacion );
        return true;
    }

    /* Valida y establece el valor del campo RevisadoPor */
    public function setRevisadoPor( $s_RevisadoPor, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_RevisadoPor, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo RevisadoPor ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setRevisadoPor( $s_RevisadoPor );
        return true;
    }

    /* Valida y establece el valor del campo FechaRevision */
    public function setFechaRevision( $d_FechaRevision, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaRevision, "DATETIME", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaRevision ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaRevision( $d_FechaRevision );
        return true;
    }

    /* Valida y establece el valor del campo IdRequerimiento */
    public function setIdRequerimiento( $i_IdRequerimiento, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdRequerimiento, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdRequerimiento ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdRequerimiento( $i_IdRequerimiento );
        return true;
    }

    /* Valida el contenido del registro */
    public function validateRecord()
    {
        $this->setIdCompania( $this->getIdCompania(), false );
        $this->setIdSucursal( $this->getIdSucursal(), true );
        $this->setIdOrdenCompra( $this->getIdOrdenCompra(), false );
        $this->setTipoOrden( $this->getTipoOrden(), true );
        $this->setIdProyecto( $this->getIdProyecto(), true );
        $this->setProyectoNombre( $this->getProyectoNombre(), true );
        $this->setIdProveedor( $this->getIdProveedor(), true );
        $this->setNombreProveedor( $this->getNombreProveedor(), true );
        $this->setNumeroInterno( $this->getNumeroInterno(), true );
        $this->setIdOrdenClasificacion( $this->getIdOrdenClasificacion(), true );
        $this->setIdMoneda( $this->getIdMoneda(), true );
        $this->setIdMonedaPago( $this->getIdMonedaPago(), true );
        $this->setTerminoId( $this->getTerminoId(), true );
        $this->setDescripcion( $this->getDescripcion(), true );
        $this->setObservacion( $this->getObservacion(), true );
        $this->setObservacionEntrega( $this->getObservacionEntrega(), true );
        $this->setObservacionRechazo( $this->getObservacionRechazo(), true );
        $this->setAfectoIGV( $this->getAfectoIGV(), true );
        $this->setMontoAfecto( $this->getMontoAfecto(), true );
        $this->setMontoNoAfecto( $this->getMontoNoAfecto(), true );
        $this->setMontoIGV( $this->getMontoIGV(), true );
        $this->setMontoBruto( $this->getMontoBruto(), true );
        $this->setMontoPendientePago( $this->getMontoPendientePago(), true );
        $this->setEstado( $this->getEstado(), true );
        $this->setTipoCambio( $this->getTipoCambio(), true );
        $this->setFechaCreacion( $this->getFechaCreacion(), true );
        $this->setUsuarioCreacion( $this->getUsuarioCreacion(), true );
        $this->setFechaModificacion( $this->getFechaModificacion(), true );
        $this->setUsuarioModificacion( $this->getUsuarioModificacion(), true );
        $this->setIdAlmacenEntrega( $this->getIdAlmacenEntrega(), true );
        $this->setFechaEntrega( $this->getFechaEntrega(), true );
        $this->setIdAlmacenIngreso( $this->getIdAlmacenIngreso(), true );
        $this->setPreparadoPor( $this->getPreparadoPor(), true );
        $this->setFechaPreparacion( $this->getFechaPreparacion(), true );
        $this->setAprobadoPor( $this->getAprobadoPor(), true );
        $this->setFechaAprobacion( $this->getFechaAprobacion(), true );
        $this->setRevisadoPor( $this->getRevisadoPor(), true );
        $this->setFechaRevision( $this->getFechaRevision(), true );
        $this->setIdRequerimiento( $this->getIdRequerimiento(), true );
        return true;
    }
}
?>