<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: CAR_VehiculoModelo.xml */
/* Generado: 2024-12-31 05:18:46 */

/* Validacion del contenido de los campos campos de la tabla CAR_VehiculoModelo */
abstract class BaseCAR_VehiculoModeloBV extends CAR_VehiculoModeloBN
{
    /* Contiene la clase que valida el tipo de dato */
    private $o_Validator; // Contiene el objeto que realizara la validacion de tipo de dato.
    private $s_ValidatorMessage; // Contiene la ultima observacion de la validacion del tipo de dato.

    /* Constructor ( Establece la clase que valida los tipos de datos y establece los valores por defecto ) */
    public function __construct()
    {
        /* Establecemos el objeto que realizara la validacion del tipo de dato */
        $this->o_Validator = new utilValidDataType();

        /* Establecemos los valores por defecto */
    }

    /* Valida en tipo de dato */
    private function validateData( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull )
    {
        $this->s_ValidatorMessage = null;
        if( !$this->o_Validator->validate( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull ) )
        {
            $this->s_ValidatorMessage = $this->o_Validator->getMessage();
        }
        return is_null( $this->s_ValidatorMessage );
    }

    /* Valida y establece el valor del campo IdVehiculoModelo */
    public function setIdVehiculoModelo( $i_IdVehiculoModelo, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdVehiculoModelo, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdVehiculoModelo ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdVehiculoModelo( $i_IdVehiculoModelo );
        return true;
    }

    /* Valida y establece el valor del campo IdVehiculoMarca */
    public function setIdVehiculoMarca( $i_IdVehiculoMarca, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdVehiculoMarca, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdVehiculoMarca ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdVehiculoMarca( $i_IdVehiculoMarca );
        return true;
    }

    /* Valida y establece el valor del campo IdVehiculoTipo */
    public function setIdVehiculoTipo( $i_IdVehiculoTipo, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdVehiculoTipo, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdVehiculoTipo ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdVehiculoTipo( $i_IdVehiculoTipo );
        return true;
    }

    /* Valida y establece el valor del campo Descripcion */
    public function setDescripcion( $s_Descripcion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Descripcion, "VARCHAR", 80, 0, false ) )
            {
                throw new Exception( "El campo Descripcion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDescripcion( $s_Descripcion );
        return true;
    }

    /* Valida y establece el valor del campo Codigo */
    public function setCodigo( $s_Codigo, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Codigo, "VARCHAR", 300, 0, false ) )
            {
                throw new Exception( "El campo Codigo ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setCodigo( $s_Codigo );
        return true;
    }

    /* Valida y establece el valor del campo Estado */
    public function setEstado( $s_Estado, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Estado, "VARCHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo Estado ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setEstado( $s_Estado );
        return true;
    }

    /* Valida y establece el valor del campo FechaCreacion */
    public function setFechaCreacion( $d_FechaCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaCreacion, "DATETIME", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaCreacion( $d_FechaCreacion );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioCreacion */
    public function setUsuarioCreacion( $s_UsuarioCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioCreacion, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo UsuarioCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioCreacion( $s_UsuarioCreacion );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioModificacion */
    public function setUsuarioModificacion( $s_UsuarioModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioModificacion, "VARCHAR", 20, 0, false ) )
            {
                throw new Exception( "El campo UsuarioModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioModificacion( $s_UsuarioModificacion );
        return true;
    }

    /* Valida y establece el valor del campo FechaModificacion */
    public function setFechaModificacion( $d_FechaModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaModificacion, "DATETIME", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaModificacion( $d_FechaModificacion );
        return true;
    }

    /* Valida y establece el valor del campo Eliminado */
    public function setEliminado( $i_Eliminado, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_Eliminado, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo Eliminado ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setEliminado( $i_Eliminado );
        return true;
    }

    /* Valida y establece el valor del campo FechaEliminado */
    public function setFechaEliminado( $d_FechaEliminado, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaEliminado, "DATETIME", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaEliminado ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaEliminado( $d_FechaEliminado );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioEliminado */
    public function setUsuarioEliminado( $s_UsuarioEliminado, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioEliminado, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo UsuarioEliminado ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioEliminado( $s_UsuarioEliminado );
        return true;
    }

    /* Valida el contenido del registro */
    public function validateRecord()
    {
        $this->setIdVehiculoModelo( $this->getIdVehiculoModelo(), false );
        $this->setIdVehiculoMarca( $this->getIdVehiculoMarca(), true );
        $this->setIdVehiculoTipo( $this->getIdVehiculoTipo(), true );
        $this->setDescripcion( $this->getDescripcion(), true );
        $this->setCodigo( $this->getCodigo(), true );
        $this->setEstado( $this->getEstado(), true );
        $this->setFechaCreacion( $this->getFechaCreacion(), true );
        $this->setUsuarioCreacion( $this->getUsuarioCreacion(), true );
        $this->setUsuarioModificacion( $this->getUsuarioModificacion(), true );
        $this->setFechaModificacion( $this->getFechaModificacion(), true );
        $this->setEliminado( $this->getEliminado(), true );
        $this->setFechaEliminado( $this->getFechaEliminado(), true );
        $this->setUsuarioEliminado( $this->getUsuarioEliminado(), true );
        return true;
    }
}
?>