<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: ALM_RequerimientoDetalle.xml */
/* Generado: 2021-08-12 07:46:43 */

/* Validacion del contenido de los campos campos de la tabla ALM_RequerimientoDetalle */
abstract class BaseALM_RequerimientoDetalleBV extends ALM_RequerimientoDetalleBN
{
    /* Contiene la clase que valida el tipo de dato */
    private $o_Validator; // Contiene el objeto que realizara la validacion de tipo de dato.
    private $s_ValidatorMessage; // Contiene la ultima observacion de la validacion del tipo de dato.

    /* Constructor ( Establece la clase que valida los tipos de datos y establece los valores por defecto ) */
    public function __construct()
    {
        /* Establecemos el objeto que realizara la validacion del tipo de dato */
        $this->o_Validator = new utilValidDataType();

        /* Establecemos los valores por defecto */
    }

    /* Valida en tipo de dato */
    private function validateData( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull )
    {
        $this->s_ValidatorMessage = null;
        if( !$this->o_Validator->validate( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull ) )
        {
            $this->s_ValidatorMessage = $this->o_Validator->getMessage();
        }
        return is_null( $this->s_ValidatorMessage );
    }

    /* Valida y establece el valor del campo IdRequerimientoDetalle */
    public function setIdRequerimientoDetalle( $i_IdRequerimientoDetalle, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdRequerimientoDetalle, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdRequerimientoDetalle ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdRequerimientoDetalle( $i_IdRequerimientoDetalle );
        return true;
    }

    /* Valida y establece el valor del campo IdRequerimiento */
    public function setIdRequerimiento( $i_IdRequerimiento, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdRequerimiento, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdRequerimiento ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdRequerimiento( $i_IdRequerimiento );
        return true;
    }

    /* Valida y establece el valor del campo IdItem */
    public function setIdItem( $s_IdItem, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdItem, "VARCHAR", 20, 0, false ) )
            {
                throw new Exception( "El campo IdItem ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdItem( $s_IdItem );
        return true;
    }

    /* Valida y establece el valor del campo CantidadSugerida */
    public function setCantidadSugerida( $f_CantidadSugerida, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_CantidadSugerida, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo CantidadSugerida ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setCantidadSugerida( $f_CantidadSugerida );
        return true;
    }

    /* Valida y establece el valor del campo CantidadPedida */
    public function setCantidadPedida( $f_CantidadPedida, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_CantidadPedida, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo CantidadPedida ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setCantidadPedida( $f_CantidadPedida );
        return true;
    }

    /* Valida y establece el valor del campo IdMoneda */
    public function setIdMoneda( $s_IdMoneda, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdMoneda, "VARCHAR", 2, 0, false ) )
            {
                throw new Exception( "El campo IdMoneda ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdMoneda( $s_IdMoneda );
        return true;
    }

    /* Valida y establece el valor del campo IdLote */
    public function setIdLote( $s_IdLote, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdLote, "VARCHAR", 20, 0, false ) )
            {
                throw new Exception( "El campo IdLote ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdLote( $s_IdLote );
        return true;
    }

    /* Valida y establece el valor del campo FechaVencimiento */
    public function setFechaVencimiento( $d_FechaVencimiento, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaVencimiento, "DATE", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaVencimiento ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaVencimiento( $d_FechaVencimiento );
        return true;
    }

    /* Valida y establece el valor del campo StockMinimo */
    public function setStockMinimo( $f_StockMinimo, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_StockMinimo, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo StockMinimo ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setStockMinimo( $f_StockMinimo );
        return true;
    }

    /* Valida y establece el valor del campo StockMaximo */
    public function setStockMaximo( $f_StockMaximo, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_StockMaximo, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo StockMaximo ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setStockMaximo( $f_StockMaximo );
        return true;
    }

    /* Valida y establece el valor del campo PrecioUnitario */
    public function setPrecioUnitario( $f_PrecioUnitario, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_PrecioUnitario, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo PrecioUnitario ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setPrecioUnitario( $f_PrecioUnitario );
        return true;
    }

    /* Valida y establece el valor del campo PrecioUnitarioIGV */
    public function setPrecioUnitarioIGV( $f_PrecioUnitarioIGV, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_PrecioUnitarioIGV, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo PrecioUnitarioIGV ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setPrecioUnitarioIGV( $f_PrecioUnitarioIGV );
        return true;
    }

    /* Valida y establece el valor del campo PrecioSubTotal */
    public function setPrecioSubTotal( $f_PrecioSubTotal, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_PrecioSubTotal, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo PrecioSubTotal ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setPrecioSubTotal( $f_PrecioSubTotal );
        return true;
    }

    /* Valida y establece el valor del campo ValorIGV */
    public function setValorIGV( $f_ValorIGV, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_ValorIGV, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo ValorIGV ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setValorIGV( $f_ValorIGV );
        return true;
    }

    /* Valida y establece el valor del campo PrecioTotalConIGV */
    public function setPrecioTotalConIGV( $f_PrecioTotalConIGV, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_PrecioTotalConIGV, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo PrecioTotalConIGV ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setPrecioTotalConIGV( $f_PrecioTotalConIGV );
        return true;
    }

    /* Valida y establece el valor del campo Estado */
    public function setEstado( $s_Estado, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Estado, "VARCHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo Estado ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setEstado( $s_Estado );
        return true;
    }

    /* Valida y establece el valor del campo IGVExoneradoFlag */
    public function setIGVExoneradoFlag( $s_IGVExoneradoFlag, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IGVExoneradoFlag, "VARCHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo IGVExoneradoFlag ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIGVExoneradoFlag( $s_IGVExoneradoFlag );
        return true;
    }

    /* Valida y establece el valor del campo FechaCreacion */
    public function setFechaCreacion( $d_FechaCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaCreacion, "DATETIME", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaCreacion( $d_FechaCreacion );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioCreacion */
    public function setUsuarioCreacion( $s_UsuarioCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioCreacion, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo UsuarioCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioCreacion( $s_UsuarioCreacion );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioModificacion */
    public function setUsuarioModificacion( $s_UsuarioModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioModificacion, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo UsuarioModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioModificacion( $s_UsuarioModificacion );
        return true;
    }

    /* Valida y establece el valor del campo FechaModificacion */
    public function setFechaModificacion( $d_FechaModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaModificacion, "TIMESTAMP", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaModificacion( $d_FechaModificacion );
        return true;
    }

    /* Valida el contenido del registro */
    public function validateRecord()
    {
        $this->setIdRequerimientoDetalle( $this->getIdRequerimientoDetalle(), false );
        $this->setIdRequerimiento( $this->getIdRequerimiento(), true );
        $this->setIdItem( $this->getIdItem(), true );
        $this->setCantidadSugerida( $this->getCantidadSugerida(), true );
        $this->setCantidadPedida( $this->getCantidadPedida(), true );
        $this->setIdMoneda( $this->getIdMoneda(), true );
        $this->setIdLote( $this->getIdLote(), true );
        $this->setFechaVencimiento( $this->getFechaVencimiento(), true );
        $this->setStockMinimo( $this->getStockMinimo(), true );
        $this->setStockMaximo( $this->getStockMaximo(), true );
        $this->setPrecioUnitario( $this->getPrecioUnitario(), true );
        $this->setPrecioUnitarioIGV( $this->getPrecioUnitarioIGV(), true );
        $this->setPrecioSubTotal( $this->getPrecioSubTotal(), true );
        $this->setValorIGV( $this->getValorIGV(), true );
        $this->setPrecioTotalConIGV( $this->getPrecioTotalConIGV(), true );
        $this->setEstado( $this->getEstado(), true );
        $this->setIGVExoneradoFlag( $this->getIGVExoneradoFlag(), true );
        $this->setFechaCreacion( $this->getFechaCreacion(), true );
        $this->setUsuarioCreacion( $this->getUsuarioCreacion(), true );
        $this->setUsuarioModificacion( $this->getUsuarioModificacion(), true );
        $this->setFechaModificacion( $this->getFechaModificacion(), true );
        return true;
    }
}
?>