<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: ALM_RequerimientoCabecera.xml */
/* Generado: 2021-08-12 06:24:35 */

/* Validacion del contenido de los campos campos de la tabla ALM_RequerimientoCabecera */
abstract class BaseALM_RequerimientoCabeceraBV extends ALM_RequerimientoCabeceraBN
{
    /* Contiene la clase que valida el tipo de dato */
    private $o_Validator; // Contiene el objeto que realizara la validacion de tipo de dato.
    private $s_ValidatorMessage; // Contiene la ultima observacion de la validacion del tipo de dato.

    /* Constructor ( Establece la clase que valida los tipos de datos y establece los valores por defecto ) */
    public function __construct()
    {
        /* Establecemos el objeto que realizara la validacion del tipo de dato */
        $this->o_Validator = new utilValidDataType();

        /* Establecemos los valores por defecto */
    }

    /* Valida en tipo de dato */
    private function validateData( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull )
    {
        $this->s_ValidatorMessage = null;
        if( !$this->o_Validator->validate( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull ) )
        {
            $this->s_ValidatorMessage = $this->o_Validator->getMessage();
        }
        return is_null( $this->s_ValidatorMessage );
    }

    /* Valida y establece el valor del campo IdRequerimiento */
    public function setIdRequerimiento( $i_IdRequerimiento, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdRequerimiento, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdRequerimiento ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdRequerimiento( $i_IdRequerimiento );
        return true;
    }

    /* Valida y establece el valor del campo FechaRequerida */
    public function setFechaRequerida( $d_FechaRequerida, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaRequerida, "DATE", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaRequerida ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaRequerida( $d_FechaRequerida );
        return true;
    }

    /* Valida y establece el valor del campo FechaProgramada */
    public function setFechaProgramada( $d_FechaProgramada, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaProgramada, "DATE", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaProgramada ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaProgramada( $d_FechaProgramada );
        return true;
    }

    /* Valida y establece el valor del campo IdCompania */
    public function setIdCompania( $i_IdCompania, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdCompania, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdCompania ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdCompania( $i_IdCompania );
        return true;
    }

    /* Valida y establece el valor del campo IdSucursal */
    public function setIdSucursal( $i_IdSucursal, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdSucursal, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdSucursal ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdSucursal( $i_IdSucursal );
        return true;
    }

    /* Valida y establece el valor del campo IdAlmacen */
    public function setIdAlmacen( $s_IdAlmacen, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdAlmacen, "VARCHAR", 10, 0, false ) )
            {
                throw new Exception( "El campo IdAlmacen ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdAlmacen( $s_IdAlmacen );
        return true;
    }

    /* Valida y establece el valor del campo IdPersona */
    public function setIdPersona( $i_IdPersona, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdPersona, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdPersona ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdPersona( $i_IdPersona );
        return true;
    }

    /* Valida y establece el valor del campo Descripcion */
    public function setDescripcion( $s_Descripcion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Descripcion, "VARCHAR", 150, 0, false ) )
            {
                throw new Exception( "El campo Descripcion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDescripcion( $s_Descripcion );
        return true;
    }

    /* Valida y establece el valor del campo ResponsableNombre */
    public function setResponsableNombre( $s_ResponsableNombre, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ResponsableNombre, "VARCHAR", 150, 0, false ) )
            {
                throw new Exception( "El campo ResponsableNombre ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setResponsableNombre( $s_ResponsableNombre );
        return true;
    }

    /* Valida y establece el valor del campo Comentario */
    public function setComentario( $s_Comentario, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Comentario, "VARCHAR", 250, 0, false ) )
            {
                throw new Exception( "El campo Comentario ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setComentario( $s_Comentario );
        return true;
    }

    /* Valida y establece el valor del campo Estado */
    public function setEstado( $s_Estado, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Estado, "VARCHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo Estado ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setEstado( $s_Estado );
        return true;
    }

    /* Valida y establece el valor del campo MontoTotal */
    public function setMontoTotal( $f_MontoTotal, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_MontoTotal, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo MontoTotal ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setMontoTotal( $f_MontoTotal );
        return true;
    }

    /* Valida y establece el valor del campo CompraAprobadaFlag */
    public function setCompraAprobadaFlag( $s_CompraAprobadaFlag, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_CompraAprobadaFlag, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo CompraAprobadaFlag ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setCompraAprobadaFlag( $s_CompraAprobadaFlag );
        return true;
    }

    /* Valida y establece el valor del campo ModoIngresoConIGVFlag */
    public function setModoIngresoConIGVFlag( $s_ModoIngresoConIGVFlag, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ModoIngresoConIGVFlag, "VARCHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo ModoIngresoConIGVFlag ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setModoIngresoConIGVFlag( $s_ModoIngresoConIGVFlag );
        return true;
    }

    /* Valida y establece el valor del campo FechaCreacion */
    public function setFechaCreacion( $d_FechaCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaCreacion, "DATETIME", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaCreacion( $d_FechaCreacion );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioCreacion */
    public function setUsuarioCreacion( $s_UsuarioCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioCreacion, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo UsuarioCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioCreacion( $s_UsuarioCreacion );
        return true;
    }

    /* Valida y establece el valor del campo FechaModificacion */
    public function setFechaModificacion( $d_FechaModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaModificacion, "TIMESTAMP", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaModificacion( $d_FechaModificacion );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioModificacion */
    public function setUsuarioModificacion( $s_UsuarioModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioModificacion, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo UsuarioModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioModificacion( $s_UsuarioModificacion );
        return true;
    }

    /* Valida y establece el valor del campo FechaEnvio */
    public function setFechaEnvio( $d_FechaEnvio, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaEnvio, "DATETIME", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaEnvio ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaEnvio( $d_FechaEnvio );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioEnvio */
    public function setUsuarioEnvio( $s_UsuarioEnvio, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioEnvio, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo UsuarioEnvio ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioEnvio( $s_UsuarioEnvio );
        return true;
    }

    /* Valida y establece el valor del campo NumeroOrden */
    public function setNumeroOrden( $i_NumeroOrden, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_NumeroOrden, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo NumeroOrden ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setNumeroOrden( $i_NumeroOrden );
        return true;
    }

    /* Valida y establece el valor del campo FechaAprobada */
    public function setFechaAprobada( $d_FechaAprobada, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaAprobada, "DATE", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaAprobada ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaAprobada( $d_FechaAprobada );
        return true;
    }

    /* Valida y establece el valor del campo RazonRechazo */
    public function setRazonRechazo( $s_RazonRechazo, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_RazonRechazo, "VARCHAR", 500, 0, false ) )
            {
                throw new Exception( "El campo RazonRechazo ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setRazonRechazo( $s_RazonRechazo );
        return true;
    }

    /* Valida el contenido del registro */
    public function validateRecord()
    {
        $this->setIdRequerimiento( $this->getIdRequerimiento(), false );
        $this->setFechaRequerida( $this->getFechaRequerida(), true );
        $this->setFechaProgramada( $this->getFechaProgramada(), true );
        $this->setIdCompania( $this->getIdCompania(), true );
        $this->setIdSucursal( $this->getIdSucursal(), true );
        $this->setIdAlmacen( $this->getIdAlmacen(), true );
        $this->setIdPersona( $this->getIdPersona(), true );
        $this->setDescripcion( $this->getDescripcion(), true );
        $this->setResponsableNombre( $this->getResponsableNombre(), true );
        $this->setComentario( $this->getComentario(), true );
        $this->setEstado( $this->getEstado(), true );
        $this->setMontoTotal( $this->getMontoTotal(), true );
        $this->setCompraAprobadaFlag( $this->getCompraAprobadaFlag(), true );
        $this->setModoIngresoConIGVFlag( $this->getModoIngresoConIGVFlag(), true );
        $this->setFechaCreacion( $this->getFechaCreacion(), true );
        $this->setUsuarioCreacion( $this->getUsuarioCreacion(), true );
        $this->setFechaModificacion( $this->getFechaModificacion(), true );
        $this->setUsuarioModificacion( $this->getUsuarioModificacion(), true );
        $this->setFechaEnvio( $this->getFechaEnvio(), true );
        $this->setUsuarioEnvio( $this->getUsuarioEnvio(), true );
        $this->setNumeroOrden( $this->getNumeroOrden(), true );
        $this->setFechaAprobada( $this->getFechaAprobada(), true );
        $this->setRazonRechazo( $this->getRazonRechazo(), true );
        return true;
    }
}
?>