<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: ALM_Kardex.xml */
/* Generado: 2022-11-15 20:49:42 */

/* Validacion del contenido de los campos campos de la tabla ALM_Kardex */
abstract class BaseALM_KardexBV extends ALM_KardexBN
{
    /* Contiene la clase que valida el tipo de dato */
    private $o_Validator; // Contiene el objeto que realizara la validacion de tipo de dato.
    private $s_ValidatorMessage; // Contiene la ultima observacion de la validacion del tipo de dato.

    /* Constructor ( Establece la clase que valida los tipos de datos y establece los valores por defecto ) */
    public function __construct()
    {
        /* Establecemos el objeto que realizara la validacion del tipo de dato */
        $this->o_Validator = new utilValidDataType();

        /* Establecemos los valores por defecto */
    }

    /* Valida en tipo de dato */
    private function validateData( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull )
    {
        $this->s_ValidatorMessage = null;
        if( !$this->o_Validator->validate( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull ) )
        {
            $this->s_ValidatorMessage = $this->o_Validator->getMessage();
        }
        return is_null( $this->s_ValidatorMessage );
    }

    /* Valida y establece el valor del campo IdAlmacen */
    public function setIdAlmacen( $s_IdAlmacen, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdAlmacen, "CHAR", 10, 0, false ) )
            {
                throw new Exception( "El campo IdAlmacen ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdAlmacen( $s_IdAlmacen );
        return true;
    }

    /* Valida y establece el valor del campo IdCompania */
    public function setIdCompania( $i_IdCompania, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdCompania, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdCompania ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdCompania( $i_IdCompania );
        return true;
    }

    /* Valida y establece el valor del campo IdSucursal */
    public function setIdSucursal( $i_IdSucursal, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdSucursal, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdSucursal ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdSucursal( $i_IdSucursal );
        return true;
    }

    /* Valida y establece el valor del campo IdItem */
    public function setIdItem( $s_IdItem, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdItem, "VARCHAR", 20, 0, false ) )
            {
                throw new Exception( "El campo IdItem ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdItem( $s_IdItem );
        return true;
    }

    /* Valida y establece el valor del campo IdCondicion */
    public function setIdCondicion( $s_IdCondicion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdCondicion, "CHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo IdCondicion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdCondicion( $s_IdCondicion );
        return true;
    }

    /* Valida y establece el valor del campo IdLote */
    public function setIdLote( $s_IdLote, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdLote, "VARCHAR", 20, 0, false ) )
            {
                throw new Exception( "El campo IdLote ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdLote( $s_IdLote );
        return true;
    }

    /* Valida y establece el valor del campo IdFecha */
    public function setIdFecha( $d_IdFecha, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_IdFecha, "DATETIME", 0, 0, false ) )
            {
                throw new Exception( "El campo IdFecha ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdFecha( $d_IdFecha );
        return true;
    }

    /* Valida y establece el valor del campo IdTransaccion */
    public function setIdTransaccion( $s_IdTransaccion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdTransaccion, "VARCHAR", 3, 0, false ) )
            {
                throw new Exception( "El campo IdTransaccion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdTransaccion( $s_IdTransaccion );
        return true;
    }

    /* Valida y establece el valor del campo ReferenciaNumeroInterno */
    public function setReferenciaNumeroInterno( $s_ReferenciaNumeroInterno, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ReferenciaNumeroInterno, "VARCHAR", 50, 0, false ) )
            {
                throw new Exception( "El campo ReferenciaNumeroInterno ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setReferenciaNumeroInterno( $s_ReferenciaNumeroInterno );
        return true;
    }

    /* Valida y establece el valor del campo ReferenciaCompaniaSocio */
    public function setReferenciaCompaniaSocio( $s_ReferenciaCompaniaSocio, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ReferenciaCompaniaSocio, "VARCHAR", 50, 0, false ) )
            {
                throw new Exception( "El campo ReferenciaCompaniaSocio ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setReferenciaCompaniaSocio( $s_ReferenciaCompaniaSocio );
        return true;
    }

    /* Valida y establece el valor del campo ReferenciaTipoDocumento */
    public function setReferenciaTipoDocumento( $s_ReferenciaTipoDocumento, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ReferenciaTipoDocumento, "VARCHAR", 3, 0, false ) )
            {
                throw new Exception( "El campo ReferenciaTipoDocumento ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setReferenciaTipoDocumento( $s_ReferenciaTipoDocumento );
        return true;
    }

    /* Valida y establece el valor del campo ReferenciaNumeroDocumento */
    public function setReferenciaNumeroDocumento( $s_ReferenciaNumeroDocumento, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ReferenciaNumeroDocumento, "VARCHAR", 10, 0, false ) )
            {
                throw new Exception( "El campo ReferenciaNumeroDocumento ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setReferenciaNumeroDocumento( $s_ReferenciaNumeroDocumento );
        return true;
    }

    /* Valida y establece el valor del campo ReferenciaSecuencia */
    public function setReferenciaSecuencia( $s_ReferenciaSecuencia, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ReferenciaSecuencia, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo ReferenciaSecuencia ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setReferenciaSecuencia( $s_ReferenciaSecuencia );
        return true;
    }

    /* Valida y establece el valor del campo IdUnidadMedida */
    public function setIdUnidadMedida( $s_IdUnidadMedida, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdUnidadMedida, "VARCHAR", 6, 0, false ) )
            {
                throw new Exception( "El campo IdUnidadMedida ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdUnidadMedida( $s_IdUnidadMedida );
        return true;
    }

    /* Valida y establece el valor del campo Cantidad */
    public function setCantidad( $f_Cantidad, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_Cantidad, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo Cantidad ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setCantidad( $f_Cantidad );
        return true;
    }

    /* Valida y establece el valor del campo CantidadDoble */
    public function setCantidadDoble( $f_CantidadDoble, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_CantidadDoble, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo CantidadDoble ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setCantidadDoble( $f_CantidadDoble );
        return true;
    }

    /* Valida y establece el valor del campo PrecioUnitario */
    public function setPrecioUnitario( $f_PrecioUnitario, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_PrecioUnitario, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo PrecioUnitario ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setPrecioUnitario( $f_PrecioUnitario );
        return true;
    }

    /* Valida y establece el valor del campo PrecioUnitarioDolares */
    public function setPrecioUnitarioDolares( $f_PrecioUnitarioDolares, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_PrecioUnitarioDolares, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo PrecioUnitarioDolares ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setPrecioUnitarioDolares( $f_PrecioUnitarioDolares );
        return true;
    }

    /* Valida y establece el valor del campo MontoTotal */
    public function setMontoTotal( $f_MontoTotal, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_MontoTotal, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo MontoTotal ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setMontoTotal( $f_MontoTotal );
        return true;
    }

    /* Valida y establece el valor del campo MontoTotalDolares */
    public function setMontoTotalDolares( $f_MontoTotalDolares, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_MontoTotalDolares, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo MontoTotalDolares ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setMontoTotalDolares( $f_MontoTotalDolares );
        return true;
    }

    /* Valida y establece el valor del campo PrecioCosto */
    public function setPrecioCosto( $f_PrecioCosto, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_PrecioCosto, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo PrecioCosto ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setPrecioCosto( $f_PrecioCosto );
        return true;
    }

    /* Valida y establece el valor del campo CostoTotal */
    public function setCostoTotal( $f_CostoTotal, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_CostoTotal, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo CostoTotal ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setCostoTotal( $f_CostoTotal );
        return true;
    }

    /* Valida y establece el valor del campo SaldoCantidad */
    public function setSaldoCantidad( $f_SaldoCantidad, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_SaldoCantidad, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo SaldoCantidad ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setSaldoCantidad( $f_SaldoCantidad );
        return true;
    }

    /* Valida y establece el valor del campo SaldoPrecioCosto */
    public function setSaldoPrecioCosto( $f_SaldoPrecioCosto, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_SaldoPrecioCosto, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo SaldoPrecioCosto ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setSaldoPrecioCosto( $f_SaldoPrecioCosto );
        return true;
    }

    /* Valida y establece el valor del campo SaldoCostoTotal */
    public function setSaldoCostoTotal( $f_SaldoCostoTotal, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $f_SaldoCostoTotal, "DECIMAL", 16, 6, false ) )
            {
                throw new Exception( "El campo SaldoCostoTotal ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setSaldoCostoTotal( $f_SaldoCostoTotal );
        return true;
    }

    /* Valida y establece el valor del campo Periodo */
    public function setPeriodo( $s_Periodo, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Periodo, "VARCHAR", 6, 0, false ) )
            {
                throw new Exception( "El campo Periodo ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setPeriodo( $s_Periodo );
        return true;
    }

    /* Valida y establece el valor del campo CodigoCliente */
    public function setCodigoCliente( $s_CodigoCliente, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_CodigoCliente, "VARCHAR", 10, 0, false ) )
            {
                throw new Exception( "El campo CodigoCliente ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setCodigoCliente( $s_CodigoCliente );
        return true;
    }

    /* Valida y establece el valor del campo CodigoProveedor */
    public function setCodigoProveedor( $s_CodigoProveedor, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_CodigoProveedor, "VARCHAR", 10, 0, false ) )
            {
                throw new Exception( "El campo CodigoProveedor ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setCodigoProveedor( $s_CodigoProveedor );
        return true;
    }

    /* Valida y establece el valor del campo TipoDocumentoFiscal */
    public function setTipoDocumentoFiscal( $s_TipoDocumentoFiscal, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_TipoDocumentoFiscal, "VARCHAR", 5, 0, false ) )
            {
                throw new Exception( "El campo TipoDocumentoFiscal ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setTipoDocumentoFiscal( $s_TipoDocumentoFiscal );
        return true;
    }

    /* Valida y establece el valor del campo CodDocumentoFiscal */
    public function setCodDocumentoFiscal( $s_CodDocumentoFiscal, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_CodDocumentoFiscal, "VARCHAR", 5, 0, false ) )
            {
                throw new Exception( "El campo CodDocumentoFiscal ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setCodDocumentoFiscal( $s_CodDocumentoFiscal );
        return true;
    }

    /* Valida y establece el valor del campo SerieDocumentoFiscal */
    public function setSerieDocumentoFiscal( $s_SerieDocumentoFiscal, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_SerieDocumentoFiscal, "VARCHAR", 5, 0, false ) )
            {
                throw new Exception( "El campo SerieDocumentoFiscal ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setSerieDocumentoFiscal( $s_SerieDocumentoFiscal );
        return true;
    }

    /* Valida y establece el valor del campo NumeroDocumentoFiscal */
    public function setNumeroDocumentoFiscal( $s_NumeroDocumentoFiscal, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_NumeroDocumentoFiscal, "VARCHAR", 15, 0, false ) )
            {
                throw new Exception( "El campo NumeroDocumentoFiscal ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setNumeroDocumentoFiscal( $s_NumeroDocumentoFiscal );
        return true;
    }

    /* Valida y establece el valor del campo FechaDocumentoFiscal */
    public function setFechaDocumentoFiscal( $d_FechaDocumentoFiscal, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaDocumentoFiscal, "DATE", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaDocumentoFiscal ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaDocumentoFiscal( $d_FechaDocumentoFiscal );
        return true;
    }

    /* Valida y establece el valor del campo ReferenciaTipoDocumento2 */
    public function setReferenciaTipoDocumento2( $s_ReferenciaTipoDocumento2, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ReferenciaTipoDocumento2, "VARCHAR", 5, 0, false ) )
            {
                throw new Exception( "El campo ReferenciaTipoDocumento2 ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setReferenciaTipoDocumento2( $s_ReferenciaTipoDocumento2 );
        return true;
    }

    /* Valida y establece el valor del campo ReferenciaNumeroDocumento2 */
    public function setReferenciaNumeroDocumento2( $s_ReferenciaNumeroDocumento2, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ReferenciaNumeroDocumento2, "VARCHAR", 15, 0, false ) )
            {
                throw new Exception( "El campo ReferenciaNumeroDocumento2 ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setReferenciaNumeroDocumento2( $s_ReferenciaNumeroDocumento2 );
        return true;
    }

    /* Valida y establece el valor del campo ReferenciaSecuencia2 */
    public function setReferenciaSecuencia2( $s_ReferenciaSecuencia2, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ReferenciaSecuencia2, "VARCHAR", 15, 0, false ) )
            {
                throw new Exception( "El campo ReferenciaSecuencia2 ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setReferenciaSecuencia2( $s_ReferenciaSecuencia2 );
        return true;
    }

    /* Valida y establece el valor del campo ParentRef */
    public function setParentRef( $s_ParentRef, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ParentRef, "VARCHAR", 100, 0, false ) )
            {
                throw new Exception( "El campo ParentRef ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setParentRef( $s_ParentRef );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioModificacion */
    public function setUsuarioModificacion( $s_UsuarioModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioModificacion, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo UsuarioModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioModificacion( $s_UsuarioModificacion );
        return true;
    }

    /* Valida y establece el valor del campo FechaModificacion */
    public function setFechaModificacion( $d_FechaModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaModificacion, "TIMESTAMP", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaModificacion( $d_FechaModificacion );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioCreacion */
    public function setUsuarioCreacion( $s_UsuarioCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioCreacion, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo UsuarioCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioCreacion( $s_UsuarioCreacion );
        return true;
    }

    /* Valida y establece el valor del campo FechCreacion */
    public function setFechCreacion( $d_FechCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechCreacion, "DATETIME", 0, 0, false ) )
            {
                throw new Exception( "El campo FechCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechCreacion( $d_FechCreacion );
        return true;
    }

    /* Valida el contenido del registro */
    public function validateRecord()
    {
        $this->setIdAlmacen( $this->getIdAlmacen(), true );
        $this->setIdCompania( $this->getIdCompania(), true );
        $this->setIdSucursal( $this->getIdSucursal(), true );
        $this->setIdItem( $this->getIdItem(), true );
        $this->setIdCondicion( $this->getIdCondicion(), true );
        $this->setIdLote( $this->getIdLote(), true );
        $this->setIdFecha( $this->getIdFecha(), true );
        $this->setIdTransaccion( $this->getIdTransaccion(), true );
        $this->setReferenciaNumeroInterno( $this->getReferenciaNumeroInterno(), true );
        $this->setReferenciaCompaniaSocio( $this->getReferenciaCompaniaSocio(), true );
        $this->setReferenciaTipoDocumento( $this->getReferenciaTipoDocumento(), true );
        $this->setReferenciaNumeroDocumento( $this->getReferenciaNumeroDocumento(), true );
        $this->setReferenciaSecuencia( $this->getReferenciaSecuencia(), true );
        $this->setIdUnidadMedida( $this->getIdUnidadMedida(), true );
        $this->setCantidad( $this->getCantidad(), true );
        $this->setCantidadDoble( $this->getCantidadDoble(), true );
        $this->setPrecioUnitario( $this->getPrecioUnitario(), true );
        $this->setPrecioUnitarioDolares( $this->getPrecioUnitarioDolares(), true );
        $this->setMontoTotal( $this->getMontoTotal(), true );
        $this->setMontoTotalDolares( $this->getMontoTotalDolares(), true );
        $this->setPrecioCosto( $this->getPrecioCosto(), true );
        $this->setCostoTotal( $this->getCostoTotal(), true );
        $this->setSaldoCantidad( $this->getSaldoCantidad(), true );
        $this->setSaldoPrecioCosto( $this->getSaldoPrecioCosto(), true );
        $this->setSaldoCostoTotal( $this->getSaldoCostoTotal(), true );
        $this->setPeriodo( $this->getPeriodo(), true );
        $this->setCodigoCliente( $this->getCodigoCliente(), true );
        $this->setCodigoProveedor( $this->getCodigoProveedor(), true );
        $this->setTipoDocumentoFiscal( $this->getTipoDocumentoFiscal(), true );
        $this->setCodDocumentoFiscal( $this->getCodDocumentoFiscal(), true );
        $this->setSerieDocumentoFiscal( $this->getSerieDocumentoFiscal(), true );
        $this->setNumeroDocumentoFiscal( $this->getNumeroDocumentoFiscal(), true );
        $this->setFechaDocumentoFiscal( $this->getFechaDocumentoFiscal(), true );
        $this->setReferenciaTipoDocumento2( $this->getReferenciaTipoDocumento2(), true );
        $this->setReferenciaNumeroDocumento2( $this->getReferenciaNumeroDocumento2(), true );
        $this->setReferenciaSecuencia2( $this->getReferenciaSecuencia2(), true );
        $this->setParentRef( $this->getParentRef(), true );
        $this->setUsuarioModificacion( $this->getUsuarioModificacion(), true );
        $this->setFechaModificacion( $this->getFechaModificacion(), true );
        $this->setUsuarioCreacion( $this->getUsuarioCreacion(), true );
        $this->setFechCreacion( $this->getFechCreacion(), true );
        return true;
    }
}
?>