<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: ALM_CajaChicaLog.xml */
/* Generado: 2020-08-18 04:21:23 */

/* Validacion del contenido de los campos campos de la tabla ALM_CajaChicaLog */
abstract class BaseALM_CajaChicaLogBV extends ALM_CajaChicaLogBN
{
    /* Contiene la clase que valida el tipo de dato */
    private $o_Validator; // Contiene el objeto que realizara la validacion de tipo de dato.
    private $s_ValidatorMessage; // Contiene la ultima observacion de la validacion del tipo de dato.

    /* Constructor ( Establece la clase que valida los tipos de datos y establece los valores por defecto ) */
    public function __construct()
    {
        /* Establecemos el objeto que realizara la validacion del tipo de dato */
        $this->o_Validator = new utilValidDataType();

        /* Establecemos los valores por defecto */
    }

    /* Valida en tipo de dato */
    private function validateData( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull )
    {
        $this->s_ValidatorMessage = null;
        if( !$this->o_Validator->validate( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull ) )
        {
            $this->s_ValidatorMessage = $this->o_Validator->getMessage();
        }
        return is_null( $this->s_ValidatorMessage );
    }

    /* Valida y establece el valor del campo IdCajaLog */
    public function setIdCajaLog( $i_IdCajaLog, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdCajaLog, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdCajaLog ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdCajaLog( $i_IdCajaLog );
        return true;
    }

    /* Valida y establece el valor del campo IdCaja */
    public function setIdCaja( $i_IdCaja, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdCaja, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdCaja ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdCaja( $i_IdCaja );
        return true;
    }

    /* Valida y establece el valor del campo TipoLog */
    public function setTipoLog( $i_TipoLog, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_TipoLog, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo TipoLog ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setTipoLog( $i_TipoLog );
        return true;
    }

    /* Valida y establece el valor del campo ValorAnterior */
    public function setValorAnterior( $s_ValorAnterior, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ValorAnterior, "VARCHAR", 250, 0, false ) )
            {
                throw new Exception( "El campo ValorAnterior ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setValorAnterior( $s_ValorAnterior );
        return true;
    }

    /* Valida y establece el valor del campo ValorNuevo */
    public function setValorNuevo( $s_ValorNuevo, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_ValorNuevo, "VARCHAR", 250, 0, false ) )
            {
                throw new Exception( "El campo ValorNuevo ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setValorNuevo( $s_ValorNuevo );
        return true;
    }

    /* Valida y establece el valor del campo FechaCreacion */
    public function setFechaCreacion( $d_FechaCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaCreacion, "TIMESTAMP", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaCreacion( $d_FechaCreacion );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioCreacion */
    public function setUsuarioCreacion( $s_UsuarioCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioCreacion, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo UsuarioCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioCreacion( $s_UsuarioCreacion );
        return true;
    }

    /* Valida el contenido del registro */
    public function validateRecord()
    {
        $this->setIdCajaLog( $this->getIdCajaLog(), false );
        $this->setIdCaja( $this->getIdCaja(), true );
        $this->setTipoLog( $this->getTipoLog(), true );
        $this->setValorAnterior( $this->getValorAnterior(), true );
        $this->setValorNuevo( $this->getValorNuevo(), true );
        $this->setFechaCreacion( $this->getFechaCreacion(), true );
        $this->setUsuarioCreacion( $this->getUsuarioCreacion(), true );
        return true;
    }
}
?>